/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.jdbc;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.jdbc.AbstractIoTDBJDBCResultSet;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.service.rpc.thrift.TSIService;
import org.apache.iotdb.service.rpc.thrift.TSQueryDataSet;

public class IoTDBJDBCResultSet
extends AbstractIoTDBJDBCResultSet {
    public IoTDBJDBCResultSet(Statement statement, List<String> columnNameList, List<String> columnTypeList, Map<String, Integer> columnNameIndex, boolean ignoreTimeStamp, TSIService.Iface client, String sql, long queryId, long sessionId, TSQueryDataSet dataset, long timeout) throws SQLException {
        super(statement, columnNameList, columnTypeList, columnNameIndex, ignoreTimeStamp, client, sql, queryId, sessionId, timeout);
        this.ioTDBRpcDataSet.setTsQueryDataSet(dataset);
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        try {
            return this.ioTDBRpcDataSet.getLong(columnName);
        }
        catch (StatementExecutionException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    protected boolean fetchResults() throws SQLException {
        try {
            return this.ioTDBRpcDataSet.fetchResults();
        }
        catch (IoTDBConnectionException | StatementExecutionException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    protected boolean hasCachedResults() {
        return this.ioTDBRpcDataSet.hasCachedResults();
    }

    @Override
    protected void constructOneRow() {
        this.ioTDBRpcDataSet.constructOneRow();
    }

    @Override
    protected void checkRecord() throws SQLException {
        try {
            this.ioTDBRpcDataSet.checkRecord();
        }
        catch (StatementExecutionException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    protected String getValueByName(String columnName) throws SQLException {
        try {
            return this.ioTDBRpcDataSet.getValueByName(columnName);
        }
        catch (StatementExecutionException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    protected Object getObjectByName(String columnName) throws SQLException {
        try {
            return this.ioTDBRpcDataSet.getObjectByName(columnName);
        }
        catch (StatementExecutionException e) {
            throw new SQLException(e.getMessage());
        }
    }

    public boolean isIgnoreTimeStamp() {
        return this.ioTDBRpcDataSet.ignoreTimeStamp;
    }
}

