/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.filter.operator;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterSerializeId;
import org.apache.iotdb.tsfile.read.filter.factory.FilterType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class In<T extends Comparable<T>>
implements Filter {
    private static final long serialVersionUID = 8572705136773595399L;
    private Set<T> values;
    private boolean not;
    private FilterType filterType;

    public In() {
    }

    public In(Set<T> values, FilterType filterType, boolean not) {
        this.values = values;
        this.filterType = filterType;
        this.not = not;
    }

    @Override
    public boolean satisfy(Statistics statistics) {
        return true;
    }

    @Override
    public boolean satisfy(long time, Object value) {
        Object v = this.filterType == FilterType.TIME_FILTER ? Long.valueOf(time) : value;
        return this.values.contains(v) != this.not;
    }

    @Override
    public boolean satisfyStartEndTime(long startTime, long endTime) {
        return true;
    }

    @Override
    public boolean containStartEndTime(long startTime, long endTime) {
        return true;
    }

    @Override
    public Filter copy() {
        return new In<T>(new HashSet<T>(this.values), this.filterType, this.not);
    }

    @Override
    public void serialize(DataOutputStream outputStream) {
        try {
            outputStream.write(this.getSerializeId().ordinal());
            outputStream.write(this.filterType.ordinal());
            ReadWriteIOUtils.write((Boolean)this.not, (OutputStream)outputStream);
            outputStream.write(this.values.size());
            for (Comparable value : this.values) {
                ReadWriteIOUtils.writeObject(value, outputStream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        this.filterType = FilterType.values()[buffer.get()];
        this.not = ReadWriteIOUtils.readBool(buffer);
        this.values = new HashSet<T>();
        for (int i = 0; i < buffer.get(); ++i) {
            this.values.add((Comparable)ReadWriteIOUtils.readObject(buffer));
        }
    }

    public String toString() {
        ArrayList<T> valueList = new ArrayList<T>(this.values);
        Collections.sort(valueList);
        return (Object)((Object)this.filterType) + " < reverse: " + this.not + ", " + valueList;
    }

    @Override
    public FilterSerializeId getSerializeId() {
        return FilterSerializeId.IN;
    }

    public Set<T> getValues() {
        return this.values;
    }
}

