/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.filter;

import java.util.Set;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterType;
import org.apache.iotdb.tsfile.read.filter.operator.Eq;
import org.apache.iotdb.tsfile.read.filter.operator.Gt;
import org.apache.iotdb.tsfile.read.filter.operator.GtEq;
import org.apache.iotdb.tsfile.read.filter.operator.In;
import org.apache.iotdb.tsfile.read.filter.operator.Like;
import org.apache.iotdb.tsfile.read.filter.operator.Lt;
import org.apache.iotdb.tsfile.read.filter.operator.LtEq;
import org.apache.iotdb.tsfile.read.filter.operator.NotEq;
import org.apache.iotdb.tsfile.read.filter.operator.NotFilter;
import org.apache.iotdb.tsfile.read.filter.operator.Regexp;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class ValueFilter {
    private ValueFilter() {
    }

    public static <T extends Comparable<T>> ValueEq<T> eq(T value) {
        return new ValueEq(value, null);
    }

    public static <T extends Comparable<T>> ValueGt<T> gt(T value) {
        return new ValueGt(value, null);
    }

    public static <T extends Comparable<T>> ValueGtEq<T> gtEq(T value) {
        return new ValueGtEq(value, null);
    }

    public static <T extends Comparable<T>> ValueLt<T> lt(T value) {
        return new ValueLt(value, null);
    }

    public static <T extends Comparable<T>> ValueLtEq<T> ltEq(T value) {
        return new ValueLtEq(value, null);
    }

    public static <T extends Comparable<T>> ValueIn<T> in(Set<T> values, boolean not) {
        return new ValueIn(values, not);
    }

    public static ValueNotFilter not(Filter filter) {
        return new ValueNotFilter(filter);
    }

    public static <T extends Comparable<T>> ValueNotEq<T> notEq(T value) {
        return new ValueNotEq(value, null);
    }

    public static <T extends Comparable<T>> ValueRegexp<T> regexp(String value) {
        return new ValueRegexp(value);
    }

    public static <T extends Comparable<T>> ValueLike<T> like(String value) {
        return new ValueLike(value);
    }

    public static class VectorValueLike<T extends Comparable<T>>
    extends ValueLike<T> {
        private final int index;

        private VectorValueLike(String value, int index) {
            super(value);
            this.index = index;
        }

        public boolean satisfy(long time, TsPrimitiveType[] values) {
            Long v = this.filterType == FilterType.TIME_FILTER ? Long.valueOf(time) : values[this.index].getValue();
            return this.value.equals(v);
        }
    }

    public static class ValueLike<T extends Comparable<T>>
    extends Like<T> {
        private ValueLike(String value) {
            super(value, FilterType.VALUE_FILTER);
        }
    }

    public static class VectorValueRegexp<T extends Comparable<T>>
    extends ValueRegexp<T> {
        private final int index;

        private VectorValueRegexp(String value, int index) {
            super(value);
            this.index = index;
        }

        public boolean satisfy(long time, TsPrimitiveType[] values) {
            Long v = this.filterType == FilterType.TIME_FILTER ? Long.valueOf(time) : values[this.index].getValue();
            return this.value.equals(v);
        }
    }

    public static class ValueRegexp<T extends Comparable<T>>
    extends Regexp<T> {
        private ValueRegexp(String value) {
            super(value, FilterType.VALUE_FILTER);
        }
    }

    public static class VectorValueNotEq<T extends Comparable<T>>
    extends ValueNotEq<T> {
        private final int index;

        private VectorValueNotEq(T value, int index) {
            super((Comparable)value, null);
            this.index = index;
        }

        public boolean satisfy(long time, TsPrimitiveType[] values) {
            Long v = this.filterType == FilterType.TIME_FILTER ? Long.valueOf(time) : values[this.index].getValue();
            return !this.value.equals(v);
        }
    }

    public static class ValueNotEq<T extends Comparable<T>>
    extends NotEq<T> {
        private ValueNotEq(T value) {
            super(value, FilterType.VALUE_FILTER);
        }

        /* synthetic */ ValueNotEq(Comparable x0, 1 x1) {
            this(x0);
        }
    }

    public static class ValueNotFilter
    extends NotFilter {
        private ValueNotFilter(Filter filter) {
            super(filter);
        }

        @Override
        public String toString() {
            return (Object)((Object)FilterType.VALUE_FILTER) + super.toString();
        }
    }

    public static class ValueLtEq<T extends Comparable<T>>
    extends LtEq<T> {
        private ValueLtEq(T value) {
            super(value, FilterType.VALUE_FILTER);
        }

        /* synthetic */ ValueLtEq(Comparable x0, 1 x1) {
            this(x0);
        }
    }

    public static class ValueLt<T extends Comparable<T>>
    extends Lt<T> {
        private ValueLt(T value) {
            super(value, FilterType.VALUE_FILTER);
        }

        /* synthetic */ ValueLt(Comparable x0, 1 x1) {
            this(x0);
        }
    }

    public static class ValueGtEq<T extends Comparable<T>>
    extends GtEq<T> {
        private ValueGtEq(T value) {
            super(value, FilterType.VALUE_FILTER);
        }

        /* synthetic */ ValueGtEq(Comparable x0, 1 x1) {
            this(x0);
        }
    }

    public static class ValueGt<T extends Comparable<T>>
    extends Gt<T> {
        private ValueGt(T value) {
            super(value, FilterType.VALUE_FILTER);
        }

        /* synthetic */ ValueGt(Comparable x0, 1 x1) {
            this(x0);
        }
    }

    public static class ValueEq<T extends Comparable<T>>
    extends Eq<T> {
        private ValueEq(T value) {
            super(value, FilterType.VALUE_FILTER);
        }

        /* synthetic */ ValueEq(Comparable x0, 1 x1) {
            this(x0);
        }
    }

    public static class ValueIn<T extends Comparable<T>>
    extends In<T> {
        private ValueIn(Set<T> values, boolean not) {
            super(values, FilterType.VALUE_FILTER, not);
        }
    }
}

