/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.executor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.UnsupportedDataTypeException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupProcessor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.FillQueryPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.dataset.SingleDataSet;
import org.apache.iotdb.db.query.executor.fill.IFill;
import org.apache.iotdb.db.query.executor.fill.PreviousFill;
import org.apache.iotdb.db.query.reader.series.ManagedSeriesReader;
import org.apache.iotdb.db.query.reader.series.SeriesRawDataBatchReader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;

public class FillQueryExecutor {
    protected FillQueryPlan plan;
    protected List<PartialPath> selectedSeries;
    protected List<TSDataType> dataTypes;
    protected Map<TSDataType, IFill> typeIFillMap;
    protected long queryTime;

    public FillQueryExecutor(FillQueryPlan fillQueryPlan) {
        this.plan = fillQueryPlan;
        this.selectedSeries = this.plan.getDeduplicatedPaths();
        this.typeIFillMap = this.plan.getFillType();
        this.dataTypes = this.plan.getDeduplicatedDataTypes();
        this.queryTime = this.plan.getQueryTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryDataSet execute(QueryContext context) throws StorageEngineException, QueryProcessException, IOException {
        RowRecord record = new RowRecord(this.queryTime);
        List<StorageGroupProcessor> list = StorageEngine.getInstance().mergeLock(this.selectedSeries);
        try {
            List<TimeValuePair> timeValuePairs = this.getTimeValuePairs(context);
            long defaultFillInterval = IoTDBDescriptor.getInstance().getConfig().getDefaultFillInterval();
            for (int i = 0; i < this.selectedSeries.size(); ++i) {
                IFill fill;
                TSDataType dataType;
                PartialPath path;
                block11: {
                    block10: {
                        path = this.selectedSeries.get(i);
                        dataType = this.dataTypes.get(i);
                        if (timeValuePairs.get(i) != null) {
                            record.addField(timeValuePairs.get(i).getValue().getValue(), dataType);
                            continue;
                        }
                        if (this.typeIFillMap.containsKey(dataType)) break block10;
                        switch (dataType) {
                            case INT32: 
                            case INT64: 
                            case FLOAT: 
                            case DOUBLE: 
                            case BOOLEAN: 
                            case TEXT: {
                                fill = new PreviousFill(dataType, this.queryTime, defaultFillInterval);
                                break block11;
                            }
                            default: {
                                throw new UnsupportedDataTypeException("unsupported data type " + dataType);
                            }
                        }
                    }
                    fill = this.typeIFillMap.get(dataType).copy();
                }
                fill = this.configureFill(fill, path, dataType, this.queryTime, this.plan.getAllMeasurementsInDevice(path.getDevice()), context);
                TimeValuePair timeValuePair = fill.getFillResult();
                if (timeValuePair == null || timeValuePair.getValue() == null) {
                    record.addField(null);
                    continue;
                }
                record.addField(timeValuePair.getValue().getValue(), dataType);
            }
        }
        finally {
            StorageEngine.getInstance().mergeUnLock(list);
        }
        SingleDataSet dataSet = new SingleDataSet(this.selectedSeries, this.dataTypes);
        dataSet.setRecord(record);
        return dataSet;
    }

    protected IFill configureFill(IFill fill, PartialPath path, TSDataType dataType, long queryTime, Set<String> deviceMeasurements, QueryContext context) {
        fill.configureFill(path, dataType, queryTime, deviceMeasurements, context);
        return fill;
    }

    protected List<TimeValuePair> getTimeValuePairs(QueryContext context) throws QueryProcessException, StorageEngineException, IOException {
        List<ManagedSeriesReader> readers = this.initManagedSeriesReader(context);
        ArrayList<TimeValuePair> ret = new ArrayList<TimeValuePair>(this.selectedSeries.size());
        for (ManagedSeriesReader reader : readers) {
            BatchData batchData;
            if (reader.hasNextBatch() && (batchData = reader.nextBatch()).hasCurrent()) {
                ret.add(new TimeValuePair(batchData.currentTime(), batchData.currentTsPrimitiveType()));
                continue;
            }
            ret.add(null);
        }
        return ret;
    }

    private List<ManagedSeriesReader> initManagedSeriesReader(QueryContext context) throws StorageEngineException, QueryProcessException {
        TimeFilter.TimeEq timeFilter = TimeFilter.eq((long)this.queryTime);
        ArrayList<ManagedSeriesReader> readers = new ArrayList<ManagedSeriesReader>();
        for (int i = 0; i < this.selectedSeries.size(); ++i) {
            PartialPath path = this.selectedSeries.get(i);
            TSDataType dataType = this.dataTypes.get(i);
            QueryDataSource queryDataSource = QueryResourceManager.getInstance().getQueryDataSource(path, context, (Filter)timeFilter);
            timeFilter = queryDataSource.updateFilterUsingTTL((Filter)timeFilter);
            SeriesRawDataBatchReader reader = new SeriesRawDataBatchReader(path, this.plan.getAllMeasurementsInDevice(path.getDevice()), dataType, context, queryDataSource, (Filter)timeFilter, null, null, this.plan.isAscending());
            readers.add(reader);
        }
        return readers;
    }
}

