/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset.groupby;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.AggregationPlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimePlan;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.groupby.GroupByEngineDataSet;
import org.apache.iotdb.db.utils.AggregateUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupByTimeDataSet
extends QueryDataSet {
    private static final Logger logger = LoggerFactory.getLogger(GroupByTimeDataSet.class);
    private List<RowRecord> records = new ArrayList<RowRecord>();
    private int index = 0;
    protected long queryId;
    private GroupByTimePlan groupByTimePlan;
    private QueryContext context;

    public GroupByTimeDataSet(QueryContext context, GroupByTimePlan plan, GroupByEngineDataSet dataSet) throws QueryProcessException, IOException {
        this.queryId = context.getQueryId();
        this.paths = new ArrayList<PartialPath>(plan.getDeduplicatedPaths());
        this.dataTypes = plan.getDeduplicatedDataTypes();
        this.groupByTimePlan = plan;
        this.context = context;
        if (logger.isDebugEnabled()) {
            logger.debug("paths " + this.paths + " level:" + plan.getLevel());
        }
        Map<String, AggregateResult> finalPaths = plan.getAggPathByLevel();
        if (logger.isDebugEnabled()) {
            logger.debug("only group by level, paths:" + this.groupByTimePlan.getPaths());
        }
        while (dataSet != null && dataSet.hasNextWithoutConstraint()) {
            RowRecord rawRecord = dataSet.nextWithoutConstraint();
            RowRecord curRecord = new RowRecord(rawRecord.getTimestamp());
            List<AggregateResult> mergedAggResults = AggregateUtils.mergeRecordByPath((AggregationPlan)plan, rawRecord, finalPaths);
            for (AggregateResult resultData : mergedAggResults) {
                TSDataType dataType = resultData.getResultDataType();
                curRecord.addField(resultData.getResult(), dataType);
            }
            this.records.add(curRecord);
        }
        this.dataTypes = new ArrayList();
        this.paths = new ArrayList();
        for (int i = 0; i < finalPaths.size(); ++i) {
            this.dataTypes.add(TSDataType.INT64);
        }
    }

    public boolean hasNextWithoutConstraint() {
        return this.index < this.records.size();
    }

    public RowRecord nextWithoutConstraint() {
        return this.records.get(this.index++);
    }
}

