/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset.groupby;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupProcessor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimeFillPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.groupby.GroupByEngineDataSet;
import org.apache.iotdb.db.query.executor.LastQueryExecutor;
import org.apache.iotdb.db.query.executor.fill.IFill;
import org.apache.iotdb.db.query.executor.fill.PreviousFill;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.utils.Pair;

public class GroupByFillDataSet
extends QueryDataSet {
    private GroupByEngineDataSet groupByEngineDataSet;
    private Map<TSDataType, IFill> fillTypes;
    private Object[] previousValue;
    private long[] previousTime;
    private long[] lastTimeArray;
    private TimeValuePair[] firstNotNullTV;
    private boolean isPeekEnded = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupByFillDataSet(List<PartialPath> paths, List<TSDataType> dataTypes, GroupByEngineDataSet groupByEngineDataSet, Map<TSDataType, IFill> fillTypes, QueryContext context, GroupByTimeFillPlan groupByFillPlan) throws StorageEngineException, IOException, QueryProcessException {
        super(new ArrayList<PartialPath>(paths), dataTypes, groupByFillPlan.isAscending());
        this.groupByEngineDataSet = groupByEngineDataSet;
        this.fillTypes = fillTypes;
        List<StorageGroupProcessor> list = StorageEngine.getInstance().mergeLock(paths);
        try {
            this.initPreviousParis(context, groupByFillPlan);
            this.initLastTimeArray(context, groupByFillPlan);
        }
        finally {
            StorageEngine.getInstance().mergeUnLock(list);
        }
    }

    private void initPreviousParis(QueryContext context, GroupByTimeFillPlan groupByFillPlan) throws StorageEngineException, IOException, QueryProcessException {
        this.previousValue = new Object[this.paths.size()];
        this.previousTime = new long[this.paths.size()];
        this.firstNotNullTV = new TimeValuePair[this.paths.size()];
        for (int i = 0; i < this.paths.size(); ++i) {
            PartialPath path = (PartialPath)this.paths.get(i);
            TSDataType dataType = (TSDataType)this.dataTypes.get(i);
            PreviousFill fill = this.fillTypes.containsKey(dataType) ? new PreviousFill(dataType, this.groupByEngineDataSet.getStartTime(), ((PreviousFill)this.fillTypes.get(dataType)).getBeforeRange(), ((PreviousFill)this.fillTypes.get(dataType)).isUntilLast()) : new PreviousFill(dataType, this.groupByEngineDataSet.getStartTime(), IoTDBDescriptor.getInstance().getConfig().getDefaultFillInterval());
            ((IFill)fill).configureFill(path, dataType, this.groupByEngineDataSet.getStartTime(), groupByFillPlan.getAllMeasurementsInDevice(path.getDevice()), context);
            this.firstNotNullTV[i] = ((IFill)fill).getFillResult();
            TimeValuePair timeValuePair = this.firstNotNullTV[i];
            this.previousValue[i] = null;
            this.previousTime[i] = Long.MAX_VALUE;
            if (!this.ascending || timeValuePair == null || timeValuePair.getValue() == null) continue;
            this.previousValue[i] = timeValuePair.getValue().getValue();
            this.previousTime[i] = timeValuePair.getTimestamp();
        }
    }

    private void initLastTimeArray(QueryContext context, GroupByTimeFillPlan groupByFillPlan) throws IOException, StorageEngineException, QueryProcessException {
        this.lastTimeArray = new long[this.paths.size()];
        Arrays.fill(this.lastTimeArray, Long.MAX_VALUE);
        ArrayList<PartialPath> seriesPaths = new ArrayList<PartialPath>();
        for (int i = 0; i < this.paths.size(); ++i) {
            seriesPaths.add((PartialPath)this.paths.get(i));
        }
        List<Pair<Boolean, TimeValuePair>> lastValueContainer = LastQueryExecutor.calculateLastPairForSeriesLocally(seriesPaths, this.dataTypes, context, null, groupByFillPlan.getDeviceToMeasurements());
        for (int i = 0; i < lastValueContainer.size(); ++i) {
            if (!Boolean.TRUE.equals(lastValueContainer.get((int)i).left)) continue;
            this.lastTimeArray[i] = ((TimeValuePair)lastValueContainer.get((int)i).right).getTimestamp();
        }
    }

    public boolean hasNextWithoutConstraint() {
        return this.groupByEngineDataSet.hasNextWithoutConstraint();
    }

    public RowRecord nextWithoutConstraint() throws IOException {
        RowRecord rowRecord = this.groupByEngineDataSet.nextWithoutConstraint();
        for (int i = 0; i < this.paths.size(); ++i) {
            Field field = (Field)rowRecord.getFields().get(i);
            if (field == null || field.getDataType() == null) {
                TSDataType tsDataType = (TSDataType)this.dataTypes.get(i);
                if (!(this.ascending || this.isPeekEnded || this.canUseCacheData(rowRecord, tsDataType, i))) {
                    this.fillCache(i);
                }
                if (!this.canUseCacheData(rowRecord, tsDataType, i)) continue;
                rowRecord.getFields().set(i, Field.getField((Object)this.previousValue[i], (TSDataType)tsDataType));
                continue;
            }
            this.previousValue[i] = field.getObjectValue(field.getDataType());
            this.previousTime[i] = rowRecord.getTimestamp();
        }
        return rowRecord;
    }

    private void fillCache(int i) throws IOException {
        Pair<Long, Object> data = this.groupByEngineDataSet.peekNextNotNullValue((Path)this.paths.get(i), i);
        if (data == null) {
            this.isPeekEnded = true;
            this.previousTime[i] = Long.MIN_VALUE;
            this.previousValue[i] = null;
            if (!this.firstCacheIsEmpty(i)) {
                this.previousValue[i] = this.firstNotNullTV[i].getValue().getValue();
                this.previousTime[i] = this.firstNotNullTV[i].getTimestamp();
            }
        } else {
            this.previousValue[i] = data.right;
            this.previousTime[i] = (Long)data.left;
        }
    }

    private boolean canUseCacheData(RowRecord rowRecord, TSDataType tsDataType, int i) {
        PreviousFill previousFill = (PreviousFill)this.fillTypes.get(tsDataType);
        return !this.cacheIsEmpty(i) && this.satisfyTime(rowRecord, tsDataType, previousFill, this.lastTimeArray[i]) && this.satisfyRange(tsDataType, previousFill) && this.isIncreasingTime(rowRecord, this.previousTime[i]);
    }

    private boolean isIncreasingTime(RowRecord rowRecord, long time) {
        return rowRecord.getTimestamp() >= time;
    }

    private boolean satisfyTime(RowRecord rowRecord, TSDataType tsDataType, PreviousFill previousFill, long lastTime) {
        return this.fillTypes.containsKey(tsDataType) && !previousFill.isUntilLast() || rowRecord.getTimestamp() <= lastTime;
    }

    private boolean satisfyRange(TSDataType tsDataType, PreviousFill previousFill) {
        return !this.fillTypes.containsKey(tsDataType) || previousFill.getBeforeRange() < 0L || previousFill.getBeforeRange() >= this.groupByEngineDataSet.interval;
    }

    private boolean cacheIsEmpty(int i) {
        return this.previousValue[i] == null;
    }

    private boolean firstCacheIsEmpty(int i) {
        return this.firstNotNullTV[i] == null || this.firstNotNullTV[i].getValue() == null;
    }
}

