/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.control;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.db.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.query.QueryTimeoutRuntimeException;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.ServiceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryTimeManager
implements IService {
    private static final Logger logger = LoggerFactory.getLogger(QueryTimeManager.class);
    private final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private Map<Long, QueryInfo> queryInfoMap = new ConcurrentHashMap<Long, QueryInfo>();
    private ScheduledExecutorService executorService;
    private Map<Long, ScheduledFuture<?>> queryScheduledTaskMap = new ConcurrentHashMap();

    private QueryTimeManager() {
        this.executorService = IoTDBThreadPoolFactory.newScheduledThreadPool(1, "query-time-manager");
    }

    public void registerQuery(long queryId, long startTime, String sql, long timeout) {
        this.queryInfoMap.put(queryId, new QueryInfo(startTime, sql));
        if (timeout != 0L) {
            ScheduledFuture<?> scheduledFuture = this.executorService.schedule(() -> {
                this.killQuery(queryId);
                logger.warn(String.format("Query is time out (%dms) with queryId %d", timeout, queryId));
            }, timeout, TimeUnit.MILLISECONDS);
            this.queryScheduledTaskMap.put(queryId, scheduledFuture);
        }
    }

    public void killQuery(long queryId) {
        if (this.queryInfoMap.get(queryId) == null) {
            return;
        }
        this.queryInfoMap.get(queryId).setInterrupted(true);
    }

    public AtomicBoolean unRegisterQuery(long queryId) {
        AtomicBoolean successRemoved = new AtomicBoolean(false);
        this.queryInfoMap.computeIfPresent(queryId, (k, v) -> {
            successRemoved.set(true);
            ScheduledFuture<?> scheduledFuture = this.queryScheduledTaskMap.remove(queryId);
            if (scheduledFuture != null) {
                scheduledFuture.cancel(false);
            }
            return null;
        });
        return successRemoved;
    }

    public static void checkQueryAlive(long queryId) {
        QueryInfo queryInfo = QueryTimeManager.getInstance().queryInfoMap.get(queryId);
        if (queryInfo != null && queryInfo.isInterrupted() && QueryTimeManager.getInstance().unRegisterQuery(queryId).get()) {
            throw new QueryTimeoutRuntimeException("Current query is time out, please check your statement or modify timeout parameter.");
        }
    }

    public Map<Long, QueryInfo> getQueryInfoMap() {
        return this.queryInfoMap;
    }

    public static QueryTimeManager getInstance() {
        return QueryTimeManagerHelper.INSTANCE;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        if (this.executorService == null || this.executorService.isShutdown()) {
            return;
        }
        this.executorService.shutdownNow();
    }

    @Override
    public ServiceType getID() {
        return ServiceType.QUERY_TIME_MANAGER;
    }

    public class QueryInfo {
        private static final int MAX_STATEMENT_LENGTH = 64;
        private final long startTime;
        private final String statement;
        private volatile boolean isInterrupted = false;

        public QueryInfo(long startTime, String statement) {
            this.startTime = startTime;
            this.statement = statement.length() <= 64 ? statement : statement.substring(0, 32) + "..." + statement.substring(statement.length() - 32);
        }

        public long getStartTime() {
            return this.startTime;
        }

        public String getStatement() {
            return this.statement;
        }

        public void setInterrupted(boolean interrupted) {
            this.isInterrupted = interrupted;
        }

        public boolean isInterrupted() {
            return this.isInterrupted;
        }
    }

    private static class QueryTimeManagerHelper {
        private static final QueryTimeManager INSTANCE = new QueryTimeManager();

        private QueryTimeManagerHelper() {
        }
    }
}

