/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;

public class MNodePlan
extends PhysicalPlan {
    protected String name;
    protected int childSize;

    public MNodePlan() {
        super(false, Operator.OperatorType.MNODE);
    }

    public MNodePlan(String name, int childSize) {
        super(false, Operator.OperatorType.MNODE);
        this.name = name;
        this.childSize = childSize;
    }

    public MNodePlan(boolean isQuery, Operator.OperatorType operatorType) {
        super(isQuery, operatorType);
    }

    @Override
    public List<PartialPath> getPaths() {
        return new ArrayList<PartialPath>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getChildSize() {
        return this.childSize;
    }

    public void setChildSize(int childSize) {
        this.childSize = childSize;
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        buffer.put((byte)PhysicalPlan.PhysicalPlanType.MNODE.ordinal());
        this.putString(buffer, this.name);
        buffer.putInt(this.childSize);
        buffer.putLong(this.index);
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.write((byte)PhysicalPlan.PhysicalPlanType.MNODE.ordinal());
        this.putString(stream, this.name);
        stream.writeInt(this.childSize);
        stream.writeLong(this.index);
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        this.name = this.readString(buffer);
        this.childSize = buffer.getInt();
        this.index = buffer.getLong();
    }

    public String toString() {
        return "MNode{" + this.name + "," + this.childSize + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MNodePlan that = (MNodePlan)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.childSize, that.childSize);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.childSize);
    }
}

