/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.service.rpc.thrift.EndPoint;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionUtils {
    private static final Logger logger = LoggerFactory.getLogger(SessionUtils.class);

    public static ByteBuffer getTimeBuffer(Tablet tablet) {
        ByteBuffer timeBuffer = ByteBuffer.allocate(tablet.getTimeBytesSize());
        for (int i = 0; i < tablet.rowSize; ++i) {
            timeBuffer.putLong(tablet.timestamps[i]);
        }
        timeBuffer.flip();
        return timeBuffer;
    }

    public static ByteBuffer getValueBuffer(Tablet tablet) {
        ByteBuffer valueBuffer = ByteBuffer.allocate(tablet.getValueBytesSize());
        block8: for (int i = 0; i < tablet.getSchemas().size(); ++i) {
            TSDataType dataType = ((MeasurementSchema)tablet.getSchemas().get(i)).getType();
            switch (dataType) {
                case INT32: {
                    int[] intValues = (int[])tablet.values[i];
                    for (int index = 0; index < tablet.rowSize; ++index) {
                        valueBuffer.putInt(intValues[index]);
                    }
                    continue block8;
                }
                case INT64: {
                    long[] longValues = (long[])tablet.values[i];
                    for (int index = 0; index < tablet.rowSize; ++index) {
                        valueBuffer.putLong(longValues[index]);
                    }
                    continue block8;
                }
                case FLOAT: {
                    float[] floatValues = (float[])tablet.values[i];
                    for (int index = 0; index < tablet.rowSize; ++index) {
                        valueBuffer.putFloat(floatValues[index]);
                    }
                    continue block8;
                }
                case DOUBLE: {
                    double[] doubleValues = (double[])tablet.values[i];
                    for (int index = 0; index < tablet.rowSize; ++index) {
                        valueBuffer.putDouble(doubleValues[index]);
                    }
                    continue block8;
                }
                case BOOLEAN: {
                    boolean[] boolValues = (boolean[])tablet.values[i];
                    for (int index = 0; index < tablet.rowSize; ++index) {
                        valueBuffer.put(BytesUtils.boolToByte((boolean)boolValues[index]));
                    }
                    continue block8;
                }
                case TEXT: {
                    Binary[] binaryValues = (Binary[])tablet.values[i];
                    for (int index = 0; index < tablet.rowSize; ++index) {
                        valueBuffer.putInt(binaryValues[index].getLength());
                        valueBuffer.put(binaryValues[index].getValues());
                    }
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", dataType));
                }
            }
        }
        valueBuffer.flip();
        return valueBuffer;
    }

    public static List<EndPoint> parseSeedNodeUrls(List<String> nodeUrls) {
        if (nodeUrls == null) {
            throw new NumberFormatException("nodeUrls is null");
        }
        ArrayList<EndPoint> endPointsList = new ArrayList<EndPoint>();
        for (String nodeUrl : nodeUrls) {
            EndPoint endPoint = SessionUtils.parseNodeUrl(nodeUrl);
            endPointsList.add(endPoint);
        }
        return endPointsList;
    }

    private static EndPoint parseNodeUrl(String nodeUrl) {
        EndPoint endPoint = new EndPoint();
        String[] split = nodeUrl.split(":");
        if (split.length != 2) {
            throw new NumberFormatException("NodeUrl Incorrect format");
        }
        String ip = split[0];
        try {
            int rpcPort = Integer.parseInt(split[1]);
            return endPoint.setIp(ip).setPort(rpcPort);
        }
        catch (Exception e) {
            throw new NumberFormatException("NodeUrl Incorrect format");
        }
    }
}

