/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.engine.cache.TimeSeriesMetadataCache;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.db.query.reader.chunk.MemChunkLoader;
import org.apache.iotdb.db.query.reader.chunk.MemChunkReader;
import org.apache.iotdb.db.query.reader.chunk.metadata.DiskChunkMetadataLoader;
import org.apache.iotdb.db.query.reader.chunk.metadata.MemChunkMetadataLoader;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.TsFileMetadata;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.controller.IChunkMetadataLoader;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.IPageReader;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReader;

public class FileLoaderUtils {
    private FileLoaderUtils() {
    }

    public static void checkTsFileResource(TsFileResource tsFileResource) throws IOException {
        if (!tsFileResource.resourceFileExists()) {
            try (TsFileSequenceReader reader = new TsFileSequenceReader(tsFileResource.getTsFile().getAbsolutePath());){
                FileLoaderUtils.updateTsFileResource(reader, tsFileResource);
            }
            tsFileResource.serialize();
        } else {
            tsFileResource.deserialize();
        }
        tsFileResource.setClosed(true);
    }

    public static void updateTsFileResource(TsFileSequenceReader reader, TsFileResource tsFileResource) throws IOException {
        for (Map.Entry entry : reader.getAllTimeseriesMetadata().entrySet()) {
            for (TimeseriesMetadata timeseriesMetaData : (List)entry.getValue()) {
                tsFileResource.updateStartTime((String)entry.getKey(), timeseriesMetaData.getStatistics().getStartTime());
                tsFileResource.updateEndTime((String)entry.getKey(), timeseriesMetaData.getStatistics().getEndTime());
            }
        }
        tsFileResource.updatePlanIndexes(reader.getMinPlanIndex());
        tsFileResource.updatePlanIndexes(reader.getMaxPlanIndex());
    }

    public static TimeseriesMetadata loadTimeSeriesMetadata(TsFileResource resource, PartialPath seriesPath, QueryContext context, Filter filter, Set<String> allSensors) throws IOException {
        TimeseriesMetadata timeSeriesMetadata;
        if (resource.isClosed()) {
            if (!resource.getTsFile().exists()) {
                return null;
            }
            timeSeriesMetadata = TimeSeriesMetadataCache.getInstance().get(new TimeSeriesMetadataCache.TimeSeriesMetadataCacheKey(resource.getTsFilePath(), seriesPath.getDevice(), seriesPath.getMeasurement()), allSensors, context.isDebug());
            if (timeSeriesMetadata != null) {
                timeSeriesMetadata.setChunkMetadataLoader((IChunkMetadataLoader)new DiskChunkMetadataLoader(resource, seriesPath, context, filter));
            }
        } else {
            timeSeriesMetadata = resource.getTimeSeriesMetadata();
            if (timeSeriesMetadata != null) {
                timeSeriesMetadata.setChunkMetadataLoader((IChunkMetadataLoader)new MemChunkMetadataLoader(resource, seriesPath, context, filter));
            }
        }
        if (timeSeriesMetadata != null) {
            List<Modification> pathModifications = context.getPathModifications(resource.getModFile(), seriesPath);
            timeSeriesMetadata.setModified(!pathModifications.isEmpty());
            if (timeSeriesMetadata.getStatistics().getStartTime() > timeSeriesMetadata.getStatistics().getEndTime()) {
                return null;
            }
            if (filter != null && !filter.satisfyStartEndTime(timeSeriesMetadata.getStatistics().getStartTime(), timeSeriesMetadata.getStatistics().getEndTime())) {
                return null;
            }
        }
        return timeSeriesMetadata;
    }

    public static List<ChunkMetadata> loadChunkMetadataList(TimeseriesMetadata timeSeriesMetadata) throws IOException {
        return timeSeriesMetadata.loadChunkMetadataList();
    }

    public static List<IPageReader> loadPageReaderList(ChunkMetadata chunkMetaData, Filter timeFilter) throws IOException {
        MemChunkReader chunkReader;
        if (chunkMetaData == null) {
            throw new IOException("Can't init null chunkMeta");
        }
        IChunkLoader chunkLoader = chunkMetaData.getChunkLoader();
        if (chunkLoader instanceof MemChunkLoader) {
            MemChunkLoader memChunkLoader = (MemChunkLoader)chunkLoader;
            chunkReader = new MemChunkReader(memChunkLoader.getChunk(), timeFilter);
        } else {
            Chunk chunk = chunkLoader.loadChunk(chunkMetaData);
            chunk.setFromOldFile(chunkMetaData.isFromOldTsFile());
            chunkReader = new ChunkReader(chunk, timeFilter);
            chunkReader.hasNextSatisfiedPage();
        }
        return chunkReader.loadPageReaderList();
    }

    public static List<ChunkMetadata> getChunkMetadataList(Path path, String filePath) throws IOException {
        TsFileSequenceReader tsFileReader = FileReaderManager.getInstance().get(filePath, true);
        return tsFileReader.getChunkMetadataList(path);
    }

    public static TsFileMetadata getTsFileMetadata(String filePath) throws IOException {
        TsFileSequenceReader reader = FileReaderManager.getInstance().get(filePath, true);
        return reader.readFileMetadata();
    }
}

