/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;

public class MinValueAggrResult
extends AggregateResult {
    public MinValueAggrResult(TSDataType dataType) {
        super(dataType, AggregationType.MIN_VALUE);
        this.reset();
    }

    @Override
    public Object getResult() {
        return this.hasCandidateResult() ? this.getValue() : null;
    }

    @Override
    public void updateResultFromStatistics(Statistics statistics) {
        Comparable minVal = (Comparable)statistics.getMinValue();
        this.updateResult(minVal);
    }

    @Override
    public void updateResultFromPageData(BatchData dataInThisPage) {
        this.updateResultFromPageData(dataInThisPage, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @Override
    public void updateResultFromPageData(BatchData dataInThisPage, long minBound, long maxBound) {
        while (dataInThisPage.hasCurrent() && dataInThisPage.currentTime() < maxBound && dataInThisPage.currentTime() >= minBound) {
            this.updateResult((Comparable)dataInThisPage.currentValue());
            dataInThisPage.next();
        }
    }

    @Override
    public void updateResultUsingTimestamps(long[] timestamps, int length, IReaderByTimestamp dataReader) throws IOException {
        Comparable minVal = null;
        Object[] values = dataReader.getValuesInTimestamps(timestamps, length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null || minVal != null && minVal.compareTo(values[i]) <= 0) continue;
            minVal = (Comparable)values[i];
        }
        this.updateResult(minVal);
    }

    @Override
    public void updateResultUsingValues(long[] timestamps, int length, Object[] values) {
        Comparable minVal = null;
        for (int i = 0; i < length; ++i) {
            if (values[i] == null || minVal != null && minVal.compareTo(values[i]) <= 0) continue;
            minVal = (Comparable)values[i];
        }
        this.updateResult(minVal);
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public void merge(AggregateResult another) {
        if (another.getResult() != null) {
            Object value = another.getResult();
            this.updateResult((Comparable)value);
        }
    }

    @Override
    protected void deserializeSpecificFields(ByteBuffer buffer) {
    }

    @Override
    protected void serializeSpecificFields(OutputStream outputStream) {
    }

    private void updateResult(Comparable<Object> minVal) {
        if (minVal == null) {
            return;
        }
        if (!this.hasCandidateResult() || minVal.compareTo(this.getValue()) < 0) {
            this.setValue(minVal);
        }
    }
}

