/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.logfile;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.Map;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagLogFile
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(TagLogFile.class);
    private FileChannel fileChannel;
    private static final String LENGTH_EXCEED_MSG = "Tag/Attribute exceeds the max length limit. Please enlarge tag_attribute_total_size in iotdb-engine.properties";
    private static final int MAX_LENGTH = IoTDBDescriptor.getInstance().getConfig().getTagAttributeTotalSize();
    private static final byte FILL_BYTE = 0;

    public TagLogFile(String schemaDir, String logFileName) throws IOException {
        File metadataDir = SystemFileFactory.INSTANCE.getFile(schemaDir);
        if (!metadataDir.exists()) {
            if (metadataDir.mkdirs()) {
                logger.info("create schema folder {}.", (Object)metadataDir);
            } else {
                logger.info("create schema folder {} failed.", (Object)metadataDir);
            }
        }
        File logFile = SystemFileFactory.INSTANCE.getFile(schemaDir + File.separator + logFileName);
        this.fileChannel = FileChannel.open(logFile.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.DSYNC);
        this.fileChannel.position(this.fileChannel.size());
    }

    public Pair<Map<String, String>, Map<String, String>> read(int size, long position) throws IOException {
        if (position < 0L) {
            return new Pair(Collections.emptyMap(), Collections.emptyMap());
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(size);
        this.fileChannel.read(byteBuffer, position);
        byteBuffer.flip();
        return new Pair((Object)ReadWriteIOUtils.readMap((ByteBuffer)byteBuffer), (Object)ReadWriteIOUtils.readMap((ByteBuffer)byteBuffer));
    }

    public Map<String, String> readTag(int size, long position) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(size);
        this.fileChannel.read(byteBuffer, position);
        byteBuffer.flip();
        return ReadWriteIOUtils.readMap((ByteBuffer)byteBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long write(Map<String, String> tagMap, Map<String, String> attributeMap) throws IOException, MetadataException {
        ByteBuffer byteBuffer = this.convertMapToByteBuffer(tagMap, attributeMap);
        TagLogFile tagLogFile = this;
        synchronized (tagLogFile) {
            long offset = this.fileChannel.position();
            this.fileChannel.write(byteBuffer);
            return offset;
        }
    }

    public void write(Map<String, String> tagMap, Map<String, String> attributeMap, long position) throws IOException, MetadataException {
        ByteBuffer byteBuffer = this.convertMapToByteBuffer(tagMap, attributeMap);
        this.fileChannel.write(byteBuffer, position);
    }

    private ByteBuffer convertMapToByteBuffer(Map<String, String> tagMap, Map<String, String> attributeMap) throws MetadataException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(MAX_LENGTH);
        int length = this.serializeMap(tagMap, byteBuffer, 0);
        length = this.serializeMap(attributeMap, byteBuffer, length);
        for (int i = length + 1; i <= MAX_LENGTH; ++i) {
            byteBuffer.put((byte)0);
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    private int serializeMap(Map<String, String> map, ByteBuffer byteBuffer, int length) throws MetadataException {
        if (map == null) {
            if ((length += 4) > MAX_LENGTH) {
                throw new MetadataException(LENGTH_EXCEED_MSG);
            }
            ReadWriteIOUtils.write((int)0, (ByteBuffer)byteBuffer);
            return length;
        }
        if ((length += 4) > MAX_LENGTH) {
            throw new MetadataException(LENGTH_EXCEED_MSG);
        }
        ReadWriteIOUtils.write((int)map.size(), (ByteBuffer)byteBuffer);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            byte[] bytes = entry.getKey().getBytes();
            if ((length += 4 + bytes.length) > MAX_LENGTH) {
                throw new MetadataException(LENGTH_EXCEED_MSG);
            }
            ReadWriteIOUtils.write((int)bytes.length, (ByteBuffer)byteBuffer);
            byteBuffer.put(bytes);
            bytes = entry.getValue().getBytes();
            if ((length += 4 + bytes.length) > MAX_LENGTH) {
                throw new MetadataException(LENGTH_EXCEED_MSG);
            }
            ReadWriteIOUtils.write((int)bytes.length, (ByteBuffer)byteBuffer);
            byteBuffer.put(bytes);
        }
        return length;
    }

    @Override
    public void close() throws IOException {
        this.fileChannel.force(true);
        this.fileChannel.close();
        this.fileChannel = null;
    }
}

