/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.merge.recover;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.apache.iotdb.db.engine.merge.manage.MergeResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.metadata.PartialPath;

public class MergeLogger {
    public static final String MERGE_LOG_NAME = "merge.log";
    static final String STR_SEQ_FILES = "seqFiles";
    static final String STR_UNSEQ_FILES = "unseqFiles";
    static final String STR_TIMESERIES = "timeseries";
    static final String STR_START = "start";
    static final String STR_END = "end";
    static final String STR_ALL_TS_END = "all ts end";
    static final String STR_MERGE_START = "merge start";
    static final String STR_MERGE_END = "merge end";
    private BufferedWriter logStream;

    public MergeLogger(String storageGroupDir) throws IOException {
        this.logStream = new BufferedWriter(new FileWriter(new File(storageGroupDir, MERGE_LOG_NAME), true));
    }

    public void close() throws IOException {
        this.logStream.close();
    }

    public void logTSStart(List<PartialPath> paths) throws IOException {
        this.logStream.write(STR_START);
        for (PartialPath path : paths) {
            this.logStream.write(" " + path);
        }
        this.logStream.newLine();
        this.logStream.flush();
    }

    public void logFilePosition(File file) throws IOException {
        this.logStream.write(String.format("%s %d", file.getAbsolutePath(), file.length()));
        this.logStream.newLine();
        this.logStream.flush();
    }

    public void logTSEnd() throws IOException {
        this.logStream.write(STR_END);
        this.logStream.newLine();
        this.logStream.flush();
    }

    public void logAllTsEnd() throws IOException {
        this.logStream.write(STR_ALL_TS_END);
        this.logStream.newLine();
        this.logStream.flush();
    }

    public void logFileMergeStart(File file, long position) throws IOException {
        this.logStream.write(String.format("%s %d", file.getAbsolutePath(), position));
        this.logStream.newLine();
        this.logStream.flush();
    }

    public void logFileMergeEnd() throws IOException {
        this.logStream.write(STR_END);
        this.logStream.newLine();
        this.logStream.flush();
    }

    public void logMergeEnd() throws IOException {
        this.logStream.write(STR_MERGE_END);
        this.logStream.newLine();
        this.logStream.flush();
    }

    public void logFiles(MergeResource resource) throws IOException {
        this.logSeqFiles(resource.getSeqFiles());
        this.logUnseqFiles(resource.getUnseqFiles());
    }

    private void logSeqFiles(List<TsFileResource> seqFiles) throws IOException {
        this.logStream.write(STR_SEQ_FILES);
        this.logStream.newLine();
        for (TsFileResource tsFileResource : seqFiles) {
            this.logStream.write(tsFileResource.getTsFile().getAbsolutePath());
            this.logStream.newLine();
        }
        this.logStream.flush();
    }

    private void logUnseqFiles(List<TsFileResource> unseqFiles) throws IOException {
        this.logStream.write(STR_UNSEQ_FILES);
        this.logStream.newLine();
        for (TsFileResource tsFileResource : unseqFiles) {
            this.logStream.write(tsFileResource.getTsFile().getAbsolutePath());
            this.logStream.newLine();
        }
        this.logStream.flush();
    }

    public void logMergeStart() throws IOException {
        this.logStream.write(STR_MERGE_START);
        this.logStream.newLine();
        this.logStream.flush();
    }
}

