/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.cost.statistic;

public class ConcurrentCircularArray {
    long[] data;
    int tail;
    int head;

    public ConcurrentCircularArray(int size) {
        this.data = new long[size];
        this.head = 0;
        this.tail = 0;
    }

    public synchronized boolean put(long d) {
        if ((this.tail + 1) % this.data.length == this.head) {
            return false;
        }
        this.data[this.tail++] = d;
        this.tail %= this.data.length;
        return true;
    }

    public synchronized boolean hasData() {
        return this.tail != this.head;
    }

    public synchronized long take() {
        if (this.tail != this.head) {
            long result = this.data[this.head++];
            this.head %= this.data.length;
            return result;
        }
        return -1L;
    }

    public synchronized void clear() {
        this.head = 0;
        this.tail = 0;
    }
}

