/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query.reader.mult;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.cluster.client.async.AsyncDataClient;
import org.apache.iotdb.cluster.client.sync.SyncDataClient;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.query.RemoteQueryContext;
import org.apache.iotdb.cluster.rpc.thrift.MultSeriesQueryRequest;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.server.RaftServer;
import org.apache.iotdb.cluster.server.handlers.caller.GenericHandler;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.utils.SerializeUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.read.filter.operator.AndFilter;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultDataSourceInfo {
    private static final Logger logger = LoggerFactory.getLogger(MultDataSourceInfo.class);
    private long readerId = -1L;
    private Node curSource;
    private PartitionGroup partitionGroup;
    private List<PartialPath> partialPaths;
    private List<TSDataType> dataTypes;
    private MultSeriesQueryRequest request;
    private RemoteQueryContext context;
    private MetaGroupMember metaGroupMember;
    private List<Node> nodes;
    private int curPos;
    private boolean isNoData = false;
    private boolean isNoClient = false;

    public MultDataSourceInfo(PartitionGroup group, List<PartialPath> partialPaths, List<TSDataType> dataTypes, MultSeriesQueryRequest request, RemoteQueryContext context, MetaGroupMember metaGroupMember, List<Node> nodes) {
        this.partitionGroup = group;
        this.partialPaths = partialPaths;
        this.dataTypes = dataTypes;
        this.request = request;
        this.context = context;
        this.metaGroupMember = metaGroupMember;
        this.nodes = nodes;
        this.curPos = nodes.size() - 1;
        this.curSource = nodes.get(this.curPos);
    }

    public boolean hasNextDataClient(long timestamp) {
        if (this.nodes.isEmpty()) {
            this.isNoData = false;
            return false;
        }
        int nextNodePos = (this.curPos + 1) % this.nodes.size();
        do {
            Node node = this.nodes.get(nextNodePos);
            logger.debug("querying {} from {} of {}", new Object[]{this.request.path, node, this.partitionGroup.getHeader()});
            try {
                Long newReaderId = this.getReaderId(node, timestamp);
                if (newReaderId != null) {
                    logger.debug("get a readerId {} for {} from {}", new Object[]{newReaderId, this.request.path, node});
                    if (newReaderId != -1L) {
                        this.context.registerRemoteNode(node, this.partitionGroup.getHeader());
                        this.readerId = newReaderId;
                        this.curSource = node;
                        this.curPos = nextNodePos;
                        return true;
                    }
                    this.isNoClient = true;
                    this.isNoData = true;
                    return false;
                }
            }
            catch (IOException | TException e) {
                logger.error("Cannot query {} from {}", new Object[]{this.request.path, node, e});
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error("Cannot query {} from {}", new Object[]{this.request.path, node, e});
            }
        } while ((nextNodePos = (nextNodePos + 1) % this.nodes.size()) != this.curPos);
        this.isNoClient = true;
        this.isNoData = false;
        return false;
    }

    public List<PartialPath> getPartialPaths() {
        return this.partialPaths;
    }

    private Long getReaderId(Node node, long timestamp) throws TException, InterruptedException, IOException {
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            return this.applyForReaderIdAsync(node, timestamp);
        }
        return this.applyForReaderIdSync(node, timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long applyForReaderIdAsync(Node node, long timestamp) throws TException, InterruptedException, IOException {
        TimeFilter.TimeGt newFilter;
        AsyncDataClient client = this.metaGroupMember.getClientProvider().getAsyncDataClient(node, RaftServer.getReadOperationTimeoutMS());
        AtomicReference result = new AtomicReference();
        GenericHandler handler = new GenericHandler(client.getNode(), result);
        if (this.request.isSetTimeFilterBytes()) {
            Filter timeFilter = FilterFactory.deserialize((ByteBuffer)this.request.timeFilterBytes);
            newFilter = new AndFilter(timeFilter, (Filter)TimeFilter.gt((long)timestamp));
        } else {
            newFilter = TimeFilter.gt((long)timestamp);
        }
        this.request.setTimeFilterBytes(SerializeUtils.serializeFilter((Filter)newFilter));
        client.queryMultSeries(this.request, handler);
        AtomicReference atomicReference = result;
        synchronized (atomicReference) {
            if (result.get() == null && handler.getException() == null) {
                result.wait(RaftServer.getReadOperationTimeoutMS());
            }
        }
        return (Long)result.get();
    }

    private Long applyForReaderIdSync(Node node, long timestamp) throws TException, IOException {
        try (SyncDataClient client = this.metaGroupMember.getClientProvider().getSyncDataClient(node, RaftServer.getReadOperationTimeoutMS());){
            long newReaderId;
            TimeFilter.TimeGt newFilter;
            if (this.request.isSetTimeFilterBytes()) {
                Filter timeFilter = FilterFactory.deserialize((ByteBuffer)this.request.timeFilterBytes);
                newFilter = new AndFilter(timeFilter, (Filter)TimeFilter.gt((long)timestamp));
            } else {
                newFilter = TimeFilter.gt((long)timestamp);
            }
            this.request.setTimeFilterBytes(SerializeUtils.serializeFilter((Filter)newFilter));
            try {
                newReaderId = client.queryMultSeries(this.request);
            }
            catch (TException e) {
                client.getInputProtocol().getTransport().close();
                throw e;
            }
            Long l = newReaderId;
            return l;
        }
    }

    public long getReaderId() {
        return this.readerId;
    }

    public List<TSDataType> getDataTypes() {
        return this.dataTypes;
    }

    public Node getHeader() {
        return this.partitionGroup.getHeader();
    }

    AsyncDataClient getCurAsyncClient(int timeout) throws IOException {
        return this.isNoClient ? null : this.metaGroupMember.getClientProvider().getAsyncDataClient(this.curSource, timeout);
    }

    SyncDataClient getCurSyncClient(int timeout) throws IOException {
        return this.isNoClient ? null : this.metaGroupMember.getClientProvider().getSyncDataClient(this.curSource, timeout);
    }

    public boolean isNoData() {
        return this.isNoData;
    }

    private boolean isNoClient() {
        return this.isNoClient;
    }

    public String toString() {
        return "DataSourceInfo{readerId=" + this.readerId + ", curSource=" + this.curSource + ", partitionGroup=" + this.partitionGroup + ", request=" + this.request + '}';
    }

    boolean checkCurClient() throws IOException {
        if (this.isNoClient()) {
            if (!this.isNoData()) {
                throw new IOException("no available client.");
            }
            return false;
        }
        return true;
    }

    Node getCurrentNode() {
        return this.curSource;
    }
}

