/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.rescon.PrimitiveArrayManager;
import org.apache.iotdb.db.utils.datastructure.BinaryTVList;
import org.apache.iotdb.db.utils.datastructure.BooleanTVList;
import org.apache.iotdb.db.utils.datastructure.DoubleTVList;
import org.apache.iotdb.db.utils.datastructure.FloatTVList;
import org.apache.iotdb.db.utils.datastructure.IntTVList;
import org.apache.iotdb.db.utils.datastructure.LongTVList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.apache.iotdb.tsfile.utils.Binary;

public abstract class TVList {
    protected static final int SMALL_ARRAY_LENGTH = 32;
    private static final String ERR_DATATYPE_NOT_CONSISTENT = "DataType not consistent";
    protected List<long[]> timestamps = new ArrayList<long[]>();
    protected int size = 0;
    protected long[][] sortedTimestamps;
    protected boolean sorted = true;
    protected AtomicInteger referenceCount;
    protected long pivotTime;
    protected long minTime = Long.MAX_VALUE;
    private long version;

    public TVList() {
        this.referenceCount = new AtomicInteger();
    }

    public static TVList newList(TSDataType dataType) {
        switch (dataType) {
            case TEXT: {
                return new BinaryTVList();
            }
            case FLOAT: {
                return new FloatTVList();
            }
            case INT32: {
                return new IntTVList();
            }
            case INT64: {
                return new LongTVList();
            }
            case DOUBLE: {
                return new DoubleTVList();
            }
            case BOOLEAN: {
                return new BooleanTVList();
            }
        }
        return null;
    }

    public static long tvListArrayMemSize(TSDataType type) {
        long size = 0L;
        size += (long)PrimitiveArrayManager.ARRAY_SIZE * 8L;
        return size += (long)PrimitiveArrayManager.ARRAY_SIZE * (long)type.getDataTypeSize();
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public void increaseReferenceCount() {
        this.referenceCount.incrementAndGet();
    }

    public int getReferenceCount() {
        return this.referenceCount.get();
    }

    public int size() {
        return this.size;
    }

    public long getTime(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int arrayIndex = index / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = index % PrimitiveArrayManager.ARRAY_SIZE;
        return this.timestamps.get(arrayIndex)[elementIndex];
    }

    public void putLong(long time, long value) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putInt(long time, int value) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putFloat(long time, float value) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putDouble(long time, double value) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putBinary(long time, Binary value) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putBoolean(long time, boolean value) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putLongs(long[] time, long[] value, int start, int end) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putInts(long[] time, int[] value, int start, int end) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putFloats(long[] time, float[] value, int start, int end) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putDoubles(long[] time, double[] value, int start, int end) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putBinaries(long[] time, Binary[] value, int start, int end) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putBooleans(long[] time, boolean[] value, int start, int end) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public long getLong(int index) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public int getInt(int index) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public float getFloat(int index) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public double getDouble(int index) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public Binary getBinary(int index) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public boolean getBoolean(int index) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public abstract void sort();

    public long getMinTime() {
        return this.minTime;
    }

    public long getVersion() {
        return this.version;
    }

    protected abstract void set(int var1, int var2);

    protected abstract void setFromSorted(int var1, int var2);

    protected abstract void setToSorted(int var1, int var2);

    protected abstract void reverseRange(int var1, int var2);

    protected abstract void expandValues();

    public abstract TVList clone();

    public TVList clone(long version) {
        this.version = version;
        return this.clone();
    }

    protected abstract void releaseLastValueArray();

    protected void releaseLastTimeArray() {
        PrimitiveArrayManager.release(this.timestamps.remove(this.timestamps.size() - 1));
    }

    public int delete(long lowerBound, long upperBound) {
        int newSize = 0;
        this.minTime = Long.MAX_VALUE;
        for (int i = 0; i < this.size; ++i) {
            long time = this.getTime(i);
            if (time >= lowerBound && time <= upperBound) continue;
            this.set(i, newSize++);
            this.minTime = Math.min(time, this.minTime);
        }
        int deletedNumber = this.size - newSize;
        this.size = newSize;
        int newArrayNum = newSize / PrimitiveArrayManager.ARRAY_SIZE;
        if (newSize % PrimitiveArrayManager.ARRAY_SIZE != 0) {
            ++newArrayNum;
        }
        for (int releaseIdx = newArrayNum; releaseIdx < this.timestamps.size(); ++releaseIdx) {
            this.releaseLastTimeArray();
            this.releaseLastValueArray();
        }
        return deletedNumber;
    }

    protected void cloneAs(TVList cloneList) {
        for (long[] timestampArray : this.timestamps) {
            cloneList.timestamps.add(this.cloneTime(timestampArray));
        }
        cloneList.size = this.size;
        cloneList.sorted = this.sorted;
        cloneList.minTime = this.minTime;
    }

    public void clear() {
        this.size = 0;
        this.sorted = true;
        this.minTime = Long.MAX_VALUE;
        this.clearTime();
        this.clearSortedTime();
        this.clearValue();
        this.clearSortedValue();
    }

    protected void clearTime() {
        if (this.timestamps != null) {
            for (long[] dataArray : this.timestamps) {
                PrimitiveArrayManager.release(dataArray);
            }
            this.timestamps.clear();
        }
    }

    protected void clearSortedTime() {
        if (this.sortedTimestamps != null) {
            this.sortedTimestamps = null;
        }
    }

    abstract void clearValue();

    abstract void clearSortedValue();

    protected void checkExpansion() {
        if (this.size % PrimitiveArrayManager.ARRAY_SIZE == 0) {
            this.expandValues();
            this.timestamps.add((long[])this.getPrimitiveArraysByType(TSDataType.INT64));
        }
    }

    protected Object getPrimitiveArraysByType(TSDataType dataType) {
        return PrimitiveArrayManager.allocate(dataType);
    }

    protected long[] cloneTime(long[] array) {
        long[] cloneArray = new long[array.length];
        System.arraycopy(array, 0, cloneArray, 0, array.length);
        return cloneArray;
    }

    protected void sort(int lo, int hi) {
        if (this.sorted) {
            return;
        }
        if (lo == hi) {
            return;
        }
        if (hi - lo <= 32) {
            int initRunLen = this.countRunAndMakeAscending(lo, hi);
            this.binarySort(lo, hi, lo + initRunLen);
            return;
        }
        int mid = lo + hi >>> 1;
        this.sort(lo, mid);
        this.sort(mid, hi);
        this.merge(lo, mid, hi);
    }

    protected int countRunAndMakeAscending(int lo, int hi) {
        assert (lo < hi);
        int runHi = lo + 1;
        if (runHi == hi) {
            return 1;
        }
        if (this.getTime(runHi++) < this.getTime(lo)) {
            while (runHi < hi && this.getTime(runHi) < this.getTime(runHi - 1)) {
                ++runHi;
            }
            this.reverseRange(lo, runHi);
        } else {
            while (runHi < hi && this.getTime(runHi) >= this.getTime(runHi - 1)) {
                ++runHi;
            }
        }
        return runHi - lo;
    }

    protected int compare(int idx1, int idx2) {
        long t1 = this.getTime(idx1);
        long t2 = this.getTime(idx2);
        return Long.compare(t1, t2);
    }

    protected abstract void saveAsPivot(int var1);

    protected abstract void setPivotTo(int var1);

    protected void binarySort(int lo, int hi, int start) {
        assert (lo <= start && start <= hi);
        if (start == lo) {
            ++start;
        }
        while (start < hi) {
            int n;
            this.saveAsPivot(start);
            int left = lo;
            int right = start;
            assert (left <= right);
            while (left < right) {
                int mid = left + right >>> 1;
                if (this.compare(start, mid) < 0) {
                    right = mid;
                    continue;
                }
                left = mid + 1;
            }
            assert (left == right);
            for (int i = n = start - left; i >= 1; --i) {
                this.set(left + i - 1, left + i);
            }
            this.setPivotTo(left);
            ++start;
        }
        for (int i = lo; i < hi; ++i) {
            this.setToSorted(i, i);
        }
    }

    protected void merge(int lo, int mid, int hi) {
        int end;
        int start;
        int tmpIdx = 0;
        int leftIdx = lo;
        int rightIdx = mid;
        int endSide = 0;
        while (endSide == 0) {
            if (this.compare(leftIdx, rightIdx) <= 0) {
                this.setToSorted(leftIdx, lo + tmpIdx);
                ++tmpIdx;
                if (++leftIdx != mid) continue;
                endSide = 1;
                continue;
            }
            this.setToSorted(rightIdx, lo + tmpIdx);
            ++tmpIdx;
            if (++rightIdx != hi) continue;
            endSide = 2;
        }
        if (endSide == 1) {
            start = rightIdx;
            end = hi;
        } else {
            start = leftIdx;
            end = mid;
        }
        while (start < end) {
            this.setToSorted(start, lo + tmpIdx);
            ++tmpIdx;
            ++start;
        }
        for (int i = lo; i < hi; ++i) {
            this.setFromSorted(i, i);
        }
    }

    void updateMinTimeAndSorted(long[] time) {
        this.updateMinTimeAndSorted(time, 0, time.length);
    }

    void updateMinTimeAndSorted(long[] time, int start, int end) {
        int length = time.length;
        long inPutMinTime = Long.MAX_VALUE;
        boolean inputSorted = true;
        for (int i = start; i < end; ++i) {
            inPutMinTime = Math.min(inPutMinTime, time[i]);
            if (!inputSorted || i >= length - 1 || time[i] <= time[i + 1]) continue;
            inputSorted = false;
        }
        this.minTime = Math.min(inPutMinTime, this.minTime);
        this.sorted = this.sorted && inputSorted && (this.size == 0 || inPutMinTime >= this.getTime(this.size - 1));
    }

    public abstract TimeValuePair getTimeValuePair(int var1);

    protected abstract TimeValuePair getTimeValuePair(int var1, long var2, Integer var4, TSEncoding var5);

    public IPointReader getIterator() {
        return new Ite();
    }

    public IPointReader getIterator(int floatPrecision, TSEncoding encoding, int size, List<TimeRange> deletionList) {
        return new Ite(floatPrecision, encoding, size, deletionList);
    }

    public abstract TSDataType getDataType();

    public long getLastTime() {
        return this.getTime(this.size - 1);
    }

    private class Ite
    implements IPointReader {
        private TimeValuePair cachedTimeValuePair;
        private boolean hasCachedPair;
        private int cur;
        private Integer floatPrecision;
        private TSEncoding encoding;
        private int deleteCursor = 0;
        private int iteSize = 0;
        private List<TimeRange> deletionList;

        public Ite() {
            this.iteSize = TVList.this.size;
        }

        public Ite(int floatPrecision, TSEncoding encoding, int size, List<TimeRange> deletionList) {
            this.floatPrecision = floatPrecision;
            this.encoding = encoding;
            this.iteSize = size;
            this.deletionList = deletionList;
        }

        public boolean hasNextTimeValuePair() {
            if (this.hasCachedPair) {
                return true;
            }
            while (this.cur < this.iteSize) {
                long time = TVList.this.getTime(this.cur);
                if (this.isPointDeleted(time) || this.cur + 1 < TVList.this.size() && time == TVList.this.getTime(this.cur + 1)) {
                    ++this.cur;
                    continue;
                }
                this.cachedTimeValuePair = TVList.this.getTimeValuePair(this.cur, time, this.floatPrecision, this.encoding);
                this.hasCachedPair = true;
                ++this.cur;
                return true;
            }
            return false;
        }

        private boolean isPointDeleted(long timestamp) {
            while (this.deletionList != null && this.deleteCursor < this.deletionList.size()) {
                if (this.deletionList.get(this.deleteCursor).contains(timestamp)) {
                    return true;
                }
                if (this.deletionList.get(this.deleteCursor).getMax() < timestamp) {
                    ++this.deleteCursor;
                    continue;
                }
                return false;
            }
            return false;
        }

        public TimeValuePair nextTimeValuePair() throws IOException {
            if (this.hasCachedPair || this.hasNextTimeValuePair()) {
                this.hasCachedPair = false;
                return this.cachedTimeValuePair;
            }
            throw new IOException("no next time value pair");
        }

        public TimeValuePair currentTimeValuePair() {
            return this.cachedTimeValuePair;
        }

        public void close() throws IOException {
        }
    }
}

