/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.control;

import java.time.ZoneId;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.dataset.UDTFDataSet;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionManager.class);
    private final ThreadLocal<Long> currSessionId = new ThreadLocal();
    private final Map<Long, String> sessionIdToUsername = new ConcurrentHashMap<Long, String>();
    private final Map<Long, ZoneId> sessionIdToZoneId = new ConcurrentHashMap<Long, ZoneId>();
    private final AtomicLong sessionIdGenerator = new AtomicLong();
    private final AtomicLong statementIdGenerator = new AtomicLong();
    private final Map<Long, Set<Long>> sessionIdToStatementId = new ConcurrentHashMap<Long, Set<Long>>();
    private final Map<Long, Set<Long>> statementIdToQueryId = new ConcurrentHashMap<Long, Set<Long>>();
    private final Map<Long, QueryDataSet> queryIdToDataSet = new ConcurrentHashMap<Long, QueryDataSet>();

    private SessionManager() {
    }

    public Long getCurrSessionId() {
        return this.currSessionId.get();
    }

    public void removeCurrSessionId() {
        this.currSessionId.remove();
    }

    public TimeZone getCurrSessionTimeZone() {
        if (this.getCurrSessionId() != null) {
            return TimeZone.getTimeZone(SessionManager.getInstance().getZoneId(this.getCurrSessionId()));
        }
        return TimeZone.getTimeZone("+08:00");
    }

    public long requestSessionId(String username, String zoneId) {
        long sessionId = this.sessionIdGenerator.incrementAndGet();
        this.currSessionId.set(sessionId);
        this.sessionIdToUsername.put(sessionId, username);
        this.sessionIdToZoneId.put(sessionId, ZoneId.of(zoneId));
        return sessionId;
    }

    public boolean releaseSessionResource(long sessionId) {
        this.sessionIdToZoneId.remove(sessionId);
        Set<Long> statementIdSet = this.sessionIdToStatementId.remove(sessionId);
        if (statementIdSet != null) {
            for (Long statementId : statementIdSet) {
                Set<Long> queryIdSet = this.statementIdToQueryId.remove(statementId);
                if (queryIdSet == null) continue;
                for (Long queryId : queryIdSet) {
                    this.releaseQueryResourceNoExceptions(queryId);
                }
            }
        }
        return this.sessionIdToUsername.remove(sessionId) != null;
    }

    public long requestStatementId(long sessionId) {
        long statementId = this.statementIdGenerator.incrementAndGet();
        this.sessionIdToStatementId.computeIfAbsent(sessionId, s -> new CopyOnWriteArraySet()).add(statementId);
        return statementId;
    }

    public void closeStatement(long sessionId, long statementId) {
        Set<Long> queryIdSet = this.statementIdToQueryId.remove(statementId);
        if (queryIdSet != null) {
            for (Long queryId : queryIdSet) {
                this.releaseQueryResourceNoExceptions(queryId);
            }
        }
        if (this.sessionIdToStatementId.containsKey(sessionId)) {
            this.sessionIdToStatementId.get(sessionId).remove(statementId);
        }
    }

    public long requestQueryId(Long statementId, boolean isDataQuery) {
        long queryId = this.requestQueryId(isDataQuery);
        this.statementIdToQueryId.computeIfAbsent(statementId, k -> new CopyOnWriteArraySet()).add(queryId);
        return queryId;
    }

    public long requestQueryId(boolean isDataQuery) {
        return QueryResourceManager.getInstance().assignQueryId(isDataQuery);
    }

    public void releaseQueryResource(long queryId) throws StorageEngineException {
        QueryDataSet dataSet = this.queryIdToDataSet.remove(queryId);
        if (dataSet instanceof UDTFDataSet) {
            ((UDTFDataSet)dataSet).finalizeUDFs(queryId);
        }
        QueryResourceManager.getInstance().endQuery(queryId);
    }

    public void releaseQueryResourceNoExceptions(long queryId) {
        if (queryId != -1L) {
            try {
                this.releaseQueryResource(queryId);
            }
            catch (Exception e) {
                LOGGER.warn("Error occurred while releasing query resource: ", (Throwable)e);
            }
        }
    }

    public String getUsername(Long sessionId) {
        return this.sessionIdToUsername.get(sessionId);
    }

    public ZoneId getZoneId(Long sessionId) {
        return this.sessionIdToZoneId.get(sessionId);
    }

    public void setTimezone(Long sessionId, String zone) {
        this.sessionIdToZoneId.put(sessionId, ZoneId.of(zone));
    }

    public boolean hasDataset(Long queryId) {
        return this.queryIdToDataSet.containsKey(queryId);
    }

    public QueryDataSet getDataset(Long queryId) {
        return this.queryIdToDataSet.get(queryId);
    }

    public void setDataset(Long queryId, QueryDataSet dataSet) {
        this.queryIdToDataSet.put(queryId, dataSet);
    }

    public void removeDataset(Long queryId) {
        this.queryIdToDataSet.remove(queryId);
    }

    public void closeDataset(Long statementId, Long queryId) {
        this.releaseQueryResourceNoExceptions(queryId);
        if (this.statementIdToQueryId.containsKey(statementId)) {
            this.statementIdToQueryId.get(statementId).remove(queryId);
        }
    }

    public static SessionManager getInstance() {
        return SessionManagerHelper.INSTANCE;
    }

    private static class SessionManagerHelper {
        private static final SessionManager INSTANCE = new SessionManager();

        private SessionManagerHelper() {
        }
    }
}

