/*
 * Decompiled with CFR 0.152.
 */
package me.tongfei.progressbar;

import java.io.InputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.BaseStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import me.tongfei.progressbar.DefaultProgressBarRenderer;
import me.tongfei.progressbar.ProgressBarBuilder;
import me.tongfei.progressbar.ProgressBarConsumer;
import me.tongfei.progressbar.ProgressBarRenderer;
import me.tongfei.progressbar.ProgressBarStyle;
import me.tongfei.progressbar.ProgressState;
import me.tongfei.progressbar.ProgressUpdateAction;
import me.tongfei.progressbar.Util;
import me.tongfei.progressbar.wrapped.ProgressBarWrappedInputStream;
import me.tongfei.progressbar.wrapped.ProgressBarWrappedIterable;
import me.tongfei.progressbar.wrapped.ProgressBarWrappedIterator;
import me.tongfei.progressbar.wrapped.ProgressBarWrappedSpliterator;

public class ProgressBar
implements AutoCloseable {
    private ProgressState progress;
    private ProgressUpdateAction action;
    private ScheduledFuture<Void> scheduledTask;

    public ProgressBar(String task, long initialMax) {
        this(task, initialMax, 1000, System.err, ProgressBarStyle.COLORFUL_UNICODE_BLOCK, "", 1L, false, null, ChronoUnit.SECONDS, 0L, Duration.ZERO);
    }

    public ProgressBar(String task, long initialMax, int updateIntervalMillis, PrintStream os, ProgressBarStyle style, String unitName, long unitSize, boolean showSpeed, DecimalFormat speedFormat, ChronoUnit speedUnit, long processed, Duration elapsed) {
        this(task, initialMax, updateIntervalMillis, processed, elapsed, new DefaultProgressBarRenderer(style, unitName, unitSize, showSpeed, speedFormat, speedUnit), Util.createConsoleConsumer(os));
    }

    public ProgressBar(String task, long initialMax, int updateIntervalMillis, long processed, Duration elapsed, ProgressBarRenderer renderer, ProgressBarConsumer consumer) {
        this.progress = new ProgressState(task, initialMax, processed, elapsed);
        this.action = new ProgressUpdateAction(this.progress, renderer, consumer);
        this.scheduledTask = Util.executor.scheduleAtFixedRate(this.action, 0L, updateIntervalMillis, TimeUnit.MILLISECONDS);
    }

    public ProgressBar stepBy(long n) {
        this.progress.stepBy(n);
        return this;
    }

    public ProgressBar stepTo(long n) {
        this.progress.stepTo(n);
        return this;
    }

    public ProgressBar step() {
        this.progress.stepBy(1L);
        return this;
    }

    public ProgressBar maxHint(long n) {
        if (n < 0L) {
            this.progress.setAsIndefinite();
        } else {
            this.progress.setAsDefinite();
            this.progress.maxHint(n);
        }
        return this;
    }

    public ProgressBar pause() {
        this.progress.pause();
        return this;
    }

    public ProgressBar resume() {
        this.progress.resume();
        return this;
    }

    @Override
    public void close() {
        this.scheduledTask.cancel(false);
        this.progress.kill();
        try {
            Util.executor.schedule(this.action, 0L, TimeUnit.NANOSECONDS).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
    }

    public ProgressBar setExtraMessage(String msg) {
        this.progress.setExtraMessage(msg);
        return this;
    }

    public long getCurrent() {
        return this.progress.getCurrent();
    }

    public long getMax() {
        return this.progress.getMax();
    }

    public String getTaskName() {
        return this.progress.getTaskName();
    }

    public String getExtraMessage() {
        return this.progress.getExtraMessage();
    }

    public static <T> Iterator<T> wrap(Iterator<T> it, String task) {
        return ProgressBar.wrap(it, new ProgressBarBuilder().setTaskName(task).setInitialMax(-1L));
    }

    public static <T> Iterator<T> wrap(Iterator<T> it, ProgressBarBuilder pbb) {
        return new ProgressBarWrappedIterator<T>(it, pbb.build());
    }

    public static <T> Iterable<T> wrap(Iterable<T> ts, String task) {
        return ProgressBar.wrap(ts, new ProgressBarBuilder().setTaskName(task));
    }

    public static <T> Iterable<T> wrap(Iterable<T> ts, ProgressBarBuilder pbb) {
        long size = ts.spliterator().getExactSizeIfKnown();
        if (size != -1L) {
            pbb.setInitialMax(size);
        }
        return new ProgressBarWrappedIterable<T>(ts, pbb);
    }

    public static InputStream wrap(InputStream is, String task) {
        ProgressBarBuilder pbb = new ProgressBarBuilder().setTaskName(task).setInitialMax(Util.getInputStreamSize(is));
        return ProgressBar.wrap(is, pbb);
    }

    public static InputStream wrap(InputStream is, ProgressBarBuilder pbb) {
        long size = Util.getInputStreamSize(is);
        if (size != -1L) {
            pbb.setInitialMax(size);
        }
        return new ProgressBarWrappedInputStream(is, pbb.build());
    }

    public static <T> Spliterator<T> wrap(Spliterator<T> sp, String task) {
        ProgressBarBuilder pbb = new ProgressBarBuilder().setTaskName(task);
        return ProgressBar.wrap(sp, pbb);
    }

    public static <T> Spliterator<T> wrap(Spliterator<T> sp, ProgressBarBuilder pbb) {
        long size = sp.getExactSizeIfKnown();
        if (size != -1L) {
            pbb.setInitialMax(size);
        }
        return new ProgressBarWrappedSpliterator<T>(sp, pbb.build());
    }

    public static <T, S extends BaseStream<T, S>> Stream<T> wrap(S stream, String task) {
        ProgressBarBuilder pbb = new ProgressBarBuilder().setTaskName(task);
        return ProgressBar.wrap(stream, pbb);
    }

    public static <T, S extends BaseStream<T, S>> Stream<T> wrap(S stream, ProgressBarBuilder pbb) {
        Spliterator<T> sp = ProgressBar.wrap(stream.spliterator(), pbb);
        return StreamSupport.stream(sp, stream.isParallel());
    }

    public static <T> Stream<T> wrap(T[] array, String task) {
        ProgressBarBuilder pbb = new ProgressBarBuilder().setTaskName(task).setInitialMax(array.length);
        return ProgressBar.wrap(array, pbb);
    }

    public static <T> Stream<T> wrap(T[] array, ProgressBarBuilder pbb) {
        return ProgressBar.wrap(Arrays.stream(array), pbb);
    }
}

