/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertMultiTabletPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowsPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.qp.physical.sys.AlterTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.AuthorPlan;
import org.apache.iotdb.db.qp.physical.sys.ChangeAliasPlan;
import org.apache.iotdb.db.qp.physical.sys.ChangeTagOffsetPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateIndexPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateMultiTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DataAuthPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DropIndexPlan;
import org.apache.iotdb.db.qp.physical.sys.FlushPlan;
import org.apache.iotdb.db.qp.physical.sys.LoadConfigurationPlan;
import org.apache.iotdb.db.qp.physical.sys.MNodePlan;
import org.apache.iotdb.db.qp.physical.sys.MeasurementMNodePlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTTLPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowDevicesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.StorageGroupMNodePlan;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public abstract class PhysicalPlan {
    private static final String SERIALIZATION_UNIMPLEMENTED = "serialization unimplemented";
    private boolean isQuery;
    private Operator.OperatorType operatorType;
    private static final int NULL_VALUE_LEN = -1;
    protected boolean canBeSplit = true;
    private String loginUserName;
    protected long index;
    private boolean debug;

    public boolean canBeSplit() {
        return this.canBeSplit;
    }

    protected PhysicalPlan(boolean isQuery) {
        this.isQuery = isQuery;
    }

    protected PhysicalPlan(boolean isQuery, Operator.OperatorType operatorType) {
        this.isQuery = isQuery;
        this.operatorType = operatorType;
    }

    public String printQueryPlan() {
        return "abstract plan";
    }

    public abstract List<PartialPath> getPaths();

    public void setPaths(List<PartialPath> paths) {
    }

    public boolean isQuery() {
        return this.isQuery;
    }

    public Operator.OperatorType getOperatorType() {
        return this.operatorType;
    }

    public void setOperatorType(Operator.OperatorType operatorType) {
        this.operatorType = operatorType;
    }

    public List<String> getAggregations() {
        return Collections.emptyList();
    }

    public void setQuery(boolean query) {
        this.isQuery = query;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void serialize(DataOutputStream stream) throws IOException {
        throw new UnsupportedOperationException(SERIALIZATION_UNIMPLEMENTED);
    }

    public void serialize(ByteBuffer buffer) {
        throw new UnsupportedOperationException(SERIALIZATION_UNIMPLEMENTED);
    }

    public void deserialize(ByteBuffer buffer) throws IllegalPathException {
        throw new UnsupportedOperationException(SERIALIZATION_UNIMPLEMENTED);
    }

    protected void putString(ByteBuffer buffer, String value) {
        if (value == null) {
            buffer.putInt(-1);
        } else {
            ReadWriteIOUtils.write((String)value, (ByteBuffer)buffer);
        }
    }

    protected void putStrings(ByteBuffer buffer, List<String> values) {
        for (String value : values) {
            this.putString(buffer, value);
        }
    }

    protected void putString(DataOutputStream stream, String value) throws IOException {
        if (value == null) {
            stream.writeInt(-1);
        } else {
            ReadWriteIOUtils.write((String)value, (OutputStream)stream);
        }
    }

    protected void putStrings(DataOutputStream stream, List<String> values) throws IOException {
        for (String value : values) {
            this.putString(stream, value);
        }
    }

    protected String readString(ByteBuffer buffer) {
        int valueLen = buffer.getInt();
        if (valueLen == -1) {
            return null;
        }
        return ReadWriteIOUtils.readStringWithLength((ByteBuffer)buffer, (int)valueLen);
    }

    protected List<String> readStrings(ByteBuffer buffer, int totalSize) {
        ArrayList<String> result = new ArrayList<String>(totalSize);
        for (int i = 0; i < totalSize; ++i) {
            result.add(this.readString(buffer));
        }
        return result;
    }

    public String getLoginUserName() {
        return this.loginUserName;
    }

    public void setLoginUserName(String loginUserName) {
        this.loginUserName = loginUserName;
    }

    public long getIndex() {
        return this.index;
    }

    public void setIndex(long index) {
        this.index = index;
    }

    public void checkIntegrity() throws QueryProcessException {
    }

    public static enum PhysicalPlanType {
        INSERT,
        DELETE,
        BATCHINSERT,
        SET_STORAGE_GROUP,
        CREATE_TIMESERIES,
        TTL,
        GRANT_WATERMARK_EMBEDDING,
        REVOKE_WATERMARK_EMBEDDING,
        CREATE_ROLE,
        DELETE_ROLE,
        CREATE_USER,
        REVOKE_USER_ROLE,
        REVOKE_ROLE_PRIVILEGE,
        REVOKE_USER_PRIVILEGE,
        GRANT_ROLE_PRIVILEGE,
        GRANT_USER_PRIVILEGE,
        GRANT_USER_ROLE,
        MODIFY_PASSWORD,
        DELETE_USER,
        DELETE_STORAGE_GROUP,
        SHOW_TIMESERIES,
        DELETE_TIMESERIES,
        LOAD_CONFIGURATION,
        CREATE_MULTI_TIMESERIES,
        ALTER_TIMESERIES,
        FLUSH,
        CREATE_INDEX,
        DROP_INDEX,
        CHANGE_TAG_OFFSET,
        CHANGE_ALIAS,
        MNODE,
        MEASUREMENT_MNODE,
        STORAGE_GROUP_MNODE,
        BATCH_INSERT_ONE_DEVICE,
        MULTI_BATCH_INSERT,
        BATCH_INSERT_ROWS,
        SHOW_DEVICES;

    }

    public static class Factory {
        private Factory() {
        }

        public static PhysicalPlan create(ByteBuffer buffer) throws IOException, IllegalPathException {
            PhysicalPlan plan;
            byte typeNum = buffer.get();
            if (typeNum >= PhysicalPlanType.values().length) {
                throw new IOException("unrecognized log type " + typeNum);
            }
            PhysicalPlanType type = PhysicalPlanType.values()[typeNum];
            switch (type) {
                case INSERT: {
                    plan = new InsertRowPlan();
                    plan.deserialize(buffer);
                    break;
                }
                case BATCHINSERT: {
                    plan = new InsertTabletPlan();
                    plan.deserialize(buffer);
                    break;
                }
                case MULTI_BATCH_INSERT: {
                    plan = new InsertMultiTabletPlan();
                    plan.deserialize(buffer);
                    break;
                }
                case DELETE: {
                    plan = new DeletePlan();
                    plan.deserialize(buffer);
                    break;
                }
                case SET_STORAGE_GROUP: {
                    plan = new SetStorageGroupPlan();
                    plan.deserialize(buffer);
                    break;
                }
                case CREATE_TIMESERIES: {
                    plan = new CreateTimeSeriesPlan();
                    plan.deserialize(buffer);
                    break;
                }
                case DELETE_TIMESERIES: {
                    plan = new DeleteTimeSeriesPlan();
                    plan.deserialize(buffer);
                    break;
                }
                case CREATE_INDEX: {
                    plan = new CreateIndexPlan();
                    plan.deserialize(buffer);
                    break;
                }
                case DROP_INDEX: {
                    plan = new DropIndexPlan();
                    plan.deserialize(buffer);
                    break;
                }
                case TTL: {
                    plan = new SetTTLPlan();
                    plan.deserialize(buffer);
                    break;
                }
                case GRANT_WATERMARK_EMBEDDING: {
                    plan = new DataAuthPlan(Operator.OperatorType.GRANT_WATERMARK_EMBEDDING);
                    plan.deserialize(buffer);
                    break;
                }
                case REVOKE_WATERMARK_EMBEDDING: {
                    plan = new DataAuthPlan(Operator.OperatorType.REVOKE_WATERMARK_EMBEDDING);
                    plan.deserialize(buffer);
                    break;
                }
                case CREATE_ROLE: {
                    plan = new AuthorPlan(Operator.OperatorType.CREATE_ROLE);
                    plan.deserialize(buffer);
                    break;
                }
                case DELETE_ROLE: {
                    plan = new AuthorPlan(Operator.OperatorType.DELETE_ROLE);
                    plan.deserialize(buffer);
                    break;
                }
                case CREATE_USER: {
                    plan = new AuthorPlan(Operator.OperatorType.CREATE_USER);
                    plan.deserialize(buffer);
                    break;
                }
                case REVOKE_USER_ROLE: {
                    plan = new AuthorPlan(Operator.OperatorType.REVOKE_USER_ROLE);
                    plan.deserialize(buffer);
                    break;
                }
                case REVOKE_ROLE_PRIVILEGE: {
                    plan = new AuthorPlan(Operator.OperatorType.REVOKE_ROLE_PRIVILEGE);
                    plan.deserialize(buffer);
                    break;
                }
                case REVOKE_USER_PRIVILEGE: {
                    plan = new AuthorPlan(Operator.OperatorType.REVOKE_USER_PRIVILEGE);
                    plan.deserialize(buffer);
                    break;
                }
                case GRANT_ROLE_PRIVILEGE: {
                    plan = new AuthorPlan(Operator.OperatorType.GRANT_ROLE_PRIVILEGE);
                    plan.deserialize(buffer);
                    break;
                }
                case GRANT_USER_PRIVILEGE: {
                    plan = new AuthorPlan(Operator.OperatorType.GRANT_USER_PRIVILEGE);
                    plan.deserialize(buffer);
                    break;
                }
                case GRANT_USER_ROLE: {
                    plan = new AuthorPlan(Operator.OperatorType.GRANT_USER_ROLE);
                    plan.deserialize(buffer);
                    break;
                }
                case MODIFY_PASSWORD: {
                    plan = new AuthorPlan(Operator.OperatorType.MODIFY_PASSWORD);
                    plan.deserialize(buffer);
                    break;
                }
                case DELETE_USER: {
                    plan = new AuthorPlan(Operator.OperatorType.DELETE_USER);
                    plan.deserialize(buffer);
                    break;
                }
                case DELETE_STORAGE_GROUP: {
                    plan = new DeleteStorageGroupPlan();
                    plan.deserialize(buffer);
                    break;
                }
                case SHOW_TIMESERIES: {
                    plan = new ShowTimeSeriesPlan();
                    plan.deserialize(buffer);
                    break;
                }
                case SHOW_DEVICES: {
                    plan = new ShowDevicesPlan();
                    plan.deserialize(buffer);
                    break;
                }
                case LOAD_CONFIGURATION: {
                    plan = new LoadConfigurationPlan();
                    plan.deserialize(buffer);
                    break;
                }
                case ALTER_TIMESERIES: {
                    plan = new AlterTimeSeriesPlan();
                    plan.deserialize(buffer);
                    break;
                }
                case FLUSH: {
                    plan = new FlushPlan();
                    plan.deserialize(buffer);
                    break;
                }
                case CREATE_MULTI_TIMESERIES: {
                    plan = new CreateMultiTimeSeriesPlan();
                    plan.deserialize(buffer);
                    break;
                }
                case CHANGE_ALIAS: {
                    plan = new ChangeAliasPlan();
                    plan.deserialize(buffer);
                    break;
                }
                case CHANGE_TAG_OFFSET: {
                    plan = new ChangeTagOffsetPlan();
                    plan.deserialize(buffer);
                    break;
                }
                case MNODE: {
                    plan = new MNodePlan();
                    plan.deserialize(buffer);
                    break;
                }
                case MEASUREMENT_MNODE: {
                    plan = new MeasurementMNodePlan();
                    plan.deserialize(buffer);
                    break;
                }
                case STORAGE_GROUP_MNODE: {
                    plan = new StorageGroupMNodePlan();
                    plan.deserialize(buffer);
                    break;
                }
                case BATCH_INSERT_ROWS: {
                    plan = new InsertRowsPlan();
                    plan.deserialize(buffer);
                    break;
                }
                default: {
                    throw new IOException("unrecognized log type " + (Object)((Object)type));
                }
            }
            return plan;
        }
    }
}

