/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf;

import com.google.common.net.InetAddresses;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Properties;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.directories.DirectoryManager;
import org.apache.iotdb.db.engine.compaction.CompactionStrategy;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.utils.FilePathUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.fileSystem.FSType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(IoTDBDescriptor.class);
    private IoTDBConfig conf = new IoTDBConfig();

    protected IoTDBDescriptor() {
        this.loadProps();
    }

    public static IoTDBDescriptor getInstance() {
        return IoTDBDescriptorHolder.INSTANCE;
    }

    public IoTDBConfig getConfig() {
        return this.conf;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URL getPropsUrl() {
        String urlString;
        block8: {
            urlString = System.getProperty("IOTDB_CONF", null);
            if (urlString == null) {
                urlString = System.getProperty("IOTDB_HOME", null);
                if (urlString != null) {
                    urlString = urlString + File.separatorChar + "conf" + File.separatorChar + "iotdb-engine.properties";
                    break block8;
                } else {
                    URL uri = IoTDBConfig.class.getResource("/iotdb-engine.properties");
                    if (uri != null) {
                        return uri;
                    }
                    logger.warn("Cannot find IOTDB_HOME or IOTDB_CONF environment variable when loading config file {}, use default configuration", (Object)"iotdb-engine.properties");
                    this.conf.updatePath();
                    return null;
                }
            }
            if (!urlString.endsWith(".properties")) {
                urlString = urlString + File.separatorChar + "iotdb-engine.properties";
            }
        }
        if (!urlString.startsWith("file:") && !urlString.startsWith("classpath:")) {
            urlString = "file:" + urlString;
        }
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProps() {
        URL url = this.getPropsUrl();
        if (url == null) {
            logger.warn("Couldn't load the configuration from any of the known sources.");
            return;
        }
        try (InputStream inputStream = url.openStream();){
            long memTableSizeThreshold;
            logger.info("Start to read config file {}", (Object)url);
            Properties properties = new Properties();
            properties.load(inputStream);
            this.conf.setEnableStatMonitor(Boolean.parseBoolean(properties.getProperty("enable_stat_monitor", Boolean.toString(this.conf.isEnableStatMonitor()))));
            this.conf.setEnableMonitorSeriesWrite(Boolean.parseBoolean(properties.getProperty("enable_monitor_series_write", Boolean.toString(this.conf.isEnableStatMonitor()))));
            this.conf.setEnableMetricService(Boolean.parseBoolean(properties.getProperty("enable_metric_service", Boolean.toString(this.conf.isEnableMetricService()))));
            this.conf.setMetricsPort(Integer.parseInt(properties.getProperty("metrics_port", Integer.toString(this.conf.getMetricsPort()))));
            this.conf.setQueryCacheSizeInMetric(Integer.parseInt(properties.getProperty("query_cache_size_in_metric", Integer.toString(this.conf.getQueryCacheSizeInMetric()))));
            this.conf.setRpcAddress(properties.getProperty("rpc_address", this.conf.getRpcAddress()));
            this.replaceHostnameWithIP();
            this.conf.setRpcThriftCompressionEnable(Boolean.parseBoolean(properties.getProperty("rpc_thrift_compression_enable", Boolean.toString(this.conf.isRpcThriftCompressionEnable()))));
            this.conf.setRpcAdvancedCompressionEnable(Boolean.parseBoolean(properties.getProperty("rpc_advanced_compression_enable", Boolean.toString(this.conf.isRpcAdvancedCompressionEnable()))));
            this.conf.setRpcPort(Integer.parseInt(properties.getProperty("rpc_port", Integer.toString(this.conf.getRpcPort()))));
            this.conf.setTimestampPrecision(properties.getProperty("timestamp_precision", this.conf.getTimestampPrecision()));
            this.conf.setBufferedArraysMemoryProportion(Double.parseDouble(properties.getProperty("buffered_arrays_memory_proportion", Double.toString(this.conf.getBufferedArraysMemoryProportion()))));
            this.conf.setFlushProportion(Double.parseDouble(properties.getProperty("flush_proportion", Double.toString(this.conf.getFlushProportion()))));
            this.conf.setRejectProportion(Double.parseDouble(properties.getProperty("reject_proportion", Double.toString(this.conf.getRejectProportion()))));
            this.conf.setStorageGroupSizeReportThreshold(Long.parseLong(properties.getProperty("storage_group_report_threshold", Long.toString(this.conf.getStorageGroupSizeReportThreshold()))));
            this.conf.setMetaDataCacheEnable(Boolean.parseBoolean(properties.getProperty("meta_data_cache_enable", Boolean.toString(this.conf.isMetaDataCacheEnable()))));
            this.conf.setEnableLastCache(Boolean.parseBoolean(properties.getProperty("enable_last_cache", Boolean.toString(this.conf.isLastCacheEnabled()))));
            this.initMemoryAllocate(properties);
            this.loadWALProps(properties);
            String systemDir = properties.getProperty("system_dir");
            if (systemDir == null) {
                systemDir = properties.getProperty("base_dir");
                systemDir = systemDir != null ? FilePathUtils.regularizePath(systemDir) + "system" : this.conf.getSystemDir();
            }
            this.conf.setSystemDir(systemDir);
            this.conf.setSchemaDir(FilePathUtils.regularizePath(this.conf.getSystemDir()) + "schema");
            this.conf.setSyncDir(FilePathUtils.regularizePath(this.conf.getSystemDir()) + "sync");
            this.conf.setQueryDir(FilePathUtils.regularizePath(this.conf.getSystemDir() + "query"));
            this.conf.setTracingDir(properties.getProperty("tracing_dir", this.conf.getTracingDir()));
            this.conf.setDataDirs(properties.getProperty("data_dirs", this.conf.getDataDirs()[0]).split(","));
            this.conf.setWalDir(properties.getProperty("wal_dir", this.conf.getWalDir()));
            int mlogBufferSize = Integer.parseInt(properties.getProperty("mlog_buffer_size", Integer.toString(this.conf.getMlogBufferSize())));
            if (mlogBufferSize > 0) {
                this.conf.setMlogBufferSize(mlogBufferSize);
            }
            this.conf.setMultiDirStrategyClassName(properties.getProperty("multi_dir_strategy", this.conf.getMultiDirStrategyClassName()));
            this.conf.setBatchSize(Integer.parseInt(properties.getProperty("batch_size", Integer.toString(this.conf.getBatchSize()))));
            this.conf.setEnableMemControl(Boolean.parseBoolean(properties.getProperty("enable_mem_control", Boolean.toString(this.conf.isEnableMemControl()))));
            logger.info("IoTDB enable memory control: {}", (Object)this.conf.isEnableMemControl());
            long tsfileSizeThreshold = Long.parseLong(properties.getProperty("tsfile_size_threshold", Long.toString(this.conf.getTsFileSizeThreshold())).trim());
            if (tsfileSizeThreshold >= 0L) {
                this.conf.setTsFileSizeThreshold(tsfileSizeThreshold);
            }
            if ((memTableSizeThreshold = Long.parseLong(properties.getProperty("memtable_size_threshold", Long.toString(this.conf.getMemtableSizeThreshold())).trim())) > 0L) {
                this.conf.setMemtableSizeThreshold(memTableSizeThreshold);
            }
            this.conf.setAvgSeriesPointNumberThreshold(Integer.parseInt(properties.getProperty("avg_series_point_number_threshold", Integer.toString(this.conf.getAvgSeriesPointNumberThreshold()))));
            this.conf.setCheckPeriodWhenInsertBlocked(Integer.parseInt(properties.getProperty("check_period_when_insert_blocked", Integer.toString(this.conf.getCheckPeriodWhenInsertBlocked()))));
            this.conf.setMaxWaitingTimeWhenInsertBlocked(Integer.parseInt(properties.getProperty("max_waiting_time_when_insert_blocked", Integer.toString(this.conf.getMaxWaitingTimeWhenInsertBlocked()))));
            this.conf.setEstimatedSeriesSize(Integer.parseInt(properties.getProperty("estimated_series_size", Integer.toString(this.conf.getEstimatedSeriesSize()))));
            this.conf.setIoTaskQueueSizeForFlushing(Integer.parseInt(properties.getProperty("io_task_queue_size_for_flushing", Integer.toString(this.conf.getIoTaskQueueSizeForFlushing()))));
            this.conf.setMergeChunkPointNumberThreshold(Integer.parseInt(properties.getProperty("merge_chunk_point_number", Integer.toString(this.conf.getMergeChunkPointNumberThreshold()))));
            this.conf.setMergePagePointNumberThreshold(Integer.parseInt(properties.getProperty("merge_page_point_number", Integer.toString(this.conf.getMergePagePointNumberThreshold()))));
            this.conf.setCompactionStrategy(CompactionStrategy.valueOf(properties.getProperty("compaction_strategy", this.conf.getCompactionStrategy().toString())));
            this.conf.setEnableUnseqCompaction(Boolean.parseBoolean(properties.getProperty("enable_unseq_compaction", Boolean.toString(this.conf.isEnableUnseqCompaction()))));
            this.conf.setEnableContinuousCompaction(Boolean.parseBoolean(properties.getProperty("enable_continuous_compaction", Boolean.toString(this.conf.isEnableContinuousCompaction()))));
            this.conf.setSeqLevelNum(Integer.parseInt(properties.getProperty("seq_level_num", Integer.toString(this.conf.getSeqLevelNum()))));
            this.conf.setSeqFileNumInEachLevel(Integer.parseInt(properties.getProperty("seq_file_num_in_each_level", Integer.toString(this.conf.getSeqFileNumInEachLevel()))));
            this.conf.setUnseqLevelNum(Integer.parseInt(properties.getProperty("unseq_level_num", Integer.toString(this.conf.getUnseqLevelNum()))));
            this.conf.setMaxSelectUnseqFileNumInEachUnseqCompaction(Integer.parseInt(properties.getProperty("max_open_file_num_in_each_unseq_compaction", Integer.toString(this.conf.getMaxSelectUnseqFileNumInEachUnseqCompaction()))));
            this.conf.setUnseqFileNumInEachLevel(Integer.parseInt(properties.getProperty("unseq_file_num_in_each_level", Integer.toString(this.conf.getUnseqFileNumInEachLevel()))));
            this.conf.setQueryTimeoutThreshold(Integer.parseInt(properties.getProperty("query_timeout_threshold", Integer.toString(this.conf.getQueryTimeoutThreshold()))));
            this.conf.setSyncEnable(Boolean.parseBoolean(properties.getProperty("is_sync_enable", Boolean.toString(this.conf.isSyncEnable()))));
            this.conf.setSyncServerPort(Integer.parseInt(properties.getProperty("sync_server_port", Integer.toString(this.conf.getSyncServerPort())).trim()));
            this.conf.setIpWhiteList(properties.getProperty("ip_white_list", this.conf.getIpWhiteList()));
            this.conf.setConcurrentFlushThread(Integer.parseInt(properties.getProperty("concurrent_flush_thread", Integer.toString(this.conf.getConcurrentFlushThread()))));
            if (this.conf.getConcurrentFlushThread() <= 0) {
                this.conf.setConcurrentFlushThread(Runtime.getRuntime().availableProcessors());
            }
            this.conf.setIndexRootFolder(properties.getProperty("index_root_dir", this.conf.getIndexRootFolder()));
            this.conf.setEnableIndex(Boolean.parseBoolean(properties.getProperty("enable_index", Boolean.toString(this.conf.isEnableIndex()))));
            this.conf.setConcurrentIndexBuildThread(Integer.parseInt(properties.getProperty("concurrent_index_build_thread", Integer.toString(this.conf.getConcurrentIndexBuildThread()))));
            if (this.conf.getConcurrentIndexBuildThread() <= 0) {
                this.conf.setConcurrentIndexBuildThread(Runtime.getRuntime().availableProcessors());
            }
            this.conf.setDefaultIndexWindowRange(Integer.parseInt(properties.getProperty("default_index_window_range", Integer.toString(this.conf.getDefaultIndexWindowRange()))));
            this.conf.setIndexBufferSize(Long.parseLong(properties.getProperty("index_buffer_size", Long.toString(this.conf.getIndexBufferSize()))));
            this.conf.setConcurrentQueryThread(Integer.parseInt(properties.getProperty("concurrent_query_thread", Integer.toString(this.conf.getConcurrentQueryThread()))));
            if (this.conf.getConcurrentQueryThread() <= 0) {
                this.conf.setConcurrentQueryThread(Runtime.getRuntime().availableProcessors());
            }
            this.conf.setmManagerCacheSize(Integer.parseInt(properties.getProperty("metadata_node_cache_size", Integer.toString(this.conf.getmManagerCacheSize())).trim()));
            this.conf.setmRemoteSchemaCacheSize(Integer.parseInt(properties.getProperty("remote_schema_cache_size", Integer.toString(this.conf.getmRemoteSchemaCacheSize())).trim()));
            this.conf.setLanguageVersion(properties.getProperty("language_version", this.conf.getLanguageVersion()).trim());
            if (properties.containsKey("chunk_buffer_pool_enable")) {
                this.conf.setChunkBufferPoolEnable(Boolean.parseBoolean(properties.getProperty("chunk_buffer_pool_enable")));
            }
            this.conf.setEnableExternalSort(Boolean.parseBoolean(properties.getProperty("enable_external_sort", Boolean.toString(this.conf.isEnableExternalSort()))));
            this.conf.setExternalSortThreshold(Integer.parseInt(properties.getProperty("external_sort_threshold", Integer.toString(this.conf.getExternalSortThreshold()))));
            this.conf.setUpgradeThreadNum(Integer.parseInt(properties.getProperty("upgrade_thread_num", Integer.toString(this.conf.getUpgradeThreadNum()))));
            this.conf.setMergeMemoryBudget(Long.parseLong(properties.getProperty("merge_memory_budget", Long.toString(this.conf.getMergeMemoryBudget()))));
            this.conf.setMergeThreadNum(Integer.parseInt(properties.getProperty("merge_thread_num", Integer.toString(this.conf.getMergeThreadNum()))));
            this.conf.setMergeChunkSubThreadNum(Integer.parseInt(properties.getProperty("merge_chunk_subthread_num", Integer.toString(this.conf.getMergeChunkSubThreadNum()))));
            this.conf.setContinueMergeAfterReboot(Boolean.parseBoolean(properties.getProperty("continue_merge_after_reboot", Boolean.toString(this.conf.isContinueMergeAfterReboot()))));
            this.conf.setMergeFileSelectionTimeBudget(Long.parseLong(properties.getProperty("merge_fileSelection_time_budget", Long.toString(this.conf.getMergeFileSelectionTimeBudget()))));
            this.conf.setMergeIntervalSec(Long.parseLong(properties.getProperty("merge_interval_sec", Long.toString(this.conf.getMergeIntervalSec()))));
            this.conf.setCompactionInterval(Long.parseLong(properties.getProperty("compaction_interval", Long.toString(this.conf.getCompactionInterval()))));
            this.conf.setForceFullMerge(Boolean.parseBoolean(properties.getProperty("force_full_merge", Boolean.toString(this.conf.isForceFullMerge()))));
            this.conf.setCompactionThreadNum(Integer.parseInt(properties.getProperty("compaction_thread_num", Integer.toString(this.conf.getCompactionThreadNum()))));
            this.conf.setMergeWriteThroughputMbPerSec(Integer.parseInt(properties.getProperty("merge_write_throughput_mb_per_sec", Integer.toString(this.conf.getMergeWriteThroughputMbPerSec()))));
            this.conf.setEnablePartialInsert(Boolean.parseBoolean(properties.getProperty("enable_partial_insert", String.valueOf(this.conf.isEnablePartialInsert()))));
            this.conf.setEnableMTreeSnapshot(Boolean.parseBoolean(properties.getProperty("enable_mtree_snapshot", Boolean.toString(this.conf.isEnableMTreeSnapshot()))));
            this.conf.setMtreeSnapshotInterval(Integer.parseInt(properties.getProperty("mtree_snapshot_interval", Integer.toString(this.conf.getMtreeSnapshotInterval()))));
            this.conf.setMtreeSnapshotThresholdTime(Integer.parseInt(properties.getProperty("mtree_snapshot_threshold_time", Integer.toString(this.conf.getMtreeSnapshotThresholdTime()))));
            this.conf.setEnablePerformanceStat(Boolean.parseBoolean(properties.getProperty("enable_performance_stat", Boolean.toString(this.conf.isEnablePerformanceStat())).trim()));
            this.conf.setEnablePerformanceTracing(Boolean.parseBoolean(properties.getProperty("enable_performance_tracing", Boolean.toString(this.conf.isEnablePerformanceTracing())).trim()));
            this.conf.setPerformanceStatDisplayInterval(Long.parseLong(properties.getProperty("performance_stat_display_interval", Long.toString(this.conf.getPerformanceStatDisplayInterval())).trim()));
            this.conf.setPerformanceStatMemoryInKB(Integer.parseInt(properties.getProperty("performance_stat_memory_in_kb", Integer.toString(this.conf.getPerformanceStatMemoryInKB())).trim()));
            int maxConcurrentClientNum = Integer.parseInt(properties.getProperty("rpc_max_concurrent_client_num", Integer.toString(this.conf.getRpcMaxConcurrentClientNum()).trim()));
            if (maxConcurrentClientNum <= 0) {
                maxConcurrentClientNum = 65535;
            }
            this.conf.setEnableWatermark(Boolean.parseBoolean(properties.getProperty("watermark_module_opened", Boolean.toString(this.conf.isEnableWatermark()).trim())));
            this.conf.setWatermarkSecretKey(properties.getProperty("watermark_secret_key", this.conf.getWatermarkSecretKey()));
            this.conf.setWatermarkBitString(properties.getProperty("watermark_bit_string", this.conf.getWatermarkBitString()));
            this.conf.setWatermarkMethod(properties.getProperty("watermark_method", this.conf.getWatermarkMethod()));
            this.loadAutoCreateSchemaProps(properties);
            this.conf.setRpcMaxConcurrentClientNum(maxConcurrentClientNum);
            this.conf.setTsFileStorageFs(properties.getProperty("tsfile_storage_fs", this.conf.getTsFileStorageFs().toString()));
            this.conf.setCoreSitePath(properties.getProperty("core_site_path", this.conf.getCoreSitePath()));
            this.conf.setHdfsSitePath(properties.getProperty("hdfs_site_path", this.conf.getHdfsSitePath()));
            this.conf.setHdfsIp(properties.getProperty("hdfs_ip", this.conf.getRawHDFSIp()).split(","));
            this.conf.setHdfsPort(properties.getProperty("hdfs_port", this.conf.getHdfsPort()));
            this.conf.setDfsNameServices(properties.getProperty("dfs_nameservices", this.conf.getDfsNameServices()));
            this.conf.setDfsHaNamenodes(properties.getProperty("dfs_ha_namenodes", this.conf.getRawDfsHaNamenodes()).split(","));
            this.conf.setDfsHaAutomaticFailoverEnabled(Boolean.parseBoolean(properties.getProperty("dfs_ha_automatic_failover_enabled", String.valueOf(this.conf.isDfsHaAutomaticFailoverEnabled()))));
            this.conf.setDfsClientFailoverProxyProvider(properties.getProperty("dfs_client_failover_proxy_provider", this.conf.getDfsClientFailoverProxyProvider()));
            this.conf.setUseKerberos(Boolean.parseBoolean(properties.getProperty("hdfs_use_kerberos", String.valueOf(this.conf.isUseKerberos()))));
            this.conf.setKerberosKeytabFilePath(properties.getProperty("kerberos_keytab_file_path", this.conf.getKerberosKeytabFilePath()));
            this.conf.setKerberosPrincipal(properties.getProperty("kerberos_principal", this.conf.getKerberosPrincipal()));
            this.conf.setDefaultTTL(Long.parseLong(properties.getProperty("default_ttl", String.valueOf(this.conf.getDefaultTTL()))));
            this.conf.setConcurrentWritingTimePartition(Integer.parseInt(properties.getProperty("concurrent_writing_time_partition", String.valueOf(this.conf.getConcurrentWritingTimePartition()))));
            this.conf.setTimeIndexLevel(properties.getProperty("time_index_level", String.valueOf((Object)this.conf.getTimeIndexLevel())));
            this.conf.setDefaultFillInterval(Integer.parseInt(properties.getProperty("default_fill_interval", String.valueOf(this.conf.getDefaultFillInterval()))));
            this.conf.setTagAttributeTotalSize(Integer.parseInt(properties.getProperty("tag_attribute_total_size", String.valueOf(this.conf.getTagAttributeTotalSize()))));
            this.conf.setPrimitiveArraySize(Integer.parseInt(properties.getProperty("primitive_array_size", String.valueOf(this.conf.getPrimitiveArraySize()))));
            this.conf.setThriftMaxFrameSize(Integer.parseInt(properties.getProperty("thrift_max_frame_size", String.valueOf(this.conf.getThriftMaxFrameSize()))));
            if (this.conf.getThriftMaxFrameSize() < 0x800000) {
                this.conf.setThriftMaxFrameSize(0x800000);
            }
            this.conf.setThriftDefaultBufferSize(Integer.parseInt(properties.getProperty("thrift_init_buffer_size", String.valueOf(this.conf.getThriftDefaultBufferSize()))));
            this.conf.setFrequencyIntervalInMinute(Integer.parseInt(properties.getProperty("frequency_interval_in_minute", String.valueOf(this.conf.getFrequencyIntervalInMinute()))));
            this.conf.setSlowQueryThreshold(Long.parseLong(properties.getProperty("slow_query_threshold", String.valueOf(this.conf.getSlowQueryThreshold()))));
            this.conf.setVirtualStorageGroupNum(Integer.parseInt(properties.getProperty("virtual_storage_group_num", String.valueOf(this.conf.getVirtualStorageGroupNum()))));
            if (properties.getProperty("mqtt_host") != null) {
                this.conf.setMqttHost(properties.getProperty("mqtt_host"));
            }
            if (properties.getProperty("mqtt_port") != null) {
                this.conf.setMqttPort(Integer.parseInt(properties.getProperty("mqtt_port")));
            }
            if (properties.getProperty("mqtt_handler_pool_size") != null) {
                this.conf.setMqttHandlerPoolSize(Integer.parseInt(properties.getProperty("mqtt_handler_pool_size")));
            }
            if (properties.getProperty("mqtt_payload_formatter") != null) {
                this.conf.setMqttPayloadFormatter(properties.getProperty("mqtt_payload_formatter"));
            }
            if (properties.getProperty("enable_mqtt_service") != null) {
                this.conf.setEnableMQTTService(Boolean.parseBoolean(properties.getProperty("enable_mqtt_service")));
            }
            if (properties.getProperty("mqtt_max_message_size") != null) {
                this.conf.setMqttMaxMessageSize(Integer.parseInt(properties.getProperty("mqtt_max_message_size")));
            }
            this.conf.setAuthorizerProvider(properties.getProperty("authorizer_provider_class", this.conf.getAuthorizerProvider()));
            this.conf.setOpenIdProviderUrl(properties.getProperty("openID_url", this.conf.getOpenIdProviderUrl()));
            this.conf.setEnablePartition(Boolean.parseBoolean(properties.getProperty("enable_partition", String.valueOf(this.conf.isEnablePartition()))));
            this.conf.setPartitionInterval(Long.parseLong(properties.getProperty("partition_interval", String.valueOf(this.conf.getPartitionInterval()))));
            this.conf.setAdminName(properties.getProperty("admin_name", this.conf.getAdminName()));
            this.conf.setAdminPassword(properties.getProperty("admin_password", this.conf.getAdminPassword()));
            TSFileDescriptor.getInstance().getConfig().setTSFileStorageFs(FSType.valueOf((String)properties.getProperty("tsfile_storage_fs", this.conf.getTsFileStorageFs().name())));
            TSFileDescriptor.getInstance().getConfig().setCoreSitePath(properties.getProperty("core_site_path", this.conf.getCoreSitePath()));
            TSFileDescriptor.getInstance().getConfig().setHdfsSitePath(properties.getProperty("hdfs_site_path", this.conf.getHdfsSitePath()));
            TSFileDescriptor.getInstance().getConfig().setHdfsIp(properties.getProperty("hdfs_ip", this.conf.getRawHDFSIp()).split(","));
            TSFileDescriptor.getInstance().getConfig().setHdfsPort(properties.getProperty("hdfs_port", this.conf.getHdfsPort()));
            TSFileDescriptor.getInstance().getConfig().setDfsNameServices(properties.getProperty("dfs_nameservices", this.conf.getDfsNameServices()));
            TSFileDescriptor.getInstance().getConfig().setDfsHaNamenodes(properties.getProperty("dfs_ha_namenodes", this.conf.getRawDfsHaNamenodes()).split(","));
            TSFileDescriptor.getInstance().getConfig().setDfsHaAutomaticFailoverEnabled(Boolean.parseBoolean(properties.getProperty("dfs_ha_automatic_failover_enabled", String.valueOf(this.conf.isDfsHaAutomaticFailoverEnabled()))));
            TSFileDescriptor.getInstance().getConfig().setDfsClientFailoverProxyProvider(properties.getProperty("dfs_client_failover_proxy_provider", this.conf.getDfsClientFailoverProxyProvider()));
            TSFileDescriptor.getInstance().getConfig().setUseKerberos(Boolean.parseBoolean(properties.getProperty("hdfs_use_kerberos", String.valueOf(this.conf.isUseKerberos()))));
            TSFileDescriptor.getInstance().getConfig().setKerberosKeytabFilePath(properties.getProperty("kerberos_keytab_file_path", this.conf.getKerberosKeytabFilePath()));
            TSFileDescriptor.getInstance().getConfig().setKerberosPrincipal(properties.getProperty("kerberos_principal", this.conf.getKerberosPrincipal()));
            TSFileDescriptor.getInstance().getConfig().setBatchSize(this.conf.getBatchSize());
            this.loadTsFileProps(properties);
            this.loadUDFProps(properties);
        }
        catch (FileNotFoundException e) {
            logger.warn("Fail to find config file {}", (Object)url, (Object)e);
        }
        catch (IOException e) {
            logger.warn("Cannot load config file, use default configuration", (Throwable)e);
        }
        catch (Exception e) {
            logger.warn("Incorrect format in config file, use default configuration", (Throwable)e);
        }
        finally {
            this.conf.updatePath();
        }
    }

    private void replaceHostnameWithIP() throws UnknownHostException {
        boolean isInvalidRpcIp = InetAddresses.isInetAddress((String)this.conf.getRpcAddress());
        if (!isInvalidRpcIp) {
            InetAddress address = InetAddress.getByName(this.getConfig().getRpcAddress());
            this.getConfig().setRpcAddress(address.getHostAddress());
        }
        logger.debug("after replace, the rpc_address={},", (Object)this.conf.getRpcAddress());
    }

    private void loadWALProps(Properties properties) {
        long poolTrimIntervalInMS;
        int maxWalBytebufferNumForEachPartition;
        this.conf.setEnableWal(Boolean.parseBoolean(properties.getProperty("enable_wal", Boolean.toString(this.conf.isEnableWal()))));
        this.conf.setFlushWalThreshold(Integer.parseInt(properties.getProperty("flush_wal_threshold", Integer.toString(this.conf.getFlushWalThreshold()))));
        this.conf.setForceWalPeriodInMs(Long.parseLong(properties.getProperty("force_wal_period_in_ms", Long.toString(this.conf.getForceWalPeriodInMs()))));
        this.conf.setEnableDiscardOutOfOrderData(Boolean.parseBoolean(properties.getProperty("enable_discard_out_of_order_data", Boolean.toString(this.conf.isEnableDiscardOutOfOrderData()))));
        int walBufferSize = Integer.parseInt(properties.getProperty("wal_buffer_size", Integer.toString(this.conf.getWalBufferSize())));
        if (walBufferSize > 0) {
            this.conf.setWalBufferSize(walBufferSize);
        }
        if ((maxWalBytebufferNumForEachPartition = Integer.parseInt(properties.getProperty("max_wal_bytebuffer_num_for_each_partition", Integer.toString(this.conf.getMaxWalBytebufferNumForEachPartition())))) > 0) {
            this.conf.setMaxWalBytebufferNumForEachPartition(maxWalBytebufferNumForEachPartition);
        }
        if ((poolTrimIntervalInMS = (long)Integer.parseInt(properties.getProperty("wal_pool_trim_interval_ms", Long.toString(this.conf.getWalPoolTrimIntervalInMS())))) > 0L) {
            this.conf.setWalPoolTrimIntervalInMS(poolTrimIntervalInMS);
        }
    }

    private void loadAutoCreateSchemaProps(Properties properties) {
        this.conf.setAutoCreateSchemaEnabled(Boolean.parseBoolean(properties.getProperty("enable_auto_create_schema", Boolean.toString(this.conf.isAutoCreateSchemaEnabled()).trim())));
        this.conf.setBooleanStringInferType(TSDataType.valueOf((String)properties.getProperty("boolean_string_infer_type", this.conf.getBooleanStringInferType().toString())));
        this.conf.setIntegerStringInferType(TSDataType.valueOf((String)properties.getProperty("integer_string_infer_type", this.conf.getIntegerStringInferType().toString())));
        this.conf.setLongStringInferType(TSDataType.valueOf((String)properties.getProperty("long_string_infer_type", this.conf.getLongStringInferType().toString())));
        this.conf.setFloatingStringInferType(TSDataType.valueOf((String)properties.getProperty("floating_string_infer_type", this.conf.getFloatingStringInferType().toString())));
        this.conf.setNanStringInferType(TSDataType.valueOf((String)properties.getProperty("nan_string_infer_type", this.conf.getNanStringInferType().toString())));
        this.conf.setDefaultStorageGroupLevel(Integer.parseInt(properties.getProperty("default_storage_group_level", Integer.toString(this.conf.getDefaultStorageGroupLevel()))));
        this.conf.setDefaultBooleanEncoding(properties.getProperty("default_boolean_encoding", this.conf.getDefaultBooleanEncoding().toString()));
        this.conf.setDefaultInt32Encoding(properties.getProperty("default_int32_encoding", this.conf.getDefaultInt32Encoding().toString()));
        this.conf.setDefaultInt64Encoding(properties.getProperty("default_int64_encoding", this.conf.getDefaultInt64Encoding().toString()));
        this.conf.setDefaultFloatEncoding(properties.getProperty("default_float_encoding", this.conf.getDefaultFloatEncoding().toString()));
        this.conf.setDefaultDoubleEncoding(properties.getProperty("default_double_encoding", this.conf.getDefaultDoubleEncoding().toString()));
        this.conf.setDefaultTextEncoding(properties.getProperty("default_text_encoding", this.conf.getDefaultTextEncoding().toString()));
    }

    private void loadTsFileProps(Properties properties) {
        TSFileDescriptor.getInstance().getConfig().setGroupSizeInByte(Integer.parseInt(properties.getProperty("group_size_in_byte", Integer.toString(TSFileDescriptor.getInstance().getConfig().getGroupSizeInByte()))));
        TSFileDescriptor.getInstance().getConfig().setPageSizeInByte(Integer.parseInt(properties.getProperty("page_size_in_byte", Integer.toString(TSFileDescriptor.getInstance().getConfig().getPageSizeInByte()))));
        if (TSFileDescriptor.getInstance().getConfig().getPageSizeInByte() > TSFileDescriptor.getInstance().getConfig().getGroupSizeInByte()) {
            logger.warn("page_size is greater than group size, will set it as the same with group size");
            TSFileDescriptor.getInstance().getConfig().setPageSizeInByte(TSFileDescriptor.getInstance().getConfig().getGroupSizeInByte());
        }
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(Integer.parseInt(properties.getProperty("max_number_of_points_in_page", Integer.toString(TSFileDescriptor.getInstance().getConfig().getMaxNumberOfPointsInPage()))));
        TSFileDescriptor.getInstance().getConfig().setTimeSeriesDataType(properties.getProperty("time_series_data_type", TSFileDescriptor.getInstance().getConfig().getTimeSeriesDataType()));
        TSFileDescriptor.getInstance().getConfig().setMaxStringLength(Integer.parseInt(properties.getProperty("max_string_length", Integer.toString(TSFileDescriptor.getInstance().getConfig().getMaxStringLength()))));
        TSFileDescriptor.getInstance().getConfig().setBloomFilterErrorRate(Double.parseDouble(properties.getProperty("bloom_filter_error_rate", Double.toString(TSFileDescriptor.getInstance().getConfig().getBloomFilterErrorRate()))));
        TSFileDescriptor.getInstance().getConfig().setFloatPrecision(Integer.parseInt(properties.getProperty("float_precision", Integer.toString(TSFileDescriptor.getInstance().getConfig().getFloatPrecision()))));
        TSFileDescriptor.getInstance().getConfig().setTimeEncoder(properties.getProperty("time_encoder", TSFileDescriptor.getInstance().getConfig().getTimeEncoder()));
        TSFileDescriptor.getInstance().getConfig().setValueEncoder(properties.getProperty("value_encoder", TSFileDescriptor.getInstance().getConfig().getValueEncoder()));
        TSFileDescriptor.getInstance().getConfig().setCompressor(properties.getProperty("compressor", TSFileDescriptor.getInstance().getConfig().getCompressor().toString()));
        TSFileDescriptor.getInstance().getConfig().setMaxDegreeOfIndexNode(Integer.parseInt(properties.getProperty("max_degree_of_index_node", Integer.toString(TSFileDescriptor.getInstance().getConfig().getMaxDegreeOfIndexNode()))));
    }

    public void loadHotModifiedProps(Properties properties) throws QueryProcessException {
        try {
            long memTableSizeThreshold;
            String multiDirStrategyClassName;
            String dataDirs = properties.getProperty("data_dirs", null);
            if (dataDirs != null) {
                this.conf.reloadDataDirs(dataDirs.split(","));
            }
            if ((multiDirStrategyClassName = properties.getProperty("multi_dir_strategy", null)) != null && !multiDirStrategyClassName.equals(this.conf.getMultiDirStrategyClassName())) {
                this.conf.setMultiDirStrategyClassName(multiDirStrategyClassName);
                DirectoryManager.getInstance().updateDirectoryStrategy();
            }
            this.loadWALProps(properties);
            long tsfileSizeThreshold = Long.parseLong(properties.getProperty("tsfile_size_threshold", Long.toString(this.conf.getTsFileSizeThreshold())).trim());
            if (tsfileSizeThreshold >= 0L) {
                this.conf.setTsFileSizeThreshold(tsfileSizeThreshold);
            }
            if ((memTableSizeThreshold = Long.parseLong(properties.getProperty("memtable_size_threshold", Long.toString(this.conf.getMemtableSizeThreshold())).trim())) > 0L) {
                this.conf.setMemtableSizeThreshold(memTableSizeThreshold);
            }
            this.loadAutoCreateSchemaProps(properties);
            this.loadTsFileProps(properties);
            this.conf.setMaxQueryDeduplicatedPathNum(Integer.parseInt(properties.getProperty("max_deduplicated_path_num")));
            this.conf.setFrequencyIntervalInMinute(Integer.parseInt(properties.getProperty("frequency_interval_in_minute")));
            this.conf.setSlowQueryThreshold(Long.parseLong(properties.getProperty("slow_query_threshold")));
            this.conf.setEnableContinuousCompaction(Boolean.parseBoolean(properties.getProperty("enable_continuous_compaction")));
            this.conf.setMergeWriteThroughputMbPerSec(Integer.parseInt(properties.getProperty("merge_write_throughput_mb_per_sec")));
        }
        catch (Exception e) {
            throw new QueryProcessException(String.format("Fail to reload configuration because %s", e));
        }
    }

    public void loadHotModifiedProps() throws QueryProcessException {
        URL url = this.getPropsUrl();
        if (url == null) {
            logger.warn("Couldn't load the configuration from any of the known sources.");
            return;
        }
        try (InputStream inputStream = url.openStream();){
            logger.info("Start to reload config file {}", (Object)url);
            Properties properties = new Properties();
            properties.load(inputStream);
            this.loadHotModifiedProps(properties);
        }
        catch (Exception e) {
            logger.warn("Fail to reload config file {}", (Object)url, (Object)e);
            throw new QueryProcessException(String.format("Fail to reload config file %s because %s", url, e.getMessage()));
        }
    }

    private void initMemoryAllocate(Properties properties) {
        String memoryAllocateProportion = properties.getProperty("write_read_schema_free_memory_proportion");
        if (memoryAllocateProportion != null) {
            String[] proportions = memoryAllocateProportion.split(":");
            int proportionSum = 0;
            for (String proportion : proportions) {
                proportionSum += Integer.parseInt(proportion.trim());
            }
            long maxMemoryAvailable = Runtime.getRuntime().maxMemory();
            if (proportionSum != 0) {
                this.conf.setAllocateMemoryForWrite(maxMemoryAvailable * (long)Integer.parseInt(proportions[0].trim()) / (long)proportionSum);
                this.conf.setAllocateMemoryForRead(maxMemoryAvailable * (long)Integer.parseInt(proportions[1].trim()) / (long)proportionSum);
                this.conf.setAllocateMemoryForSchema(maxMemoryAvailable * (long)Integer.parseInt(proportions[2].trim()) / (long)proportionSum);
            }
        }
        logger.info("allocateMemoryForRead = {}", (Object)this.conf.getAllocateMemoryForRead());
        logger.info("allocateMemoryForWrite = {}", (Object)this.conf.getAllocateMemoryForWrite());
        logger.info("allocateMemoryForSchema = {}", (Object)this.conf.getAllocateMemoryForSchema());
        if (!this.conf.isMetaDataCacheEnable()) {
            return;
        }
        String queryMemoryAllocateProportion = properties.getProperty("chunk_timeseriesmeta_free_memory_proportion");
        if (queryMemoryAllocateProportion != null) {
            String[] proportions = queryMemoryAllocateProportion.split(":");
            int proportionSum = 0;
            for (String proportion : proportions) {
                proportionSum += Integer.parseInt(proportion.trim());
            }
            long maxMemoryAvailable = this.conf.getAllocateMemoryForRead();
            if (proportionSum != 0) {
                try {
                    this.conf.setAllocateMemoryForChunkCache(maxMemoryAvailable * (long)Integer.parseInt(proportions[0].trim()) / (long)proportionSum);
                    this.conf.setAllocateMemoryForTimeSeriesMetaDataCache(maxMemoryAvailable * (long)Integer.parseInt(proportions[1].trim()) / (long)proportionSum);
                    this.conf.setAllocateMemoryForReadWithoutCache(maxMemoryAvailable * (long)Integer.parseInt(proportions[2].trim()) / (long)proportionSum);
                }
                catch (Exception e) {
                    throw new RuntimeException("Each subsection of configuration item chunkmeta_chunk_timeseriesmeta_free_memory_proportion should be an integer, which is " + queryMemoryAllocateProportion);
                }
            }
            this.conf.setMaxQueryDeduplicatedPathNum(Integer.parseInt(properties.getProperty("max_deduplicated_path_num")));
        }
    }

    private void loadUDFProps(Properties properties) {
        String readerTransformerCollectorMemoryProportion;
        String initialByteArrayLengthForMemoryControl = properties.getProperty("udf_initial_byte_array_length_for_memory_control");
        if (initialByteArrayLengthForMemoryControl != null) {
            this.conf.setUdfInitialByteArrayLengthForMemoryControl(Integer.parseInt(initialByteArrayLengthForMemoryControl));
        }
        this.conf.setUdfDir(properties.getProperty("udf_root_dir", this.conf.getUdfDir()));
        String memoryBudgetInMb = properties.getProperty("udf_memory_budget_in_mb");
        if (memoryBudgetInMb != null) {
            this.conf.setUdfMemoryBudgetInMB((float)Math.min((double)Float.parseFloat(memoryBudgetInMb), 0.2 * (double)this.conf.getAllocateMemoryForRead()));
        }
        if ((readerTransformerCollectorMemoryProportion = properties.getProperty("udf_reader_transformer_collector_memory_proportion")) != null) {
            String[] proportions = readerTransformerCollectorMemoryProportion.split(":");
            int proportionSum = 0;
            for (String proportion : proportions) {
                proportionSum += Integer.parseInt(proportion.trim());
            }
            float maxMemoryAvailable = this.conf.getUdfMemoryBudgetInMB();
            try {
                this.conf.setUdfReaderMemoryBudgetInMB(maxMemoryAvailable * (float)Integer.parseInt(proportions[0].trim()) / (float)proportionSum);
                this.conf.setUdfTransformerMemoryBudgetInMB(maxMemoryAvailable * (float)Integer.parseInt(proportions[1].trim()) / (float)proportionSum);
                this.conf.setUdfCollectorMemoryBudgetInMB(maxMemoryAvailable * (float)Integer.parseInt(proportions[2].trim()) / (float)proportionSum);
            }
            catch (Exception e) {
                throw new RuntimeException("Each subsection of configuration item udf_reader_transformer_collector_memory_proportion should be an integer, which is " + readerTransformerCollectorMemoryProportion);
            }
        }
    }

    public TSEncoding getDefaultEncodingByType(TSDataType dataType) {
        switch (dataType) {
            case BOOLEAN: {
                return this.conf.getDefaultBooleanEncoding();
            }
            case INT32: {
                return this.conf.getDefaultInt32Encoding();
            }
            case INT64: {
                return this.conf.getDefaultInt64Encoding();
            }
            case FLOAT: {
                return this.conf.getDefaultFloatEncoding();
            }
            case DOUBLE: {
                return this.conf.getDefaultDoubleEncoding();
            }
        }
        return this.conf.getDefaultTextEncoding();
    }

    private static class IoTDBDescriptorHolder {
        private static final IoTDBDescriptor INSTANCE = new IoTDBDescriptor();

        private IoTDBDescriptorHolder() {
        }
    }
}

