/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import jline.console.ConsoleReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.iotdb.exception.ArgsErrorException;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.session.SessionDataSet;
import org.apache.iotdb.tool.AbstractCsvTool;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.RowRecord;

public class ExportCsv
extends AbstractCsvTool {
    private static final String TARGET_DIR_ARGS = "td";
    private static final String TARGET_DIR_NAME = "targetDirectory";
    private static final String TARGET_FILE_ARGS = "f";
    private static final String TARGET_FILE_NAME = "targetFile";
    private static final String SQL_FILE_ARGS = "s";
    private static final String SQL_FILE_NAME = "sqlfile";
    private static final String TSFILEDB_CLI_PREFIX = "ExportCsv";
    private static final String DUMP_FILE_NAME_DEFAULT = "dump";
    private static String targetFile = "dump";
    private static String targetDirectory;
    private static final int EXPORT_PER_LINE_COUNT = 10000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        CommandLine commandLine;
        Options options = ExportCsv.createOptions();
        HelpFormatter hf = new HelpFormatter();
        DefaultParser parser = new DefaultParser();
        hf.setOptionComparator(null);
        hf.setWidth(92);
        if (args == null || args.length == 0) {
            System.out.println("Too few params input, please check the following hint.");
            hf.printHelp(TSFILEDB_CLI_PREFIX, options, true);
            return;
        }
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            hf.printHelp(TSFILEDB_CLI_PREFIX, options, true);
            return;
        }
        if (commandLine.hasOption("help")) {
            hf.printHelp(TSFILEDB_CLI_PREFIX, options, true);
            return;
        }
        ConsoleReader reader = new ConsoleReader();
        reader.setExpandEvents(false);
        try {
            ExportCsv.parseBasicParams(commandLine, reader);
            ExportCsv.parseSpecialParams(commandLine);
            if (!ExportCsv.checkTimeFormat()) {
                return;
            }
            String sqlFile = commandLine.getOptionValue(SQL_FILE_ARGS);
            session = new Session(host, Integer.parseInt(port), username, password);
            session.open(false);
            ExportCsv.setTimeZone();
            if (sqlFile == null) {
                String sql = reader.readLine("ExportCsv> please input query: ");
                String[] values = sql.trim().split(";");
                for (int i = 0; i < values.length; ++i) {
                    ExportCsv.dumpResult(values[i], i);
                }
            } else {
                ExportCsv.dumpFromSqlFile(sqlFile);
            }
        }
        catch (IOException e) {
            System.out.println("Failed to operate on file, because " + e.getMessage());
        }
        catch (ArgsErrorException e) {
            System.out.println("Invalid args: " + e.getMessage());
        }
        catch (IoTDBConnectionException | StatementExecutionException e) {
            System.out.println("Connect failed because " + e.getMessage());
        }
        finally {
            reader.close();
            if (session != null) {
                try {
                    session.close();
                }
                catch (IoTDBConnectionException e) {
                    System.out.println("Encounter an error when closing session, error is: " + e.getMessage());
                }
            }
        }
    }

    private static void parseSpecialParams(CommandLine commandLine) throws ArgsErrorException {
        targetDirectory = ExportCsv.checkRequiredArg(TARGET_DIR_ARGS, TARGET_DIR_NAME, commandLine);
        targetFile = commandLine.getOptionValue(TARGET_FILE_ARGS);
        if (targetFile == null) {
            targetFile = DUMP_FILE_NAME_DEFAULT;
        }
        if ((timeFormat = commandLine.getOptionValue("tf")) == null) {
            timeFormat = "default";
        }
        timeZoneID = commandLine.getOptionValue("tz");
        if (!targetDirectory.endsWith(File.separator)) {
            targetDirectory = targetDirectory + File.separator;
        }
    }

    private static Options createOptions() {
        Options options = ExportCsv.createNewOptions();
        Option opTargetFile = Option.builder((String)TARGET_DIR_ARGS).required().argName(TARGET_DIR_NAME).hasArg().desc("Target File Directory (required)").build();
        options.addOption(opTargetFile);
        Option targetFileName = Option.builder((String)TARGET_FILE_ARGS).argName(TARGET_FILE_NAME).hasArg().desc("Export file name (optional)").build();
        options.addOption(targetFileName);
        Option opSqlFile = Option.builder((String)SQL_FILE_ARGS).argName(SQL_FILE_NAME).hasArg().desc("SQL File Path (optional)").build();
        options.addOption(opSqlFile);
        Option opTimeFormat = Option.builder((String)"tf").argName("timeformat").hasArg().desc("Output time Format in csv file. You can choose 1) timestamp, number, long 2) ISO8601, default 3) user-defined pattern like yyyy-MM-dd\\ HH:mm:ss, default ISO8601 (optional)").build();
        options.addOption(opTimeFormat);
        Option opTimeZone = Option.builder((String)"tz").argName("timeZone").hasArg().desc("Time Zone eg. +08:00 or -01:00 (optional)").build();
        options.addOption(opTimeZone);
        Option opHelp = Option.builder((String)"help").longOpt("help").hasArg(false).desc("Display help information").build();
        options.addOption(opHelp);
        return options;
    }

    private static void dumpFromSqlFile(String filePath) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String sql;
            int index = 0;
            while ((sql = reader.readLine()) != null) {
                ExportCsv.dumpResult(sql, index);
                ++index;
            }
        }
    }

    private static void dumpResult(String sql, int index) {
        String path = targetDirectory + targetFile + index + ".csv";
        File tf = new File(path);
        try {
            if (!tf.exists() && !tf.createNewFile()) {
                System.out.println("Could not create target file for sql statement: " + sql);
                return;
            }
        }
        catch (IOException e) {
            System.out.println("Cannot create dump file " + path + " because: " + e.getMessage());
            return;
        }
        System.out.println("Start to export data from sql statement: " + sql);
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(tf));){
            SessionDataSet sessionDataSet = session.executeQueryStatement(sql);
            long startTime = System.currentTimeMillis();
            ExportCsv.writeMetadata(bw, sessionDataSet.getColumnNames());
            int line = ExportCsv.writeResultSet(sessionDataSet, bw);
            System.out.printf("Statement [%s] has dumped to file %s successfully! It costs %dms to export %d lines.%n", sql, path, System.currentTimeMillis() - startTime, line);
        }
        catch (IOException | IoTDBConnectionException | StatementExecutionException e) {
            System.out.println("Cannot dump result because: " + e.getMessage());
        }
    }

    private static void writeMetadata(BufferedWriter bw, List<String> columnNames) throws IOException {
        if (!columnNames.get(0).equals("Time")) {
            bw.write("Time,");
        }
        for (int i = 0; i < columnNames.size() - 1; ++i) {
            bw.write(columnNames.get(i) + ",");
        }
        bw.write(columnNames.get(columnNames.size() - 1) + "\n");
    }

    private static int writeResultSet(SessionDataSet rs, BufferedWriter bw) throws IOException, StatementExecutionException, IoTDBConnectionException {
        int line = 0;
        long timestamp = System.currentTimeMillis();
        while (rs.hasNext()) {
            RowRecord rowRecord = rs.next();
            List fields = rowRecord.getFields();
            ExportCsv.writeTime(rowRecord.getTimestamp(), bw);
            ExportCsv.writeValue(fields, bw);
            if (++line % 10000 != 0) continue;
            long tmp = System.currentTimeMillis();
            System.out.printf("%d lines have been exported, it takes %dms%n", line, tmp - timestamp);
            timestamp = tmp;
        }
        return line;
    }

    private static void writeTime(Long time, BufferedWriter bw) throws IOException {
        String timestampPrecision = "ms";
        switch (timeFormat) {
            case "default": {
                String str = RpcUtils.parseLongToDateWithPrecision((DateTimeFormatter)DateTimeFormatter.ISO_OFFSET_DATE_TIME, (long)time, (ZoneId)zoneId, (String)timestampPrecision);
                bw.write(str + ",");
                break;
            }
            case "timestamp": 
            case "long": 
            case "number": {
                bw.write(time + ",");
                break;
            }
            default: {
                ZonedDateTime dateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), zoneId);
                bw.write(dateTime.format(DateTimeFormatter.ofPattern(timeFormat)) + ",");
            }
        }
    }

    private static void writeValue(List<Field> fields, BufferedWriter bw) throws IOException {
        for (int j = 0; j < fields.size() - 1; ++j) {
            String value = fields.get(j).getStringValue();
            if ("null".equalsIgnoreCase(value)) {
                bw.write(",");
                continue;
            }
            if (fields.get(j).getDataType() == TSDataType.TEXT) {
                int location = value.indexOf("\"");
                if (location > -1) {
                    if (location == 0 || value.charAt(location - 1) != '\\') {
                        bw.write("\"" + value.replace("\"", "\\\"") + "\",");
                        continue;
                    }
                    bw.write("\"" + value + "\",");
                    continue;
                }
                if (value.contains(",")) {
                    bw.write("\"" + value + "\",");
                    continue;
                }
                bw.write(value + ",");
                continue;
            }
            bw.write(value + ",");
        }
        String lastValue = fields.get(fields.size() - 1).getStringValue();
        if ("null".equalsIgnoreCase(lastValue)) {
            bw.write("\n");
        } else if (fields.get(fields.size() - 1).getDataType() == TSDataType.TEXT) {
            int location = lastValue.indexOf("\"");
            if (location > -1) {
                if (location == 0 || lastValue.charAt(location - 1) != '\\') {
                    bw.write("\"" + lastValue.replace("\"", "\\\"") + "\"\n");
                } else {
                    bw.write("\"" + lastValue + "\"\n");
                }
            } else if (lastValue.contains(",")) {
                bw.write("\"" + lastValue + "\"\n");
            } else {
                bw.write(lastValue + "\n");
            }
        } else {
            bw.write(lastValue + "\n");
        }
    }
}

