/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.universal;

import java.io.IOException;
import java.util.PriorityQueue;
import org.apache.iotdb.db.query.reader.universal.Element;
import org.apache.iotdb.db.query.reader.universal.PriorityMergeReader;
import org.apache.iotdb.tsfile.read.reader.IPointReader;

public class DescPriorityMergeReader
extends PriorityMergeReader {
    public DescPriorityMergeReader() {
        this.heap = new PriorityQueue((o1, o2) -> {
            int timeCompare = Long.compare(o2.currPair().getTimestamp(), o1.currPair().getTimestamp());
            return timeCompare != 0 ? timeCompare : o2.getPriority().compareTo(o1.getPriority());
        });
    }

    @Override
    public void addReader(IPointReader reader, PriorityMergeReader.MergeReaderPriority priority, long endTime) throws IOException {
        if (reader.hasNextTimeValuePair()) {
            this.heap.add(new Element(reader, reader.nextTimeValuePair(), priority));
            this.currentReadStopTime = Math.min(this.currentReadStopTime, endTime);
        } else {
            reader.close();
        }
    }
}

