/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.executor;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.auth.AuthException;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.auth.authorizer.BasicAuthorizer;
import org.apache.iotdb.db.auth.authorizer.IAuthorizer;
import org.apache.iotdb.db.auth.entity.PathPrivilege;
import org.apache.iotdb.db.auth.entity.Role;
import org.apache.iotdb.db.auth.entity.User;
import org.apache.iotdb.db.conf.IoTDBConstant;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.cache.ChunkCache;
import org.apache.iotdb.db.engine.cache.TimeSeriesMetadataCache;
import org.apache.iotdb.db.engine.flush.pool.FlushTaskPoolManager;
import org.apache.iotdb.db.engine.merge.manage.MergeManager;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupProcessor;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.BatchProcessException;
import org.apache.iotdb.db.exception.QueryIdNotExsitException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.UDFRegistrationException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.metadata.mnode.MNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.StorageGroupMNode;
import org.apache.iotdb.db.monitor.StatMonitor;
import org.apache.iotdb.db.qp.constant.SQLConstant;
import org.apache.iotdb.db.qp.executor.IPlanExecutor;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.sys.AuthorOperator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.AggregationPlan;
import org.apache.iotdb.db.qp.physical.crud.AlignByDevicePlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePartitionPlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.FillQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimeFillPlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertMultiTabletPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowsOfOneDevicePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowsPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.qp.physical.crud.LastQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryIndexPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.UDTFPlan;
import org.apache.iotdb.db.qp.physical.sys.AlterTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.AuthorPlan;
import org.apache.iotdb.db.qp.physical.sys.CountPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateFunctionPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateMultiTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTriggerPlan;
import org.apache.iotdb.db.qp.physical.sys.DataAuthPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DropFunctionPlan;
import org.apache.iotdb.db.qp.physical.sys.DropTriggerPlan;
import org.apache.iotdb.db.qp.physical.sys.FlushPlan;
import org.apache.iotdb.db.qp.physical.sys.KillQueryPlan;
import org.apache.iotdb.db.qp.physical.sys.LoadConfigurationPlan;
import org.apache.iotdb.db.qp.physical.sys.MergePlan;
import org.apache.iotdb.db.qp.physical.sys.OperateFilePlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTTLPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowChildNodesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowChildPathsPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowDevicesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowFunctionsPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowLockInfoPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTTLPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTriggersPlan;
import org.apache.iotdb.db.qp.physical.sys.StartTriggerPlan;
import org.apache.iotdb.db.qp.physical.sys.StopTriggerPlan;
import org.apache.iotdb.db.qp.physical.sys.TracingPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryTimeManager;
import org.apache.iotdb.db.query.control.TracingManager;
import org.apache.iotdb.db.query.dataset.AlignByDeviceDataSet;
import org.apache.iotdb.db.query.dataset.ListDataSet;
import org.apache.iotdb.db.query.dataset.ShowDevicesDataSet;
import org.apache.iotdb.db.query.dataset.ShowTimeseriesDataSet;
import org.apache.iotdb.db.query.dataset.SingleDataSet;
import org.apache.iotdb.db.query.executor.IQueryRouter;
import org.apache.iotdb.db.query.executor.QueryRouter;
import org.apache.iotdb.db.query.udf.service.UDFRegistrationInformation;
import org.apache.iotdb.db.query.udf.service.UDFRegistrationService;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.tools.TsFileRewriteTool;
import org.apache.iotdb.db.utils.AuthUtils;
import org.apache.iotdb.db.utils.FileLoaderUtils;
import org.apache.iotdb.db.utils.UpgradeUtils;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.file.metadata.ChunkGroupMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.EmptyDataSet;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlanExecutor
implements IPlanExecutor {
    private static final Logger logger = LoggerFactory.getLogger(PlanExecutor.class);
    protected IQueryRouter queryRouter = new QueryRouter();
    private IAuthorizer authorizer;
    private static final String INSERT_MEASUREMENTS_FAILED_MESSAGE = "failed to insert measurements ";

    public PlanExecutor() throws QueryProcessException {
        try {
            this.authorizer = BasicAuthorizer.getInstance();
        }
        catch (AuthException e) {
            throw new QueryProcessException(e.getMessage());
        }
    }

    @Override
    public QueryDataSet processQuery(PhysicalPlan queryPlan, QueryContext context) throws IOException, StorageEngineException, QueryFilterOptimizationException, QueryProcessException, MetadataException, InterruptedException {
        if (queryPlan instanceof QueryPlan) {
            return this.processDataQuery((QueryPlan)queryPlan, context);
        }
        if (queryPlan instanceof AuthorPlan) {
            return this.processAuthorQuery((AuthorPlan)queryPlan);
        }
        if (queryPlan instanceof ShowPlan) {
            return this.processShowQuery((ShowPlan)queryPlan, context);
        }
        throw new QueryProcessException(String.format("Unrecognized query plan %s", queryPlan));
    }

    @Override
    public boolean processNonQuery(PhysicalPlan plan) throws QueryProcessException, StorageGroupNotSetException, StorageEngineException {
        switch (plan.getOperatorType()) {
            case DELETE: {
                this.delete((DeletePlan)plan);
                return true;
            }
            case INSERT: {
                this.insert((InsertRowPlan)plan);
                return true;
            }
            case BATCH_INSERT_ONE_DEVICE: {
                this.insert((InsertRowsOfOneDevicePlan)plan);
                return true;
            }
            case BATCH_INSERT_ROWS: {
                this.insert((InsertRowsPlan)plan);
                return true;
            }
            case BATCHINSERT: {
                this.insertTablet((InsertTabletPlan)plan);
                return true;
            }
            case MULTI_BATCH_INSERT: {
                this.insertTablet((InsertMultiTabletPlan)plan);
                return true;
            }
            case CREATE_ROLE: 
            case DELETE_ROLE: 
            case CREATE_USER: 
            case REVOKE_USER_ROLE: 
            case REVOKE_ROLE_PRIVILEGE: 
            case REVOKE_USER_PRIVILEGE: 
            case GRANT_ROLE_PRIVILEGE: 
            case GRANT_USER_PRIVILEGE: 
            case GRANT_USER_ROLE: 
            case MODIFY_PASSWORD: 
            case DELETE_USER: {
                AuthorPlan author = (AuthorPlan)plan;
                return this.operateAuthor(author);
            }
            case GRANT_WATERMARK_EMBEDDING: {
                return this.operateWatermarkEmbedding(((DataAuthPlan)plan).getUsers(), true);
            }
            case REVOKE_WATERMARK_EMBEDDING: {
                return this.operateWatermarkEmbedding(((DataAuthPlan)plan).getUsers(), false);
            }
            case DELETE_TIMESERIES: {
                return this.deleteTimeSeries((DeleteTimeSeriesPlan)plan);
            }
            case CREATE_TIMESERIES: {
                return this.createTimeSeries((CreateTimeSeriesPlan)plan);
            }
            case CREATE_MULTI_TIMESERIES: {
                return this.createMultiTimeSeries((CreateMultiTimeSeriesPlan)plan);
            }
            case ALTER_TIMESERIES: {
                return this.alterTimeSeries((AlterTimeSeriesPlan)plan);
            }
            case SET_STORAGE_GROUP: {
                return this.setStorageGroup((SetStorageGroupPlan)plan);
            }
            case DELETE_STORAGE_GROUP: {
                return this.deleteStorageGroups((DeleteStorageGroupPlan)plan);
            }
            case TTL: {
                this.operateTTL((SetTTLPlan)plan);
                return true;
            }
            case LOAD_CONFIGURATION: {
                this.loadConfiguration((LoadConfigurationPlan)plan);
                return true;
            }
            case LOAD_FILES: {
                this.operateLoadFiles((OperateFilePlan)plan);
                return true;
            }
            case REMOVE_FILE: {
                this.operateRemoveFile((OperateFilePlan)plan);
                return true;
            }
            case MOVE_FILE: {
                this.operateMoveFile((OperateFilePlan)plan);
                return true;
            }
            case FLUSH: {
                this.operateFlush((FlushPlan)plan);
                return true;
            }
            case MERGE: 
            case FULL_MERGE: {
                this.operateMerge((MergePlan)plan);
                return true;
            }
            case TRACING: {
                this.operateTracing((TracingPlan)plan);
                return true;
            }
            case CLEAR_CACHE: {
                this.operateClearCache();
                return true;
            }
            case DELETE_PARTITION: {
                DeletePartitionPlan p = (DeletePartitionPlan)plan;
                StorageGroupProcessor.TimePartitionFilter filter = (storageGroupName, partitionId) -> storageGroupName.equals(((DeletePartitionPlan)plan).getStorageGroupName().getFullPath()) && p.getPartitionId().contains(partitionId);
                StorageEngine.getInstance().removePartitions(((DeletePartitionPlan)plan).getStorageGroupName(), filter);
                return true;
            }
            case CREATE_SCHEMA_SNAPSHOT: {
                this.operateCreateSnapshot();
                return true;
            }
            case CREATE_FUNCTION: {
                return this.operateCreateFunction((CreateFunctionPlan)plan);
            }
            case DROP_FUNCTION: {
                return this.operateDropFunction((DropFunctionPlan)plan);
            }
            case CREATE_TRIGGER: {
                return this.operateCreateTrigger((CreateTriggerPlan)plan);
            }
            case DROP_TRIGGER: {
                return this.operateDropTrigger((DropTriggerPlan)plan);
            }
            case START_TRIGGER: {
                return this.operateStartTrigger((StartTriggerPlan)plan);
            }
            case STOP_TRIGGER: {
                return this.operateStopTrigger((StopTriggerPlan)plan);
            }
            case CREATE_INDEX: {
                throw new QueryProcessException("Create index hasn't been supported yet");
            }
            case DROP_INDEX: {
                throw new QueryProcessException("Drop index hasn't been supported yet");
            }
            case KILL: {
                try {
                    this.operateKillQuery((KillQueryPlan)plan);
                }
                catch (QueryIdNotExsitException e) {
                    throw new QueryProcessException(e.getMessage());
                }
                return true;
            }
        }
        throw new UnsupportedOperationException(String.format("operation %s is not supported", new Object[]{plan.getOperatorType()}));
    }

    private boolean operateCreateFunction(CreateFunctionPlan plan) throws UDFRegistrationException {
        UDFRegistrationService.getInstance().register(plan.getUdfName(), plan.getClassName(), plan.isTemporary(), true);
        return true;
    }

    private boolean operateDropFunction(DropFunctionPlan plan) throws UDFRegistrationException {
        UDFRegistrationService.getInstance().deregister(plan.getUdfName());
        return true;
    }

    private boolean operateCreateTrigger(CreateTriggerPlan plan) {
        return false;
    }

    private boolean operateDropTrigger(DropTriggerPlan plan) {
        return false;
    }

    private boolean operateStartTrigger(StartTriggerPlan plan) {
        return false;
    }

    private boolean operateStopTrigger(StopTriggerPlan plan) {
        return false;
    }

    private void operateMerge(MergePlan plan) throws StorageEngineException {
        if (plan.getOperatorType() == Operator.OperatorType.FULL_MERGE) {
            StorageEngine.getInstance().mergeAll(true);
        } else {
            StorageEngine.getInstance().mergeAll(false);
        }
    }

    private void operateClearCache() {
        ChunkCache.getInstance().clear();
        TimeSeriesMetadataCache.getInstance().clear();
    }

    private void operateCreateSnapshot() {
        IoTDB.metaManager.createMTreeSnapshot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void operateKillQuery(KillQueryPlan killQueryPlan) throws QueryIdNotExsitException {
        QueryTimeManager queryTimeManager = QueryTimeManager.getInstance();
        long killQueryId = killQueryPlan.getQueryId();
        if (killQueryId != -1L) {
            if (queryTimeManager.getQueryInfoMap().get(killQueryId) == null) throw new QueryIdNotExsitException(String.format("Query Id %d is not exist, please check it.", killQueryPlan.getQueryId()));
            queryTimeManager.killQuery(killQueryId);
            return;
        }
        if (queryTimeManager.getQueryInfoMap().isEmpty()) return;
        Map<Long, QueryTimeManager.QueryInfo> map = queryTimeManager.getQueryInfoMap();
        synchronized (map) {
            ArrayList<Long> queryIdList = new ArrayList<Long>(queryTimeManager.getQueryInfoMap().keySet());
            for (Long queryId : queryIdList) {
                queryTimeManager.killQuery(queryId);
            }
            return;
        }
    }

    private void operateTracing(TracingPlan plan) {
        IoTDBDescriptor.getInstance().getConfig().setEnablePerformanceTracing(plan.isTracingOn());
        if (!plan.isTracingOn()) {
            TracingManager.getInstance().close();
        } else if (!TracingManager.getInstance().getWriterStatus()) {
            TracingManager.getInstance().openTracingWriteStream();
        }
    }

    private void operateFlush(FlushPlan plan) throws StorageGroupNotSetException {
        List<PartialPath> noExistSg;
        if (plan.getPaths().isEmpty()) {
            StorageEngine.getInstance().syncCloseAllProcessor();
        } else {
            PlanExecutor.flushSpecifiedStorageGroups(plan);
        }
        if (!plan.getPaths().isEmpty() && !(noExistSg = this.checkStorageGroupExist(plan.getPaths())).isEmpty()) {
            StringBuilder sb = new StringBuilder();
            noExistSg.forEach(storageGroup -> sb.append(storageGroup.getFullPath()).append(","));
            throw new StorageGroupNotSetException(sb.subSequence(0, sb.length() - 1).toString(), true);
        }
    }

    public static void flushSpecifiedStorageGroups(FlushPlan plan) throws StorageGroupNotSetException {
        Map<PartialPath, List<Pair<Long, Boolean>>> storageGroupMap = plan.getStorageGroupPartitionIds();
        for (Map.Entry<PartialPath, List<Pair<Long, Boolean>>> entry : storageGroupMap.entrySet()) {
            PartialPath storageGroupName = entry.getKey();
            if (entry.getValue() == null) {
                if (plan.isSeq() == null) {
                    StorageEngine.getInstance().closeStorageGroupProcessor(storageGroupName, true, plan.isSync());
                    StorageEngine.getInstance().closeStorageGroupProcessor(storageGroupName, false, plan.isSync());
                    continue;
                }
                StorageEngine.getInstance().closeStorageGroupProcessor(storageGroupName, plan.isSeq(), plan.isSync());
                continue;
            }
            List<Pair<Long, Boolean>> partitionIdSequencePairs = entry.getValue();
            for (Pair<Long, Boolean> pair : partitionIdSequencePairs) {
                StorageEngine.getInstance().closeStorageGroupProcessor(storageGroupName, (Long)pair.left, (Boolean)pair.right, true);
            }
        }
    }

    protected QueryDataSet processDataQuery(QueryPlan queryPlan, QueryContext context) throws StorageEngineException, QueryFilterOptimizationException, QueryProcessException, IOException, InterruptedException {
        AlignByDeviceDataSet queryDataSet;
        if (queryPlan instanceof AlignByDevicePlan) {
            queryDataSet = this.getAlignByDeviceDataSet((AlignByDevicePlan)queryPlan, context, this.queryRouter);
        } else {
            if (queryPlan.getPaths() == null || queryPlan.getPaths().isEmpty()) {
                return new EmptyDataSet();
            }
            if (queryPlan instanceof UDTFPlan) {
                UDTFPlan udtfPlan = (UDTFPlan)queryPlan;
                queryDataSet = this.queryRouter.udtfQuery(udtfPlan, context);
            } else if (queryPlan instanceof GroupByTimeFillPlan) {
                GroupByTimeFillPlan groupByFillPlan = (GroupByTimeFillPlan)queryPlan;
                queryDataSet = this.queryRouter.groupByFill(groupByFillPlan, context);
            } else if (queryPlan instanceof GroupByTimePlan) {
                GroupByTimePlan groupByTimePlan = (GroupByTimePlan)queryPlan;
                queryDataSet = this.queryRouter.groupBy(groupByTimePlan, context);
            } else {
                if (queryPlan instanceof QueryIndexPlan) {
                    throw new QueryProcessException("Query index hasn't been supported yet");
                }
                if (queryPlan instanceof AggregationPlan) {
                    AggregationPlan aggregationPlan = (AggregationPlan)queryPlan;
                    queryDataSet = this.queryRouter.aggregate(aggregationPlan, context);
                } else if (queryPlan instanceof FillQueryPlan) {
                    FillQueryPlan fillQueryPlan = (FillQueryPlan)queryPlan;
                    queryDataSet = this.queryRouter.fill(fillQueryPlan, context);
                } else {
                    queryDataSet = queryPlan instanceof LastQueryPlan ? this.queryRouter.lastQuery((LastQueryPlan)queryPlan, context) : this.queryRouter.rawDataQuery((RawDataQueryPlan)queryPlan, context);
                }
            }
        }
        queryDataSet.setRowLimit(queryPlan.getRowLimit());
        queryDataSet.setRowOffset(queryPlan.getRowOffset());
        queryDataSet.setWithoutAllNull(queryPlan.isWithoutAllNull());
        queryDataSet.setWithoutAnyNull(queryPlan.isWithoutAnyNull());
        return queryDataSet;
    }

    protected AlignByDeviceDataSet getAlignByDeviceDataSet(AlignByDevicePlan plan, QueryContext context, IQueryRouter router) {
        return new AlignByDeviceDataSet(plan, context, router);
    }

    protected QueryDataSet processShowQuery(ShowPlan showPlan, QueryContext context) throws QueryProcessException, MetadataException {
        switch (showPlan.getShowContentType()) {
            case TTL: {
                return this.processShowTTLQuery((ShowTTLPlan)showPlan);
            }
            case FLUSH_TASK_INFO: {
                return this.processShowFlushTaskInfo();
            }
            case VERSION: {
                return this.processShowVersion();
            }
            case TIMESERIES: {
                return this.processShowTimeseries((ShowTimeSeriesPlan)showPlan, context);
            }
            case STORAGE_GROUP: {
                return this.processShowStorageGroup((ShowStorageGroupPlan)showPlan);
            }
            case LOCK_INFO: {
                return this.processShowLockInfo((ShowLockInfoPlan)showPlan);
            }
            case DEVICES: {
                return this.processShowDevices((ShowDevicesPlan)showPlan);
            }
            case CHILD_PATH: {
                return this.processShowChildPaths((ShowChildPathsPlan)showPlan);
            }
            case CHILD_NODE: {
                return this.processShowChildNodes((ShowChildNodesPlan)showPlan);
            }
            case COUNT_TIMESERIES: {
                return this.processCountTimeSeries((CountPlan)showPlan);
            }
            case COUNT_NODE_TIMESERIES: {
                return this.processCountNodeTimeSeries((CountPlan)showPlan);
            }
            case COUNT_DEVICES: {
                return this.processCountDevices((CountPlan)showPlan);
            }
            case COUNT_STORAGE_GROUP: {
                return this.processCountStorageGroup((CountPlan)showPlan);
            }
            case COUNT_NODES: {
                return this.processCountNodes((CountPlan)showPlan);
            }
            case MERGE_STATUS: {
                return this.processShowMergeStatus();
            }
            case QUERY_PROCESSLIST: {
                return this.processShowQueryProcesslist();
            }
            case FUNCTIONS: {
                return this.processShowFunctions((ShowFunctionsPlan)showPlan);
            }
            case TRIGGERS: {
                return this.processShowTriggers((ShowTriggersPlan)showPlan);
            }
        }
        throw new QueryProcessException(String.format("Unrecognized show plan %s", showPlan));
    }

    private QueryDataSet processCountNodes(CountPlan countPlan) throws MetadataException {
        int num = this.getNodesNumInGivenLevel(countPlan.getPath(), countPlan.getLevel());
        return this.createSingleDataSet("count", TSDataType.INT32, num);
    }

    private QueryDataSet processCountNodeTimeSeries(CountPlan countPlan) throws MetadataException {
        List<PartialPath> nodes = this.getNodesList(countPlan.getPath(), countPlan.getLevel());
        ListDataSet listDataSet = new ListDataSet(Arrays.asList(new PartialPath("column", false), new PartialPath("count", false)), Arrays.asList(TSDataType.TEXT, TSDataType.INT32));
        for (PartialPath columnPath : nodes) {
            RowRecord record = new RowRecord(0L);
            Field field = new Field(TSDataType.TEXT);
            field.setBinaryV(new Binary(columnPath.getFullPath()));
            Field field1 = new Field(TSDataType.INT32);
            field1.setIntV(this.getPathsNum(columnPath));
            record.addField(field);
            record.addField(field1);
            listDataSet.putRecord(record);
        }
        return listDataSet;
    }

    private QueryDataSet processCountDevices(CountPlan countPlan) throws MetadataException {
        int num = this.getDevicesNum(countPlan.getPath());
        return this.createSingleDataSet("devices", TSDataType.INT32, num);
    }

    private QueryDataSet processCountStorageGroup(CountPlan countPlan) throws MetadataException {
        int num = this.getStorageGroupNum(countPlan.getPath());
        return this.createSingleDataSet("storage group", TSDataType.INT32, num);
    }

    private QueryDataSet createSingleDataSet(String columnName, TSDataType columnType, Object val) {
        SingleDataSet singleDataSet = new SingleDataSet(Collections.singletonList(new PartialPath(columnName, false)), Collections.singletonList(columnType));
        Field field = new Field(columnType);
        switch (columnType) {
            case TEXT: {
                field.setBinaryV((Binary)val);
                break;
            }
            case FLOAT: {
                field.setFloatV(((Float)val).floatValue());
                break;
            }
            case INT32: {
                field.setIntV(((Integer)val).intValue());
                break;
            }
            case INT64: {
                field.setLongV(((Long)val).longValue());
                break;
            }
            case DOUBLE: {
                field.setDoubleV(((Double)val).doubleValue());
                break;
            }
            case BOOLEAN: {
                field.setBoolV(((Boolean)val).booleanValue());
            }
        }
        RowRecord record = new RowRecord(0L);
        record.addField(field);
        singleDataSet.setRecord(record);
        return singleDataSet;
    }

    private int getDevicesNum(PartialPath path) throws MetadataException {
        return IoTDB.metaManager.getDevicesNum(path);
    }

    private int getStorageGroupNum(PartialPath path) throws MetadataException {
        return IoTDB.metaManager.getStorageGroupNum(path);
    }

    protected int getPathsNum(PartialPath path) throws MetadataException {
        return IoTDB.metaManager.getAllTimeseriesCount(path);
    }

    protected int getNodesNumInGivenLevel(PartialPath path, int level) throws MetadataException {
        return IoTDB.metaManager.getNodesCountInGivenLevel(path, level);
    }

    protected List<PartialPath> getPathsName(PartialPath path) throws MetadataException {
        return IoTDB.metaManager.getAllTimeseriesPath(path);
    }

    protected List<PartialPath> getNodesList(PartialPath schemaPattern, int level) throws MetadataException {
        return IoTDB.metaManager.getNodesList(schemaPattern, level);
    }

    private QueryDataSet processCountTimeSeries(CountPlan countPlan) throws MetadataException {
        int num = this.getPathsNum(countPlan.getPath());
        return this.createSingleDataSet("count", TSDataType.INT32, num);
    }

    private QueryDataSet processShowDevices(ShowDevicesPlan showDevicesPlan) throws MetadataException {
        return new ShowDevicesDataSet(showDevicesPlan);
    }

    protected Set<PartialPath> getDevices(PartialPath path) throws MetadataException {
        return IoTDB.metaManager.getDevices(path);
    }

    private QueryDataSet processShowChildPaths(ShowChildPathsPlan showChildPathsPlan) throws MetadataException {
        Set<String> childPathsList = this.getPathNextChildren(showChildPathsPlan.getPath());
        ListDataSet listDataSet = new ListDataSet(Collections.singletonList(new PartialPath("child paths", false)), Collections.singletonList(TSDataType.TEXT));
        for (String s : childPathsList) {
            RowRecord record = new RowRecord(0L);
            Field field = new Field(TSDataType.TEXT);
            field.setBinaryV(new Binary(s));
            record.addField(field);
            listDataSet.putRecord(record);
        }
        return listDataSet;
    }

    protected Set<String> getPathNextChildren(PartialPath path) throws MetadataException {
        return IoTDB.metaManager.getChildNodePathInNextLevel(path);
    }

    private QueryDataSet processShowChildNodes(ShowChildNodesPlan showChildNodesPlan) throws MetadataException {
        Set<String> childNodesList = this.getNodeNextChildren(showChildNodesPlan.getPath());
        ListDataSet listDataSet = new ListDataSet(Collections.singletonList(new PartialPath("child nodes", false)), Collections.singletonList(TSDataType.TEXT));
        for (String s : childNodesList) {
            RowRecord record = new RowRecord(0L);
            Field field = new Field(TSDataType.TEXT);
            field.setBinaryV(new Binary(s));
            record.addField(field);
            listDataSet.putRecord(record);
        }
        return listDataSet;
    }

    protected Set<String> getNodeNextChildren(PartialPath path) throws MetadataException {
        return IoTDB.metaManager.getChildNodeInNextLevel(path);
    }

    protected List<PartialPath> getStorageGroupNames(PartialPath path) throws MetadataException {
        return IoTDB.metaManager.getStorageGroupPaths(path);
    }

    private QueryDataSet processShowStorageGroup(ShowStorageGroupPlan showStorageGroupPlan) throws MetadataException {
        ListDataSet listDataSet = new ListDataSet(Collections.singletonList(new PartialPath("storage group", false)), Collections.singletonList(TSDataType.TEXT));
        List<PartialPath> storageGroupList = this.getStorageGroupNames(showStorageGroupPlan.getPath());
        this.addToDataSet((Collection<PartialPath>)storageGroupList, listDataSet);
        return listDataSet;
    }

    private void addToDataSet(Collection<PartialPath> paths, ListDataSet dataSet) {
        for (PartialPath s : paths) {
            RowRecord record = new RowRecord(0L);
            Field field = new Field(TSDataType.TEXT);
            field.setBinaryV(new Binary(s.getFullPath()));
            record.addField(field);
            dataSet.putRecord(record);
        }
    }

    private QueryDataSet processShowLockInfo(ShowLockInfoPlan showLockInfoPlan) throws MetadataException {
        ListDataSet listDataSet = new ListDataSet(Arrays.asList(new PartialPath("storage group", false), new PartialPath("lock holder", false)), Arrays.asList(TSDataType.TEXT, TSDataType.TEXT));
        try {
            List<PartialPath> storageGroupList = this.getStorageGroupNames(showLockInfoPlan.getPath());
            List<String> lockHolderList = StorageEngine.getInstance().getLockInfo(storageGroupList);
            this.addLockInfoToDataSet(storageGroupList, lockHolderList, listDataSet);
        }
        catch (StorageEngineException e) {
            throw new MetadataException(e);
        }
        return listDataSet;
    }

    private void addLockInfoToDataSet(List<PartialPath> paths, List<String> lockHolderList, ListDataSet dataSet) {
        for (int i = 0; i < paths.size(); ++i) {
            RowRecord record = new RowRecord(0L);
            Field field = new Field(TSDataType.TEXT);
            field.setBinaryV(new Binary(paths.get(i).getFullPath()));
            record.addField(field);
            field = new Field(TSDataType.TEXT);
            field.setBinaryV(new Binary(lockHolderList.get(i)));
            record.addField(field);
            dataSet.putRecord(record);
        }
    }

    private QueryDataSet processShowTimeseries(ShowTimeSeriesPlan showTimeSeriesPlan, QueryContext context) throws MetadataException {
        return new ShowTimeseriesDataSet(showTimeSeriesPlan, context);
    }

    protected List<StorageGroupMNode> getAllStorageGroupNodes() {
        return IoTDB.metaManager.getAllStorageGroupNodes();
    }

    private QueryDataSet processShowTTLQuery(ShowTTLPlan showTTLPlan) {
        ListDataSet listDataSet = new ListDataSet(Arrays.asList(new PartialPath("storage group", false), new PartialPath("ttl", false)), Arrays.asList(TSDataType.TEXT, TSDataType.INT64));
        List<PartialPath> selectedSgs = showTTLPlan.getStorageGroups();
        List<StorageGroupMNode> storageGroups = this.getAllStorageGroupNodes();
        int timestamp = 0;
        for (StorageGroupMNode mNode : storageGroups) {
            Field ttl;
            PartialPath sgName = mNode.getPartialPath();
            if (!selectedSgs.isEmpty() && !selectedSgs.contains(sgName)) continue;
            RowRecord rowRecord = new RowRecord((long)timestamp++);
            Field sg = new Field(TSDataType.TEXT);
            sg.setBinaryV(new Binary(sgName.getFullPath()));
            if (mNode.getDataTTL() != Long.MAX_VALUE) {
                ttl = new Field(TSDataType.INT64);
                ttl.setLongV(mNode.getDataTTL());
            } else {
                ttl = null;
            }
            rowRecord.addField(sg);
            rowRecord.addField(ttl);
            listDataSet.putRecord(rowRecord);
        }
        return listDataSet;
    }

    private QueryDataSet processShowVersion() {
        SingleDataSet singleDataSet = new SingleDataSet(Collections.singletonList(new PartialPath("        version", false)), Collections.singletonList(TSDataType.TEXT));
        Field field = new Field(TSDataType.TEXT);
        field.setBinaryV(new Binary(IoTDBConstant.VERSION));
        RowRecord rowRecord = new RowRecord(0L);
        rowRecord.addField(field);
        singleDataSet.setRecord(rowRecord);
        return singleDataSet;
    }

    private QueryDataSet processShowFlushTaskInfo() {
        ListDataSet listDataSet = new ListDataSet(Arrays.asList(new PartialPath("                             item", false), new PartialPath("value", false)), Arrays.asList(TSDataType.TEXT, TSDataType.TEXT));
        int timestamp = 0;
        this.addRowRecordForShowQuery(listDataSet, timestamp++, "total number of flush tasks", Integer.toString(FlushTaskPoolManager.getInstance().getTotalTasks()));
        this.addRowRecordForShowQuery(listDataSet, timestamp++, "number of working flush tasks", Integer.toString(FlushTaskPoolManager.getInstance().getWorkingTasksNumber()));
        this.addRowRecordForShowQuery(listDataSet, timestamp, "number of waiting flush tasks", Integer.toString(FlushTaskPoolManager.getInstance().getWaitingTasksNumber()));
        return listDataSet;
    }

    private QueryDataSet processShowFunctions(ShowFunctionsPlan showPlan) throws QueryProcessException {
        ListDataSet listDataSet = new ListDataSet(Arrays.asList(new PartialPath("function name", false), new PartialPath("function type", false), new PartialPath("class name (UDF)", false)), Arrays.asList(TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT));
        this.appendUDFs(listDataSet, showPlan);
        this.appendNativeFunctions(listDataSet, showPlan);
        listDataSet.sort((r1, r2) -> String.CASE_INSENSITIVE_ORDER.compare(((Field)r1.getFields().get(0)).getStringValue(), ((Field)r2.getFields().get(0)).getStringValue()));
        return listDataSet;
    }

    private void appendUDFs(ListDataSet listDataSet, ShowFunctionsPlan showPlan) throws QueryProcessException {
        for (UDFRegistrationInformation info : UDFRegistrationService.getInstance().getRegistrationInformation()) {
            if (showPlan.showTemporary() && !info.isTemporary()) continue;
            RowRecord rowRecord = new RowRecord(0L);
            rowRecord.addField((Object)Binary.valueOf((String)info.getFunctionName()), TSDataType.TEXT);
            String functionType = "";
            try {
                if (info.isBuiltin()) {
                    if (info.isUDTF()) {
                        functionType = "built-in UDTF";
                    } else if (info.isUDAF()) {
                        functionType = "built-in UDAF";
                    }
                } else if (info.isUDTF()) {
                    functionType = "external UDTF";
                } else if (info.isUDAF()) {
                    functionType = "external UDAF";
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new QueryProcessException(e.toString());
            }
            rowRecord.addField((Object)Binary.valueOf((String)functionType), TSDataType.TEXT);
            rowRecord.addField((Object)Binary.valueOf((String)info.getClassName()), TSDataType.TEXT);
            listDataSet.putRecord(rowRecord);
        }
    }

    private void appendNativeFunctions(ListDataSet listDataSet, ShowFunctionsPlan showPlan) {
        if (showPlan.showTemporary()) {
            return;
        }
        Binary functionType = Binary.valueOf((String)"native");
        Binary className = Binary.valueOf((String)"");
        for (String functionName : SQLConstant.getNativeFunctionNames()) {
            RowRecord rowRecord = new RowRecord(0L);
            rowRecord.addField((Object)Binary.valueOf((String)functionName.toUpperCase()), TSDataType.TEXT);
            rowRecord.addField((Object)functionType, TSDataType.TEXT);
            rowRecord.addField((Object)className, TSDataType.TEXT);
            listDataSet.putRecord(rowRecord);
        }
    }

    private QueryDataSet processShowTriggers(ShowTriggersPlan showPlan) {
        return new ListDataSet(Arrays.asList(new PartialPath("trigger name", false), new PartialPath("status", false), new PartialPath("event", false), new PartialPath("path", false), new PartialPath("class name", false), new PartialPath("attributes", false)), Arrays.asList(TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT));
    }

    private void addRowRecordForShowQuery(ListDataSet listDataSet, int timestamp, String item, String value) {
        RowRecord rowRecord = new RowRecord((long)timestamp);
        Field itemField = new Field(TSDataType.TEXT);
        itemField.setBinaryV(new Binary(item));
        Field valueField = new Field(TSDataType.TEXT);
        valueField.setBinaryV(new Binary(value));
        rowRecord.addField(itemField);
        rowRecord.addField(valueField);
        listDataSet.putRecord(rowRecord);
    }

    @Override
    public void delete(DeletePlan deletePlan) throws QueryProcessException {
        for (PartialPath path : deletePlan.getPaths()) {
            this.delete(path, deletePlan.getDeleteStartTime(), deletePlan.getDeleteEndTime(), deletePlan.getIndex());
        }
    }

    private void operateLoadFiles(OperateFilePlan plan) throws QueryProcessException {
        File file = plan.getFile();
        if (!file.exists()) {
            throw new QueryProcessException(String.format("File path %s doesn't exists.", file.getPath()));
        }
        if (file.isDirectory()) {
            this.recursionFileDir(file, plan);
        } else {
            this.loadFile(file, plan);
        }
    }

    private void recursionFileDir(File curFile, OperateFilePlan plan) throws QueryProcessException {
        File[] files;
        for (File file : files = curFile.listFiles()) {
            if (file.isDirectory()) {
                this.recursionFileDir(file, plan);
                continue;
            }
            this.loadFile(file, plan);
        }
    }

    private void loadFile(File file, OperateFilePlan plan) throws QueryProcessException {
        if (!file.getName().endsWith(".tsfile")) {
            return;
        }
        TsFileResource tsFileResource = new TsFileResource(file);
        tsFileResource.setClosed(true);
        try {
            RestorableTsFileIOWriter restorableTsFileIOWriter = new RestorableTsFileIOWriter(file);
            if (restorableTsFileIOWriter.hasCrashed()) {
                restorableTsFileIOWriter.close();
                throw new QueryProcessException(String.format("Cannot load file %s because the file has crashed.", file.getAbsolutePath()));
            }
            HashMap<Path, MeasurementSchema> schemaMap = new HashMap<Path, MeasurementSchema>();
            ArrayList<ChunkGroupMetadata> chunkGroupMetadataList = new ArrayList<ChunkGroupMetadata>();
            try (TsFileSequenceReader reader = new TsFileSequenceReader(file.getAbsolutePath(), false);){
                reader.selfCheck(schemaMap, chunkGroupMetadataList, false);
            }
            FileLoaderUtils.checkTsFileResource(tsFileResource);
            if (UpgradeUtils.isNeedUpgrade(tsFileResource)) {
                throw new QueryProcessException(String.format("Cannot load file %s because the file's version is old which needs to be upgraded.", file.getAbsolutePath()));
            }
            if (plan.isAutoCreateSchema()) {
                this.createSchemaAutomatically(chunkGroupMetadataList, schemaMap, plan.getSgLevel());
            }
            ArrayList<TsFileResource> splitResources = new ArrayList<TsFileResource>();
            if (tsFileResource.isSpanMultiTimePartitions()) {
                logger.info("try to split the tsFile={} du to it spans multi partitions", (Object)tsFileResource.getTsFile().getPath());
                TsFileRewriteTool.rewriteTsFile(tsFileResource, splitResources);
                logger.info("after split, the old tsFile was split to {} new tsFiles", (Object)splitResources.size());
            }
            if (splitResources.isEmpty()) {
                splitResources.add(tsFileResource);
            }
            for (TsFileResource resource : splitResources) {
                StorageEngine.getInstance().loadNewTsFile(resource);
            }
        }
        catch (Exception e) {
            throw new QueryProcessException(String.format("Cannot load file %s because %s", file.getAbsolutePath(), e.getMessage()));
        }
    }

    private void createSchemaAutomatically(List<ChunkGroupMetadata> chunkGroupMetadataList, Map<Path, MeasurementSchema> knownSchemas, int sgLevel) throws QueryProcessException, MetadataException {
        if (chunkGroupMetadataList.isEmpty()) {
            return;
        }
        HashSet<PartialPath> registeredSeries = new HashSet<PartialPath>();
        for (ChunkGroupMetadata chunkGroupMetadata : chunkGroupMetadataList) {
            String device = chunkGroupMetadata.getDevice();
            MNode node = IoTDB.metaManager.getDeviceNodeWithAutoCreate(new PartialPath(device), true, sgLevel);
            for (ChunkMetadata chunkMetadata : chunkGroupMetadata.getChunkMetadataList()) {
                PartialPath series = new PartialPath(chunkGroupMetadata.getDevice() + "." + chunkMetadata.getMeasurementUid());
                if (registeredSeries.contains(series)) continue;
                registeredSeries.add(series);
                MeasurementSchema schema = knownSchemas.get(new Path(series.getDevice(), series.getMeasurement()));
                if (schema == null) {
                    throw new MetadataException(String.format("Can not get the schema of measurement [%s]", chunkMetadata.getMeasurementUid()));
                }
                if (!node.hasChild(chunkMetadata.getMeasurementUid())) {
                    IoTDB.metaManager.createTimeseries(series, schema.getType(), schema.getEncodingType(), schema.getCompressor(), Collections.emptyMap());
                    continue;
                }
                if (node.getChild(chunkMetadata.getMeasurementUid()) instanceof MeasurementMNode) continue;
                throw new QueryProcessException(String.format("Current Path is not leaf node. %s", series));
            }
        }
    }

    private void operateRemoveFile(OperateFilePlan plan) throws QueryProcessException {
        try {
            if (!StorageEngine.getInstance().deleteTsfile(plan.getFile())) {
                throw new QueryProcessException(String.format("File %s doesn't exist.", plan.getFile().getName()));
            }
        }
        catch (StorageEngineException | IllegalPathException e) {
            throw new QueryProcessException(String.format("Cannot remove file because %s", e.getMessage()));
        }
    }

    private void operateMoveFile(OperateFilePlan plan) throws QueryProcessException {
        if (!plan.getTargetDir().exists() || !plan.getTargetDir().isDirectory()) {
            throw new QueryProcessException(String.format("Target dir %s is invalid.", plan.getTargetDir().getPath()));
        }
        try {
            if (!StorageEngine.getInstance().moveTsfile(plan.getFile(), plan.getTargetDir())) {
                throw new QueryProcessException(String.format("File %s doesn't exist.", plan.getFile().getName()));
            }
        }
        catch (StorageEngineException | IllegalPathException e) {
            throw new QueryProcessException(String.format("Cannot move file %s to target directory %s because %s", plan.getFile().getPath(), plan.getTargetDir().getPath(), e.getMessage()));
        }
    }

    private void operateTTL(SetTTLPlan plan) throws QueryProcessException {
        try {
            List<PartialPath> storageGroupPaths = IoTDB.metaManager.getStorageGroupPaths(plan.getStorageGroup());
            for (PartialPath storagePath : storageGroupPaths) {
                IoTDB.metaManager.setTTL(storagePath, plan.getDataTTL());
                StorageEngine.getInstance().setTTL(storagePath, plan.getDataTTL());
            }
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        catch (IOException e) {
            throw new QueryProcessException(e.getMessage());
        }
    }

    @Override
    public void update(PartialPath path, long startTime, long endTime, String value) {
        throw new UnsupportedOperationException("update is not supported now");
    }

    @Override
    public void delete(PartialPath path, long startTime, long endTime, long planIndex) throws QueryProcessException {
        try {
            StorageEngine.getInstance().delete(path, startTime, endTime, planIndex);
        }
        catch (StorageEngineException e) {
            throw new QueryProcessException(e);
        }
    }

    protected MNode getSeriesSchemas(InsertPlan insertPlan) throws MetadataException {
        return IoTDB.metaManager.getSeriesSchemasAndReadLockDevice(insertPlan);
    }

    private void checkFailedMeasurments(InsertPlan plan) throws PathNotExistException, StorageEngineException {
        List<String> failedPaths = plan.getFailedMeasurements();
        List<Exception> exceptions = plan.getFailedExceptions();
        boolean isPathNotExistException = true;
        Iterator<Exception> iterator = exceptions.iterator();
        while (iterator.hasNext()) {
            Exception e;
            Throwable curException = e = iterator.next();
            while (curException.getCause() != null) {
                curException = curException.getCause();
            }
            if (curException instanceof PathNotExistException) continue;
            isPathNotExistException = false;
            break;
        }
        if (isPathNotExistException) {
            throw new PathNotExistException(failedPaths);
        }
        throw new StorageEngineException(INSERT_MEASUREMENTS_FAILED_MESSAGE + plan.getFailedMeasurements() + (!exceptions.isEmpty() ? " caused by " + exceptions.get(0).getMessage() : ""));
    }

    @Override
    public void insert(InsertRowsOfOneDevicePlan insertRowsOfOneDevicePlan) throws QueryProcessException {
        if (insertRowsOfOneDevicePlan.getRowPlans().length == 0) {
            return;
        }
        try {
            for (InsertRowPlan plan : insertRowsOfOneDevicePlan.getRowPlans()) {
                plan.setMeasurementMNodes(new MeasurementMNode[plan.getMeasurements().length]);
                this.getSeriesSchemas(plan);
            }
            StorageEngine.getInstance().insert(insertRowsOfOneDevicePlan);
            ArrayList<String> notExistedPaths = null;
            ArrayList<String> failedMeasurements = null;
            Throwable exception = null;
            for (InsertRowPlan plan : insertRowsOfOneDevicePlan.getRowPlans()) {
                if (plan.getFailedMeasurements() == null) continue;
                if (notExistedPaths == null) {
                    notExistedPaths = new ArrayList<String>();
                    failedMeasurements = new ArrayList<String>();
                }
                List<String> failedPaths = plan.getFailedMeasurements();
                List<Exception> exceptions = plan.getFailedExceptions();
                boolean isPathNotExistException = true;
                for (Exception e : exceptions) {
                    exception = e;
                    Throwable curException = e;
                    while (curException.getCause() != null) {
                        curException = curException.getCause();
                    }
                    if (curException instanceof PathNotExistException) continue;
                    isPathNotExistException = false;
                    break;
                }
                if (isPathNotExistException) {
                    notExistedPaths.addAll(failedPaths);
                    continue;
                }
                failedMeasurements.addAll(plan.getFailedMeasurements());
            }
            if (notExistedPaths != null && !notExistedPaths.isEmpty()) {
                throw new PathNotExistException((List<String>)notExistedPaths);
            }
            if (notExistedPaths != null && !failedMeasurements.isEmpty()) {
                throw new StorageEngineException("failed to insert points " + failedMeasurements + (exception != null ? " caused by " + exception.getMessage() : ""));
            }
        }
        catch (StorageEngineException | MetadataException e) {
            throw new QueryProcessException(e);
        }
    }

    @Override
    public void insert(InsertRowsPlan plan) throws QueryProcessException {
        for (int i = 0; i < plan.getInsertRowPlanList().size(); ++i) {
            if (plan.getResults().containsKey(i) || plan.isExecuted(i)) continue;
            try {
                this.insert(plan.getInsertRowPlanList().get(i));
                continue;
            }
            catch (QueryProcessException e) {
                plan.getResults().put(i, RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
            }
        }
        if (!plan.getResults().isEmpty()) {
            throw new BatchProcessException(plan.getFailingStatus());
        }
    }

    @Override
    public void insert(InsertRowPlan insertRowPlan) throws QueryProcessException {
        try {
            insertRowPlan.setMeasurementMNodes(new MeasurementMNode[insertRowPlan.getMeasurements().length]);
            this.getSeriesSchemas(insertRowPlan);
            insertRowPlan.transferType();
            StorageEngine.getInstance().insert(insertRowPlan);
            if (insertRowPlan.getFailedMeasurements() != null) {
                this.checkFailedMeasurments(insertRowPlan);
            }
        }
        catch (StorageEngineException | MetadataException e) {
            if (IoTDBDescriptor.getInstance().getConfig().isEnableStatMonitor()) {
                StatMonitor.getInstance().updateFailedStatValue();
            }
            throw new QueryProcessException(e);
        }
        catch (Exception e) {
            if (IoTDBDescriptor.getInstance().getConfig().isEnableStatMonitor()) {
                StatMonitor.getInstance().updateFailedStatValue();
            }
            throw e;
        }
    }

    @Override
    public void insertTablet(InsertMultiTabletPlan insertMultiTabletPlan) throws QueryProcessException {
        for (int i = 0; i < insertMultiTabletPlan.getInsertTabletPlanList().size(); ++i) {
            if (insertMultiTabletPlan.getResults().containsKey(i) || insertMultiTabletPlan.isExecuted(i)) continue;
            this.insertTablet(insertMultiTabletPlan.getInsertTabletPlanList().get(i));
        }
    }

    @Override
    public void insertTablet(InsertTabletPlan insertTabletPlan) throws QueryProcessException {
        if (insertTabletPlan.getRowCount() == 0) {
            return;
        }
        try {
            insertTabletPlan.setMeasurementMNodes(new MeasurementMNode[insertTabletPlan.getMeasurements().length]);
            this.getSeriesSchemas(insertTabletPlan);
            StorageEngine.getInstance().insertTablet(insertTabletPlan);
            if (insertTabletPlan.getFailedMeasurements() != null) {
                this.checkFailedMeasurments(insertTabletPlan);
            }
        }
        catch (StorageEngineException | MetadataException e) {
            if (IoTDBDescriptor.getInstance().getConfig().isEnableStatMonitor()) {
                StatMonitor.getInstance().updateFailedStatValue();
            }
            throw new QueryProcessException(e);
        }
        catch (Exception e) {
            if (IoTDBDescriptor.getInstance().getConfig().isEnableStatMonitor()) {
                StatMonitor.getInstance().updateFailedStatValue();
            }
            throw e;
        }
    }

    private boolean operateAuthor(AuthorPlan author) throws QueryProcessException {
        AuthorOperator.AuthorType authorType = author.getAuthorType();
        String userName = author.getUserName();
        String roleName = author.getRoleName();
        String password = author.getPassword();
        String newPassword = author.getNewPassword();
        Set<Integer> permissions = author.getPermissions();
        PartialPath nodeName = author.getNodeName();
        try {
            switch (authorType) {
                case UPDATE_USER: {
                    this.authorizer.updateUserPassword(userName, newPassword);
                    break;
                }
                case CREATE_USER: {
                    this.authorizer.createUser(userName, password);
                    break;
                }
                case CREATE_ROLE: {
                    this.authorizer.createRole(roleName);
                    break;
                }
                case DROP_USER: {
                    this.authorizer.deleteUser(userName);
                    break;
                }
                case DROP_ROLE: {
                    this.authorizer.deleteRole(roleName);
                    break;
                }
                case GRANT_ROLE: {
                    for (int i : permissions) {
                        this.authorizer.grantPrivilegeToRole(roleName, nodeName.getFullPath(), i);
                    }
                    break;
                }
                case GRANT_USER: {
                    for (int i : permissions) {
                        this.authorizer.grantPrivilegeToUser(userName, nodeName.getFullPath(), i);
                    }
                    break;
                }
                case GRANT_ROLE_TO_USER: {
                    this.authorizer.grantRoleToUser(roleName, userName);
                    break;
                }
                case REVOKE_USER: {
                    for (int i : permissions) {
                        this.authorizer.revokePrivilegeFromUser(userName, nodeName.getFullPath(), i);
                    }
                    break;
                }
                case REVOKE_ROLE: {
                    for (int i : permissions) {
                        this.authorizer.revokePrivilegeFromRole(roleName, nodeName.getFullPath(), i);
                    }
                    break;
                }
                case REVOKE_ROLE_FROM_USER: {
                    this.authorizer.revokeRoleFromUser(roleName, userName);
                    break;
                }
                default: {
                    throw new QueryProcessException("Unsupported operation " + (Object)((Object)authorType));
                }
            }
        }
        catch (AuthException e) {
            throw new QueryProcessException(e.getMessage(), true);
        }
        return true;
    }

    private boolean operateWatermarkEmbedding(List<String> users, boolean useWatermark) throws QueryProcessException {
        try {
            for (String user : users) {
                this.authorizer.setUserUseWaterMark(user, useWatermark);
            }
        }
        catch (AuthException e) {
            throw new QueryProcessException(e.getMessage());
        }
        return true;
    }

    private boolean createTimeSeries(CreateTimeSeriesPlan createTimeSeriesPlan) throws QueryProcessException {
        try {
            IoTDB.metaManager.createTimeseries(createTimeSeriesPlan);
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        return true;
    }

    private boolean createMultiTimeSeries(CreateMultiTimeSeriesPlan multiPlan) throws BatchProcessException {
        for (int i = 0; i < multiPlan.getPaths().size(); ++i) {
            if (multiPlan.getResults().containsKey(i) || multiPlan.isExecuted(i)) continue;
            CreateTimeSeriesPlan plan = new CreateTimeSeriesPlan(multiPlan.getPaths().get(i), multiPlan.getDataTypes().get(i), multiPlan.getEncodings().get(i), multiPlan.getCompressors().get(i), multiPlan.getProps() == null ? null : multiPlan.getProps().get(i), multiPlan.getTags() == null ? null : multiPlan.getTags().get(i), multiPlan.getAttributes() == null ? null : multiPlan.getAttributes().get(i), multiPlan.getAlias() == null ? null : multiPlan.getAlias().get(i));
            try {
                this.createTimeSeries(plan);
                continue;
            }
            catch (QueryProcessException e) {
                multiPlan.getResults().put(i, RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
            }
        }
        if (!multiPlan.getResults().isEmpty()) {
            throw new BatchProcessException(multiPlan.getFailingStatus());
        }
        return true;
    }

    protected boolean deleteTimeSeries(DeleteTimeSeriesPlan deleteTimeSeriesPlan) throws QueryProcessException {
        List<PartialPath> deletePathList = deleteTimeSeriesPlan.getPaths();
        for (int i = 0; i < deletePathList.size(); ++i) {
            PartialPath path = deletePathList.get(i);
            try {
                StorageEngine.getInstance().deleteTimeseries(path, deleteTimeSeriesPlan.getIndex());
                String failed = IoTDB.metaManager.deleteTimeseries(path);
                if (failed == null) continue;
                deleteTimeSeriesPlan.getResults().put(i, RpcUtils.getStatus((TSStatusCode)TSStatusCode.NODE_DELETE_FAILED_ERROR, (String)failed));
                continue;
            }
            catch (StorageEngineException | MetadataException e) {
                deleteTimeSeriesPlan.getResults().put(i, RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
            }
        }
        if (!deleteTimeSeriesPlan.getResults().isEmpty()) {
            throw new BatchProcessException(deleteTimeSeriesPlan.getFailingStatus());
        }
        return true;
    }

    private boolean alterTimeSeries(AlterTimeSeriesPlan alterTimeSeriesPlan) throws QueryProcessException {
        PartialPath path = alterTimeSeriesPlan.getPath();
        Map<String, String> alterMap = alterTimeSeriesPlan.getAlterMap();
        try {
            switch (alterTimeSeriesPlan.getAlterType()) {
                case RENAME: {
                    String beforeName = alterMap.keySet().iterator().next();
                    String currentName = alterMap.get(beforeName);
                    IoTDB.metaManager.renameTagOrAttributeKey(beforeName, currentName, path);
                    break;
                }
                case SET: {
                    IoTDB.metaManager.setTagsOrAttributesValue(alterMap, path);
                    break;
                }
                case DROP: {
                    IoTDB.metaManager.dropTagsOrAttributes(alterMap.keySet(), path);
                    break;
                }
                case ADD_TAGS: {
                    IoTDB.metaManager.addTags(alterMap, path);
                    break;
                }
                case ADD_ATTRIBUTES: {
                    IoTDB.metaManager.addAttributes(alterMap, path);
                    break;
                }
                case UPSERT: {
                    IoTDB.metaManager.upsertTagsAndAttributes(alterTimeSeriesPlan.getAlias(), alterTimeSeriesPlan.getTagsMap(), alterTimeSeriesPlan.getAttributesMap(), path);
                }
            }
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        catch (IOException e) {
            throw new QueryProcessException(String.format("Something went wrong while read/write the [%s]'s tag/attribute info.", path.getFullPath()));
        }
        return true;
    }

    public boolean setStorageGroup(SetStorageGroupPlan setStorageGroupPlan) throws QueryProcessException {
        PartialPath path = setStorageGroupPlan.getPath();
        try {
            IoTDB.metaManager.setStorageGroup(path);
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        return true;
    }

    protected boolean deleteStorageGroups(DeleteStorageGroupPlan deleteStorageGroupPlan) throws QueryProcessException {
        ArrayList<PartialPath> deletePathList = new ArrayList<PartialPath>();
        try {
            for (PartialPath storageGroupPath : deleteStorageGroupPlan.getPaths()) {
                List<PartialPath> allRelatedStorageGroupPath = IoTDB.metaManager.getStorageGroupPaths(storageGroupPath);
                if (allRelatedStorageGroupPath.isEmpty()) {
                    throw new PathNotExistException(storageGroupPath.getFullPath(), true);
                }
                for (PartialPath path : allRelatedStorageGroupPath) {
                    StorageEngine.getInstance().deleteStorageGroup(path);
                    deletePathList.add(path);
                }
            }
            IoTDB.metaManager.deleteStorageGroups(deletePathList);
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        return true;
    }

    protected QueryDataSet processAuthorQuery(AuthorPlan plan) throws QueryProcessException {
        ListDataSet dataSet;
        AuthorOperator.AuthorType authorType = plan.getAuthorType();
        String userName = plan.getUserName();
        String roleName = plan.getRoleName();
        PartialPath path = plan.getNodeName();
        try {
            switch (authorType) {
                case LIST_ROLE: {
                    dataSet = this.executeListRole(plan);
                    break;
                }
                case LIST_USER: {
                    dataSet = this.executeListUser(plan);
                    break;
                }
                case LIST_ROLE_USERS: {
                    dataSet = this.executeListRoleUsers(roleName);
                    break;
                }
                case LIST_USER_ROLES: {
                    dataSet = this.executeListUserRoles(userName);
                    break;
                }
                case LIST_ROLE_PRIVILEGE: {
                    dataSet = this.executeListRolePrivileges(roleName, path);
                    break;
                }
                case LIST_USER_PRIVILEGE: {
                    dataSet = this.executeListUserPrivileges(userName, path);
                    break;
                }
                default: {
                    throw new QueryProcessException("Unsupported operation " + (Object)((Object)authorType));
                }
            }
        }
        catch (AuthException e) {
            throw new QueryProcessException(e.getMessage());
        }
        return dataSet;
    }

    private ListDataSet executeListRole(AuthorPlan plan) throws AuthException {
        ListDataSet dataSet = new ListDataSet(Collections.singletonList(new PartialPath("role", false)), Collections.singletonList(TSDataType.TEXT));
        boolean hasListRolePrivilege = AuthorityChecker.check(plan.getLoginUserName(), Collections.emptyList(), plan.getOperatorType(), plan.getLoginUserName());
        if (!hasListRolePrivilege) {
            return dataSet;
        }
        List<String> roleList = this.authorizer.listAllRoles();
        this.addToDataSet(roleList, dataSet);
        return dataSet;
    }

    private void addToDataSet(List<String> strResults, ListDataSet dataSet) {
        int index = 0;
        for (String role : strResults) {
            RowRecord record = new RowRecord((long)index++);
            Field field = new Field(TSDataType.TEXT);
            field.setBinaryV(new Binary(role));
            record.addField(field);
            dataSet.putRecord(record);
        }
    }

    private ListDataSet executeListUser(AuthorPlan plan) throws AuthException {
        ListDataSet dataSet = new ListDataSet(Collections.singletonList(new PartialPath("user", false)), Collections.singletonList(TSDataType.TEXT));
        boolean hasListUserPrivilege = AuthorityChecker.check(plan.getLoginUserName(), Collections.singletonList(plan.getNodeName()), plan.getOperatorType(), plan.getLoginUserName());
        if (!hasListUserPrivilege) {
            return dataSet;
        }
        List<String> userList = this.authorizer.listAllUsers();
        this.addToDataSet(userList, dataSet);
        return dataSet;
    }

    private ListDataSet executeListRoleUsers(String roleName) throws AuthException {
        Role role = this.authorizer.getRole(roleName);
        if (role == null) {
            throw new AuthException("No such role : " + roleName);
        }
        ListDataSet dataSet = new ListDataSet(Collections.singletonList(new PartialPath("user", false)), Collections.singletonList(TSDataType.TEXT));
        List<String> userList = this.authorizer.listAllUsers();
        int index = 0;
        for (String userN : userList) {
            User userObj = this.authorizer.getUser(userN);
            if (userObj == null || !userObj.hasRole(roleName)) continue;
            RowRecord record = new RowRecord((long)index++);
            Field field = new Field(TSDataType.TEXT);
            field.setBinaryV(new Binary(userN));
            record.addField(field);
            dataSet.putRecord(record);
        }
        return dataSet;
    }

    private ListDataSet executeListUserRoles(String userName) throws AuthException {
        User user = this.authorizer.getUser(userName);
        if (user != null) {
            ListDataSet dataSet = new ListDataSet(Collections.singletonList(new PartialPath("role", false)), Collections.singletonList(TSDataType.TEXT));
            int index = 0;
            for (String roleN : user.getRoleList()) {
                RowRecord record = new RowRecord((long)index++);
                Field field = new Field(TSDataType.TEXT);
                field.setBinaryV(new Binary(roleN));
                record.addField(field);
                dataSet.putRecord(record);
            }
            return dataSet;
        }
        throw new AuthException("No such user : " + userName);
    }

    private ListDataSet executeListRolePrivileges(String roleName, PartialPath path) throws AuthException {
        Role role = this.authorizer.getRole(roleName);
        if (role != null) {
            ArrayList<PartialPath> headerList = new ArrayList<PartialPath>();
            ArrayList<TSDataType> typeList = new ArrayList<TSDataType>();
            headerList.add(new PartialPath("privilege", false));
            typeList.add(TSDataType.TEXT);
            ListDataSet dataSet = new ListDataSet(headerList, typeList);
            int index = 0;
            for (PathPrivilege pathPrivilege : role.getPrivilegeList()) {
                if (path != null && !AuthUtils.pathBelongsTo(path.getFullPath(), pathPrivilege.getPath())) continue;
                RowRecord record = new RowRecord((long)index++);
                Field field = new Field(TSDataType.TEXT);
                field.setBinaryV(new Binary(pathPrivilege.toString()));
                record.addField(field);
                dataSet.putRecord(record);
            }
            return dataSet;
        }
        throw new AuthException("No such role : " + roleName);
    }

    private ListDataSet executeListUserPrivileges(String userName, PartialPath path) throws AuthException {
        User user = this.authorizer.getUser(userName);
        if (user == null) {
            throw new AuthException("No such user : " + userName);
        }
        ArrayList<PartialPath> headerList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> typeList = new ArrayList<TSDataType>();
        headerList.add(new PartialPath("role", false));
        headerList.add(new PartialPath("privilege", false));
        typeList.add(TSDataType.TEXT);
        typeList.add(TSDataType.TEXT);
        ListDataSet dataSet = new ListDataSet(headerList, typeList);
        int index = 0;
        for (PathPrivilege pathPrivilege : user.getPrivilegeList()) {
            if (path != null && !AuthUtils.pathBelongsTo(path.getFullPath(), pathPrivilege.getPath())) continue;
            RowRecord record = new RowRecord((long)index++);
            Field roleF = new Field(TSDataType.TEXT);
            roleF.setBinaryV(new Binary(""));
            record.addField(roleF);
            Field privilegeF = new Field(TSDataType.TEXT);
            privilegeF.setBinaryV(new Binary(pathPrivilege.toString()));
            record.addField(privilegeF);
            dataSet.putRecord(record);
        }
        for (String roleN : user.getRoleList()) {
            Role role = this.authorizer.getRole(roleN);
            if (role == null) continue;
            for (PathPrivilege pathPrivilege : role.getPrivilegeList()) {
                if (path != null && !AuthUtils.pathBelongsTo(path.getFullPath(), pathPrivilege.getPath())) continue;
                RowRecord record = new RowRecord((long)index++);
                Field roleF = new Field(TSDataType.TEXT);
                roleF.setBinaryV(new Binary(roleN));
                record.addField(roleF);
                Field privilegeF = new Field(TSDataType.TEXT);
                privilegeF.setBinaryV(new Binary(pathPrivilege.toString()));
                record.addField(privilegeF);
                dataSet.putRecord(record);
            }
        }
        return dataSet;
    }

    protected String deleteTimeSeries(PartialPath path) throws MetadataException {
        return IoTDB.metaManager.deleteTimeseries(path);
    }

    protected void loadConfiguration(LoadConfigurationPlan plan) throws QueryProcessException {
        IoTDBDescriptor.getInstance().loadHotModifiedProps();
    }

    private QueryDataSet processShowMergeStatus() {
        Map<String, List<MergeManager.TaskStatus>>[] taskStatus;
        ArrayList<PartialPath> headerList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> typeList = new ArrayList<TSDataType>();
        headerList.add(new PartialPath("storage group", false));
        headerList.add(new PartialPath("task name", false));
        headerList.add(new PartialPath("created time", false));
        headerList.add(new PartialPath("progress", false));
        headerList.add(new PartialPath("cancelled", false));
        headerList.add(new PartialPath("done", false));
        typeList.add(TSDataType.TEXT);
        typeList.add(TSDataType.TEXT);
        typeList.add(TSDataType.TEXT);
        typeList.add(TSDataType.TEXT);
        typeList.add(TSDataType.BOOLEAN);
        typeList.add(TSDataType.BOOLEAN);
        ListDataSet dataSet = new ListDataSet(headerList, typeList);
        for (Map<String, List<MergeManager.TaskStatus>> statusMap : taskStatus = MergeManager.getINSTANCE().collectTaskStatus()) {
            for (Map.Entry<String, List<MergeManager.TaskStatus>> stringListEntry : statusMap.entrySet()) {
                for (MergeManager.TaskStatus status : stringListEntry.getValue()) {
                    dataSet.putRecord(this.toRowRecord(status, stringListEntry.getKey()));
                }
            }
        }
        return dataSet;
    }

    public RowRecord toRowRecord(MergeManager.TaskStatus status, String storageGroup) {
        RowRecord record = new RowRecord(0L);
        record.addField((Object)new Binary(storageGroup), TSDataType.TEXT);
        record.addField((Object)new Binary(status.getTaskName()), TSDataType.TEXT);
        record.addField((Object)new Binary(status.getCreatedTime()), TSDataType.TEXT);
        record.addField((Object)new Binary(status.getProgress()), TSDataType.TEXT);
        record.addField((Object)status.isCancelled(), TSDataType.BOOLEAN);
        record.addField((Object)status.isDone(), TSDataType.BOOLEAN);
        return record;
    }

    private QueryDataSet processShowQueryProcesslist() {
        ListDataSet listDataSet = new ListDataSet(Arrays.asList(new PartialPath("queryId", false), new PartialPath("statement", false)), Arrays.asList(TSDataType.INT64, TSDataType.TEXT));
        QueryTimeManager queryTimeManager = QueryTimeManager.getInstance();
        for (Map.Entry<Long, QueryTimeManager.QueryInfo> queryInfo : queryTimeManager.getQueryInfoMap().entrySet()) {
            RowRecord record = new RowRecord(queryInfo.getValue().getStartTime());
            record.addField((Object)queryInfo.getKey(), TSDataType.INT64);
            record.addField((Object)new Binary(queryInfo.getValue().getStatement()), TSDataType.TEXT);
            listDataSet.putRecord(record);
        }
        return listDataSet;
    }

    List<PartialPath> checkStorageGroupExist(List<PartialPath> storageGroups) {
        ArrayList<PartialPath> noExistSg = new ArrayList<PartialPath>();
        if (storageGroups == null) {
            return noExistSg;
        }
        for (PartialPath storageGroup : storageGroups) {
            if (IoTDB.metaManager.isStorageGroup(storageGroup)) continue;
            noExistSg.add(storageGroup);
        }
        return noExistSg;
    }
}

