/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupProcessor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.AliasAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.DataTypeMismatchException;
import org.apache.iotdb.db.exception.metadata.DeleteFailedException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.metadata.PathAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.StorageGroupAlreadySetException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.metadata.MTree;
import org.apache.iotdb.db.metadata.MetaUtils;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.metadata.TagLogFile;
import org.apache.iotdb.db.metadata.logfile.MLogReader;
import org.apache.iotdb.db.metadata.logfile.MLogWriter;
import org.apache.iotdb.db.metadata.mnode.MNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.StorageGroupMNode;
import org.apache.iotdb.db.monitor.MonitorConstants;
import org.apache.iotdb.db.qp.constant.SQLConstant;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.qp.physical.sys.ChangeAliasPlan;
import org.apache.iotdb.db.qp.physical.sys.ChangeTagOffsetPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTTLPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowDevicesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTimeSeriesPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.ShowDevicesResult;
import org.apache.iotdb.db.query.dataset.ShowTimeSeriesResult;
import org.apache.iotdb.db.rescon.MemTableManager;
import org.apache.iotdb.db.rescon.PrimitiveArrayManager;
import org.apache.iotdb.db.utils.EncodingInferenceUtils;
import org.apache.iotdb.db.utils.RandomDeleteCache;
import org.apache.iotdb.db.utils.SchemaUtils;
import org.apache.iotdb.db.utils.TypeInferenceUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.cache.CacheException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.TimeseriesSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MManager {
    public static final String TIME_SERIES_TREE_HEADER = "===  Timeseries Tree  ===\n\n";
    private static final String TAG_FORMAT = "tag key is %s, tag value is %s, tlog offset is %d";
    private static final String DEBUG_MSG = "%s : TimeSeries %s is removed from tag inverted index, ";
    private static final String DEBUG_MSG_1 = "%s: TimeSeries %s's tag info has been removed from tag inverted index ";
    private static final String PREVIOUS_CONDITION = "before deleting it, tag key is %s, tag value is %s, tlog offset is %d, contains key %b";
    private static final int UPDATE_SCHEMA_MAP_IN_ARRAYPOOL_THRESHOLD = 5000;
    private static final Logger logger = LoggerFactory.getLogger(MManager.class);
    private static final long MTREE_SNAPSHOT_THREAD_CHECK_TIME = 600L;
    private final int mtreeSnapshotInterval;
    private final long mtreeSnapshotThresholdTime;
    private String logFilePath;
    private String mtreeSnapshotPath;
    private String mtreeSnapshotTmpPath;
    private MTree mtree;
    private MLogWriter logWriter;
    private TagLogFile tagLogFile;
    private boolean isRecovering;
    private RandomDeleteCache<PartialPath, MNode> mNodeCache;
    private Map<String, Map<String, Set<MeasurementMNode>>> tagIndex = new ConcurrentHashMap<String, Map<String, Set<MeasurementMNode>>>();
    private Map<TSDataType, Integer> schemaDataTypeNumMap = new ConcurrentHashMap<TSDataType, Integer>();
    private long reportedDataTypeTotalNum;
    private AtomicLong totalSeriesNumber = new AtomicLong();
    private boolean initialized;
    protected static IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private File logFile;
    private ScheduledExecutorService timedCreateMTreeSnapshotThread;
    private ScheduledExecutorService timedForceMLogThread;
    private static final long MTREE_SIZE_THRESHOLD = config.getAllocateMemoryForSchema();
    private boolean allowToCreateNewSeries = true;
    private static final int ESTIMATED_SERIES_SIZE = config.getEstimatedSeriesSize();

    protected MManager() {
        this.mtreeSnapshotInterval = config.getMtreeSnapshotInterval();
        this.mtreeSnapshotThresholdTime = (long)config.getMtreeSnapshotThresholdTime() * 1000L;
        String schemaDir = config.getSchemaDir();
        File schemaFolder = SystemFileFactory.INSTANCE.getFile(schemaDir);
        if (!schemaFolder.exists()) {
            if (schemaFolder.mkdirs()) {
                logger.info("create system folder {}", (Object)schemaFolder.getAbsolutePath());
            } else {
                logger.info("create system folder {} failed.", (Object)schemaFolder.getAbsolutePath());
            }
        }
        this.logFilePath = schemaDir + File.separator + "mlog.bin";
        this.mtreeSnapshotPath = schemaDir + File.separator + "mtree-1.snapshot.bin";
        this.mtreeSnapshotTmpPath = schemaDir + File.separator + "mtree-1.snapshot.bin.tmp";
        this.isRecovering = true;
        int cacheSize = config.getmManagerCacheSize();
        this.mNodeCache = new RandomDeleteCache<PartialPath, MNode>(cacheSize){

            @Override
            public MNode loadObjectByKey(PartialPath key) throws CacheException {
                try {
                    return MManager.this.mtree.getNodeByPathWithStorageGroupCheck(key);
                }
                catch (MetadataException e) {
                    throw new CacheException((Throwable)e);
                }
            }
        };
        if (config.isEnableMTreeSnapshot()) {
            this.timedCreateMTreeSnapshotThread = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "timedCreateMTreeSnapshotThread"));
            this.timedCreateMTreeSnapshotThread.scheduleAtFixedRate(this::checkMTreeModified, 600L, 600L, TimeUnit.SECONDS);
        }
    }

    public static MManager getInstance() {
        return MManagerHolder.INSTANCE;
    }

    public synchronized void init() {
        if (this.initialized) {
            return;
        }
        this.logFile = SystemFileFactory.INSTANCE.getFile(this.logFilePath);
        try {
            this.tagLogFile = new TagLogFile(config.getSchemaDir(), "tlog.txt");
            this.isRecovering = true;
            int lineNumber = this.initFromLog(this.logFile);
            this.logWriter = new MLogWriter(config.getSchemaDir(), "mlog.bin");
            this.logWriter.setLogNum(lineNumber);
            this.isRecovering = false;
        }
        catch (IOException e) {
            logger.error("Cannot recover all MTree from file, we try to recover as possible as we can", (Throwable)e);
        }
        this.reportedDataTypeTotalNum = 0L;
        this.initialized = true;
    }

    private int initFromLog(File logFile) throws IOException {
        File tmpFile = SystemFileFactory.INSTANCE.getFile(this.mtreeSnapshotTmpPath);
        if (tmpFile.exists()) {
            logger.warn("Creating MTree snapshot not successful before crashing...");
            Files.delete(tmpFile.toPath());
        }
        File mtreeSnapshot = SystemFileFactory.INSTANCE.getFile(this.mtreeSnapshotPath);
        long time = System.currentTimeMillis();
        if (!mtreeSnapshot.exists()) {
            this.mtree = new MTree();
        } else {
            this.mtree = MTree.deserializeFrom(mtreeSnapshot);
            logger.debug("spend {} ms to deserialize mtree from snapshot", (Object)(System.currentTimeMillis() - time));
        }
        time = System.currentTimeMillis();
        if (logFile.exists()) {
            int idx = 0;
            MLogReader mLogReader = new MLogReader(config.getSchemaDir(), "mlog.bin");
            try {
                idx = this.applyMlog(mLogReader);
                logger.debug("spend {} ms to deserialize mtree from mlog.bin", (Object)(System.currentTimeMillis() - time));
                int n = idx;
                mLogReader.close();
                return n;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        mLogReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException("Failed to parser mlog.bin for err:" + e);
                }
            }
        }
        return 0;
    }

    private int applyMlog(MLogReader mLogReader) {
        int idx = 0;
        while (mLogReader.hasNext()) {
            PhysicalPlan plan = null;
            try {
                plan = mLogReader.next();
                if (plan == null) continue;
                this.operation(plan);
                ++idx;
            }
            catch (Exception e) {
                logger.error("Can not operate cmd {} for err:", plan == null ? "" : plan.getOperatorType(), (Object)e);
            }
        }
        return idx;
    }

    public void clear() {
        try {
            this.mtree = new MTree();
            this.mNodeCache.clear();
            this.tagIndex.clear();
            this.totalSeriesNumber.set(0L);
            if (this.logWriter != null) {
                this.logWriter.close();
                this.logWriter = null;
            }
            if (this.tagLogFile != null) {
                this.tagLogFile.close();
                this.tagLogFile = null;
            }
            this.schemaDataTypeNumMap.clear();
            this.reportedDataTypeTotalNum = 0L;
            this.initialized = false;
            if (config.isEnableMTreeSnapshot() && this.timedCreateMTreeSnapshotThread != null) {
                this.timedCreateMTreeSnapshotThread.shutdownNow();
                this.timedCreateMTreeSnapshotThread = null;
            }
            if (this.timedForceMLogThread != null) {
                this.timedForceMLogThread.shutdownNow();
                this.timedForceMLogThread = null;
            }
        }
        catch (IOException e) {
            logger.error("Cannot close metadata log writer, because:", (Throwable)e);
        }
    }

    public void operation(PhysicalPlan plan) throws IOException, MetadataException {
        switch (plan.getOperatorType()) {
            case CREATE_TIMESERIES: {
                CreateTimeSeriesPlan createTimeSeriesPlan = (CreateTimeSeriesPlan)plan;
                this.createTimeseries(createTimeSeriesPlan, createTimeSeriesPlan.getTagOffset());
                break;
            }
            case DELETE_TIMESERIES: {
                DeleteTimeSeriesPlan deleteTimeSeriesPlan = (DeleteTimeSeriesPlan)plan;
                this.deleteTimeseries(deleteTimeSeriesPlan.getPaths().get(0));
                break;
            }
            case SET_STORAGE_GROUP: {
                SetStorageGroupPlan setStorageGroupPlan = (SetStorageGroupPlan)plan;
                this.setStorageGroup(setStorageGroupPlan.getPath());
                break;
            }
            case DELETE_STORAGE_GROUP: {
                DeleteStorageGroupPlan deleteStorageGroupPlan = (DeleteStorageGroupPlan)plan;
                this.deleteStorageGroups(deleteStorageGroupPlan.getPaths());
                break;
            }
            case TTL: {
                SetTTLPlan setTTLPlan = (SetTTLPlan)plan;
                this.setTTL(setTTLPlan.getStorageGroup(), setTTLPlan.getDataTTL());
                break;
            }
            case CHANGE_ALIAS: {
                ChangeAliasPlan changeAliasPlan = (ChangeAliasPlan)plan;
                this.changeAlias(changeAliasPlan.getPath(), changeAliasPlan.getAlias());
                break;
            }
            case CHANGE_TAG_OFFSET: {
                ChangeTagOffsetPlan changeTagOffsetPlan = (ChangeTagOffsetPlan)plan;
                this.changeOffset(changeTagOffsetPlan.getPath(), changeTagOffsetPlan.getOffset());
                break;
            }
            default: {
                logger.error("Unrecognizable command {}", (Object)plan.getOperatorType());
            }
        }
    }

    public void createTimeseries(CreateTimeSeriesPlan plan) throws MetadataException {
        this.createTimeseries(plan, -1L);
    }

    private void ensureStorageGroup(PartialPath path) throws MetadataException {
        try {
            this.mtree.getStorageGroupPath(path);
        }
        catch (StorageGroupNotSetException e) {
            if (!config.isAutoCreateSchemaEnabled()) {
                throw e;
            }
            PartialPath storageGroupPath = MetaUtils.getStorageGroupPathByLevel(path, config.getDefaultStorageGroupLevel());
            this.setStorageGroup(storageGroupPath);
        }
    }

    public void createTimeseries(CreateTimeSeriesPlan plan, long offset) throws MetadataException {
        if (!this.allowToCreateNewSeries) {
            throw new MetadataException("IoTDB system load is too large to create timeseries, please increase MAX_HEAP_SIZE in iotdb-env.sh/bat and restart");
        }
        try {
            PartialPath path = plan.getPath();
            SchemaUtils.checkDataTypeWithEncoding(plan.getDataType(), plan.getEncoding());
            this.ensureStorageGroup(path);
            TSDataType type = plan.getDataType();
            MeasurementMNode leafMNode = this.mtree.createTimeseries(path, type, plan.getEncoding(), plan.getCompressor(), plan.getProps(), plan.getAlias());
            if (plan.getTags() != null) {
                for (Map.Entry<String, String> entry : plan.getTags().entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null) continue;
                    this.tagIndex.computeIfAbsent(entry.getKey(), k -> new ConcurrentHashMap()).computeIfAbsent(entry.getValue(), v -> new CopyOnWriteArraySet()).add(leafMNode);
                }
            }
            this.totalSeriesNumber.addAndGet(1L);
            if (this.totalSeriesNumber.get() * (long)ESTIMATED_SERIES_SIZE >= MTREE_SIZE_THRESHOLD) {
                logger.warn("Current series number {} is too large...", (Object)this.totalSeriesNumber);
                this.allowToCreateNewSeries = false;
            }
            this.updateSchemaDataTypeNumMap(type, 1);
            if (!this.isRecovering) {
                if (plan.getTags() != null && !plan.getTags().isEmpty() || plan.getAttributes() != null && !plan.getAttributes().isEmpty()) {
                    offset = this.tagLogFile.write(plan.getTags(), plan.getAttributes());
                }
                plan.setTagOffset(offset);
                this.logWriter.createTimeseries(plan);
            }
            leafMNode.setOffset(offset);
        }
        catch (IOException e) {
            throw new MetadataException(e);
        }
    }

    public void createTimeseries(PartialPath path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props) throws MetadataException {
        block2: {
            try {
                this.createTimeseries(new CreateTimeSeriesPlan(path, dataType, encoding, compressor, props, null, null, null));
            }
            catch (AliasAlreadyExistException | PathAlreadyExistException e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Ignore PathAlreadyExistException and AliasAlreadyExistException when Concurrent inserting a non-exist time series {}", (Object)path);
            }
        }
    }

    public String deleteTimeseries(PartialPath prefixPath) throws MetadataException {
        if (this.isStorageGroup(prefixPath)) {
            this.mNodeCache.clear();
        }
        try {
            List<PartialPath> allTimeseries = this.mtree.getAllTimeseriesPath(prefixPath);
            if (allTimeseries.isEmpty()) {
                throw new PathNotExistException(prefixPath.getFullPath());
            }
            allTimeseries.removeIf(p -> p.startsWith(MonitorConstants.STAT_STORAGE_GROUP_ARRAY));
            HashSet<String> failedNames = new HashSet<String>();
            for (PartialPath p2 : allTimeseries) {
                this.deleteSingleTimeseriesInternal(p2, failedNames);
            }
            return failedNames.isEmpty() ? null : String.join((CharSequence)",", failedNames);
        }
        catch (IOException e) {
            throw new MetadataException(e.getMessage());
        }
    }

    private void deleteSingleTimeseriesInternal(PartialPath p, Set<String> failedNames) throws MetadataException, IOException {
        DeleteTimeSeriesPlan deleteTimeSeriesPlan = new DeleteTimeSeriesPlan();
        try {
            PartialPath emptyStorageGroup = this.deleteOneTimeseriesAndUpdateStatistics(p);
            if (!this.isRecovering) {
                if (emptyStorageGroup != null) {
                    StorageEngine.getInstance().deleteAllDataFilesInOneStorageGroup(emptyStorageGroup);
                    StorageEngine.getInstance().releaseWalDirectByteBufferPoolInOneStorageGroup(emptyStorageGroup);
                }
                deleteTimeSeriesPlan.setDeletePathList(Collections.singletonList(p));
                this.logWriter.deleteTimeseries(deleteTimeSeriesPlan);
            }
        }
        catch (DeleteFailedException e) {
            failedNames.add(e.getName());
        }
    }

    private void removeFromTagInvertedIndex(MeasurementMNode node) throws IOException {
        if (node.getOffset() < 0L) {
            return;
        }
        Map<String, String> tagMap = this.tagLogFile.readTag(config.getTagAttributeTotalSize(), node.getOffset());
        if (tagMap != null) {
            for (Map.Entry<String, String> entry : tagMap.entrySet()) {
                if (this.tagIndex.containsKey(entry.getKey()) && this.tagIndex.get(entry.getKey()).containsKey(entry.getValue())) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format(String.format(DEBUG_MSG, "Deletetag key is %s, tag value is %s, tlog offset is %d", node.getFullPath()), entry.getKey(), entry.getValue(), node.getOffset()));
                    }
                    this.tagIndex.get(entry.getKey()).get(entry.getValue()).remove(node);
                    if (!this.tagIndex.get(entry.getKey()).get(entry.getValue()).isEmpty()) continue;
                    this.tagIndex.get(entry.getKey()).remove(entry.getValue());
                    if (!this.tagIndex.get(entry.getKey()).isEmpty()) continue;
                    this.tagIndex.remove(entry.getKey());
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug(String.format(String.format(DEBUG_MSG_1, "Deletebefore deleting it, tag key is %s, tag value is %s, tlog offset is %d, contains key %b", node.getFullPath()), entry.getKey(), entry.getValue(), node.getOffset(), this.tagIndex.containsKey(entry.getKey())));
            }
        }
    }

    private PartialPath deleteOneTimeseriesAndUpdateStatistics(PartialPath path) throws MetadataException, IOException {
        Pair<PartialPath, MeasurementMNode> pair = this.mtree.deleteTimeseriesAndReturnEmptyStorageGroup(path);
        this.removeFromTagInvertedIndex((MeasurementMNode)pair.right);
        PartialPath storageGroupPath = (PartialPath)pair.left;
        this.updateSchemaDataTypeNumMap(((MeasurementMNode)pair.right).getSchema().getType(), -1);
        this.mNodeCache.clear();
        this.totalSeriesNumber.addAndGet(-1L);
        if (!this.allowToCreateNewSeries && this.totalSeriesNumber.get() * (long)ESTIMATED_SERIES_SIZE < MTREE_SIZE_THRESHOLD) {
            logger.info("Current series number {} come back to normal level", (Object)this.totalSeriesNumber);
            this.allowToCreateNewSeries = true;
        }
        return storageGroupPath;
    }

    public void setStorageGroup(PartialPath storageGroup) throws MetadataException {
        try {
            this.mtree.setStorageGroup(storageGroup);
            if (!config.isEnableMemControl()) {
                MemTableManager.getInstance().addOrDeleteStorageGroup(1);
            }
            if (!this.isRecovering) {
                this.logWriter.setStorageGroup(storageGroup);
            }
        }
        catch (IOException e) {
            throw new MetadataException(e.getMessage());
        }
    }

    public void deleteStorageGroups(List<PartialPath> storageGroups) throws MetadataException {
        try {
            for (PartialPath storageGroup : storageGroups) {
                this.totalSeriesNumber.addAndGet(-this.mtree.getAllTimeseriesCount(storageGroup));
                if (!this.allowToCreateNewSeries && this.totalSeriesNumber.get() * (long)ESTIMATED_SERIES_SIZE < MTREE_SIZE_THRESHOLD) {
                    logger.info("Current series number {} come back to normal level", (Object)this.totalSeriesNumber);
                    this.allowToCreateNewSeries = true;
                }
                this.mNodeCache.clear();
                List<MeasurementMNode> leafMNodes = this.mtree.deleteStorageGroup(storageGroup);
                for (MeasurementMNode leafMNode : leafMNodes) {
                    this.removeFromTagInvertedIndex(leafMNode);
                    this.updateSchemaDataTypeNumMap(leafMNode.getSchema().getType(), -1);
                }
                if (!config.isEnableMemControl()) {
                    MemTableManager.getInstance().addOrDeleteStorageGroup(-1);
                }
                if (this.isRecovering) continue;
                this.logWriter.deleteStorageGroup(storageGroup);
            }
        }
        catch (IOException e) {
            throw new MetadataException(e.getMessage());
        }
    }

    private synchronized void updateSchemaDataTypeNumMap(TSDataType type, int num) {
        this.schemaDataTypeNumMap.put(type, this.schemaDataTypeNumMap.getOrDefault(type, 0) + num);
        this.schemaDataTypeNumMap.put(TSDataType.INT64, this.schemaDataTypeNumMap.getOrDefault(TSDataType.INT64, 0) + num);
        long currentDataTypeTotalNum = this.totalSeriesNumber.get() * 2L;
        if (num > 0 && currentDataTypeTotalNum - this.reportedDataTypeTotalNum >= 5000L) {
            PrimitiveArrayManager.updateSchemaDataTypeNum(this.schemaDataTypeNumMap, currentDataTypeTotalNum);
            this.reportedDataTypeTotalNum = currentDataTypeTotalNum;
        }
    }

    public boolean isStorageGroup(PartialPath path) {
        return this.mtree.isStorageGroup(path);
    }

    public TSDataType getSeriesType(PartialPath path) throws MetadataException {
        if (path.equals(SQLConstant.TIME_PATH)) {
            return TSDataType.INT64;
        }
        return this.mtree.getSchema(path).getType();
    }

    public MeasurementMNode[] getMNodes(PartialPath deviceId, String[] measurements) throws MetadataException {
        MNode deviceNode = this.getNodeByPath(deviceId);
        MeasurementMNode[] mNodes = new MeasurementMNode[measurements.length];
        for (int i = 0; i < mNodes.length; ++i) {
            mNodes[i] = (MeasurementMNode)deviceNode.getChild(measurements[i]);
            if (mNodes[i] != null || IoTDBDescriptor.getInstance().getConfig().isEnablePartialInsert()) continue;
            throw new MetadataException(measurements[i] + " does not exist in " + deviceId);
        }
        return mNodes;
    }

    public Set<PartialPath> getDevices(PartialPath prefixPath) throws MetadataException {
        return this.mtree.getDevices(prefixPath);
    }

    public List<ShowDevicesResult> getDevices(ShowDevicesPlan plan) throws MetadataException {
        return this.mtree.getDevices(plan);
    }

    public List<PartialPath> getNodesList(PartialPath prefixPath, int nodeLevel) throws MetadataException {
        return this.getNodesList(prefixPath, nodeLevel, null);
    }

    public List<PartialPath> getNodesList(PartialPath prefixPath, int nodeLevel, StorageGroupFilter filter) throws MetadataException {
        return this.mtree.getNodesList(prefixPath, nodeLevel, filter);
    }

    public PartialPath getStorageGroupPath(PartialPath path) throws StorageGroupNotSetException {
        return this.mtree.getStorageGroupPath(path);
    }

    public List<PartialPath> getAllStorageGroupPaths() {
        return this.mtree.getAllStorageGroupPaths();
    }

    public List<PartialPath> searchAllRelatedStorageGroups(PartialPath path) throws MetadataException {
        return this.mtree.searchAllRelatedStorageGroups(path);
    }

    public List<PartialPath> getStorageGroupPaths(PartialPath prefixPath) throws MetadataException {
        return this.mtree.getStorageGroupPaths(prefixPath);
    }

    public List<StorageGroupMNode> getAllStorageGroupNodes() {
        return this.mtree.getAllStorageGroupNodes();
    }

    public List<PartialPath> getAllTimeseriesPath(PartialPath prefixPath) throws MetadataException {
        return this.mtree.getAllTimeseriesPath(prefixPath);
    }

    public Pair<List<PartialPath>, Integer> getAllTimeseriesPathWithAlias(PartialPath prefixPath, int limit, int offset) throws MetadataException {
        return this.mtree.getAllTimeseriesPathWithAlias(prefixPath, limit, offset);
    }

    public int getAllTimeseriesCount(PartialPath prefixPath) throws MetadataException {
        return this.mtree.getAllTimeseriesCount(prefixPath);
    }

    public int getDevicesNum(PartialPath prefixPath) throws MetadataException {
        return this.mtree.getDevicesNum(prefixPath);
    }

    public int getStorageGroupNum(PartialPath prefixPath) throws MetadataException {
        return this.mtree.getStorageGroupNum(prefixPath);
    }

    public int getNodesCountInGivenLevel(PartialPath prefixPath, int level) throws MetadataException {
        return this.mtree.getNodesCountInGivenLevel(prefixPath, level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ShowTimeSeriesResult> showTimeseriesWithIndex(ShowTimeSeriesPlan plan, QueryContext context) throws MetadataException {
        List<Object> allMatchedNodes;
        block15: {
            String tagValue;
            if (!this.tagIndex.containsKey(plan.getKey())) {
                throw new MetadataException("The key " + plan.getKey() + " is not a tag.", true);
            }
            Map<String, Set<MeasurementMNode>> value2Node = this.tagIndex.get(plan.getKey());
            if (value2Node.isEmpty()) {
                throw new MetadataException("The key " + plan.getKey() + " is not a tag.");
            }
            allMatchedNodes = new ArrayList();
            if (plan.isContains()) {
                for (Map.Entry<String, Set<MeasurementMNode>> entry : value2Node.entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null || !(tagValue = entry.getKey()).contains(plan.getValue())) continue;
                    allMatchedNodes.addAll((Collection<Object>)entry.getValue());
                }
            } else {
                for (Map.Entry<String, Set<MeasurementMNode>> entry : value2Node.entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null) continue;
                    tagValue = entry.getKey();
                    if (!plan.getValue().equals(tagValue)) continue;
                    allMatchedNodes.addAll((Collection<Object>)entry.getValue());
                }
            }
            if (plan.isOrderByHeat()) {
                try {
                    List<StorageGroupProcessor> list = StorageEngine.getInstance().mergeLock(allMatchedNodes.stream().map(MNode::getPartialPath).collect(Collectors.toList()));
                    try {
                        allMatchedNodes = allMatchedNodes.stream().sorted(Comparator.comparingLong(mNode -> MTree.getLastTimeStamp(mNode, context)).reversed().thenComparing(MNode::getFullPath)).collect(Collectors.toList());
                        break block15;
                    }
                    finally {
                        StorageEngine.getInstance().mergeUnLock(list);
                    }
                }
                catch (StorageEngineException e) {
                    throw new MetadataException(e);
                }
            }
            allMatchedNodes = allMatchedNodes.stream().sorted(Comparator.comparing(MNode::getFullPath)).collect(Collectors.toList());
        }
        LinkedList<ShowTimeSeriesResult> res = new LinkedList<ShowTimeSeriesResult>();
        String[] prefixNodes = plan.getPath().getNodes();
        int curOffset = -1;
        int count = 0;
        int limit = plan.getLimit();
        int offset = plan.getOffset();
        for (MeasurementMNode measurementMNode : allMatchedNodes) {
            if (!this.match(measurementMNode.getPartialPath(), prefixNodes) || (limit != 0 || offset != 0) && (++curOffset < offset || count == limit)) continue;
            try {
                Pair<Map<String, String>, Map<String, String>> tagAndAttributePair = this.tagLogFile.read(config.getTagAttributeTotalSize(), measurementMNode.getOffset());
                MeasurementSchema measurementSchema = measurementMNode.getSchema();
                res.add(new ShowTimeSeriesResult(measurementMNode.getFullPath(), measurementMNode.getAlias(), this.getStorageGroupPath(measurementMNode.getPartialPath()).getFullPath(), measurementSchema.getType(), measurementSchema.getEncodingType(), measurementSchema.getCompressor(), (Map)tagAndAttributePair.left, (Map)tagAndAttributePair.right));
                if (limit == 0) continue;
                ++count;
            }
            catch (IOException e) {
                throw new MetadataException("Something went wrong while deserialize tag info of " + measurementMNode.getFullPath(), e);
            }
        }
        return res;
    }

    private boolean match(PartialPath fullPath, String[] prefixNodes) {
        String[] nodes = fullPath.getNodes();
        if (nodes.length < prefixNodes.length) {
            return false;
        }
        for (int i = 0; i < prefixNodes.length; ++i) {
            if ("*".equals(prefixNodes[i]) || prefixNodes[i].equals(nodes[i])) continue;
            return false;
        }
        return true;
    }

    public List<ShowTimeSeriesResult> showTimeseries(ShowTimeSeriesPlan plan, QueryContext context) throws MetadataException {
        if (plan.getKey() != null && plan.getValue() != null) {
            return this.showTimeseriesWithIndex(plan, context);
        }
        return this.showTimeseriesWithoutIndex(plan, context);
    }

    private List<ShowTimeSeriesResult> showTimeseriesWithoutIndex(ShowTimeSeriesPlan plan, QueryContext context) throws MetadataException {
        List<Pair<PartialPath, String[]>> ans = plan.isOrderByHeat() ? this.mtree.getAllMeasurementSchemaByHeatOrder(plan, context) : this.mtree.getAllMeasurementSchema(plan);
        LinkedList<ShowTimeSeriesResult> res = new LinkedList<ShowTimeSeriesResult>();
        for (Pair<PartialPath, String[]> ansString : ans) {
            long tagFileOffset = Long.parseLong(((String[])ansString.right)[5]);
            try {
                Pair<Map<String, String>, Map<String, String>> tagAndAttributePair = new Pair<Map<String, String>, Map<String, String>>(Collections.emptyMap(), Collections.emptyMap());
                if (tagFileOffset >= 0L) {
                    tagAndAttributePair = this.tagLogFile.read(config.getTagAttributeTotalSize(), tagFileOffset);
                }
                res.add(new ShowTimeSeriesResult(((PartialPath)ansString.left).getFullPath(), ((String[])ansString.right)[0], ((String[])ansString.right)[1], TSDataType.valueOf((String)((String[])ansString.right)[2]), TSEncoding.valueOf((String)((String[])ansString.right)[3]), CompressionType.valueOf((String)((String[])ansString.right)[4]), (Map)tagAndAttributePair.left, (Map)tagAndAttributePair.right));
            }
            catch (IOException e) {
                throw new MetadataException("Something went wrong while deserialize tag info of " + ((PartialPath)ansString.left).getFullPath(), e);
            }
        }
        return res;
    }

    public MeasurementSchema getSeriesSchema(PartialPath device, String measurement) throws MetadataException {
        MNode node = this.mtree.getNodeByPath(device);
        MNode leaf = node.getChild(measurement);
        if (leaf != null) {
            return ((MeasurementMNode)leaf).getSchema();
        }
        return null;
    }

    public Set<String> getChildNodePathInNextLevel(PartialPath path) throws MetadataException {
        return this.mtree.getChildNodePathInNextLevel(path);
    }

    public Set<String> getChildNodeInNextLevel(PartialPath path) throws MetadataException {
        return this.mtree.getChildNodeInNextLevel(path);
    }

    public boolean isPathExist(PartialPath path) {
        return this.mtree.isPathExist(path);
    }

    public MNode getNodeByPath(PartialPath path) throws MetadataException {
        return this.mtree.getNodeByPath(path);
    }

    public StorageGroupMNode getStorageGroupNodeByStorageGroupPath(PartialPath path) throws MetadataException {
        return this.mtree.getStorageGroupNodeByStorageGroupPath(path);
    }

    public StorageGroupMNode getStorageGroupNodeByPath(PartialPath path) throws MetadataException {
        return this.mtree.getStorageGroupNodeByPath(path);
    }

    public MNode getDeviceNodeWithAutoCreate(PartialPath path, boolean autoCreateSchema, int sgLevel) throws MetadataException {
        try {
            MNode node = this.mNodeCache.get(path);
            return node;
        }
        catch (CacheException e) {
            if (!autoCreateSchema) {
                throw new PathNotExistException(path.getFullPath());
            }
            boolean shouldSetStorageGroup = e.getCause() instanceof StorageGroupNotSetException;
            try {
                if (shouldSetStorageGroup) {
                    PartialPath storageGroupPath = MetaUtils.getStorageGroupPathByLevel(path, sgLevel);
                    this.setStorageGroup(storageGroupPath);
                }
                MNode node = this.mtree.getDeviceNodeWithAutoCreating(path, sgLevel);
                return node;
            }
            catch (StorageGroupAlreadySetException e2) {
                MNode node = this.mtree.getDeviceNodeWithAutoCreating(path, sgLevel);
                return node;
            }
        }
    }

    public MNode getDeviceNodeWithAutoCreate(PartialPath path) throws MetadataException {
        return this.getDeviceNodeWithAutoCreate(path, config.isAutoCreateSchemaEnabled(), config.getDefaultStorageGroupLevel());
    }

    public MNode getDeviceNode(PartialPath path) throws MetadataException {
        try {
            MNode node = this.mNodeCache.get(path);
            return node;
        }
        catch (CacheException e) {
            throw new PathNotExistException(path.getFullPath());
        }
    }

    public String getDeviceId(PartialPath path) {
        String device = null;
        try {
            MNode deviceNode = this.getDeviceNode(path);
            device = deviceNode.getFullPath();
        }
        catch (NullPointerException | MetadataException exception) {
            // empty catch block
        }
        return device;
    }

    public String getMetadataInString() {
        return TIME_SERIES_TREE_HEADER + this.mtree;
    }

    public void setTTL(PartialPath storageGroup, long dataTTL) throws MetadataException, IOException {
        this.getStorageGroupNodeByStorageGroupPath(storageGroup).setDataTTL(dataTTL);
        if (!this.isRecovering) {
            this.logWriter.setTTL(storageGroup, dataTTL);
        }
    }

    public Map<PartialPath, Long> getStorageGroupsTTL() {
        HashMap<PartialPath, Long> storageGroupsTTL = new HashMap<PartialPath, Long>();
        try {
            List<PartialPath> storageGroups = this.getAllStorageGroupPaths();
            for (PartialPath storageGroup : storageGroups) {
                long ttl = this.getStorageGroupNodeByStorageGroupPath(storageGroup).getDataTTL();
                storageGroupsTTL.put(storageGroup, ttl);
            }
        }
        catch (MetadataException e) {
            logger.error("get storage groups ttl failed.", (Throwable)e);
        }
        return storageGroupsTTL;
    }

    public void changeOffset(PartialPath path, long offset) throws MetadataException {
        ((MeasurementMNode)this.mtree.getNodeByPath(path)).setOffset(offset);
    }

    public void changeAlias(PartialPath path, String alias) throws MetadataException {
        MeasurementMNode leafMNode = (MeasurementMNode)this.mtree.getNodeByPath(path);
        if (leafMNode.getAlias() != null) {
            leafMNode.getParent().deleteAliasChild(leafMNode.getAlias());
        }
        leafMNode.getParent().addAlias(alias, leafMNode);
        leafMNode.setAlias(alias);
    }

    public void upsertTagsAndAttributes(String alias, Map<String, String> tagsMap, Map<String, String> attributesMap, PartialPath fullPath) throws MetadataException, IOException {
        MNode mNode = this.mtree.getNodeByPath(fullPath);
        if (!(mNode instanceof MeasurementMNode)) {
            throw new PathNotExistException(fullPath.getFullPath());
        }
        MeasurementMNode leafMNode = (MeasurementMNode)mNode;
        if (alias != null && !alias.equals(leafMNode.getAlias())) {
            if (!leafMNode.getParent().addAlias(alias, leafMNode)) {
                throw new MetadataException("The alias already exists.");
            }
            if (leafMNode.getAlias() != null) {
                leafMNode.getParent().deleteAliasChild(leafMNode.getAlias());
            }
            leafMNode.setAlias(alias);
            this.logWriter.changeAlias(fullPath, alias);
        }
        if (tagsMap == null && attributesMap == null) {
            return;
        }
        if (leafMNode.getOffset() < 0L) {
            long offset = this.tagLogFile.write(tagsMap, attributesMap);
            this.logWriter.changeOffset(fullPath, offset);
            leafMNode.setOffset(offset);
            if (tagsMap != null) {
                for (Map.Entry<String, String> entry : tagsMap.entrySet()) {
                    this.tagIndex.computeIfAbsent(entry.getKey(), k -> new ConcurrentHashMap()).computeIfAbsent(entry.getValue(), v -> new CopyOnWriteArraySet()).add(leafMNode);
                }
            }
            return;
        }
        Pair<Map<String, String>, Map<String, String>> pair = this.tagLogFile.read(config.getTagAttributeTotalSize(), leafMNode.getOffset());
        if (tagsMap != null) {
            for (Map.Entry<String, String> entry : tagsMap.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                String beforeValue = (String)((Map)pair.left).get(key);
                ((Map)pair.left).put(key, value);
                if (beforeValue != null && !beforeValue.equals(value)) {
                    if (this.tagIndex.containsKey(key) && this.tagIndex.get(key).containsKey(beforeValue)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug(String.format(String.format(DEBUG_MSG, "Upserttag key is %s, tag value is %s, tlog offset is %d", leafMNode.getFullPath()), key, beforeValue, leafMNode.getOffset()));
                        }
                        this.tagIndex.get(key).get(beforeValue).remove(leafMNode);
                        if (this.tagIndex.get(key).get(beforeValue).isEmpty()) {
                            this.tagIndex.get(key).remove(beforeValue);
                        }
                    } else if (logger.isDebugEnabled()) {
                        logger.debug(String.format(String.format(DEBUG_MSG_1, "Upsertbefore deleting it, tag key is %s, tag value is %s, tlog offset is %d, contains key %b", leafMNode.getFullPath()), key, beforeValue, leafMNode.getOffset(), this.tagIndex.containsKey(key)));
                    }
                }
                if (beforeValue != null && beforeValue.equals(value)) continue;
                this.tagIndex.computeIfAbsent(key, k -> new ConcurrentHashMap()).computeIfAbsent(value, v -> new CopyOnWriteArraySet()).add(leafMNode);
            }
        }
        if (attributesMap != null) {
            ((Map)pair.right).putAll(attributesMap);
        }
        this.tagLogFile.write((Map)pair.left, (Map)pair.right, leafMNode.getOffset());
    }

    public void addAttributes(Map<String, String> attributesMap, PartialPath fullPath) throws MetadataException, IOException {
        MNode mNode = this.mtree.getNodeByPath(fullPath);
        if (!(mNode instanceof MeasurementMNode)) {
            throw new PathNotExistException(fullPath.getFullPath());
        }
        MeasurementMNode leafMNode = (MeasurementMNode)mNode;
        if (leafMNode.getOffset() < 0L) {
            long offset = this.tagLogFile.write(Collections.emptyMap(), attributesMap);
            this.logWriter.changeOffset(fullPath, offset);
            leafMNode.setOffset(offset);
            return;
        }
        Pair<Map<String, String>, Map<String, String>> pair = this.tagLogFile.read(config.getTagAttributeTotalSize(), leafMNode.getOffset());
        for (Map.Entry<String, String> entry : attributesMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (((Map)pair.right).containsKey(key)) {
                throw new MetadataException(String.format("TimeSeries [%s] already has the attribute [%s].", fullPath, key));
            }
            ((Map)pair.right).put(key, value);
        }
        this.tagLogFile.write((Map)pair.left, (Map)pair.right, leafMNode.getOffset());
    }

    public void addTags(Map<String, String> tagsMap, PartialPath fullPath) throws MetadataException, IOException {
        MNode mNode = this.mtree.getNodeByPath(fullPath);
        if (!(mNode instanceof MeasurementMNode)) {
            throw new PathNotExistException(fullPath.getFullPath());
        }
        MeasurementMNode leafMNode = (MeasurementMNode)mNode;
        if (leafMNode.getOffset() < 0L) {
            long offset = this.tagLogFile.write(tagsMap, Collections.emptyMap());
            this.logWriter.changeOffset(fullPath, offset);
            leafMNode.setOffset(offset);
            for (Map.Entry<String, String> entry : tagsMap.entrySet()) {
                this.tagIndex.computeIfAbsent(entry.getKey(), k -> new ConcurrentHashMap()).computeIfAbsent(entry.getValue(), v -> new CopyOnWriteArraySet()).add(leafMNode);
            }
            return;
        }
        Pair<Map<String, String>, Map<String, String>> pair = this.tagLogFile.read(config.getTagAttributeTotalSize(), leafMNode.getOffset());
        for (Map.Entry<String, String> entry : tagsMap.entrySet()) {
            String key2 = entry.getKey();
            String value2 = entry.getValue();
            if (((Map)pair.left).containsKey(key2)) {
                throw new MetadataException(String.format("TimeSeries [%s] already has the tag [%s].", fullPath, key2));
            }
            ((Map)pair.left).put(key2, value2);
        }
        this.tagLogFile.write((Map)pair.left, (Map)pair.right, leafMNode.getOffset());
        tagsMap.forEach((key, value) -> this.tagIndex.computeIfAbsent((String)key, k -> new ConcurrentHashMap()).computeIfAbsent(value, v -> new CopyOnWriteArraySet()).add(leafMNode));
    }

    public void dropTagsOrAttributes(Set<String> keySet, PartialPath fullPath) throws MetadataException, IOException {
        MNode mNode = this.mtree.getNodeByPath(fullPath);
        if (!(mNode instanceof MeasurementMNode)) {
            throw new PathNotExistException(fullPath.getFullPath());
        }
        MeasurementMNode leafMNode = (MeasurementMNode)mNode;
        if (leafMNode.getOffset() < 0L) {
            return;
        }
        Pair<Map<String, String>, Map<String, String>> pair = this.tagLogFile.read(config.getTagAttributeTotalSize(), leafMNode.getOffset());
        HashMap<String, String> deleteTag = new HashMap<String, String>();
        for (String key : keySet) {
            String removeVal = (String)((Map)pair.left).remove(key);
            if (removeVal != null) {
                deleteTag.put(key, removeVal);
                continue;
            }
            removeVal = (String)((Map)pair.right).remove(key);
            if (removeVal != null) continue;
            logger.warn("TimeSeries [{}] does not have tag/attribute [{}]", (Object)fullPath, (Object)key);
        }
        this.tagLogFile.write((Map)pair.left, (Map)pair.right, leafMNode.getOffset());
        for (Map.Entry entry : deleteTag.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            Map<String, Set<MeasurementMNode>> tagVal2LeafMNodeSet = this.tagIndex.get(key);
            if (tagVal2LeafMNodeSet != null) {
                Set<MeasurementMNode> MMNodes = tagVal2LeafMNodeSet.get(value);
                if (MMNodes == null) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format(String.format(DEBUG_MSG, "Droptag key is %s, tag value is %s, tlog offset is %d", leafMNode.getFullPath()), entry.getKey(), entry.getValue(), leafMNode.getOffset()));
                }
                MMNodes.remove(leafMNode);
                if (!MMNodes.isEmpty()) continue;
                tagVal2LeafMNodeSet.remove(value);
                if (!tagVal2LeafMNodeSet.isEmpty()) continue;
                this.tagIndex.remove(key);
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug(String.format(String.format(DEBUG_MSG_1, "Dropbefore deleting it, tag key is %s, tag value is %s, tlog offset is %d, contains key %b", leafMNode.getFullPath()), key, value, leafMNode.getOffset(), this.tagIndex.containsKey(key)));
        }
    }

    public void setTagsOrAttributesValue(Map<String, String> alterMap, PartialPath fullPath) throws MetadataException, IOException {
        String key;
        MNode mNode = this.mtree.getNodeByPath(fullPath);
        if (!(mNode instanceof MeasurementMNode)) {
            throw new PathNotExistException(fullPath.getFullPath());
        }
        MeasurementMNode leafMNode = (MeasurementMNode)mNode;
        if (leafMNode.getOffset() < 0L) {
            throw new MetadataException(String.format("TimeSeries [%s] does not have any tag/attribute.", fullPath));
        }
        Pair<Map<String, String>, Map<String, String>> pair = this.tagLogFile.read(config.getTagAttributeTotalSize(), leafMNode.getOffset());
        HashMap<String, String> oldTagValue = new HashMap<String, String>();
        HashMap<String, String> newTagValue = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : alterMap.entrySet()) {
            key = entry.getKey();
            String value = entry.getValue();
            if (((Map)pair.left).containsKey(key)) {
                oldTagValue.put(key, (String)((Map)pair.left).get(key));
                newTagValue.put(key, value);
                ((Map)pair.left).put(key, value);
                continue;
            }
            if (((Map)pair.right).containsKey(key)) {
                ((Map)pair.right).put(key, value);
                continue;
            }
            throw new MetadataException(String.format("TimeSeries [%s] does not have tag/attribute [%s].", fullPath, key), true);
        }
        this.tagLogFile.write((Map)pair.left, (Map)pair.right, leafMNode.getOffset());
        for (Map.Entry<String, String> entry : oldTagValue.entrySet()) {
            key = entry.getKey();
            String beforeValue = entry.getValue();
            String currentValue = (String)newTagValue.get(key);
            if (this.tagIndex.containsKey(key) && this.tagIndex.get(key).containsKey(beforeValue)) {
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format(String.format(DEBUG_MSG, "Settag key is %s, tag value is %s, tlog offset is %d", leafMNode.getFullPath()), entry.getKey(), beforeValue, leafMNode.getOffset()));
                }
                this.tagIndex.get(key).get(beforeValue).remove(leafMNode);
            } else if (logger.isDebugEnabled()) {
                logger.debug(String.format(String.format(DEBUG_MSG_1, "Setbefore deleting it, tag key is %s, tag value is %s, tlog offset is %d, contains key %b", leafMNode.getFullPath()), key, beforeValue, leafMNode.getOffset(), this.tagIndex.containsKey(key)));
            }
            this.tagIndex.computeIfAbsent(key, k -> new ConcurrentHashMap()).computeIfAbsent(currentValue, k -> new CopyOnWriteArraySet()).add(leafMNode);
        }
    }

    public void renameTagOrAttributeKey(String oldKey, String newKey, PartialPath fullPath) throws MetadataException, IOException {
        MNode mNode = this.mtree.getNodeByPath(fullPath);
        if (!(mNode instanceof MeasurementMNode)) {
            throw new PathNotExistException(fullPath.getFullPath());
        }
        MeasurementMNode leafMNode = (MeasurementMNode)mNode;
        if (leafMNode.getOffset() < 0L) {
            throw new MetadataException(String.format("TimeSeries [%s] does not have [%s] tag/attribute.", fullPath, oldKey), true);
        }
        Pair<Map<String, String>, Map<String, String>> pair = this.tagLogFile.read(config.getTagAttributeTotalSize(), leafMNode.getOffset());
        if (((Map)pair.left).containsKey(newKey) || ((Map)pair.right).containsKey(newKey)) {
            throw new MetadataException(String.format("TimeSeries [%s] already has a tag/attribute named [%s].", fullPath, newKey), true);
        }
        if (((Map)pair.left).containsKey(oldKey)) {
            String value = (String)((Map)pair.left).remove(oldKey);
            ((Map)pair.left).put(newKey, value);
            this.tagLogFile.write((Map)pair.left, (Map)pair.right, leafMNode.getOffset());
            if (this.tagIndex.containsKey(oldKey) && this.tagIndex.get(oldKey).containsKey(value)) {
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format(String.format(DEBUG_MSG, "Renametag key is %s, tag value is %s, tlog offset is %d", leafMNode.getFullPath()), oldKey, value, leafMNode.getOffset()));
                }
                this.tagIndex.get(oldKey).get(value).remove(leafMNode);
            } else if (logger.isDebugEnabled()) {
                logger.debug(String.format(String.format(DEBUG_MSG_1, "Renamebefore deleting it, tag key is %s, tag value is %s, tlog offset is %d, contains key %b", leafMNode.getFullPath()), oldKey, value, leafMNode.getOffset(), this.tagIndex.containsKey(oldKey)));
            }
            this.tagIndex.computeIfAbsent(newKey, k -> new ConcurrentHashMap()).computeIfAbsent(value, k -> new CopyOnWriteArraySet()).add(leafMNode);
        } else if (((Map)pair.right).containsKey(oldKey)) {
            ((Map)pair.right).put(newKey, (String)((Map)pair.right).remove(oldKey));
            this.tagLogFile.write((Map)pair.left, (Map)pair.right, leafMNode.getOffset());
        } else {
            throw new MetadataException(String.format("TimeSeries [%s] does not have tag/attribute [%s].", fullPath, oldKey), true);
        }
    }

    boolean checkStorageGroupByPath(PartialPath path) {
        return this.mtree.checkStorageGroupByPath(path);
    }

    List<String> getStorageGroupByPath(PartialPath path) throws MetadataException {
        try {
            return this.mtree.getStorageGroupByPath(path);
        }
        catch (MetadataException e) {
            throw new MetadataException(e);
        }
    }

    public void collectTimeseriesSchema(MNode startingNode, Collection<TimeseriesSchema> timeseriesSchemas) {
        ArrayDeque<MNode> nodeDeque = new ArrayDeque<MNode>();
        nodeDeque.addLast(startingNode);
        while (!nodeDeque.isEmpty()) {
            MNode node = (MNode)nodeDeque.removeFirst();
            if (node instanceof MeasurementMNode) {
                MeasurementSchema nodeSchema = ((MeasurementMNode)node).getSchema();
                timeseriesSchemas.add(new TimeseriesSchema(node.getFullPath(), nodeSchema.getType(), nodeSchema.getEncodingType(), nodeSchema.getCompressor()));
                continue;
            }
            if (node.getChildren().isEmpty()) continue;
            nodeDeque.addAll(node.getChildren().values());
        }
    }

    public void collectTimeseriesSchema(String prefixPath, Collection<TimeseriesSchema> timeseriesSchemas) throws MetadataException {
        this.collectTimeseriesSchema(this.getNodeByPath(new PartialPath(prefixPath)), timeseriesSchemas);
    }

    public void collectMeasurementSchema(MNode startingNode, Collection<MeasurementSchema> measurementSchemas) {
        ArrayDeque<MNode> nodeDeque = new ArrayDeque<MNode>();
        nodeDeque.addLast(startingNode);
        while (!nodeDeque.isEmpty()) {
            MNode node = (MNode)nodeDeque.removeFirst();
            if (node instanceof MeasurementMNode) {
                MeasurementSchema nodeSchema = ((MeasurementMNode)node).getSchema();
                measurementSchemas.add(new MeasurementSchema(node.getName(), nodeSchema.getType(), nodeSchema.getEncodingType(), nodeSchema.getCompressor()));
                continue;
            }
            if (node.getChildren().isEmpty()) continue;
            nodeDeque.addAll(node.getChildren().values());
        }
    }

    public void collectSeries(PartialPath startingPath, List<MeasurementSchema> measurementSchemas) {
        MNode mNode;
        try {
            mNode = this.getNodeByPath(startingPath);
        }
        catch (MetadataException e) {
            return;
        }
        this.collectMeasurementSchema(mNode, measurementSchemas);
    }

    public Map<String, String> determineStorageGroup(PartialPath path) throws IllegalPathException {
        Map<String, String> sgPathMap = this.mtree.determineStorageGroup(path);
        if (logger.isDebugEnabled()) {
            logger.debug("The storage groups of path {} are {}", (Object)path, sgPathMap.keySet());
        }
        return sgPathMap;
    }

    public void cacheMeta(PartialPath path, MeasurementMNode measurementMNode) {
    }

    public void updateLastCache(PartialPath seriesPath, TimeValuePair timeValuePair, boolean highPriorityUpdate, Long latestFlushedTime, MeasurementMNode node) {
        if (node != null) {
            node.updateCachedLast(timeValuePair, highPriorityUpdate, latestFlushedTime);
        } else {
            try {
                MeasurementMNode node1 = (MeasurementMNode)this.mtree.getNodeByPath(seriesPath);
                node1.updateCachedLast(timeValuePair, highPriorityUpdate, latestFlushedTime);
            }
            catch (MetadataException e) {
                logger.warn("failed to update last cache for the {}, err:{}", (Object)seriesPath, (Object)e.getMessage());
            }
        }
    }

    public TimeValuePair getLastCache(PartialPath seriesPath) {
        try {
            MeasurementMNode node = (MeasurementMNode)this.mtree.getNodeByPath(seriesPath);
            return node.getCachedLast();
        }
        catch (MetadataException e) {
            logger.warn("failed to get last cache for the {}, err:{}", (Object)seriesPath, (Object)e.getMessage());
            return null;
        }
    }

    public void flushAllMlogForTest() throws IOException {
        this.logWriter.close();
    }

    private void checkMTreeModified() {
        if (this.logWriter == null || this.logFile == null) {
            return;
        }
        if (System.currentTimeMillis() - this.logFile.lastModified() < this.mtreeSnapshotThresholdTime) {
            if (logger.isDebugEnabled()) {
                logger.debug("MTree snapshot need not be created. Time from last modification: {} ms.", (Object)(System.currentTimeMillis() - this.logFile.lastModified()));
            }
        } else if (this.logWriter.getLogNum() < this.mtreeSnapshotInterval) {
            if (logger.isDebugEnabled()) {
                logger.debug("MTree snapshot need not be created. New mlog line number: {}.", (Object)this.logWriter.getLogNum());
            }
        } else {
            logger.info("New mlog line number: {}, time from last modification: {} ms", (Object)this.logWriter.getLogNum(), (Object)(System.currentTimeMillis() - this.logFile.lastModified()));
            this.createMTreeSnapshot();
        }
    }

    public void createMTreeSnapshot() {
        block6: {
            long time = System.currentTimeMillis();
            logger.info("Start creating MTree snapshot to {}", (Object)this.mtreeSnapshotPath);
            try {
                this.mtree.serializeTo(this.mtreeSnapshotTmpPath);
                File tmpFile = SystemFileFactory.INSTANCE.getFile(this.mtreeSnapshotTmpPath);
                File snapshotFile = SystemFileFactory.INSTANCE.getFile(this.mtreeSnapshotPath);
                if (snapshotFile.exists()) {
                    Files.delete(snapshotFile.toPath());
                }
                if (tmpFile.renameTo(snapshotFile)) {
                    logger.info("Finish creating MTree snapshot to {}, spend {} ms.", (Object)this.mtreeSnapshotPath, (Object)(System.currentTimeMillis() - time));
                }
                this.logWriter.clear();
            }
            catch (IOException e) {
                logger.warn("Failed to create MTree snapshot to {}", (Object)this.mtreeSnapshotPath, (Object)e);
                if (!SystemFileFactory.INSTANCE.getFile(this.mtreeSnapshotTmpPath).exists()) break block6;
                try {
                    Files.delete(SystemFileFactory.INSTANCE.getFile(this.mtreeSnapshotTmpPath).toPath());
                }
                catch (IOException e1) {
                    logger.warn("delete file {} failed: {}", (Object)this.mtreeSnapshotTmpPath, (Object)e1.getMessage());
                }
            }
        }
    }

    public MNode getSeriesSchemasAndReadLockDevice(InsertPlan plan) throws MetadataException {
        PartialPath deviceId = plan.getDeviceId();
        String[] measurementList = plan.getMeasurements();
        MeasurementMNode[] measurementMNodes = plan.getMeasurementMNodes();
        MNode deviceMNode = this.getDeviceNodeWithAutoCreate(deviceId);
        for (int i = 0; i < measurementList.length; ++i) {
            try {
                MeasurementMNode measurementMNode;
                MNode child = this.getMNode(deviceMNode, measurementList[i]);
                if (child instanceof MeasurementMNode) {
                    measurementMNode = (MeasurementMNode)child;
                } else {
                    if (child instanceof StorageGroupMNode) {
                        throw new PathAlreadyExistException(deviceId + "." + measurementList[i]);
                    }
                    if (!config.isAutoCreateSchemaEnabled()) {
                        throw new PathNotExistException(deviceId + "." + measurementList[i]);
                    }
                    TSDataType dataType = this.getTypeInLoc(plan, i);
                    this.internalCreateTimeseries(deviceId.concatNode(measurementList[i]), dataType);
                    measurementMNode = (MeasurementMNode)deviceMNode.getChild(measurementList[i]);
                }
                TSDataType insertDataType = null;
                if (plan instanceof InsertRowPlan) {
                    insertDataType = !((InsertRowPlan)plan).isNeedInferType() ? this.getTypeInLoc(plan, i) : measurementMNode.getSchema().getType();
                } else if (plan instanceof InsertTabletPlan) {
                    insertDataType = this.getTypeInLoc(plan, i);
                }
                if (measurementMNode.getSchema().getType() != insertDataType) {
                    logger.warn("DataType mismatch, Insert measurement {} type {}, metadata tree type {}", new Object[]{measurementList[i], insertDataType, measurementMNode.getSchema().getType()});
                    DataTypeMismatchException mismatchException = new DataTypeMismatchException(measurementList[i], insertDataType, measurementMNode.getSchema().getType());
                    if (!config.isEnablePartialInsert()) {
                        throw mismatchException;
                    }
                    plan.markFailedMeasurementInsertion(i, mismatchException);
                    continue;
                }
                measurementMNodes[i] = measurementMNode;
                measurementList[i] = measurementMNode.getName();
                continue;
            }
            catch (MetadataException e) {
                logger.warn("meet error when check {}.{}, message: {}", new Object[]{deviceId, measurementList[i], e.getMessage()});
                if (config.isEnablePartialInsert()) {
                    plan.markFailedMeasurementInsertion(i, e);
                    continue;
                }
                throw e;
            }
        }
        return deviceMNode;
    }

    public MNode getMNode(MNode deviceMNode, String measurementName) {
        return deviceMNode.getChild(measurementName);
    }

    private void internalCreateTimeseries(PartialPath path, TSDataType dataType) throws MetadataException {
        this.createTimeseries(path, dataType, EncodingInferenceUtils.getDefaultEncoding(dataType), TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
    }

    private TSDataType getTypeInLoc(InsertPlan plan, int loc) throws MetadataException {
        TSDataType dataType;
        if (plan instanceof InsertRowPlan) {
            InsertRowPlan tPlan = (InsertRowPlan)plan;
            dataType = TypeInferenceUtils.getPredictedDataType(tPlan.getValues()[loc], tPlan.isNeedInferType());
        } else if (plan instanceof InsertTabletPlan) {
            dataType = plan.getDataTypes()[loc];
        } else {
            throw new MetadataException(String.format("Only support insert and insertTablet, plan is [%s]", new Object[]{plan.getOperatorType()}));
        }
        return dataType;
    }

    public long getTotalSeriesNumber() {
        return this.totalSeriesNumber.get();
    }

    @FunctionalInterface
    public static interface StorageGroupFilter {
        public boolean satisfy(String var1);
    }

    private static class MManagerHolder {
        private static final MManager INSTANCE = new MManager();

        private MManagerHolder() {
        }
    }
}

