/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.cluster.partition.PartitionTable;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.qp.physical.sys.AuthorPlan;
import org.apache.iotdb.db.qp.physical.sys.DataAuthPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.FlushPlan;
import org.apache.iotdb.db.qp.physical.sys.LoadConfigurationPlan;
import org.apache.iotdb.db.qp.physical.sys.LoadDataPlan;
import org.apache.iotdb.db.qp.physical.sys.MergePlan;
import org.apache.iotdb.db.qp.physical.sys.OperateFilePlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTTLPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTTLPlan;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.iotdb.tsfile.read.filter.GroupByFilter;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.operator.AndFilter;
import org.apache.iotdb.tsfile.read.filter.operator.NotFilter;
import org.apache.iotdb.tsfile.read.filter.operator.OrFilter;
import org.apache.iotdb.tsfile.utils.Murmur128Hash;

public class PartitionUtils {
    private PartitionUtils() {
    }

    public static boolean isLocalNonQueryPlan(PhysicalPlan plan) {
        return plan instanceof LoadDataPlan || plan instanceof OperateFilePlan || plan instanceof LoadConfigurationPlan && ((LoadConfigurationPlan)plan).getLoadConfigurationPlanType().equals((Object)LoadConfigurationPlan.LoadConfigurationPlanType.LOCAL);
    }

    public static boolean isGlobalMetaPlan(PhysicalPlan plan) {
        return plan instanceof SetStorageGroupPlan || plan instanceof SetTTLPlan || plan instanceof ShowTTLPlan || plan instanceof LoadConfigurationPlan && ((LoadConfigurationPlan)plan).getLoadConfigurationPlanType().equals((Object)LoadConfigurationPlan.LoadConfigurationPlanType.GLOBAL) || plan instanceof AuthorPlan || plan instanceof DeleteStorageGroupPlan || plan instanceof DataAuthPlan;
    }

    public static boolean isGlobalDataPlan(PhysicalPlan plan) {
        return plan instanceof DeletePlan || plan instanceof DeleteTimeSeriesPlan || plan instanceof MergePlan || plan instanceof FlushPlan;
    }

    public static int calculateStorageGroupSlotByTime(String storageGroupName, long timestamp, int slotNum) {
        long partitionNum = StorageEngine.getTimePartition((long)timestamp);
        return PartitionUtils.calculateStorageGroupSlotByPartition(storageGroupName, partitionNum, slotNum);
    }

    private static int calculateStorageGroupSlotByPartition(String storageGroupName, long partitionNum, int slotNum) {
        int hash = Murmur128Hash.hash((String)storageGroupName, (long)partitionNum, (int)2333);
        return Math.abs(hash % slotNum);
    }

    public static InsertTabletPlan copy(InsertTabletPlan plan, long[] times, Object[] values) {
        InsertTabletPlan newPlan = new InsertTabletPlan(plan.getDeviceId(), plan.getMeasurements());
        newPlan.setDataTypes(plan.getDataTypes());
        newPlan.setColumns(values);
        newPlan.setTimes(times);
        newPlan.setRowCount(times.length);
        newPlan.setMeasurementMNodes(plan.getMeasurementMNodes());
        return newPlan;
    }

    public static void reordering(InsertTabletPlan plan, TSStatus[] status, TSStatus[] subStatus) {
        List range = plan.getRange();
        int destLoc = 0;
        for (int i = 0; i < range.size(); i += 2) {
            int start = (Integer)range.get(i);
            int end = (Integer)range.get(i + 1);
            System.arraycopy(subStatus, destLoc, status, start, end - start);
            destLoc += end - start;
        }
    }

    public static Intervals extractTimeInterval(Filter filter) {
        if (filter == null) {
            return Intervals.ALL_INTERVAL;
        }
        if (filter instanceof AndFilter) {
            AndFilter andFilter = (AndFilter)filter;
            Intervals leftIntervals = PartitionUtils.extractTimeInterval(andFilter.getLeft());
            Intervals rightIntervals = PartitionUtils.extractTimeInterval(andFilter.getRight());
            return leftIntervals.intersection(rightIntervals);
        }
        if (filter instanceof OrFilter) {
            OrFilter orFilter = (OrFilter)filter;
            Intervals leftIntervals = PartitionUtils.extractTimeInterval(orFilter.getLeft());
            Intervals rightIntervals = PartitionUtils.extractTimeInterval(orFilter.getRight());
            return leftIntervals.union(rightIntervals);
        }
        if (filter instanceof NotFilter) {
            NotFilter notFilter = (NotFilter)filter;
            return PartitionUtils.extractTimeInterval(notFilter.getFilter()).not();
        }
        if (filter instanceof TimeFilter.TimeGt) {
            TimeFilter.TimeGt timeGt = (TimeFilter.TimeGt)filter;
            return new Intervals((Long)timeGt.getValue() + 1L, Long.MAX_VALUE);
        }
        if (filter instanceof TimeFilter.TimeGtEq) {
            TimeFilter.TimeGtEq timeGtEq = (TimeFilter.TimeGtEq)filter;
            return new Intervals((Long)timeGtEq.getValue(), Long.MAX_VALUE);
        }
        if (filter instanceof TimeFilter.TimeEq) {
            TimeFilter.TimeEq timeEq = (TimeFilter.TimeEq)filter;
            return new Intervals((Long)timeEq.getValue(), (Long)timeEq.getValue());
        }
        if (filter instanceof TimeFilter.TimeNotEq) {
            TimeFilter.TimeNotEq timeNotEq = (TimeFilter.TimeNotEq)filter;
            Intervals intervals = new Intervals();
            intervals.addInterval(Long.MIN_VALUE, (Long)timeNotEq.getValue() - 1L);
            intervals.addInterval((Long)timeNotEq.getValue() + 1L, Long.MAX_VALUE);
            return intervals;
        }
        if (filter instanceof TimeFilter.TimeLt) {
            TimeFilter.TimeLt timeLt = (TimeFilter.TimeLt)filter;
            return new Intervals(Long.MIN_VALUE, (Long)timeLt.getValue() - 1L);
        }
        if (filter instanceof TimeFilter.TimeLtEq) {
            TimeFilter.TimeLtEq timeLtEq = (TimeFilter.TimeLtEq)filter;
            return new Intervals(Long.MIN_VALUE, (Long)timeLtEq.getValue());
        }
        if (filter instanceof TimeFilter.TimeIn) {
            TimeFilter.TimeIn timeIn = (TimeFilter.TimeIn)filter;
            Intervals intervals = new Intervals();
            for (Object value : timeIn.getValues()) {
                long time = (Long)value;
                intervals.addInterval(time, time);
            }
            return intervals;
        }
        if (filter instanceof GroupByFilter) {
            GroupByFilter groupByFilter = (GroupByFilter)filter;
            return new Intervals(groupByFilter.getStartTime(), groupByFilter.getEndTime() + 1L);
        }
        return Intervals.ALL_INTERVAL;
    }

    public static void getIntervalHeaders(String storageGroupName, long timeLowerBound, long timeUpperBound, PartitionTable partitionTable, Set<Node> result) {
        long partitionInterval = StorageEngine.getTimePartitionInterval();
        for (long currPartitionStart = timeLowerBound / partitionInterval * partitionInterval; currPartitionStart <= timeUpperBound; currPartitionStart += partitionInterval) {
            result.add(partitionTable.routeToHeaderByTime(storageGroupName, currPartitionStart));
        }
    }

    public static class Intervals
    extends ArrayList<Long> {
        static final Intervals ALL_INTERVAL = new Intervals(Long.MIN_VALUE, Long.MAX_VALUE);

        public Intervals() {
        }

        Intervals(long lowerBound, long upperBound) {
            this.addInterval(lowerBound, upperBound);
        }

        public int getIntervalSize() {
            return this.size() / 2;
        }

        public long getLowerBound(int index) {
            return (Long)this.get(index * 2);
        }

        public long getUpperBound(int index) {
            return (Long)this.get(index * 2 + 1);
        }

        void setLowerBound(int index, long lb) {
            this.set(index * 2, lb);
        }

        void setUpperBound(int index, long ub) {
            this.set(index * 2 + 1, ub);
        }

        public void addInterval(long lowerBound, long upperBound) {
            this.add(lowerBound);
            this.add(upperBound);
        }

        Intervals intersection(Intervals that) {
            Intervals result = new Intervals();
            int thisSize = this.getIntervalSize();
            int thatSize = that.getIntervalSize();
            for (int i = 0; i < thisSize; ++i) {
                for (int j = 0; j < thatSize; ++j) {
                    long thisLB = this.getLowerBound(i);
                    long thisUB = this.getUpperBound(i);
                    long thatLB = that.getLowerBound(i);
                    long thatUB = that.getUpperBound(i);
                    if (thisUB < thatLB) continue;
                    if (thisUB <= thatUB) {
                        result.addInterval(Math.max(thisLB, thatLB), thisUB);
                        continue;
                    }
                    if (thisLB > thatUB) continue;
                    result.addInterval(Math.max(thisLB, thatLB), thatUB);
                }
            }
            return result;
        }

        Intervals union(Intervals that) {
            if (this.isEmpty()) {
                return that;
            }
            if (that.isEmpty()) {
                return this;
            }
            Intervals result = new Intervals();
            int thisSize = this.getIntervalSize();
            int thatSize = that.getIntervalSize();
            int thisIndex = 0;
            int thatIndex = 0;
            while (thisIndex < thisSize && thatIndex < thatSize) {
                long thisLB = this.getLowerBound(thisIndex);
                long thisUB = this.getUpperBound(thisIndex);
                long thatLB = that.getLowerBound(thatIndex);
                long thatUB = that.getUpperBound(thatIndex);
                if (thisLB <= thatLB) {
                    result.mergeLast(thisLB, thisUB);
                    ++thisIndex;
                    continue;
                }
                result.mergeLast(thatLB, thatUB);
                ++thatIndex;
            }
            Intervals remainingIntervals = thisIndex < thisSize ? this : that;
            int remainingIndex = thisIndex < thisSize ? thisIndex : thatIndex;
            this.mergeRemainingIntervals(remainingIndex, remainingIntervals, result);
            return result;
        }

        private void mergeRemainingIntervals(int remainingIndex, Intervals remainingIntervals, Intervals result) {
            for (int i = remainingIndex; i < remainingIntervals.getIntervalSize(); ++i) {
                long lb = remainingIntervals.getLowerBound(i);
                long ub = remainingIntervals.getUpperBound(i);
                result.mergeLast(lb, ub);
            }
        }

        private void mergeLast(long lowerBound, long upperBound) {
            if (this.getIntervalSize() == 0) {
                this.addInterval(lowerBound, upperBound);
                return;
            }
            int lastIndex = this.getIntervalSize() - 1;
            long lastLB = this.getLowerBound(lastIndex);
            long lastUB = this.getUpperBound(lastIndex);
            if (lowerBound > lastUB + 1L) {
                this.addInterval(lowerBound, upperBound);
                return;
            }
            if (upperBound < lastLB - 1L) {
                return;
            }
            this.setLowerBound(lastIndex, Math.min(lastLB, lowerBound));
            this.setUpperBound(lastIndex, Math.max(lastUB, upperBound));
        }

        public Intervals not() {
            if (this.isEmpty()) {
                return ALL_INTERVAL;
            }
            Intervals result = new Intervals();
            long firstLB = this.getLowerBound(0);
            if (firstLB != Long.MIN_VALUE) {
                result.addInterval(Long.MIN_VALUE, firstLB - 1L);
            }
            int intervalSize = this.getIntervalSize();
            for (int i = 0; i < intervalSize - 1; ++i) {
                long nextLB;
                long currentUB = this.getUpperBound(i);
                if (currentUB + 1L > (nextLB = this.getLowerBound(i + 1)) - 1L) continue;
                result.addInterval(currentUB + 1L, nextLB - 1L);
            }
            long lastUB = this.getUpperBound(result.getIntervalSize() - 1);
            if (lastUB != Long.MAX_VALUE) {
                result.addInterval(lastUB + 1L, Long.MAX_VALUE);
            }
            return result;
        }
    }
}

