/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query;

import java.time.ZoneId;
import org.apache.iotdb.cluster.query.ClusterConcatPathOptimizer;
import org.apache.iotdb.cluster.query.ClusterPhysicalGenerator;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.Planner;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.crud.SFWOperator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.strategy.optimizer.ConcatPathOptimizer;
import org.apache.iotdb.db.query.control.QueryResourceManager;

public class ClusterPlanner
extends Planner {
    public PhysicalPlan parseSQLToPhysicalPlan(String sqlStr, ZoneId zoneId, int fetchSize) throws QueryProcessException {
        Operator operator = this.logicalGenerator.generate(sqlStr, zoneId);
        int maxDeduplicatedPathNum = QueryResourceManager.getInstance().getMaxDeduplicatedPathNum(fetchSize);
        if (operator instanceof SFWOperator && ((SFWOperator)operator).isLastQuery()) {
            maxDeduplicatedPathNum = 0x7FFFFFFE;
        }
        operator = this.logicalOptimize(operator, maxDeduplicatedPathNum);
        ClusterPhysicalGenerator physicalGenerator = new ClusterPhysicalGenerator();
        return physicalGenerator.transformToPhysicalPlan(operator, fetchSize);
    }

    protected ConcatPathOptimizer getConcatPathOptimizer() {
        return new ClusterConcatPathOptimizer();
    }
}

