/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.client.sync;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.cluster.client.sync.SyncClientFactory;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftService;
import org.apache.iotdb.cluster.server.monitor.NodeStatusManager;
import org.apache.iotdb.cluster.utils.ClusterNode;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncClientPool {
    private static final Logger logger = LoggerFactory.getLogger(SyncClientPool.class);
    private long waitClientTimeoutMS;
    private int maxConnectionForEachNode;
    private Map<ClusterNode, Deque<RaftService.Client>> clientCaches = new ConcurrentHashMap<ClusterNode, Deque<RaftService.Client>>();
    private Map<ClusterNode, Integer> nodeClientNumMap = new ConcurrentHashMap<ClusterNode, Integer>();
    private SyncClientFactory syncClientFactory;

    public SyncClientPool(SyncClientFactory syncClientFactory) {
        this.syncClientFactory = syncClientFactory;
        this.waitClientTimeoutMS = ClusterDescriptor.getInstance().getConfig().getWaitClientTimeoutMS();
        this.maxConnectionForEachNode = ClusterDescriptor.getInstance().getConfig().getMaxClientPerNodePerMember();
    }

    public RaftService.Client getClient(Node node) {
        return this.getClient(node, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RaftService.Client getClient(Node node, boolean activatedOnly) {
        ClusterNode clusterNode = new ClusterNode(node);
        if (activatedOnly && !NodeStatusManager.getINSTANCE().isActivated(node)) {
            return null;
        }
        Deque clientStack = this.clientCaches.computeIfAbsent(clusterNode, n -> new ArrayDeque());
        SyncClientPool syncClientPool = this;
        synchronized (syncClientPool) {
            if (clientStack.isEmpty()) {
                int nodeClientNum = this.nodeClientNumMap.getOrDefault((Object)clusterNode, 0);
                if (nodeClientNum >= this.maxConnectionForEachNode) {
                    return this.waitForClient(clientStack, clusterNode);
                }
                RaftService.Client client = null;
                try {
                    client = this.syncClientFactory.getSyncClient(clusterNode, this);
                }
                catch (TTransportException e) {
                    logger.error("Cannot open transport for client {}", (Object)node, (Object)e);
                    return null;
                }
                this.nodeClientNumMap.compute(clusterNode, (n, oldValue) -> {
                    if (oldValue == null) {
                        return 1;
                    }
                    return oldValue + 1;
                });
                return client;
            }
            return (RaftService.Client)clientStack.pop();
        }
    }

    private RaftService.Client waitForClient(Deque<RaftService.Client> clientStack, ClusterNode clusterNode) {
        long waitStart = System.currentTimeMillis();
        while (clientStack.isEmpty()) {
            try {
                this.wait(this.waitClientTimeoutMS);
                if (!clientStack.isEmpty() || System.currentTimeMillis() - waitStart < this.waitClientTimeoutMS) continue;
                logger.warn("Cannot get an available client after {}ms, create a new one", (Object)this.waitClientTimeoutMS);
                RaftService.Client client = this.syncClientFactory.getSyncClient(clusterNode, this);
                this.nodeClientNumMap.computeIfPresent(clusterNode, (n, oldValue) -> oldValue + 1);
                return client;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn("Interrupted when waiting for an available client of {}", (Object)clusterNode);
                return null;
            }
            catch (TTransportException e) {
                logger.error("Cannot open transport for client {}", (Object)clusterNode, (Object)e);
                return null;
            }
        }
        return clientStack.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putClient(Node node, RaftService.Client client) {
        ClusterNode clusterNode = new ClusterNode(node);
        Deque clientStack = this.clientCaches.computeIfAbsent(clusterNode, n -> new ArrayDeque());
        SyncClientPool syncClientPool = this;
        synchronized (syncClientPool) {
            if (client.getInputProtocol() != null && client.getInputProtocol().getTransport().isOpen()) {
                clientStack.push(client);
                NodeStatusManager.getINSTANCE().activate(node);
            } else {
                try {
                    clientStack.push(this.syncClientFactory.getSyncClient(node, this));
                    NodeStatusManager.getINSTANCE().activate(node);
                }
                catch (TTransportException e) {
                    logger.error("Cannot open transport for client {}", (Object)node, (Object)e);
                    this.nodeClientNumMap.computeIfPresent(clusterNode, (n, oldValue) -> oldValue - 1);
                    NodeStatusManager.getINSTANCE().deactivate(node);
                }
            }
            this.notifyAll();
        }
    }

    public Map<ClusterNode, Integer> getNodeClientNumMap() {
        return this.nodeClientNumMap;
    }
}

