/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.exception.write.PageException;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.MetaMarker;
import org.apache.iotdb.tsfile.file.header.ChunkGroupHeader;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.reader.page.PageReader;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.v2.read.TsFileSequenceReaderForV2;
import org.apache.iotdb.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.IChunkWriter;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileRewriteTool
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(TsFileRewriteTool.class);
    protected TsFileSequenceReader reader;
    protected File oldTsFile;
    protected List<Modification> oldModification;
    protected Iterator<Modification> modsIterator;
    protected Map<TsFileIOWriter, ModificationFile> fileModificationMap;
    protected Deletion currentMod;
    protected Decoder defaultTimeDecoder = Decoder.getDecoderByType((TSEncoding)TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), (TSDataType)TSDataType.INT64);
    protected Decoder valueDecoder;
    protected Map<Long, TsFileIOWriter> partitionWriterMap;
    protected long maxPlanIndex = Long.MIN_VALUE;
    protected long minPlanIndex = Long.MAX_VALUE;

    public TsFileRewriteTool(TsFileResource resourceToBeRewritten) throws IOException {
        this.oldTsFile = resourceToBeRewritten.getTsFile();
        String file = this.oldTsFile.getAbsolutePath();
        this.reader = new TsFileSequenceReader(file);
        this.partitionWriterMap = new HashMap<Long, TsFileIOWriter>();
        if (FSFactoryProducer.getFSFactory().getFile(file + ".mods").exists()) {
            this.oldModification = (List)resourceToBeRewritten.getModFile().getModifications();
            this.modsIterator = this.oldModification.iterator();
            this.fileModificationMap = new HashMap<TsFileIOWriter, ModificationFile>();
        }
    }

    public TsFileRewriteTool(TsFileResource resourceToBeRewritten, boolean needReaderForV2) throws IOException {
        this.oldTsFile = resourceToBeRewritten.getTsFile();
        String file = this.oldTsFile.getAbsolutePath();
        this.reader = needReaderForV2 ? new TsFileSequenceReaderForV2(file) : new TsFileSequenceReader(file);
        this.partitionWriterMap = new HashMap<Long, TsFileIOWriter>();
        if (FSFactoryProducer.getFSFactory().getFile(file + ".mods").exists()) {
            this.oldModification = (List)resourceToBeRewritten.getModFile().getModifications();
            this.modsIterator = this.oldModification.iterator();
            this.fileModificationMap = new HashMap<TsFileIOWriter, ModificationFile>();
        }
    }

    public static void rewriteTsFile(TsFileResource resourceToBeRewritten, List<TsFileResource> rewrittenResources) throws IOException, WriteProcessException {
        try (TsFileRewriteTool rewriteTool = new TsFileRewriteTool(resourceToBeRewritten);){
            rewriteTool.parseAndRewriteFile(rewrittenResources);
        }
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public void parseAndRewriteFile(List<TsFileResource> rewrittenResources) throws IOException, WriteProcessException {
        if (!this.fileCheck()) {
            return;
        }
        int headerLength = "TsFile".getBytes().length + 1;
        this.reader.position((long)headerLength);
        ArrayList<List<PageHeader>> pageHeadersInChunkGroup = new ArrayList<List<PageHeader>>();
        ArrayList<List<ByteBuffer>> pageDataInChunkGroup = new ArrayList<List<ByteBuffer>>();
        ArrayList<List<Boolean>> needToDecodeInfoInChunkGroup = new ArrayList<List<Boolean>>();
        ArrayList<MeasurementSchema> measurementSchemaList = new ArrayList<MeasurementSchema>();
        String lastChunkGroupDeviceId = null;
        try {
            byte marker;
            block10: while ((marker = this.reader.readMarker()) != 2) {
                switch (marker) {
                    case 1: 
                    case 5: {
                        PageHeader pageHeader;
                        ChunkHeader header = this.reader.readChunkHeader(marker);
                        MeasurementSchema measurementSchema = new MeasurementSchema(header.getMeasurementID(), header.getDataType(), header.getEncodingType(), header.getCompressionType());
                        measurementSchemaList.add(measurementSchema);
                        TSDataType dataType = header.getDataType();
                        TSEncoding encoding = header.getEncodingType();
                        ArrayList<PageHeader> pageHeadersInChunk = new ArrayList<PageHeader>();
                        ArrayList<ByteBuffer> dataInChunk = new ArrayList<ByteBuffer>();
                        ArrayList<Boolean> needToDecodeInfo = new ArrayList<Boolean>();
                        for (int dataSize = header.getDataSize(); dataSize > 0; dataSize -= pageHeader.getSerializedPageSize()) {
                            pageHeader = this.reader.readPageHeader(dataType, header.getChunkType() == 1);
                            boolean needToDecode = this.checkIfNeedToDecode(dataType, encoding, pageHeader);
                            needToDecodeInfo.add(needToDecode);
                            ByteBuffer pageData = this.reader.readPage(pageHeader, header.getCompressionType());
                            pageHeadersInChunk.add(pageHeader);
                            dataInChunk.add(pageData);
                        }
                        pageHeadersInChunkGroup.add(pageHeadersInChunk);
                        pageDataInChunkGroup.add(dataInChunk);
                        needToDecodeInfoInChunkGroup.add(needToDecodeInfo);
                        continue block10;
                    }
                    case 0: {
                        ChunkGroupHeader chunkGroupHeader = this.reader.readChunkGroupHeader();
                        String deviceId = chunkGroupHeader.getDeviceID();
                        if (lastChunkGroupDeviceId != null && !measurementSchemaList.isEmpty()) {
                            this.rewrite(lastChunkGroupDeviceId, measurementSchemaList, pageHeadersInChunkGroup, pageDataInChunkGroup, needToDecodeInfoInChunkGroup);
                            pageHeadersInChunkGroup.clear();
                            pageDataInChunkGroup.clear();
                            measurementSchemaList.clear();
                            needToDecodeInfoInChunkGroup.clear();
                        }
                        lastChunkGroupDeviceId = deviceId;
                        continue block10;
                    }
                    case 4: {
                        this.reader.readPlanIndex();
                        for (TsFileIOWriter tsFileIOWriter : this.partitionWriterMap.values()) {
                            long tmpMaxPlanIndex;
                            long tmpMinPlanIndex = this.reader.getMinPlanIndex();
                            if (tmpMinPlanIndex < this.minPlanIndex) {
                                this.minPlanIndex = tmpMinPlanIndex;
                            }
                            if ((tmpMaxPlanIndex = this.reader.getMaxPlanIndex()) < this.maxPlanIndex) {
                                this.maxPlanIndex = tmpMaxPlanIndex;
                            }
                            tsFileIOWriter.setMaxPlanIndex(tmpMinPlanIndex);
                            tsFileIOWriter.setMaxPlanIndex(tmpMaxPlanIndex);
                            tsFileIOWriter.writePlanIndices();
                        }
                        continue block10;
                    }
                }
                MetaMarker.handleUnexpectedMarker((byte)marker);
            }
            if (!measurementSchemaList.isEmpty()) {
                this.rewrite(lastChunkGroupDeviceId, measurementSchemaList, pageHeadersInChunkGroup, pageDataInChunkGroup, needToDecodeInfoInChunkGroup);
                pageHeadersInChunkGroup.clear();
                pageDataInChunkGroup.clear();
                measurementSchemaList.clear();
                needToDecodeInfoInChunkGroup.clear();
            }
            for (TsFileIOWriter tsFileIOWriter : this.partitionWriterMap.values()) {
                rewrittenResources.add(this.endFileAndGenerateResource(tsFileIOWriter));
            }
            if (this.oldModification != null) {
                while (this.currentMod != null || this.modsIterator.hasNext()) {
                    if (this.currentMod == null) {
                        this.currentMod = (Deletion)this.modsIterator.next();
                    }
                    for (Map.Entry entry : this.fileModificationMap.entrySet()) {
                        TsFileIOWriter tsFileIOWriter = (TsFileIOWriter)entry.getKey();
                        ModificationFile newMods = (ModificationFile)entry.getValue();
                        newMods.write(new Deletion(this.currentMod.getPath(), tsFileIOWriter.getFile().length(), this.currentMod.getStartTime(), this.currentMod.getEndTime()));
                    }
                    this.currentMod = null;
                }
            }
        }
        catch (IOException e2) {
            throw new IOException("TsFile rewrite process cannot proceed at position " + this.reader.position() + "because: " + e2.getMessage());
        }
        finally {
            if (this.reader != null) {
                this.reader.close();
            }
        }
    }

    protected boolean checkIfNeedToDecode(TSDataType dataType, TSEncoding encoding, PageHeader pageHeader) {
        if (pageHeader.getStatistics() == null) {
            return true;
        }
        return StorageEngine.getTimePartition(pageHeader.getStartTime()) != StorageEngine.getTimePartition(pageHeader.getEndTime());
    }

    protected void rewrite(String deviceId, List<MeasurementSchema> schemas, List<List<PageHeader>> pageHeadersInChunkGroup, List<List<ByteBuffer>> dataInChunkGroup, List<List<Boolean>> needToDecodeInfoInChunkGroup) throws IOException, PageException {
        HashMap<Long, Map<MeasurementSchema, ChunkWriterImpl>> chunkWritersInChunkGroup = new HashMap<Long, Map<MeasurementSchema, ChunkWriterImpl>>();
        for (int i = 0; i < schemas.size(); ++i) {
            MeasurementSchema schema = schemas.get(i);
            List<ByteBuffer> pageDataInChunk = dataInChunkGroup.get(i);
            List<PageHeader> pageHeadersInChunk = pageHeadersInChunkGroup.get(i);
            List<Boolean> needToDecodeInfoInChunk = needToDecodeInfoInChunkGroup.get(i);
            this.valueDecoder = Decoder.getDecoderByType((TSEncoding)schema.getEncodingType(), (TSDataType)schema.getType());
            for (int j = 0; j < pageDataInChunk.size(); ++j) {
                if (Boolean.TRUE.equals(needToDecodeInfoInChunk.get(j))) {
                    this.decodeAndWritePageInToFiles(schema, pageDataInChunk.get(j), chunkWritersInChunkGroup);
                    continue;
                }
                this.writePageInToFile(schema, pageHeadersInChunk.get(j), pageDataInChunk.get(j), chunkWritersInChunkGroup);
            }
        }
        for (Map.Entry entry : chunkWritersInChunkGroup.entrySet()) {
            long partitionId = (Long)entry.getKey();
            TsFileIOWriter tsFileIOWriter = this.partitionWriterMap.get(partitionId);
            tsFileIOWriter.startChunkGroup(deviceId);
            for (IChunkWriter chunkWriter : ((Map)entry.getValue()).values()) {
                chunkWriter.writeToFileWriter(tsFileIOWriter);
            }
            tsFileIOWriter.endChunkGroup();
        }
    }

    public String upgradeTsFileName(String oldTsFileName) {
        return oldTsFileName;
    }

    protected TsFileIOWriter getOrDefaultTsFileIOWriter(File oldTsFile, long partition) {
        return this.partitionWriterMap.computeIfAbsent(partition, k -> {
            File partitionDir = FSFactoryProducer.getFSFactory().getFile(oldTsFile.getParent() + File.separator + partition);
            if (!partitionDir.exists()) {
                partitionDir.mkdirs();
            }
            File newFile = FSFactoryProducer.getFSFactory().getFile(partitionDir + File.separator + this.upgradeTsFileName(oldTsFile.getName()));
            try {
                if (newFile.exists()) {
                    logger.debug("delete uncomplated file {}", (Object)newFile);
                    Files.delete(newFile.toPath());
                }
                if (!newFile.createNewFile()) {
                    logger.error("Create new TsFile {} failed because it exists", (Object)newFile);
                }
                TsFileIOWriter writer = new TsFileIOWriter(newFile);
                if (this.oldModification != null) {
                    this.fileModificationMap.put(writer, new ModificationFile(newFile + ".mods"));
                }
                return writer;
            }
            catch (IOException e) {
                logger.error("Create new TsFile {} failed ", (Object)newFile, (Object)e);
                return null;
            }
        });
    }

    protected void writePageInToFile(MeasurementSchema schema, PageHeader pageHeader, ByteBuffer pageData, Map<Long, Map<MeasurementSchema, ChunkWriterImpl>> chunkWritersInChunkGroup) throws PageException {
        long partitionId = StorageEngine.getTimePartition(pageHeader.getStartTime());
        this.getOrDefaultTsFileIOWriter(this.oldTsFile, partitionId);
        Map chunkWriters = chunkWritersInChunkGroup.getOrDefault(partitionId, new HashMap());
        ChunkWriterImpl chunkWriter = chunkWriters.getOrDefault(schema, new ChunkWriterImpl(schema));
        chunkWriter.writePageHeaderAndDataIntoBuff(pageData, pageHeader);
        chunkWriters.put(schema, chunkWriter);
        chunkWritersInChunkGroup.put(partitionId, chunkWriters);
    }

    protected void decodeAndWritePageInToFiles(MeasurementSchema schema, ByteBuffer pageData, Map<Long, Map<MeasurementSchema, ChunkWriterImpl>> chunkWritersInChunkGroup) throws IOException {
        this.valueDecoder.reset();
        PageReader pageReader = new PageReader(pageData, schema.getType(), this.valueDecoder, this.defaultTimeDecoder, null);
        BatchData batchData = pageReader.getAllSatisfiedPageData();
        this.rewritePageIntoFiles(batchData, schema, chunkWritersInChunkGroup);
    }

    protected void rewritePageIntoFiles(BatchData batchData, MeasurementSchema schema, Map<Long, Map<MeasurementSchema, ChunkWriterImpl>> chunkWritersInChunkGroup) {
        while (batchData.hasCurrent()) {
            long time = batchData.currentTime();
            Object value = batchData.currentValue();
            long partitionId = StorageEngine.getTimePartition(time);
            Map chunkWriters = chunkWritersInChunkGroup.getOrDefault(partitionId, new HashMap());
            ChunkWriterImpl chunkWriter = chunkWriters.getOrDefault(schema, new ChunkWriterImpl(schema));
            this.getOrDefaultTsFileIOWriter(this.oldTsFile, partitionId);
            switch (schema.getType()) {
                case INT32: {
                    chunkWriter.write(time, ((Integer)value).intValue());
                    break;
                }
                case INT64: {
                    chunkWriter.write(time, ((Long)value).longValue());
                    break;
                }
                case FLOAT: {
                    chunkWriter.write(time, ((Float)value).floatValue());
                    break;
                }
                case DOUBLE: {
                    chunkWriter.write(time, ((Double)value).doubleValue());
                    break;
                }
                case BOOLEAN: {
                    chunkWriter.write(time, ((Boolean)value).booleanValue());
                    break;
                }
                case TEXT: {
                    chunkWriter.write(time, (Binary)value);
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", schema.getType()));
                }
            }
            batchData.next();
            chunkWriters.put(schema, chunkWriter);
            chunkWritersInChunkGroup.put(partitionId, chunkWriters);
        }
    }

    protected boolean fileCheck() throws IOException {
        String magic = this.reader.readHeadMagic();
        if (!magic.equals("TsFile")) {
            logger.error("the file's MAGIC STRING is incorrect, file path: {}", (Object)this.reader.getFileName());
            return false;
        }
        byte versionNumber = this.reader.readVersionNumber();
        if (versionNumber != 3) {
            logger.error("the file's Version Number is incorrect, file path: {}", (Object)this.reader.getFileName());
            return false;
        }
        if (!this.reader.readTailMagic().equals("TsFile")) {
            logger.error("the file is not closed correctly, file path: {}", (Object)this.reader.getFileName());
            return false;
        }
        return true;
    }

    protected TsFileResource endFileAndGenerateResource(TsFileIOWriter tsFileIOWriter) throws IOException {
        tsFileIOWriter.endFile();
        TsFileResource tsFileResource = new TsFileResource(tsFileIOWriter.getFile());
        Map deviceTimeseriesMetadataMap = tsFileIOWriter.getDeviceTimeseriesMetadataMap();
        for (Map.Entry entry : deviceTimeseriesMetadataMap.entrySet()) {
            String device = (String)entry.getKey();
            for (TimeseriesMetadata timeseriesMetaData : (List)entry.getValue()) {
                tsFileResource.updateStartTime(device, timeseriesMetaData.getStatistics().getStartTime());
                tsFileResource.updateEndTime(device, timeseriesMetaData.getStatistics().getEndTime());
            }
        }
        tsFileResource.setMinPlanIndex(this.minPlanIndex);
        tsFileResource.setMaxPlanIndex(this.maxPlanIndex);
        tsFileResource.setClosed(true);
        tsFileResource.serialize();
        return tsFileResource;
    }
}

