/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.monitor;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.server.NodeCharacter;
import org.apache.iotdb.cluster.server.monitor.Timer;
import org.apache.iotdb.rpc.RpcStat;
import org.apache.iotdb.rpc.RpcTransportFactory;

public class NodeReport {
    private Node thisNode;
    private MetaMemberReport metaMemberReport;
    private List<DataMemberReport> dataMemberReportList;

    public NodeReport(Node thisNode) {
        this.thisNode = thisNode;
        this.dataMemberReportList = new ArrayList<DataMemberReport>();
    }

    public void setMetaMemberReport(MetaMemberReport metaMemberReport) {
        this.metaMemberReport = metaMemberReport;
    }

    public void setDataMemberReportList(List<DataMemberReport> dataMemberReportList) {
        this.dataMemberReportList = dataMemberReportList;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Report of ").append(this.thisNode).append(System.lineSeparator());
        stringBuilder.append(this.metaMemberReport).append(System.lineSeparator());
        for (DataMemberReport dataMemberReport : this.dataMemberReportList) {
            stringBuilder.append(dataMemberReport).append(System.lineSeparator());
        }
        return stringBuilder.toString();
    }

    public static class DataMemberReport
    extends RaftMemberReport {
        Node header;
        long headerLatency;

        public DataMemberReport(NodeCharacter character, Node leader, long term, long lastLogTerm, long lastLogIndex, long commitIndex, long commitTerm, Node header, boolean isReadOnly, long headerLatency, long lastHeartbeatReceivedTime, long prevLastLogIndex, long maxAppliedLogIndex) {
            super(character, leader, term, lastLogTerm, lastLogIndex, commitIndex, commitTerm, isReadOnly, lastHeartbeatReceivedTime, prevLastLogIndex, maxAppliedLogIndex);
            this.header = header;
            this.headerLatency = headerLatency;
        }

        public String toString() {
            return "DataMemberReport{header=" + this.header + ", character=" + (Object)((Object)this.character) + ", Leader=" + this.leader + ", term=" + this.term + ", lastLogTerm=" + this.lastLogTerm + ", lastLogIndex=" + this.lastLogIndex + ", commitIndex=" + this.commitIndex + ", commitTerm=" + this.commitTerm + ", appliedLogIndex=" + this.maxAppliedLogIndex + ", readOnly=" + this.isReadOnly + ", headerLatency=" + this.headerLatency + "ns, lastHeartbeat=" + (System.currentTimeMillis() - this.lastHeartbeatReceivedTime) + "ms ago, logIncrement=" + (this.lastLogIndex - this.prevLastLogIndex) + '}';
        }
    }

    public static class MetaMemberReport
    extends RaftMemberReport {
        public MetaMemberReport(NodeCharacter character, Node leader, long term, long lastLogTerm, long lastLogIndex, long commitIndex, long commitTerm, boolean isReadOnly, long lastHeartbeatReceivedTime, long prevLastLogIndex, long maxAppliedLogIndex) {
            super(character, leader, term, lastLogTerm, lastLogIndex, commitIndex, commitTerm, isReadOnly, lastHeartbeatReceivedTime, prevLastLogIndex, maxAppliedLogIndex);
        }

        public String toString() {
            long readBytes = RpcStat.getReadBytes();
            long readCompressedBytes = RpcStat.getReadCompressedBytes();
            long writeBytes = RpcStat.getWriteBytes();
            long writeCompressedBytes = RpcStat.getWriteCompressedBytes();
            double readCompressionRatio = (double)readBytes / (double)readCompressedBytes;
            double writeCompressionRatio = (double)writeBytes / (double)writeCompressedBytes;
            String transportCompressionReport = "";
            if (RpcTransportFactory.isUseSnappy()) {
                transportCompressionReport = ", readBytes=" + readBytes + "/" + readCompressedBytes + "(" + readCompressionRatio + "), writeBytes=" + writeBytes + "/" + writeCompressedBytes + "(" + writeCompressionRatio + ")";
            }
            return "MetaMemberReport {\ncharacter=" + (Object)((Object)this.character) + ", Leader=" + this.leader + ", term=" + this.term + ", lastLogTerm=" + this.lastLogTerm + ", lastLogIndex=" + this.lastLogIndex + ", commitIndex=" + this.commitIndex + ", commitTerm=" + this.commitTerm + ", appliedLogIndex=" + this.maxAppliedLogIndex + ", readOnly=" + this.isReadOnly + ", lastHeartbeat=" + (System.currentTimeMillis() - this.lastHeartbeatReceivedTime) + "ms ago, logIncrement=" + (this.lastLogIndex - this.prevLastLogIndex) + transportCompressionReport + ", \n timer: " + Timer.getReport() + '}';
        }
    }

    static class RaftMemberReport {
        NodeCharacter character;
        Node leader;
        long term;
        long lastLogTerm;
        long lastLogIndex;
        long commitIndex;
        long commitTerm;
        boolean isReadOnly;
        long lastHeartbeatReceivedTime;
        long prevLastLogIndex;
        long maxAppliedLogIndex;

        RaftMemberReport(NodeCharacter character, Node leader, long term, long lastLogTerm, long lastLogIndex, long commitIndex, long commitTerm, boolean isReadOnly, long lastHeartbeatReceivedTime, long prevLastLogIndex, long maxAppliedLogIndex) {
            this.character = character;
            this.leader = leader;
            this.term = term;
            this.lastLogTerm = lastLogTerm;
            this.lastLogIndex = lastLogIndex;
            this.commitIndex = commitIndex;
            this.commitTerm = commitTerm;
            this.isReadOnly = isReadOnly;
            this.lastHeartbeatReceivedTime = lastHeartbeatReceivedTime;
            this.prevLastLogIndex = prevLastLogIndex;
            this.maxAppliedLogIndex = maxAppliedLogIndex;
        }
    }
}

