/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query.manage;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.cluster.query.RemoteQueryContext;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.dataset.groupby.GroupByExecutor;
import org.apache.iotdb.db.query.reader.series.IAggregateReader;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.tsfile.read.reader.IBatchReader;

public class ClusterQueryManager {
    private AtomicLong idAtom = new AtomicLong();
    private Map<Node, Map<Long, RemoteQueryContext>> queryContextMap = new ConcurrentHashMap<Node, Map<Long, RemoteQueryContext>>();
    private Map<Long, IBatchReader> seriesReaderMap = new ConcurrentHashMap<Long, IBatchReader>();
    private Map<Long, IReaderByTimestamp> seriesReaderByTimestampMap = new ConcurrentHashMap<Long, IReaderByTimestamp>();
    private Map<Long, IAggregateReader> aggrReaderMap = new ConcurrentHashMap<Long, IAggregateReader>();
    private Map<Long, GroupByExecutor> groupByExecutorMap = new ConcurrentHashMap<Long, GroupByExecutor>();

    public synchronized RemoteQueryContext getQueryContext(Node node, long queryId, int fetchSize, int deduplicatedPathNum) {
        Map nodeContextMap = this.queryContextMap.computeIfAbsent(node, n -> new HashMap());
        return nodeContextMap.computeIfAbsent(queryId, qId -> new RemoteQueryContext(QueryResourceManager.getInstance().assignQueryId(true, fetchSize, deduplicatedPathNum)));
    }

    public long registerReader(IBatchReader reader) {
        long newReaderId = this.idAtom.incrementAndGet();
        this.seriesReaderMap.put(newReaderId, reader);
        return newReaderId;
    }

    public long registerReaderByTime(IReaderByTimestamp readerByTimestamp) {
        long newReaderId = this.idAtom.incrementAndGet();
        this.seriesReaderByTimestampMap.put(newReaderId, readerByTimestamp);
        return newReaderId;
    }

    public synchronized void endQuery(Node node, long queryId) throws StorageEngineException {
        Map<Long, RemoteQueryContext> nodeContextMap = this.queryContextMap.get(node);
        if (nodeContextMap == null) {
            return;
        }
        RemoteQueryContext remoteQueryContext = nodeContextMap.remove(queryId);
        if (remoteQueryContext == null) {
            return;
        }
        QueryResourceManager.getInstance().endQuery(remoteQueryContext.getQueryId());
        Set<Long> readerIds = remoteQueryContext.getLocalReaderIds();
        for (long readerId : readerIds) {
            this.seriesReaderMap.remove(readerId);
            this.seriesReaderByTimestampMap.remove(readerId);
        }
        Set<Long> localGroupByExecutorIds = remoteQueryContext.getLocalGroupByExecutorIds();
        for (Long localGroupByExecutorId : localGroupByExecutorIds) {
            this.groupByExecutorMap.remove(localGroupByExecutorId);
        }
    }

    public IBatchReader getReader(long readerId) {
        return this.seriesReaderMap.get(readerId);
    }

    public IReaderByTimestamp getReaderByTimestamp(long readerId) {
        return this.seriesReaderByTimestampMap.get(readerId);
    }

    IAggregateReader getAggrReader(long readerId) {
        return this.aggrReaderMap.get(readerId);
    }

    public void endAllQueries() throws StorageEngineException {
        for (Map<Long, RemoteQueryContext> contextMap : this.queryContextMap.values()) {
            for (RemoteQueryContext context : contextMap.values()) {
                QueryResourceManager.getInstance().endQuery(context.getQueryId());
            }
        }
        this.seriesReaderByTimestampMap.clear();
        this.seriesReaderMap.clear();
        this.aggrReaderMap.clear();
    }

    long registerAggrReader(IAggregateReader aggregateReader) {
        long newReaderId = this.idAtom.incrementAndGet();
        this.aggrReaderMap.put(newReaderId, aggregateReader);
        return newReaderId;
    }

    public long registerGroupByExecutor(GroupByExecutor groupByExecutor) {
        long newExecutorId = this.idAtom.incrementAndGet();
        this.groupByExecutorMap.put(newExecutorId, groupByExecutor);
        return newExecutorId;
    }

    public GroupByExecutor getGroupByExecutor(long executorId) {
        return this.groupByExecutorMap.get(executorId);
    }
}

