/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.client;

import java.io.IOException;
import org.apache.iotdb.cluster.client.async.AsyncClientPool;
import org.apache.iotdb.cluster.client.async.AsyncDataClient;
import org.apache.iotdb.cluster.client.sync.SyncClientPool;
import org.apache.iotdb.cluster.client.sync.SyncDataClient;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocolFactory;

public class DataClientProvider {
    private AsyncClientPool dataAsyncClientPool;
    private SyncClientPool dataSyncClientPool;

    public DataClientProvider(TProtocolFactory factory) {
        if (!ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            this.dataSyncClientPool = new SyncClientPool(new SyncDataClient.FactorySync(factory));
        } else {
            this.dataAsyncClientPool = new AsyncClientPool(new AsyncDataClient.FactoryAsync(factory));
        }
    }

    AsyncClientPool getDataAsyncClientPool() {
        return this.dataAsyncClientPool;
    }

    SyncClientPool getDataSyncClientPool() {
        return this.dataSyncClientPool;
    }

    public AsyncDataClient getAsyncDataClient(Node node, int timeout) throws IOException {
        AsyncDataClient client = (AsyncDataClient)this.getDataAsyncClientPool().getClient(node);
        if (client == null) {
            throw new IOException("can not get client for node=" + node);
        }
        client.setTimeout(timeout);
        return client;
    }

    public SyncDataClient getSyncDataClient(Node node, int timeout) throws TException {
        SyncDataClient client = (SyncDataClient)this.getDataSyncClientPool().getClient(node);
        if (client == null) {
            throw new TException("can not get client for node=" + node);
        }
        client.setTimeout(timeout);
        return client;
    }
}

