/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.page;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.iotdb.tsfile.compress.ICompressor;
import org.apache.iotdb.tsfile.encoding.encoder.Encoder;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteForEncodingUtils;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageWriter {
    private static final Logger logger = LoggerFactory.getLogger(PageWriter.class);
    private ICompressor compressor;
    private Encoder timeEncoder;
    private PublicBAOS timeOut = new PublicBAOS();
    private Encoder valueEncoder;
    private PublicBAOS valueOut = new PublicBAOS();
    private Statistics<?> statistics;

    public PageWriter() {
        this(null, null);
    }

    public PageWriter(MeasurementSchema measurementSchema) {
        this(measurementSchema.getTimeEncoder(), measurementSchema.getValueEncoder());
        this.statistics = Statistics.getStatsByType(measurementSchema.getType());
        this.compressor = ICompressor.getCompressor(measurementSchema.getCompressor());
    }

    private PageWriter(Encoder timeEncoder, Encoder valueEncoder) {
        this.timeEncoder = timeEncoder;
        this.valueEncoder = valueEncoder;
    }

    public void write(long time, boolean value) {
        this.timeEncoder.encode(time, (ByteArrayOutputStream)this.timeOut);
        this.valueEncoder.encode(value, (ByteArrayOutputStream)this.valueOut);
        this.statistics.update(time, value);
    }

    public void write(long time, short value) {
        this.timeEncoder.encode(time, (ByteArrayOutputStream)this.timeOut);
        this.valueEncoder.encode(value, (ByteArrayOutputStream)this.valueOut);
        this.statistics.update(time, value);
    }

    public void write(long time, int value) {
        this.timeEncoder.encode(time, (ByteArrayOutputStream)this.timeOut);
        this.valueEncoder.encode(value, (ByteArrayOutputStream)this.valueOut);
        this.statistics.update(time, value);
    }

    public void write(long time, long value) {
        this.timeEncoder.encode(time, (ByteArrayOutputStream)this.timeOut);
        this.valueEncoder.encode(value, (ByteArrayOutputStream)this.valueOut);
        this.statistics.update(time, value);
    }

    public void write(long time, float value) {
        this.timeEncoder.encode(time, (ByteArrayOutputStream)this.timeOut);
        this.valueEncoder.encode(value, (ByteArrayOutputStream)this.valueOut);
        this.statistics.update(time, value);
    }

    public void write(long time, double value) {
        this.timeEncoder.encode(time, (ByteArrayOutputStream)this.timeOut);
        this.valueEncoder.encode(value, (ByteArrayOutputStream)this.valueOut);
        this.statistics.update(time, value);
    }

    public void write(long time, Binary value) {
        this.timeEncoder.encode(time, (ByteArrayOutputStream)this.timeOut);
        this.valueEncoder.encode(value, (ByteArrayOutputStream)this.valueOut);
        this.statistics.update(time, value);
    }

    public void write(long[] timestamps, boolean[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            this.timeEncoder.encode(timestamps[i], (ByteArrayOutputStream)this.timeOut);
            this.valueEncoder.encode(values[i], (ByteArrayOutputStream)this.valueOut);
        }
        this.statistics.update(timestamps, values, batchSize);
    }

    public void write(long[] timestamps, int[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            this.timeEncoder.encode(timestamps[i], (ByteArrayOutputStream)this.timeOut);
            this.valueEncoder.encode(values[i], (ByteArrayOutputStream)this.valueOut);
        }
        this.statistics.update(timestamps, values, batchSize);
    }

    public void write(long[] timestamps, long[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            this.timeEncoder.encode(timestamps[i], (ByteArrayOutputStream)this.timeOut);
            this.valueEncoder.encode(values[i], (ByteArrayOutputStream)this.valueOut);
        }
        this.statistics.update(timestamps, values, batchSize);
    }

    public void write(long[] timestamps, float[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            this.timeEncoder.encode(timestamps[i], (ByteArrayOutputStream)this.timeOut);
            this.valueEncoder.encode(values[i], (ByteArrayOutputStream)this.valueOut);
        }
        this.statistics.update(timestamps, values, batchSize);
    }

    public void write(long[] timestamps, double[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            this.timeEncoder.encode(timestamps[i], (ByteArrayOutputStream)this.timeOut);
            this.valueEncoder.encode(values[i], (ByteArrayOutputStream)this.valueOut);
        }
        this.statistics.update(timestamps, values, batchSize);
    }

    public void write(long[] timestamps, Binary[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            this.timeEncoder.encode(timestamps[i], (ByteArrayOutputStream)this.timeOut);
            this.valueEncoder.encode(values[i], (ByteArrayOutputStream)this.valueOut);
        }
        this.statistics.update(timestamps, values, batchSize);
    }

    private void prepareEndWriteOnePage() throws IOException {
        this.timeEncoder.flush(this.timeOut);
        this.valueEncoder.flush(this.valueOut);
    }

    public ByteBuffer getUncompressedBytes() throws IOException {
        this.prepareEndWriteOnePage();
        ByteBuffer buffer = ByteBuffer.allocate(this.timeOut.size() + this.valueOut.size() + 4);
        ReadWriteForEncodingUtils.writeUnsignedVarInt(this.timeOut.size(), buffer);
        buffer.put(this.timeOut.getBuf(), 0, this.timeOut.size());
        buffer.put(this.valueOut.getBuf(), 0, this.valueOut.size());
        buffer.flip();
        return buffer;
    }

    public void writePageHeaderAndDataIntoBuff(PublicBAOS pageBuffer) throws IOException {
        int compressedSize;
        if (this.statistics.getCount() == 0L) {
            return;
        }
        ByteBuffer pageData = this.getUncompressedBytes();
        int uncompressedSize = pageData.remaining();
        int compressedPosition = 0;
        byte[] compressedBytes = null;
        if (this.compressor.getType().equals((Object)CompressionType.UNCOMPRESSED)) {
            compressedSize = pageData.remaining();
        } else {
            compressedBytes = new byte[this.compressor.getMaxBytesForCompression(uncompressedSize)];
            compressedPosition = 0;
            compressedSize = this.compressor.compress(pageData.array(), pageData.position(), uncompressedSize, compressedBytes);
        }
        PageHeader header = new PageHeader(uncompressedSize, compressedSize, this.statistics);
        header.serializeTo(pageBuffer);
        logger.trace("start to flush a page data into buffer, buffer position {} ", (Object)pageBuffer.size());
        if (this.compressor.getType().equals((Object)CompressionType.UNCOMPRESSED)) {
            try (WritableByteChannel channel = Channels.newChannel(pageBuffer);){
                channel.write(pageData);
            }
        } else {
            pageBuffer.write(compressedBytes, compressedPosition, compressedSize);
        }
        logger.trace("start to flush a page data into buffer, buffer position {} ", (Object)pageBuffer.size());
    }

    public long estimateMaxMemSize() {
        return (long)(this.timeOut.size() + this.valueOut.size()) + this.timeEncoder.getMaxByteSize() + this.valueEncoder.getMaxByteSize();
    }

    public void reset(MeasurementSchema measurementSchema) {
        this.timeOut.reset();
        this.valueOut.reset();
        this.statistics = Statistics.getStatsByType(measurementSchema.getType());
    }

    public void setTimeEncoder(Encoder encoder) {
        this.timeEncoder = encoder;
    }

    public void setValueEncoder(Encoder encoder) {
        this.valueEncoder = encoder;
    }

    public void initStatistics(TSDataType dataType) {
        this.statistics = Statistics.getStatsByType(dataType);
    }

    public long getPointNumber() {
        return this.statistics.getCount();
    }

    public Statistics<?> getStatistics() {
        return this.statistics;
    }
}

