/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.chunk;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.tsfile.exception.write.NoMeasurementException;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.IChunkGroupWriter;
import org.apache.iotdb.tsfile.write.chunk.IChunkWriter;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkGroupWriterImpl
implements IChunkGroupWriter {
    private static final Logger LOG = LoggerFactory.getLogger(ChunkGroupWriterImpl.class);
    private final String deviceId;
    private Map<String, IChunkWriter> chunkWriters = new HashMap<String, IChunkWriter>();

    public ChunkGroupWriterImpl(String deviceId) {
        this.deviceId = deviceId;
    }

    @Override
    public void tryToAddSeriesWriter(MeasurementSchema schema, int pageSizeThreshold) {
        if (!this.chunkWriters.containsKey(schema.getMeasurementId())) {
            ChunkWriterImpl seriesWriter = new ChunkWriterImpl(schema);
            this.chunkWriters.put(schema.getMeasurementId(), seriesWriter);
        }
    }

    @Override
    public void write(long time, List<DataPoint> data) throws WriteProcessException, IOException {
        for (DataPoint point : data) {
            String measurementId = point.getMeasurementId();
            if (!this.chunkWriters.containsKey(measurementId)) {
                throw new NoMeasurementException("time " + time + ", measurement id " + measurementId + " not found!");
            }
            point.writeTo(time, this.chunkWriters.get(measurementId));
        }
    }

    @Override
    public void write(Tablet tablet) throws WriteProcessException, IOException {
        List<MeasurementSchema> timeseries = tablet.getSchemas();
        for (int i = 0; i < timeseries.size(); ++i) {
            String measurementId = timeseries.get(i).getMeasurementId();
            TSDataType dataType = timeseries.get(i).getType();
            if (!this.chunkWriters.containsKey(measurementId)) {
                throw new NoMeasurementException("measurement id" + measurementId + " not found!");
            }
            this.writeByDataType(tablet, measurementId, dataType, i);
        }
    }

    private void writeByDataType(Tablet tablet, String measurementId, TSDataType dataType, int index) throws IOException {
        int batchSize = tablet.rowSize;
        switch (dataType) {
            case INT32: {
                this.chunkWriters.get(measurementId).write(tablet.timestamps, (int[])tablet.values[index], batchSize);
                break;
            }
            case INT64: {
                this.chunkWriters.get(measurementId).write(tablet.timestamps, (long[])tablet.values[index], batchSize);
                break;
            }
            case FLOAT: {
                this.chunkWriters.get(measurementId).write(tablet.timestamps, (float[])tablet.values[index], batchSize);
                break;
            }
            case DOUBLE: {
                this.chunkWriters.get(measurementId).write(tablet.timestamps, (double[])tablet.values[index], batchSize);
                break;
            }
            case BOOLEAN: {
                this.chunkWriters.get(measurementId).write(tablet.timestamps, (boolean[])tablet.values[index], batchSize);
                break;
            }
            case TEXT: {
                this.chunkWriters.get(measurementId).write(tablet.timestamps, (Binary[])tablet.values[index], batchSize);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", new Object[]{dataType}));
            }
        }
    }

    @Override
    public long flushToFileWriter(TsFileIOWriter fileWriter) throws IOException {
        LOG.debug("start flush device id:{}", (Object)this.deviceId);
        this.sealAllChunks();
        long currentChunkGroupSize = this.getCurrentChunkGroupSize();
        for (IChunkWriter seriesWriter : this.chunkWriters.values()) {
            seriesWriter.writeToFileWriter(fileWriter);
        }
        return currentChunkGroupSize;
    }

    @Override
    public long updateMaxGroupMemSize() {
        long bufferSize = 0L;
        for (IChunkWriter seriesWriter : this.chunkWriters.values()) {
            bufferSize += seriesWriter.estimateMaxSeriesMemSize();
        }
        return bufferSize;
    }

    @Override
    public long getCurrentChunkGroupSize() {
        long size = 0L;
        for (IChunkWriter writer : this.chunkWriters.values()) {
            size += writer.getCurrentChunkSize();
        }
        return size;
    }

    private void sealAllChunks() {
        for (IChunkWriter writer : this.chunkWriters.values()) {
            writer.sealCurrentPage();
        }
    }

    @Override
    public int getSeriesNumber() {
        return this.chunkWriters.size();
    }
}

