/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.v1.file.metadata;

import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.v1.file.metadata.TsDigestV1;
import org.apache.iotdb.tsfile.v1.file.metadata.statistics.StatisticsV1;

public class ChunkMetadataV1 {
    private String measurementUid;
    private long offsetOfChunkHeader;
    private long numOfPoints;
    private long startTime;
    private long endTime;
    private TSDataType tsDataType;
    private long version;
    private TsDigestV1 valuesStatistics;

    private ChunkMetadataV1() {
    }

    public static ChunkMetadataV1 deserializeFrom(ByteBuffer buffer) {
        ChunkMetadataV1 chunkMetaData = new ChunkMetadataV1();
        chunkMetaData.measurementUid = ReadWriteIOUtils.readString(buffer);
        chunkMetaData.offsetOfChunkHeader = ReadWriteIOUtils.readLong(buffer);
        chunkMetaData.numOfPoints = ReadWriteIOUtils.readLong(buffer);
        chunkMetaData.startTime = ReadWriteIOUtils.readLong(buffer);
        chunkMetaData.endTime = ReadWriteIOUtils.readLong(buffer);
        chunkMetaData.tsDataType = ReadWriteIOUtils.readDataType(buffer);
        chunkMetaData.valuesStatistics = TsDigestV1.deserializeFrom(buffer);
        return chunkMetaData;
    }

    public long getNumOfPoints() {
        return this.numOfPoints;
    }

    public ChunkMetadata upgradeToChunkMetadata() {
        Statistics statistics = StatisticsV1.constructStatisticsFromOldChunkMetadata(this);
        ChunkMetadata chunkMetadata = new ChunkMetadata(this.measurementUid, this.tsDataType, this.offsetOfChunkHeader, statistics);
        chunkMetadata.setFromOldTsFile(true);
        return chunkMetadata;
    }

    public long getOffsetOfChunkHeader() {
        return this.offsetOfChunkHeader;
    }

    public String getMeasurementUid() {
        return this.measurementUid;
    }

    public TsDigestV1 getDigest() {
        return this.valuesStatistics;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public TSDataType getTsDataType() {
        return this.tsDataType;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }
}

