/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.reader;

import java.io.IOException;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.reader.IPointReader;

public class BatchDataIterator
implements IPointReader {
    private BatchData batchData;

    public BatchDataIterator(BatchData batchData) {
        this.batchData = batchData;
    }

    @Override
    public boolean hasNextTimeValuePair() {
        return this.batchData.hasCurrent();
    }

    @Override
    public TimeValuePair nextTimeValuePair() {
        TimeValuePair timeValuePair = new TimeValuePair(this.batchData.currentTime(), this.batchData.currentTsPrimitiveType());
        this.batchData.next();
        return timeValuePair;
    }

    @Override
    public TimeValuePair currentTimeValuePair() {
        return new TimeValuePair(this.batchData.currentTime(), this.batchData.currentTsPrimitiveType());
    }

    @Override
    public void close() throws IOException {
        this.batchData = null;
    }
}

