/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.query.dataset;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;

public abstract class QueryDataSet {
    protected List<Path> paths;
    protected List<TSDataType> dataTypes;
    protected int rowLimit = 0;
    protected int rowOffset = 0;
    protected int alreadyReturnedRowNum = 0;
    protected boolean ascending;

    public QueryDataSet() {
    }

    public QueryDataSet(List<Path> paths, List<TSDataType> dataTypes) {
        this.paths = paths;
        this.dataTypes = dataTypes;
        this.ascending = true;
    }

    public QueryDataSet(List<Path> paths, List<TSDataType> dataTypes, boolean ascending) {
        this.paths = paths;
        this.dataTypes = dataTypes;
        this.ascending = ascending;
    }

    public boolean hasNext() throws IOException {
        while (this.rowOffset > 0) {
            if (this.hasNextWithoutConstraint()) {
                this.nextWithoutConstraint();
                --this.rowOffset;
                continue;
            }
            return false;
        }
        if (this.rowLimit > 0 && this.alreadyReturnedRowNum >= this.rowLimit) {
            return false;
        }
        return this.hasNextWithoutConstraint();
    }

    protected abstract boolean hasNextWithoutConstraint() throws IOException;

    public RowRecord next() throws IOException {
        if (this.rowLimit > 0) {
            ++this.alreadyReturnedRowNum;
        }
        return this.nextWithoutConstraint();
    }

    protected abstract RowRecord nextWithoutConstraint() throws IOException;

    public List<Path> getPaths() {
        return this.paths;
    }

    public List<TSDataType> getDataTypes() {
        return this.dataTypes;
    }

    public void setDataTypes(List<TSDataType> dataTypes) {
        this.dataTypes = dataTypes;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    public int getRowOffset() {
        return this.rowOffset;
    }

    public void setRowOffset(int rowOffset) {
        this.rowOffset = rowOffset;
    }

    public boolean hasLimit() {
        return this.rowLimit > 0;
    }
}

