/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Field;

public class RowRecord {
    private long timestamp;
    private List<Field> fields;

    public RowRecord(long timestamp) {
        this.timestamp = timestamp;
        this.fields = new ArrayList<Field>();
    }

    public RowRecord(long timestamp, List<Field> fields) {
        this.timestamp = timestamp;
        this.fields = fields;
    }

    public void addField(Field f) {
        this.fields.add(f);
    }

    public void addField(Object value, TSDataType dataType) {
        this.fields.add(Field.getField(value, dataType));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.timestamp);
        for (Field f : this.fields) {
            sb.append("\t");
            sb.append(f);
        }
        return sb.toString();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public void setField(int index, Field field) {
        this.fields.set(index, field);
    }
}

