/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.encoding.decoder;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.encoding.common.EndianType;
import org.apache.iotdb.tsfile.encoding.decoder.DeltaBinaryDecoder;
import org.apache.iotdb.tsfile.encoding.decoder.DoublePrecisionDecoderV1;
import org.apache.iotdb.tsfile.encoding.decoder.DoublePrecisionDecoderV2;
import org.apache.iotdb.tsfile.encoding.decoder.FloatDecoder;
import org.apache.iotdb.tsfile.encoding.decoder.IntGorillaDecoder;
import org.apache.iotdb.tsfile.encoding.decoder.IntRleDecoder;
import org.apache.iotdb.tsfile.encoding.decoder.LongGorillaDecoder;
import org.apache.iotdb.tsfile.encoding.decoder.LongRleDecoder;
import org.apache.iotdb.tsfile.encoding.decoder.PlainDecoder;
import org.apache.iotdb.tsfile.encoding.decoder.RegularDataDecoder;
import org.apache.iotdb.tsfile.encoding.decoder.SinglePrecisionDecoderV1;
import org.apache.iotdb.tsfile.encoding.decoder.SinglePrecisionDecoderV2;
import org.apache.iotdb.tsfile.exception.encoding.TsFileDecodingException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Binary;

public abstract class Decoder {
    private static final String ERROR_MSG = "Decoder not found: %s , DataType is : %s";
    private TSEncoding type;

    public Decoder(TSEncoding type) {
        this.type = type;
    }

    public void setType(TSEncoding type) {
        this.type = type;
    }

    public TSEncoding getType() {
        return this.type;
    }

    public static Decoder getDecoderByType(TSEncoding encoding, TSDataType dataType) {
        switch (encoding) {
            case PLAIN: {
                return new PlainDecoder(EndianType.BIG_ENDIAN);
            }
            case RLE: {
                switch (dataType) {
                    case BOOLEAN: 
                    case INT32: {
                        return new IntRleDecoder(EndianType.BIG_ENDIAN);
                    }
                    case INT64: {
                        return new LongRleDecoder(EndianType.BIG_ENDIAN);
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        return new FloatDecoder(TSEncoding.valueOf(encoding.toString()), dataType);
                    }
                }
                throw new TsFileDecodingException(String.format(ERROR_MSG, new Object[]{encoding, dataType}));
            }
            case TS_2DIFF: {
                switch (dataType) {
                    case INT32: {
                        return new DeltaBinaryDecoder.IntDeltaDecoder();
                    }
                    case INT64: {
                        return new DeltaBinaryDecoder.LongDeltaDecoder();
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        return new FloatDecoder(TSEncoding.valueOf(encoding.toString()), dataType);
                    }
                }
                throw new TsFileDecodingException(String.format(ERROR_MSG, new Object[]{encoding, dataType}));
            }
            case GORILLA_V1: {
                switch (dataType) {
                    case FLOAT: {
                        return new SinglePrecisionDecoderV1();
                    }
                    case DOUBLE: {
                        return new DoublePrecisionDecoderV1();
                    }
                }
                throw new TsFileDecodingException(String.format(ERROR_MSG, new Object[]{encoding, dataType}));
            }
            case REGULAR: {
                switch (dataType) {
                    case INT32: {
                        return new RegularDataDecoder.IntRegularDecoder();
                    }
                    case INT64: {
                        return new RegularDataDecoder.LongRegularDecoder();
                    }
                }
                throw new TsFileDecodingException(String.format(ERROR_MSG, new Object[]{encoding, dataType}));
            }
            case GORILLA: {
                switch (dataType) {
                    case FLOAT: {
                        return new SinglePrecisionDecoderV2();
                    }
                    case DOUBLE: {
                        return new DoublePrecisionDecoderV2();
                    }
                    case INT32: {
                        return new IntGorillaDecoder();
                    }
                    case INT64: {
                        return new LongGorillaDecoder();
                    }
                }
                throw new TsFileDecodingException(String.format(ERROR_MSG, new Object[]{encoding, dataType}));
            }
        }
        throw new TsFileDecodingException(String.format(ERROR_MSG, new Object[]{encoding, dataType}));
    }

    public int readInt(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readInt is not supported by Decoder");
    }

    public boolean readBoolean(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readBoolean is not supported by Decoder");
    }

    public short readShort(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readShort is not supported by Decoder");
    }

    public long readLong(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readLong is not supported by Decoder");
    }

    public float readFloat(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readFloat is not supported by Decoder");
    }

    public double readDouble(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readDouble is not supported by Decoder");
    }

    public Binary readBinary(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readBinary is not supported by Decoder");
    }

    public BigDecimal readBigDecimal(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readBigDecimal is not supported by Decoder");
    }

    public abstract boolean hasNext(ByteBuffer var1) throws IOException;

    public abstract void reset();
}

