/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker;

import io.moquette.broker.Utils;
import io.moquette.broker.security.IAuthorizatorPolicy;
import io.moquette.broker.subscriptions.Topic;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Authorizator {
    private static final Logger LOG = LoggerFactory.getLogger(Authorizator.class);
    private final IAuthorizatorPolicy policy;

    Authorizator(IAuthorizatorPolicy policy) {
        this.policy = policy;
    }

    List<MqttTopicSubscription> verifyTopicsReadAccess(String clientID, String username, MqttSubscribeMessage msg) {
        ArrayList<MqttTopicSubscription> ackTopics = new ArrayList<MqttTopicSubscription>();
        int messageId = Utils.messageId((MqttMessage)msg);
        for (MqttTopicSubscription req : msg.payload().topicSubscriptions()) {
            MqttQoS qos;
            Topic topic = new Topic(req.topicName());
            if (!this.policy.canRead(topic, username, clientID)) {
                LOG.warn("Client does not have read permissions on the topic CId={}, username: {}, messageId: {}, topic: {}", new Object[]{clientID, username, messageId, topic});
                ackTopics.add(new MqttTopicSubscription(topic.toString(), MqttQoS.FAILURE));
                continue;
            }
            if (topic.isValid()) {
                LOG.debug("Client will be subscribed to the topic CId={}, username: {}, messageId: {}, topic: {}", new Object[]{clientID, username, messageId, topic});
                qos = req.qualityOfService();
            } else {
                LOG.warn("Topic filter is not valid CId={}, username: {}, messageId: {}, topic: {}", new Object[]{clientID, username, messageId, topic});
                qos = MqttQoS.FAILURE;
            }
            ackTopics.add(new MqttTopicSubscription(topic.toString(), qos));
        }
        return ackTopics;
    }

    boolean canWrite(Topic topic, String user, String client) {
        return this.policy.canWrite(topic, user, client);
    }

    boolean canRead(Topic topic, String user, String client) {
        return this.policy.canRead(topic, user, client);
    }
}

