/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.File;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.sync.conf.SyncSenderDescriptor;

public class SyncUtils {
    private static final String IP_SEPARATOR = "\\.";

    private SyncUtils() {
    }

    public static File getSnapshotFile(File file) {
        String relativeFilePath = file.getParentFile().getName() + File.separator + file.getName();
        String snapshotDir = SyncSenderDescriptor.getInstance().getConfig().getSnapshotPath();
        if (!new File(snapshotDir).exists()) {
            new File(snapshotDir).mkdirs();
        }
        return new File(snapshotDir, relativeFilePath);
    }

    public static boolean isEmpty(Map<String, Map<Long, Set<File>>> sendingFileList) {
        for (Map.Entry<String, Map<Long, Set<File>>> entry : sendingFileList.entrySet()) {
            for (Map.Entry<Long, Set<File>> innerEntry : entry.getValue().entrySet()) {
                if (innerEntry.getValue().isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean verifyIPSegment(String ipWhiteList, String ipAddress) {
        String[] ipSegments;
        for (String IPsegment : ipSegments = ipWhiteList.split(",")) {
            int subnetMask = Integer.parseInt(IPsegment.substring(IPsegment.indexOf(47) + 1));
            if (!SyncUtils.verifyIP(IPsegment = IPsegment.substring(0, IPsegment.indexOf(47)), ipAddress, subnetMask)) continue;
            return true;
        }
        return false;
    }

    private static boolean verifyIP(String ipSegment, String ipAddress, int subnetMark) {
        String[] ipSplits = ipSegment.split(IP_SEPARATOR);
        DecimalFormat df = new DecimalFormat("00000000");
        StringBuilder ipSegmentBuilder = new StringBuilder();
        for (String IPsplit : ipSplits) {
            ipSegmentBuilder.append(df.format(Integer.parseInt(Integer.toBinaryString(Integer.parseInt(IPsplit)))));
        }
        String ipSegmentBinary = ipSegmentBuilder.toString();
        ipSegmentBinary = ipSegmentBinary.substring(0, subnetMark);
        ipSplits = ipAddress.split(IP_SEPARATOR);
        StringBuilder ipAddressBuilder = new StringBuilder();
        for (String IPsplit : ipSplits) {
            ipAddressBuilder.append(df.format(Integer.parseInt(Integer.toBinaryString(Integer.parseInt(IPsplit)))));
        }
        String ipAddressBinary = ipAddressBuilder.toString();
        ipAddressBinary = ipAddressBinary.substring(0, subnetMark);
        return ipAddressBinary.equals(ipSegmentBinary);
    }
}

