/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static Logger logger = LoggerFactory.getLogger(FileUtils.class);

    private FileUtils() {
    }

    public static void deleteDirectory(File folder) throws IOException {
        if (folder.isDirectory()) {
            for (File file : folder.listFiles()) {
                FileUtils.deleteDirectory(file);
            }
        }
        try {
            Files.delete(folder.toPath());
        }
        catch (DirectoryNotEmptyException | NoSuchFileException e) {
            logger.warn("{}: {}", new Object[]{e.getMessage(), Arrays.toString(folder.list()), e});
        }
        catch (Exception e) {
            logger.warn("{}: {}", new Object[]{e.getMessage(), folder.getName(), e});
        }
    }
}

