/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.vis;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.iotdb.tsfile.file.metadata.ChunkGroupMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.utils.Pair;

public class TsFileExtractVisdata {
    public static String seqFileNameSuffix = "(seque)";
    public static String unseqFileNameSuffix = "(unseq)";

    public static void main(String[] args) throws IOException {
        int M = args.length;
        if (M % 2 == 0) {
            throw new IOException("2N+1 args should be:[path1 seqIndicator1 path2 seqIndicator2 ... pathN seqIndicatorN outputPath]");
        }
        ArrayList<String> inputPathList = new ArrayList<String>();
        ArrayList<Boolean> seqIndicatorList = new ArrayList<Boolean>();
        for (int i = 0; i < M - 1; i += 2) {
            inputPathList.add(args[i]);
            String indicator = args[i + 1].toLowerCase();
            if (!indicator.equals("true") && !indicator.equals("false")) {
                throw new IOException("seqIndicator should be 'true' or 'false' (not case sensitive).");
            }
            seqIndicatorList.add(Boolean.parseBoolean(args[i + 1]));
        }
        String outputPath = args[M - 1];
        try (PrintWriter pw = new PrintWriter(new FileWriter(outputPath));){
            int idx = 0;
            for (String inputPath : inputPathList) {
                boolean isSeq = (Boolean)seqIndicatorList.get(idx++);
                List<String> filelist = new ArrayList<String>();
                filelist = TsFileExtractVisdata.getFile(inputPath, filelist);
                for (String f : filelist) {
                    System.out.println(f);
                    File file = new File(f);
                    String fileName = file.getName();
                    String fileNameForVis = isSeq ? fileName + seqFileNameSuffix : fileName + unseqFileNameSuffix;
                    try (TsFileSequenceReader reader = new TsFileSequenceReader(f);){
                        ArrayList allChunkGroupMetadata = new ArrayList();
                        ArrayList versionInfo = new ArrayList();
                        reader.selfCheck(null, allChunkGroupMetadata, versionInfo, false);
                        TreeMap<Long, Long> versionMap = new TreeMap<Long, Long>();
                        for (Pair versionPair : versionInfo) {
                            versionMap.put((Long)versionPair.left - 8L - 1L, (Long)versionPair.right);
                        }
                        Set entrySet = versionMap.entrySet();
                        Iterator itr = entrySet.iterator();
                        Long currVersionPos = null;
                        Long currVersion = null;
                        for (ChunkGroupMetadata chunkGroupMetadata : allChunkGroupMetadata) {
                            List chunkMetadataList = chunkGroupMetadata.getChunkMetadataList();
                            for (ChunkMetadata chunkMetadata : chunkMetadataList) {
                                String tsName = chunkGroupMetadata.getDevice() + "." + chunkMetadata.getMeasurementUid();
                                long startTime = chunkMetadata.getStartTime();
                                long endTime = chunkMetadata.getEndTime();
                                long countNum = chunkMetadata.getStatistics().getCount();
                                long versionNum = -1L;
                                if (!versionMap.isEmpty()) {
                                    long offsetOfChunkHeader = chunkMetadata.getOffsetOfChunkHeader();
                                    if (currVersionPos == null || offsetOfChunkHeader > currVersionPos) {
                                        if (itr.hasNext()) {
                                            Map.Entry v = itr.next();
                                            currVersionPos = (Long)v.getKey();
                                            currVersion = (Long)v.getValue();
                                        } else {
                                            throw new IOException(String.format("Something is wrong with the tsfile %s, because there is a chunk with no version after it when there should be.", f));
                                        }
                                    }
                                    versionNum = currVersion;
                                }
                                TsFileExtractVisdata.printlnBoth(pw, String.format("%s,%s,%d,%d,%d,%d", tsName, fileNameForVis, versionNum, startTime, endTime, countNum));
                            }
                        }
                    }
                }
            }
        }
    }

    private static List<String> getFile(String path, List<String> filelist) {
        File file = new File(path);
        File[] array = file.listFiles();
        if (array == null) {
            filelist.add(path);
            return filelist;
        }
        for (File value : array) {
            if (value.isFile()) {
                String filePath = value.getPath();
                if (!filePath.endsWith(".tsfile")) continue;
                filelist.add(value.getPath());
                continue;
            }
            if (!value.isDirectory()) continue;
            TsFileExtractVisdata.getFile(value.getPath(), filelist);
        }
        return filelist;
    }

    private static void printlnBoth(PrintWriter pw, String str) {
        System.out.println(str);
        pw.println(str);
    }
}

