/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.rescon;

import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ExecutorService;
import org.apache.iotdb.db.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupInfo;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;
import org.apache.iotdb.db.exception.WriteProcessRejectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemInfo {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final Logger logger = LoggerFactory.getLogger(SystemInfo.class);
    private long totalStorageGroupMemCost = 0L;
    private ExecutorService flushTaskSubmitThreadPool = IoTDBThreadPoolFactory.newSingleThreadExecutor("FlushTask-Submit-Pool");
    private volatile boolean rejected = false;
    private Map<StorageGroupInfo, Long> reportedStorageGroupMemCostMap = new HashMap<StorageGroupInfo, Long>();
    private long flushingMemTablesCost = 0L;
    private static final double FLUSH_THERSHOLD = (double)config.getAllocateMemoryForWrite() * config.getFlushProportion();
    private static final double REJECT_THERSHOLD = (double)config.getAllocateMemoryForWrite() * config.getRejectProportion();

    public synchronized boolean reportStorageGroupStatus(StorageGroupInfo storageGroupInfo, TsFileProcessor tsFileProcessor) throws WriteProcessRejectException {
        long delta = storageGroupInfo.getMemCost() - this.reportedStorageGroupMemCostMap.getOrDefault(storageGroupInfo, 0L);
        this.totalStorageGroupMemCost += delta;
        if (logger.isDebugEnabled()) {
            logger.debug("Report Storage Group Status to the system. After adding {}, current sg mem cost is {}.", (Object)delta, (Object)this.totalStorageGroupMemCost);
        }
        this.reportedStorageGroupMemCostMap.put(storageGroupInfo, storageGroupInfo.getMemCost());
        storageGroupInfo.setLastReportedSize(storageGroupInfo.getMemCost());
        if ((double)this.totalStorageGroupMemCost < FLUSH_THERSHOLD) {
            return true;
        }
        if ((double)this.totalStorageGroupMemCost >= FLUSH_THERSHOLD && (double)this.totalStorageGroupMemCost < REJECT_THERSHOLD) {
            logger.debug("The total storage group mem costs are too large, call for flushing. Current sg cost is {}", (Object)this.totalStorageGroupMemCost);
            this.chooseMemTablesToMarkFlush(tsFileProcessor);
            return true;
        }
        this.rejected = true;
        if (this.chooseMemTablesToMarkFlush(tsFileProcessor)) {
            if (this.totalStorageGroupMemCost < config.getAllocateMemoryForWrite()) {
                return true;
            }
            throw new WriteProcessRejectException("Total Storage Group MemCost " + this.totalStorageGroupMemCost + " is over than memorySizeForWriting " + config.getAllocateMemoryForWrite());
        }
        return false;
    }

    public synchronized void resetStorageGroupStatus(StorageGroupInfo storageGroupInfo) {
        long delta = 0L;
        if (this.reportedStorageGroupMemCostMap.containsKey(storageGroupInfo)) {
            delta = this.reportedStorageGroupMemCostMap.get(storageGroupInfo) - storageGroupInfo.getMemCost();
            this.totalStorageGroupMemCost -= delta;
            storageGroupInfo.setLastReportedSize(storageGroupInfo.getMemCost());
            this.reportedStorageGroupMemCostMap.put(storageGroupInfo, storageGroupInfo.getMemCost());
        }
        if ((double)this.totalStorageGroupMemCost >= FLUSH_THERSHOLD && (double)this.totalStorageGroupMemCost < REJECT_THERSHOLD) {
            logger.debug("SG ({}) released memory (delta: {}) but still exceeding flush proportion (totalSgMemCost: {}), call flush.", new Object[]{storageGroupInfo.getStorageGroupProcessor().getStorageGroupName(), delta, this.totalStorageGroupMemCost});
            if (this.rejected) {
                logger.info("SG ({}) released memory (delta: {}), set system to normal status (totalSgMemCost: {}).", new Object[]{storageGroupInfo.getStorageGroupProcessor().getStorageGroupName(), delta, this.totalStorageGroupMemCost});
            }
            this.logCurrentTotalSGMemory();
            this.rejected = false;
        } else if ((double)this.totalStorageGroupMemCost >= REJECT_THERSHOLD) {
            logger.warn("SG ({}) released memory (delta: {}), but system is still in reject status (totalSgMemCost: {}).", new Object[]{storageGroupInfo.getStorageGroupProcessor().getStorageGroupName(), delta, this.totalStorageGroupMemCost});
            this.logCurrentTotalSGMemory();
            this.rejected = true;
        } else {
            logger.debug("SG ({}) released memory (delta: {}), system is in normal status (totalSgMemCost: {}).", new Object[]{storageGroupInfo.getStorageGroupProcessor().getStorageGroupName(), delta, this.totalStorageGroupMemCost});
            this.logCurrentTotalSGMemory();
            this.rejected = false;
        }
    }

    private void logCurrentTotalSGMemory() {
        logger.debug("Current Sg cost is {}", (Object)this.totalStorageGroupMemCost);
    }

    public synchronized void addFlushingMemTableCost(long flushingMemTableCost) {
        this.flushingMemTablesCost += flushingMemTableCost;
    }

    public synchronized void resetFlushingMemTableCost(long flushingMemTableCost) {
        this.flushingMemTablesCost -= flushingMemTableCost;
    }

    private boolean chooseMemTablesToMarkFlush(TsFileProcessor currentTsFileProcessor) {
        if (this.reportedStorageGroupMemCostMap.size() == 0) {
            return false;
        }
        PriorityQueue<TsFileProcessor> allTsFileProcessors = new PriorityQueue<TsFileProcessor>((o1, o2) -> Long.compare(o2.getWorkMemTableRamCost(), o1.getWorkMemTableRamCost()));
        for (StorageGroupInfo storageGroupInfo : this.reportedStorageGroupMemCostMap.keySet()) {
            allTsFileProcessors.addAll(storageGroupInfo.getAllReportedTsp());
        }
        boolean isCurrentTsFileProcessorSelected = false;
        long memCost = 0L;
        long activeMemSize = this.totalStorageGroupMemCost - this.flushingMemTablesCost;
        while ((double)(activeMemSize - memCost) > FLUSH_THERSHOLD) {
            if (allTsFileProcessors.isEmpty() || ((TsFileProcessor)allTsFileProcessors.peek()).getWorkMemTableRamCost() == 0L) {
                return isCurrentTsFileProcessorSelected;
            }
            TsFileProcessor selectedTsFileProcessor = (TsFileProcessor)allTsFileProcessors.peek();
            memCost += selectedTsFileProcessor.getWorkMemTableRamCost();
            selectedTsFileProcessor.setWorkMemTableShouldFlush();
            this.flushTaskSubmitThreadPool.submit(() -> selectedTsFileProcessor.submitAFlushTask());
            if (selectedTsFileProcessor == currentTsFileProcessor) {
                isCurrentTsFileProcessorSelected = true;
            }
            allTsFileProcessors.poll();
        }
        return isCurrentTsFileProcessorSelected;
    }

    public boolean isRejected() {
        return this.rejected;
    }

    public void close() {
        this.reportedStorageGroupMemCostMap.clear();
        this.totalStorageGroupMemCost = 0L;
        this.rejected = false;
    }

    public static SystemInfo getInstance() {
        return InstanceHolder.instance;
    }

    private static class InstanceHolder {
        private static SystemInfo instance = new SystemInfo();

        private InstanceHolder() {
        }
    }
}

