/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.auth.entity;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.auth.entity.PrivilegeType;
import org.apache.iotdb.db.utils.SerializeUtils;

public class PathPrivilege {
    private Set<Integer> privileges;
    private String path;
    private AtomicInteger referenceCnt = new AtomicInteger(0);
    public static final Comparator<PathPrivilege> REFERENCE_DESCENT_SORTER = (o1, o2) -> -Integer.compare(o1.referenceCnt.get(), o2.referenceCnt.get());

    public PathPrivilege() {
    }

    public PathPrivilege(String path) {
        this.path = path;
        this.privileges = new HashSet<Integer>();
    }

    public Set<Integer> getPrivileges() {
        return this.privileges;
    }

    public void setPrivileges(Set<Integer> privileges) {
        this.privileges = privileges;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public AtomicInteger getReferenceCnt() {
        return this.referenceCnt;
    }

    public void setReferenceCnt(AtomicInteger referenceCnt) {
        this.referenceCnt = referenceCnt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathPrivilege that = (PathPrivilege)o;
        return Objects.equals(this.privileges, that.privileges) && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.privileges, this.path);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.path);
        builder.append(" :");
        for (Integer privilegeId : this.privileges) {
            builder.append(" ").append((Object)PrivilegeType.values()[privilegeId]);
        }
        return builder.toString();
    }

    public ByteBuffer serialize() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        SerializeUtils.serialize(this.privileges, dataOutputStream);
        SerializeUtils.serialize(this.path, dataOutputStream);
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    public void deserialize(ByteBuffer buffer) {
        this.privileges = new HashSet<Integer>();
        SerializeUtils.deserialize(this.privileges, buffer);
        this.path = SerializeUtils.deserializeString(buffer);
    }
}

