/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.auth.authorizer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.auth.AuthException;
import org.apache.iotdb.db.auth.authorizer.IAuthorizer;
import org.apache.iotdb.db.auth.entity.PrivilegeType;
import org.apache.iotdb.db.auth.entity.Role;
import org.apache.iotdb.db.auth.entity.User;
import org.apache.iotdb.db.auth.role.IRoleManager;
import org.apache.iotdb.db.auth.user.IUserManager;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.ServiceType;
import org.apache.iotdb.db.utils.AuthUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicAuthorizer
implements IAuthorizer,
IService {
    private static final Logger logger = LoggerFactory.getLogger(BasicAuthorizer.class);
    private static final Set<Integer> ADMIN_PRIVILEGES = new HashSet<Integer>();
    private static final String NO_SUCH_ROLE_EXCEPTION = "No such role : %s";
    private static final String NO_SUCH_USER_EXCEPTION = "No such user : %s";
    IUserManager userManager;
    IRoleManager roleManager;

    BasicAuthorizer(IUserManager userManager, IRoleManager roleManager) throws AuthException {
        this.userManager = userManager;
        this.roleManager = roleManager;
        this.init();
    }

    protected void init() throws AuthException {
        this.userManager.reset();
        this.roleManager.reset();
        logger.info("Initialization of Authorizer completes");
    }

    public static IAuthorizer getInstance() throws AuthException {
        if (InstanceHolder.instance == null) {
            throw new AuthException("Authorizer uninitialized");
        }
        return InstanceHolder.instance;
    }

    abstract boolean isAdmin(String var1);

    @Override
    public boolean login(String username, String password) throws AuthException {
        User user = this.userManager.getUser(username);
        return user != null && password != null && user.getPassword().equals(AuthUtils.encryptPassword(password));
    }

    @Override
    public void createUser(String username, String password) throws AuthException {
        if (!this.userManager.createUser(username, password)) {
            throw new AuthException(String.format("User %s already exists", username));
        }
    }

    @Override
    public void deleteUser(String username) throws AuthException {
        if (this.isAdmin(username)) {
            throw new AuthException("Default administrator cannot be deleted");
        }
        if (!this.userManager.deleteUser(username)) {
            throw new AuthException(String.format("User %s does not exist", username));
        }
    }

    @Override
    public void grantPrivilegeToUser(String username, String path, int privilegeId) throws AuthException {
        String newPath = path;
        if (this.isAdmin(username)) {
            throw new AuthException("Invalid operation, administrator already has all privileges");
        }
        if (!PrivilegeType.isPathRelevant(privilegeId)) {
            newPath = "root";
        }
        if (!this.userManager.grantPrivilegeToUser(username, newPath, privilegeId)) {
            throw new AuthException(String.format("User %s already has %s on %s", new Object[]{username, PrivilegeType.values()[privilegeId], path}));
        }
    }

    @Override
    public void revokePrivilegeFromUser(String username, String path, int privilegeId) throws AuthException {
        if (this.isAdmin(username)) {
            throw new AuthException("Invalid operation, administrator must have all privileges");
        }
        String p = path;
        if (!PrivilegeType.isPathRelevant(privilegeId)) {
            p = "root";
        }
        if (!this.userManager.revokePrivilegeFromUser(username, p, privilegeId)) {
            throw new AuthException(String.format("User %s does not have %s on %s", new Object[]{username, PrivilegeType.values()[privilegeId], path}));
        }
    }

    @Override
    public void createRole(String roleName) throws AuthException {
        if (!this.roleManager.createRole(roleName)) {
            throw new AuthException(String.format("Role %s already exists", roleName));
        }
    }

    @Override
    public void deleteRole(String roleName) throws AuthException {
        boolean success = this.roleManager.deleteRole(roleName);
        if (!success) {
            throw new AuthException(String.format("Role %s does not exist", roleName));
        }
        List<String> users = this.userManager.listAllUsers();
        for (String user : users) {
            try {
                this.userManager.revokeRoleFromUser(roleName, user);
            }
            catch (AuthException e) {
                logger.warn("Error encountered when revoking a role {} from user {} after deletion, because {}", new Object[]{roleName, user, e});
            }
        }
    }

    @Override
    public void grantPrivilegeToRole(String roleName, String path, int privilegeId) throws AuthException {
        String p = path;
        if (!PrivilegeType.isPathRelevant(privilegeId)) {
            p = "root";
        }
        if (!this.roleManager.grantPrivilegeToRole(roleName, p, privilegeId)) {
            throw new AuthException(String.format("Role %s already has %s on %s", new Object[]{roleName, PrivilegeType.values()[privilegeId], path}));
        }
    }

    @Override
    public void revokePrivilegeFromRole(String roleName, String path, int privilegeId) throws AuthException {
        String p = path;
        if (!PrivilegeType.isPathRelevant(privilegeId)) {
            p = "root";
        }
        if (!this.roleManager.revokePrivilegeFromRole(roleName, p, privilegeId)) {
            throw new AuthException(String.format("Role %s does not have %s on %s", new Object[]{roleName, PrivilegeType.values()[privilegeId], path}));
        }
    }

    @Override
    public void grantRoleToUser(String roleName, String username) throws AuthException {
        Role role = this.roleManager.getRole(roleName);
        if (role == null) {
            throw new AuthException(String.format(NO_SUCH_ROLE_EXCEPTION, roleName));
        }
        boolean success = this.userManager.grantRoleToUser(roleName, username);
        if (success) {
            role = this.roleManager.getRole(roleName);
            if (role == null) {
                throw new AuthException(String.format(NO_SUCH_ROLE_EXCEPTION, roleName));
            }
        } else {
            throw new AuthException(String.format("User %s already has role %s", username, roleName));
        }
    }

    @Override
    public void revokeRoleFromUser(String roleName, String username) throws AuthException {
        Role role = this.roleManager.getRole(roleName);
        if (role == null) {
            throw new AuthException(String.format(NO_SUCH_ROLE_EXCEPTION, roleName));
        }
        if (!this.userManager.revokeRoleFromUser(roleName, username)) {
            throw new AuthException(String.format("User %s does not have role %s", username, roleName));
        }
    }

    @Override
    public Set<Integer> getPrivileges(String username, String path) throws AuthException {
        if (this.isAdmin(username)) {
            return ADMIN_PRIVILEGES;
        }
        User user = this.userManager.getUser(username);
        if (user == null) {
            throw new AuthException(String.format(NO_SUCH_USER_EXCEPTION, username));
        }
        Set<Integer> privileges = user.getPrivileges(path);
        for (String roleName : user.getRoleList()) {
            Role role = this.roleManager.getRole(roleName);
            if (role == null) continue;
            privileges.addAll(role.getPrivileges(path));
        }
        return privileges;
    }

    @Override
    public void updateUserPassword(String username, String newPassword) throws AuthException {
        if (!this.userManager.updateUserPassword(username, newPassword)) {
            throw new AuthException("password " + newPassword + " is illegal");
        }
    }

    @Override
    public boolean checkUserPrivileges(String username, String path, int privilegeId) throws AuthException {
        if (this.isAdmin(username)) {
            return true;
        }
        User user = this.userManager.getUser(username);
        if (user == null) {
            throw new AuthException(String.format(NO_SUCH_USER_EXCEPTION, username));
        }
        if (user.checkPrivilege(path, privilegeId)) {
            return true;
        }
        for (String roleName : user.getRoleList()) {
            Role role = this.roleManager.getRole(roleName);
            if (!role.checkPrivilege(path, privilegeId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, Boolean> getAllUserWaterMarkStatus() {
        HashMap<String, Boolean> userWaterMarkStatus = new HashMap<String, Boolean>();
        List<String> allUsers = this.listAllUsers();
        for (String user : allUsers) {
            try {
                userWaterMarkStatus.put(user, this.isUserUseWaterMark(user));
            }
            catch (AuthException e) {
                logger.error(String.format(NO_SUCH_USER_EXCEPTION, user));
            }
        }
        return userWaterMarkStatus;
    }

    @Override
    public Map<String, User> getAllUsers() {
        HashMap<String, User> allUsers = new HashMap<String, User>();
        List<String> userNames = this.listAllUsers();
        for (String userName : userNames) {
            try {
                allUsers.put(userName, this.getUser(userName));
            }
            catch (AuthException e) {
                logger.error(String.format("get all users failed, No such user : %s", userName));
            }
        }
        return allUsers;
    }

    @Override
    public Map<String, Role> getAllRoles() {
        HashMap<String, Role> allRoles = new HashMap<String, Role>();
        List<String> roleNames = this.listAllRoles();
        for (String roleName : roleNames) {
            try {
                allRoles.put(roleName, this.getRole(roleName));
            }
            catch (AuthException e) {
                logger.error(String.format("get all roles failed, No such role : %s", roleName));
            }
        }
        return allRoles;
    }

    @Override
    public void reset() throws AuthException {
        this.init();
    }

    @Override
    public void start() throws StartupException {
        try {
            this.init();
        }
        catch (AuthException e) {
            throw new StartupException(e);
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public ServiceType getID() {
        return ServiceType.AUTHORIZATION_SERVICE;
    }

    @Override
    public List<String> listAllUsers() {
        return this.userManager.listAllUsers();
    }

    @Override
    public List<String> listAllRoles() {
        return this.roleManager.listAllRoles();
    }

    @Override
    public Role getRole(String roleName) throws AuthException {
        return this.roleManager.getRole(roleName);
    }

    @Override
    public User getUser(String username) throws AuthException {
        return this.userManager.getUser(username);
    }

    @Override
    public boolean isUserUseWaterMark(String userName) throws AuthException {
        return this.userManager.isUserUseWaterMark(userName);
    }

    @Override
    public void setUserUseWaterMark(String userName, boolean useWaterMark) throws AuthException {
        this.userManager.setUserUseWaterMark(userName, useWaterMark);
    }

    @Override
    public void replaceAllUsers(Map<String, User> users) throws AuthException {
        this.userManager.replaceAllUsers(users);
    }

    @Override
    public void replaceAllRoles(Map<String, Role> roles) throws AuthException {
        this.roleManager.replaceAllRoles(roles);
    }

    static {
        for (int i = 0; i < PrivilegeType.values().length; ++i) {
            ADMIN_PRIVILEGES.add(i);
        }
    }

    private static class InstanceHolder {
        private static IAuthorizer instance;

        private InstanceHolder() {
        }

        static {
            Class<?> c = null;
            try {
                c = Class.forName(IoTDBDescriptor.getInstance().getConfig().getAuthorizerProvider());
                logger.info("Authorizer provider class: {}", (Object)IoTDBDescriptor.getInstance().getConfig().getAuthorizerProvider());
                instance = (IAuthorizer)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                instance = null;
                throw new IllegalStateException("Authorizer could not be initialized!", e);
            }
        }
    }
}

