/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.writelog.recover;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.version.VersionController;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.exception.metadata.DataTypeMismatchException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.qp.physical.crud.UpdatePlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.writelog.io.ILogReader;
import org.apache.iotdb.db.writelog.manager.MultiFileLogNodeManager;
import org.apache.iotdb.db.writelog.node.WriteLogNode;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogReplayer {
    private Logger logger = LoggerFactory.getLogger(LogReplayer.class);
    private String logNodePrefix;
    private String insertFilePath;
    private ModificationFile modFile;
    private VersionController versionController;
    private TsFileResource currentTsFileResource;
    private IMemTable recoverMemTable;
    private boolean sequence;
    private Map<String, Long> tempStartTimeMap = new HashMap<String, Long>();
    private Map<String, Long> tempEndTimeMap = new HashMap<String, Long>();

    public LogReplayer(String logNodePrefix, String insertFilePath, ModificationFile modFile, VersionController versionController, TsFileResource currentTsFileResource, IMemTable memTable, boolean sequence) {
        this.logNodePrefix = logNodePrefix;
        this.insertFilePath = insertFilePath;
        this.modFile = modFile;
        this.versionController = versionController;
        this.currentTsFileResource = currentTsFileResource;
        this.recoverMemTable = memTable;
        this.sequence = sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void replayLogs() {
        WriteLogNode logNode = MultiFileLogNodeManager.getInstance().getNode(this.logNodePrefix + FSFactoryProducer.getFSFactory().getFile(this.insertFilePath).getName());
        ILogReader logReader = logNode.getLogReader();
        try {
            while (logReader.hasNext()) {
                try {
                    PhysicalPlan plan = logReader.next();
                    if (plan instanceof InsertPlan) {
                        this.replayInsert((InsertPlan)plan);
                        continue;
                    }
                    if (plan instanceof DeletePlan) {
                        this.replayDelete((DeletePlan)plan);
                        continue;
                    }
                    if (!(plan instanceof UpdatePlan)) continue;
                    this.replayUpdate((UpdatePlan)plan);
                }
                catch (PathNotExistException plan) {
                }
                catch (Exception e) {
                    this.logger.warn("recover wal of {} failed", (Object)this.insertFilePath, (Object)e);
                }
            }
        }
        catch (IOException e) {
            this.logger.warn("meet error when redo wal of {}", (Object)this.insertFilePath, (Object)e);
        }
        finally {
            logReader.close();
            try {
                this.modFile.close();
            }
            catch (IOException e) {
                this.logger.error("Cannot close the modifications file {}", (Object)this.modFile.getFilePath(), (Object)e);
            }
        }
        this.tempStartTimeMap.forEach((k, v) -> this.currentTsFileResource.updateStartTime((String)k, (long)v));
        this.tempEndTimeMap.forEach((k, v) -> this.currentTsFileResource.updateEndTime((String)k, (long)v));
    }

    private void replayDelete(DeletePlan deletePlan) throws IOException, MetadataException {
        List<PartialPath> paths = deletePlan.getPaths();
        for (PartialPath path : paths) {
            for (PartialPath device : IoTDB.metaManager.getDevices(path.getDevicePath())) {
                this.recoverMemTable.delete(path, device, deletePlan.getDeleteStartTime(), deletePlan.getDeleteEndTime());
            }
            this.modFile.write(new Deletion(path, this.versionController.nextVersion(), deletePlan.getDeleteStartTime(), deletePlan.getDeleteEndTime()));
        }
    }

    private void replayInsert(InsertPlan plan) throws WriteProcessException, QueryProcessException {
        MeasurementMNode[] mNodes;
        if (this.currentTsFileResource != null) {
            Long endTime;
            long maxTime;
            long minTime;
            if (plan instanceof InsertRowPlan) {
                minTime = ((InsertRowPlan)plan).getTime();
                maxTime = ((InsertRowPlan)plan).getTime();
            } else {
                minTime = ((InsertTabletPlan)plan).getMinTime();
                maxTime = ((InsertTabletPlan)plan).getMaxTime();
            }
            long lastEndTime = this.currentTsFileResource.getEndTime(plan.getDeviceId().getFullPath());
            if (lastEndTime != Long.MIN_VALUE && lastEndTime >= minTime && this.sequence) {
                return;
            }
            Long startTime = this.tempStartTimeMap.get(plan.getDeviceId().getFullPath());
            if (startTime == null || startTime > minTime) {
                this.tempStartTimeMap.put(plan.getDeviceId().getFullPath(), minTime);
            }
            if ((endTime = this.tempEndTimeMap.get(plan.getDeviceId().getFullPath())) == null || endTime < maxTime) {
                this.tempEndTimeMap.put(plan.getDeviceId().getFullPath(), maxTime);
            }
        }
        try {
            mNodes = IoTDB.metaManager.getMNodes(plan.getDeviceId(), plan.getMeasurements());
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        plan.setMeasurementMNodes(mNodes);
        this.checkDataTypeAndMarkFailed(mNodes, plan);
        if (plan instanceof InsertRowPlan) {
            this.recoverMemTable.insert((InsertRowPlan)plan);
        } else {
            this.recoverMemTable.insertTablet((InsertTabletPlan)plan, 0, ((InsertTabletPlan)plan).getRowCount());
        }
    }

    private void replayUpdate(UpdatePlan updatePlan) {
        throw new UnsupportedOperationException("Update not supported");
    }

    private void checkDataTypeAndMarkFailed(MeasurementMNode[] mNodes, InsertPlan tPlan) {
        for (int i = 0; i < mNodes.length; ++i) {
            if (mNodes[i] == null) {
                tPlan.markFailedMeasurementInsertion(i, new PathNotExistException(tPlan.getDeviceId().getFullPath() + '.' + tPlan.getMeasurements()[i]));
                continue;
            }
            if (mNodes[i].getSchema().getType() == tPlan.getDataTypes()[i]) continue;
            tPlan.markFailedMeasurementInsertion(i, new DataTypeMismatchException(mNodes[i].getName(), tPlan.getDataTypes()[i], mNodes[i].getSchema().getType()));
        }
    }
}

