/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.timegenerator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupProcessor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.reader.series.SeriesRawDataBatchReader;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.expression.ExpressionType;
import org.apache.iotdb.tsfile.read.expression.IBinaryExpression;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.SingleSeriesExpression;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.basic.UnaryFilter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterType;
import org.apache.iotdb.tsfile.read.filter.operator.AndFilter;
import org.apache.iotdb.tsfile.read.query.timegenerator.TimeGenerator;
import org.apache.iotdb.tsfile.read.reader.IBatchReader;

public class ServerTimeGenerator
extends TimeGenerator {
    protected QueryContext context;
    protected RawDataQueryPlan queryPlan;

    public ServerTimeGenerator(QueryContext context) {
        this.context = context;
    }

    public ServerTimeGenerator(IExpression expression, QueryContext context, RawDataQueryPlan queryPlan) throws StorageEngineException {
        this.context = context;
        this.queryPlan = queryPlan;
        try {
            this.serverConstructNode(expression);
        }
        catch (IOException e) {
            throw new StorageEngineException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serverConstructNode(IExpression expression) throws IOException, StorageEngineException {
        ArrayList<PartialPath> pathList = new ArrayList<PartialPath>();
        this.getPartialPathFromExpression(expression, pathList);
        List<StorageGroupProcessor> list = StorageEngine.getInstance().mergeLock(pathList);
        try {
            this.operatorNode = this.construct(expression);
        }
        finally {
            StorageEngine.getInstance().mergeUnLock(list);
        }
    }

    private void getPartialPathFromExpression(IExpression expression, List<PartialPath> pathList) {
        if (expression.getType() == ExpressionType.SERIES) {
            pathList.add((PartialPath)((SingleSeriesExpression)expression).getSeriesPath());
        } else {
            this.getPartialPathFromExpression(((IBinaryExpression)expression).getLeft(), pathList);
            this.getPartialPathFromExpression(((IBinaryExpression)expression).getRight(), pathList);
        }
    }

    protected IBatchReader generateNewBatchReader(SingleSeriesExpression expression) throws IOException {
        QueryDataSource queryDataSource;
        TSDataType dataType;
        Filter valueFilter = expression.getFilter();
        PartialPath path = (PartialPath)expression.getSeriesPath();
        try {
            dataType = IoTDB.metaManager.getSeriesType(path);
            queryDataSource = QueryResourceManager.getInstance().getQueryDataSource(path, this.context, valueFilter);
            valueFilter = queryDataSource.updateFilterUsingTTL(valueFilter);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        Filter timeFilter = this.getTimeFilter(valueFilter);
        return new SeriesRawDataBatchReader(path, this.queryPlan.getAllMeasurementsInDevice(path.getDevice()), dataType, this.context, queryDataSource, timeFilter, valueFilter, null, this.queryPlan.isAscending());
    }

    private Filter getTimeFilter(Filter filter) {
        if (filter instanceof UnaryFilter && ((UnaryFilter)filter).getFilterType() == FilterType.TIME_FILTER) {
            return filter;
        }
        if (filter instanceof AndFilter) {
            Filter leftTimeFilter = this.getTimeFilter(((AndFilter)filter).getLeft());
            Filter rightTimeFilter = this.getTimeFilter(((AndFilter)filter).getRight());
            if (leftTimeFilter != null && rightTimeFilter != null) {
                return filter;
            }
            if (leftTimeFilter != null) {
                return leftTimeFilter;
            }
            return rightTimeFilter;
        }
        return null;
    }

    protected boolean isAscending() {
        return this.queryPlan.isAscending();
    }
}

