/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.chunk;

import java.io.IOException;
import org.apache.iotdb.db.engine.cache.ChunkCache;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;

public class DiskChunkLoader
implements IChunkLoader {
    private final TsFileResource resource;

    public DiskChunkLoader(TsFileResource resource) {
        this.resource = resource;
    }

    public Chunk loadChunk(ChunkMetadata chunkMetaData) throws IOException {
        TsFileSequenceReader tsFileSequenceReader = FileReaderManager.getInstance().get(this.resource.getTsFilePath(), this.resource.isClosed());
        return ChunkCache.getInstance().get(chunkMetaData, tsFileSequenceReader);
    }

    public void close() throws IOException {
    }
}

