/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.exception.metadata.AliasAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.metadata.PathAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.StorageGroupAlreadySetException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.metadata.MetaUtils;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.metadata.mnode.MNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.StorageGroupMNode;
import org.apache.iotdb.db.qp.physical.sys.ShowTimeSeriesPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.executor.fill.LastPointReader;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MTree
implements Serializable {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final long serialVersionUID = -4200394435237291964L;
    private static final Logger logger = LoggerFactory.getLogger(MTree.class);
    private static final String NO_CHILDNODE_MSG = " does not have the child node ";
    private static transient ThreadLocal<Integer> limit = new ThreadLocal();
    private static transient ThreadLocal<Integer> offset = new ThreadLocal();
    private static transient ThreadLocal<Integer> count = new ThreadLocal();
    private static transient ThreadLocal<Integer> curOffset = new ThreadLocal();
    private MNode root;

    MTree() {
        this.root = new MNode(null, "root");
    }

    private MTree(MNode root) {
        this.root = root;
    }

    static long getLastTimeStamp(MeasurementMNode node, QueryContext queryContext) {
        TimeValuePair last = node.getCachedLast();
        if (last != null) {
            return node.getCachedLast().getTimestamp();
        }
        try {
            QueryDataSource dataSource = QueryResourceManager.getInstance().getQueryDataSource(node.getPartialPath(), queryContext, null);
            LastPointReader lastReader = new LastPointReader(node.getPartialPath(), node.getSchema().getType(), Collections.emptySet(), queryContext, dataSource, Long.MAX_VALUE, null);
            last = lastReader.readLastPoint();
            return last != null ? last.getTimestamp() : Long.MIN_VALUE;
        }
        catch (Exception e) {
            logger.error("Something wrong happened while trying to get last time value pair of {}", (Object)node.getFullPath(), (Object)e);
            return Long.MIN_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MTree deserializeFrom(File mtreeSnapshot) {
        try {
            MTree mTree;
            BufferedReader br = new BufferedReader(new FileReader(mtreeSnapshot));
            try {
                String s;
                ArrayDeque<MNode> nodeStack = new ArrayDeque<MNode>();
                MNode node = null;
                while ((s = br.readLine()) != null) {
                    String[] nodeInfo = s.split(",");
                    short nodeType = Short.parseShort(nodeInfo[0]);
                    node = nodeType == 1 ? StorageGroupMNode.deserializeFrom(nodeInfo) : (nodeType == 2 ? MeasurementMNode.deserializeFrom(nodeInfo) : new MNode(null, nodeInfo[1]));
                    int childrenSize = Integer.parseInt(nodeInfo[nodeInfo.length - 1]);
                    if (childrenSize == 0) {
                        nodeStack.push(node);
                        continue;
                    }
                    ConcurrentHashMap<String, MNode> childrenMap = new ConcurrentHashMap<String, MNode>();
                    for (int i = 0; i < childrenSize; ++i) {
                        String alias;
                        MNode child = (MNode)nodeStack.removeFirst();
                        child.setParent(node);
                        childrenMap.put(child.getName(), child);
                        if (!(child instanceof MeasurementMNode) || (alias = ((MeasurementMNode)child).getAlias()) == null) continue;
                        node.addAlias(alias, child);
                    }
                    node.setChildren(childrenMap);
                    nodeStack.push(node);
                }
                mTree = new MTree(node);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.warn("Failed to deserialize from {}. Use a new MTree.", (Object)mtreeSnapshot.getPath());
                    MTree mTree2 = new MTree();
                    return mTree2;
                }
            }
            br.close();
            return mTree;
        }
        finally {
            limit = new ThreadLocal();
            offset = new ThreadLocal();
            count = new ThreadLocal();
            curOffset = new ThreadLocal();
        }
    }

    private static String jsonToString(JsonObject jsonObject) {
        return GSON.toJson((JsonElement)jsonObject);
    }

    static JsonObject combineMetadataInStrings(String[] metadataStrs) {
        JsonObject[] jsonObjects = new JsonObject[metadataStrs.length];
        for (int i = 0; i < jsonObjects.length; ++i) {
            jsonObjects[i] = (JsonObject)GSON.fromJson(metadataStrs[i], JsonObject.class);
        }
        JsonObject root = jsonObjects[0];
        for (int i = 1; i < jsonObjects.length; ++i) {
            root = MTree.combineJsonObjects(root, jsonObjects[i]);
        }
        return root;
    }

    private static JsonObject combineJsonObjects(JsonObject a, JsonObject b) {
        JsonObject res = new JsonObject();
        HashSet retainSet = new HashSet(a.keySet());
        retainSet.retainAll(b.keySet());
        HashSet aCha = new HashSet(a.keySet());
        HashSet bCha = new HashSet(b.keySet());
        aCha.removeAll(retainSet);
        bCha.removeAll(retainSet);
        for (String key : aCha) {
            res.add(key, a.get(key));
        }
        for (String key : bCha) {
            res.add(key, b.get(key));
        }
        for (String key : retainSet) {
            JsonElement v1 = a.get(key);
            JsonElement v2 = b.get(key);
            if (v1 instanceof JsonObject && v2 instanceof JsonObject) {
                res.add(key, (JsonElement)MTree.combineJsonObjects((JsonObject)v1, (JsonObject)v2));
                continue;
            }
            res.add(v1.getAsString(), v2);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MeasurementMNode createTimeseries(PartialPath path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props, String alias) throws MetadataException {
        String[] nodeNames = path.getNodes();
        if (nodeNames.length <= 2 || !nodeNames[0].equals(this.root.getName())) {
            throw new IllegalPathException(path.getFullPath());
        }
        MNode cur = this.root;
        boolean hasSetStorageGroup = false;
        for (int i = 1; i < nodeNames.length - 1; ++i) {
            String nodeName = nodeNames[i];
            if (cur instanceof StorageGroupMNode) {
                hasSetStorageGroup = true;
            }
            if (!cur.hasChild(nodeName)) {
                if (!hasSetStorageGroup) {
                    throw new StorageGroupNotSetException("Storage group should be created first");
                }
                cur.addChild(nodeName, new MNode(cur, nodeName));
            }
            cur = cur.getChild(nodeName);
        }
        String leafName = nodeNames[nodeNames.length - 1];
        MTree mTree = this;
        synchronized (mTree) {
            if (cur.hasChild(leafName)) {
                throw new PathAlreadyExistException(path.getFullPath());
            }
            if (alias != null && cur.hasChild(alias)) {
                throw new AliasAlreadyExistException(path.getFullPath(), alias);
            }
            MeasurementMNode leaf = new MeasurementMNode(cur, leafName, alias, dataType, encoding, compressor, props);
            cur.addChild(leafName, leaf);
            if (alias != null) {
                cur.addAlias(alias, leaf);
            }
            return leaf;
        }
    }

    MNode getDeviceNodeWithAutoCreating(PartialPath deviceId, int sgLevel) throws MetadataException {
        String[] nodeNames = deviceId.getNodes();
        if (nodeNames.length <= 1 || !nodeNames[0].equals(this.root.getName())) {
            throw new IllegalPathException(deviceId.getFullPath());
        }
        MNode cur = this.root;
        for (int i = 1; i < nodeNames.length; ++i) {
            if (!cur.hasChild(nodeNames[i])) {
                if (i == sgLevel) {
                    cur.addChild(nodeNames[i], new StorageGroupMNode(cur, nodeNames[i], IoTDBDescriptor.getInstance().getConfig().getDefaultTTL()));
                } else {
                    cur.addChild(nodeNames[i], new MNode(cur, nodeNames[i]));
                }
            }
            cur = cur.getChild(nodeNames[i]);
        }
        return cur;
    }

    boolean isPathExist(PartialPath path) {
        String[] nodeNames = path.getNodes();
        MNode cur = this.root;
        if (!nodeNames[0].equals(this.root.getName())) {
            return false;
        }
        for (int i = 1; i < nodeNames.length; ++i) {
            String childName = nodeNames[i];
            if ((cur = cur.getChild(childName)) != null) continue;
            return false;
        }
        return true;
    }

    void setStorageGroup(PartialPath path) throws MetadataException {
        int i;
        String[] nodeNames = path.getNodes();
        this.checkStorageGroup(path.getFullPath());
        MNode cur = this.root;
        if (nodeNames.length <= 1 || !nodeNames[0].equals(this.root.getName())) {
            throw new IllegalPathException(path.getFullPath());
        }
        for (i = 1; i < nodeNames.length - 1; ++i) {
            MNode temp = cur.getChild(nodeNames[i]);
            if (temp == null) {
                cur.addChild(nodeNames[i], new MNode(cur, nodeNames[i]));
            } else if (temp instanceof StorageGroupMNode) {
                throw new StorageGroupAlreadySetException(temp.getFullPath());
            }
            cur = cur.getChild(nodeNames[i]);
        }
        if (cur.hasChild(nodeNames[i])) {
            throw new StorageGroupAlreadySetException(path.getFullPath());
        }
        StorageGroupMNode storageGroupMNode = new StorageGroupMNode(cur, nodeNames[i], IoTDBDescriptor.getInstance().getConfig().getDefaultTTL());
        cur.addChild(nodeNames[i], storageGroupMNode);
    }

    private void checkStorageGroup(String storageGroup) throws IllegalPathException {
        if (!IoTDBConfig.STORAGE_GROUP_PATTERN.matcher(storageGroup).matches()) {
            throw new IllegalPathException(String.format("The storage group name can only be characters, numbers and underscores. %s", storageGroup));
        }
    }

    List<MeasurementMNode> deleteStorageGroup(PartialPath path) throws MetadataException {
        MNode cur = this.getNodeByPath(path);
        if (!(cur instanceof StorageGroupMNode)) {
            throw new StorageGroupNotSetException(path.getFullPath());
        }
        cur.getParent().deleteChild(cur.getName());
        LinkedList<MeasurementMNode> leafMNodes = new LinkedList<MeasurementMNode>();
        LinkedList<MNode> queue = new LinkedList<MNode>();
        queue.add(cur);
        while (!queue.isEmpty()) {
            MNode node = (MNode)queue.poll();
            for (MNode child : node.getChildren().values()) {
                if (child instanceof MeasurementMNode) {
                    leafMNodes.add((MeasurementMNode)child);
                    continue;
                }
                queue.add(child);
            }
        }
        cur = cur.getParent();
        while (!"root".equals(cur.getName()) && cur.getChildren().size() == 0) {
            cur.getParent().deleteChild(cur.getName());
            cur = cur.getParent();
        }
        return leafMNodes;
    }

    boolean isStorageGroup(PartialPath path) {
        int i;
        String[] nodeNames = path.getNodes();
        if (nodeNames.length <= 1 || !nodeNames[0].equals("root")) {
            return false;
        }
        MNode cur = this.root;
        for (i = 1; i < nodeNames.length - 1; ++i) {
            if ((cur = cur.getChild(nodeNames[i])) != null && !(cur instanceof StorageGroupMNode)) continue;
            return false;
        }
        cur = cur.getChild(nodeNames[i]);
        return cur instanceof StorageGroupMNode;
    }

    Pair<PartialPath, MeasurementMNode> deleteTimeseriesAndReturnEmptyStorageGroup(PartialPath path) throws MetadataException {
        MNode curNode = this.getNodeByPath(path);
        if (!(curNode instanceof MeasurementMNode)) {
            throw new PathNotExistException(path.getFullPath());
        }
        String[] nodes = path.getNodes();
        if (nodes.length == 0 || !"root".equals(nodes[0])) {
            throw new IllegalPathException(path.getFullPath());
        }
        curNode.getParent().deleteChild(curNode.getName());
        MeasurementMNode deletedNode = (MeasurementMNode)curNode;
        if (deletedNode.getAlias() != null) {
            curNode.getParent().deleteAliasChild(((MeasurementMNode)curNode).getAlias());
        }
        curNode = curNode.getParent();
        while (!"root".equals(curNode.getName()) && !(curNode instanceof MeasurementMNode) && curNode.getChildren().size() == 0) {
            if (curNode instanceof StorageGroupMNode) {
                return new Pair((Object)curNode.getPartialPath(), (Object)deletedNode);
            }
            curNode.getParent().deleteChild(curNode.getName());
            curNode = curNode.getParent();
        }
        return new Pair(null, (Object)deletedNode);
    }

    MeasurementSchema getSchema(PartialPath path) throws MetadataException {
        MeasurementMNode node = (MeasurementMNode)this.getNodeByPath(path);
        return node.getSchema();
    }

    MNode getNodeByPathWithStorageGroupCheck(PartialPath path) throws MetadataException {
        boolean storageGroupChecked = false;
        String[] nodes = path.getNodes();
        if (nodes.length == 0 || !nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(path.getFullPath());
        }
        MNode cur = this.root;
        for (int i = 1; i < nodes.length; ++i) {
            if ((cur = cur.getChild(nodes[i])) == null) {
                if (!storageGroupChecked) {
                    throw new StorageGroupNotSetException(path.getFullPath());
                }
                throw new PathNotExistException(path.getFullPath());
            }
            if (!(cur instanceof StorageGroupMNode)) continue;
            storageGroupChecked = true;
        }
        if (!storageGroupChecked) {
            throw new StorageGroupNotSetException(path.getFullPath());
        }
        return cur;
    }

    StorageGroupMNode getStorageGroupNodeByStorageGroupPath(PartialPath path) throws MetadataException {
        MNode node = this.getNodeByPath(path);
        if (node instanceof StorageGroupMNode) {
            return (StorageGroupMNode)node;
        }
        throw new StorageGroupNotSetException(path.getFullPath());
    }

    StorageGroupMNode getStorageGroupNodeByPath(PartialPath path) throws MetadataException {
        String[] nodes = path.getNodes();
        if (nodes.length == 0 || !nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(path.getFullPath());
        }
        MNode cur = this.root;
        for (int i = 1; i < nodes.length; ++i) {
            if (!((cur = cur.getChild(nodes[i])) instanceof StorageGroupMNode)) continue;
            return (StorageGroupMNode)cur;
        }
        throw new StorageGroupNotSetException(path.getFullPath());
    }

    MNode getNodeByPath(PartialPath path) throws MetadataException {
        String[] nodes = path.getNodes();
        if (nodes.length == 0 || !nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(path.getFullPath());
        }
        MNode cur = this.root;
        for (int i = 1; i < nodes.length; ++i) {
            if ((cur = cur.getChild(nodes[i])) != null) continue;
            throw new PathNotExistException(path.getFullPath());
        }
        return cur;
    }

    List<String> getStorageGroupByPath(PartialPath path) throws MetadataException {
        ArrayList<String> storageGroups = new ArrayList<String>();
        String[] nodes = path.getNodes();
        if (nodes.length == 0 || !nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(path.getFullPath());
        }
        this.findStorageGroup(this.root, nodes, 1, "", storageGroups);
        return storageGroups;
    }

    private void findStorageGroup(MNode node, String[] nodes, int idx, String parent, List<String> storageGroupNames) {
        if (node instanceof StorageGroupMNode) {
            storageGroupNames.add(node.getFullPath());
            return;
        }
        String nodeReg = MetaUtils.getNodeRegByIdx(idx, nodes);
        if (!"*".equals(nodeReg)) {
            MNode next = node.getChild(nodeReg);
            if (next != null) {
                this.findStorageGroup(next, nodes, idx + 1, parent + node.getName() + '.', storageGroupNames);
            }
        } else {
            for (MNode child : node.getChildren().values()) {
                this.findStorageGroup(child, nodes, idx + 1, parent + node.getName() + '.', storageGroupNames);
            }
        }
    }

    List<PartialPath> getAllStorageGroupPaths() {
        ArrayList<PartialPath> res = new ArrayList<PartialPath>();
        ArrayDeque<MNode> nodeStack = new ArrayDeque<MNode>();
        nodeStack.add(this.root);
        while (!nodeStack.isEmpty()) {
            MNode current = (MNode)nodeStack.pop();
            if (current instanceof StorageGroupMNode) {
                res.add(current.getPartialPath());
                continue;
            }
            nodeStack.addAll(current.getChildren().values());
        }
        return res;
    }

    List<PartialPath> searchAllRelatedStorageGroups(PartialPath path) throws MetadataException {
        String[] nodes = path.getNodes();
        if (nodes.length == 0 || !nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(path.getFullPath());
        }
        ArrayList<PartialPath> storageGroupPaths = new ArrayList<PartialPath>();
        this.findStorageGroupPaths(this.root, nodes, 1, "", storageGroupPaths, false);
        return storageGroupPaths;
    }

    List<PartialPath> getStorageGroupPaths(PartialPath prefixPath) throws MetadataException {
        String[] nodes = prefixPath.getNodes();
        if (nodes.length == 0 || !nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(prefixPath.getFullPath());
        }
        ArrayList<PartialPath> storageGroupPaths = new ArrayList<PartialPath>();
        this.findStorageGroupPaths(this.root, nodes, 1, "", storageGroupPaths, true);
        return storageGroupPaths;
    }

    private void findStorageGroupPaths(MNode node, String[] nodes, int idx, String parent, List<PartialPath> storageGroupPaths, boolean prefixOnly) {
        if (node instanceof StorageGroupMNode && (!prefixOnly || idx >= nodes.length)) {
            storageGroupPaths.add(node.getPartialPath());
            return;
        }
        String nodeReg = MetaUtils.getNodeRegByIdx(idx, nodes);
        if (!"*".equals(nodeReg)) {
            MNode next = node.getChild(nodeReg);
            if (next != null) {
                this.findStorageGroupPaths(node.getChild(nodeReg), nodes, idx + 1, parent + node.getName() + '.', storageGroupPaths, prefixOnly);
            }
        } else {
            for (MNode child : node.getChildren().values()) {
                this.findStorageGroupPaths(child, nodes, idx + 1, parent + node.getName() + '.', storageGroupPaths, prefixOnly);
            }
        }
    }

    List<StorageGroupMNode> getAllStorageGroupNodes() {
        ArrayList<StorageGroupMNode> ret = new ArrayList<StorageGroupMNode>();
        ArrayDeque<MNode> nodeStack = new ArrayDeque<MNode>();
        nodeStack.add(this.root);
        while (!nodeStack.isEmpty()) {
            MNode current = (MNode)nodeStack.pop();
            if (current instanceof StorageGroupMNode) {
                ret.add((StorageGroupMNode)current);
                continue;
            }
            nodeStack.addAll(current.getChildren().values());
        }
        return ret;
    }

    PartialPath getStorageGroupPath(PartialPath path) throws StorageGroupNotSetException {
        String[] nodes = path.getNodes();
        MNode cur = this.root;
        for (int i = 1; i < nodes.length; ++i) {
            if ((cur = cur.getChild(nodes[i])) instanceof StorageGroupMNode) {
                return cur.getPartialPath();
            }
            if (cur != null) continue;
            throw new StorageGroupNotSetException(path.getFullPath());
        }
        throw new StorageGroupNotSetException(path.getFullPath());
    }

    boolean checkStorageGroupByPath(PartialPath path) {
        String[] nodes = path.getNodes();
        MNode cur = this.root;
        for (int i = 1; i < nodes.length; ++i) {
            if ((cur = cur.getChild(nodes[i])) == null) {
                return false;
            }
            if (!(cur instanceof StorageGroupMNode)) continue;
            return true;
        }
        return false;
    }

    List<PartialPath> getAllTimeseriesPath(PartialPath prefixPath) throws MetadataException {
        ShowTimeSeriesPlan plan = new ShowTimeSeriesPlan(prefixPath);
        List<Pair<PartialPath, String[]>> res = this.getAllMeasurementSchema(plan);
        ArrayList<PartialPath> paths = new ArrayList<PartialPath>();
        for (Pair<PartialPath, String[]> p : res) {
            paths.add((PartialPath)p.left);
        }
        return paths;
    }

    Pair<List<PartialPath>, Integer> getAllTimeseriesPathWithAlias(PartialPath prefixPath, int limit, int offset) throws MetadataException {
        PartialPath prePath = new PartialPath(prefixPath.getNodes());
        ShowTimeSeriesPlan plan = new ShowTimeSeriesPlan(prefixPath);
        plan.setLimit(limit);
        plan.setOffset(offset);
        List<Pair<PartialPath, String[]>> res = this.getAllMeasurementSchema(plan, false);
        ArrayList<PartialPath> paths = new ArrayList<PartialPath>();
        for (Pair<PartialPath, String[]> p : res) {
            if (prePath.getMeasurement().equals(((String[])p.right)[0])) {
                ((PartialPath)p.left).setMeasurementAlias(((String[])p.right)[0]);
            }
            paths.add((PartialPath)p.left);
        }
        offset = curOffset.get() == null ? 0 : curOffset.get() + 1;
        curOffset.remove();
        return new Pair(paths, (Object)offset);
    }

    int getAllTimeseriesCount(PartialPath prefixPath) throws MetadataException {
        String[] nodes = prefixPath.getNodes();
        if (nodes.length == 0 || !nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(prefixPath.getFullPath());
        }
        try {
            return this.getCount(this.root, nodes, 1, false);
        }
        catch (PathNotExistException e) {
            throw new PathNotExistException(prefixPath.getFullPath());
        }
    }

    private int getCount(MNode node, String[] nodes, int idx, boolean wildcard) throws PathNotExistException {
        if (idx < nodes.length) {
            if ("*".equals(nodes[idx])) {
                int sum = 0;
                for (MNode child : node.getChildren().values()) {
                    sum += this.getCount(child, nodes, idx + 1, true);
                }
                return sum;
            }
            MNode child = node.getChild(nodes[idx]);
            if (child == null) {
                if (!wildcard) {
                    throw new PathNotExistException(node.getName() + NO_CHILDNODE_MSG + nodes[idx]);
                }
                return 0;
            }
            return this.getCount(child, nodes, idx + 1, wildcard);
        }
        int sum = node instanceof MeasurementMNode ? 1 : 0;
        for (MNode child : node.getChildren().values()) {
            sum += this.getCount(child, nodes, idx + 1, wildcard);
        }
        return sum;
    }

    int getDevicesNum(PartialPath prefixPath) throws MetadataException {
        String[] nodes = prefixPath.getNodes();
        if (nodes.length == 0 || !nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(prefixPath.getFullPath());
        }
        return this.getDevicesCount(this.root, nodes, 1);
    }

    int getStorageGroupNum(PartialPath prefixPath) throws MetadataException {
        String[] nodes = prefixPath.getNodes();
        if (nodes.length == 0 || !nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(prefixPath.getFullPath());
        }
        return this.getStorageGroupCount(this.root, nodes, 1, "");
    }

    int getNodesCountInGivenLevel(PartialPath prefixPath, int level) throws MetadataException {
        int i;
        String[] nodes = prefixPath.getNodes();
        if (nodes.length == 0 || !nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(prefixPath.getFullPath());
        }
        MNode node = this.root;
        for (i = 1; i < nodes.length && !nodes[i].equals("*"); ++i) {
            if (node.getChild(nodes[i]) == null) {
                throw new MetadataException(nodes[i - 1] + NO_CHILDNODE_MSG + nodes[i]);
            }
            node = node.getChild(nodes[i]);
        }
        return this.getCountInGivenLevel(node, level - (i - 1));
    }

    private int getDevicesCount(MNode node, String[] nodes, int idx) throws MetadataException {
        String nodeReg = MetaUtils.getNodeRegByIdx(idx, nodes);
        int cnt = 0;
        if (!"*".equals(nodeReg)) {
            MNode next = node.getChild(nodeReg);
            if (next != null) {
                cnt = next instanceof MeasurementMNode && idx >= nodes.length ? ++cnt : (cnt += this.getDevicesCount(node.getChild(nodeReg), nodes, idx + 1));
            }
        } else {
            boolean deviceAdded = false;
            for (MNode child : node.getChildren().values()) {
                if (child instanceof MeasurementMNode && !deviceAdded && idx >= nodes.length) {
                    ++cnt;
                    deviceAdded = true;
                }
                cnt += this.getDevicesCount(child, nodes, idx + 1);
            }
        }
        return cnt;
    }

    private int getStorageGroupCount(MNode node, String[] nodes, int idx, String parent) throws MetadataException {
        int cnt = 0;
        if (node instanceof StorageGroupMNode && idx >= nodes.length) {
            return ++cnt;
        }
        String nodeReg = MetaUtils.getNodeRegByIdx(idx, nodes);
        if (!"*".equals(nodeReg)) {
            MNode next = node.getChild(nodeReg);
            if (next != null) {
                cnt += this.getStorageGroupCount(next, nodes, idx + 1, parent + node.getName() + '.');
            }
        } else {
            for (MNode child : node.getChildren().values()) {
                cnt += this.getStorageGroupCount(child, nodes, idx + 1, parent + node.getName() + '.');
            }
        }
        return cnt;
    }

    private int getCountInGivenLevel(MNode node, int targetLevel) {
        if (targetLevel == 0) {
            return 1;
        }
        int cnt = 0;
        for (MNode child : node.getChildren().values()) {
            cnt += this.getCountInGivenLevel(child, targetLevel - 1);
        }
        return cnt;
    }

    List<Pair<PartialPath, String[]>> getAllMeasurementSchemaByHeatOrder(ShowTimeSeriesPlan plan, QueryContext queryContext) throws MetadataException {
        String[] nodes = plan.getPath().getNodes();
        if (nodes.length == 0 || !nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(plan.getPath().getFullPath());
        }
        ArrayList<Pair<PartialPath, String[]>> allMatchedNodes = new ArrayList<Pair<PartialPath, String[]>>();
        this.findPath(this.root, nodes, 1, allMatchedNodes, false, true, queryContext);
        Stream<Pair> sortedStream = allMatchedNodes.stream().sorted(Comparator.comparingLong(p -> Long.parseLong(((String[])p.right)[6])).reversed().thenComparing(p -> (PartialPath)p.left));
        if (plan.getLimit() == 0) {
            return sortedStream.collect(Collectors.toList());
        }
        return sortedStream.skip(plan.getOffset()).limit(plan.getLimit()).collect(Collectors.toList());
    }

    List<Pair<PartialPath, String[]>> getAllMeasurementSchema(ShowTimeSeriesPlan plan) throws MetadataException {
        return this.getAllMeasurementSchema(plan, true);
    }

    List<Pair<PartialPath, String[]>> getAllMeasurementSchema(ShowTimeSeriesPlan plan, boolean removeCurrentOffset) throws MetadataException {
        LinkedList<Pair<PartialPath, String[]>> res;
        String[] nodes = plan.getPath().getNodes();
        if (nodes.length == 0 || !nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(plan.getPath().getFullPath());
        }
        limit.set(plan.getLimit());
        offset.set(plan.getOffset());
        curOffset.set(-1);
        count.set(0);
        if (offset.get() != 0 || limit.get() != 0) {
            res = new LinkedList<Pair<PartialPath, String[]>>();
            this.findPath(this.root, nodes, 1, res, true, false, null);
        } else {
            res = new LinkedList();
            this.findPath(this.root, nodes, 1, res, false, false, null);
        }
        limit.remove();
        offset.remove();
        if (removeCurrentOffset) {
            curOffset.remove();
        }
        count.remove();
        return res;
    }

    private void findPath(MNode node, String[] nodes, int idx, List<Pair<PartialPath, String[]>> timeseriesSchemaList, boolean hasLimit, boolean needLast, QueryContext queryContext) throws MetadataException {
        String nodeReg;
        if (node instanceof MeasurementMNode && nodes.length <= idx) {
            if (hasLimit) {
                curOffset.set(curOffset.get() + 1);
                if (curOffset.get() < offset.get() || count.get().intValue() == limit.get().intValue()) {
                    return;
                }
            }
            PartialPath nodePath = node.getPartialPath();
            String[] tsRow = new String[7];
            tsRow[0] = ((MeasurementMNode)node).getAlias();
            MeasurementSchema measurementSchema = ((MeasurementMNode)node).getSchema();
            tsRow[1] = this.getStorageGroupPath(nodePath).getFullPath();
            tsRow[2] = measurementSchema.getType().toString();
            tsRow[3] = measurementSchema.getEncodingType().toString();
            tsRow[4] = measurementSchema.getCompressor().toString();
            tsRow[5] = String.valueOf(((MeasurementMNode)node).getOffset());
            tsRow[6] = needLast ? String.valueOf(MTree.getLastTimeStamp((MeasurementMNode)node, queryContext)) : null;
            Pair temp = new Pair((Object)nodePath, (Object)tsRow);
            timeseriesSchemaList.add((Pair<PartialPath, String[]>)temp);
            if (hasLimit) {
                count.set(count.get() + 1);
            }
        }
        if (!(nodeReg = MetaUtils.getNodeRegByIdx(idx, nodes)).contains("*")) {
            MNode next = node.getChild(nodeReg);
            if (next != null) {
                this.findPath(next, nodes, idx + 1, timeseriesSchemaList, hasLimit, needLast, queryContext);
            }
        } else {
            for (MNode child : node.getChildren().values()) {
                if (!Pattern.matches(nodeReg.replace("*", ".*"), child.getName())) continue;
                this.findPath(child, nodes, idx + 1, timeseriesSchemaList, hasLimit, needLast, queryContext);
                if (!hasLimit || count.get().intValue() != limit.get().intValue()) continue;
                return;
            }
        }
    }

    Set<String> getChildNodePathInNextLevel(PartialPath path) throws MetadataException {
        String[] nodes = path.getNodes();
        if (nodes.length == 0 || !nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(path.getFullPath());
        }
        TreeSet<String> childNodePaths = new TreeSet<String>();
        this.findChildNodePathInNextLevel(this.root, nodes, 1, "", childNodePaths, nodes.length + 1);
        return childNodePaths;
    }

    private void findChildNodePathInNextLevel(MNode node, String[] nodes, int idx, String parent, Set<String> res, int length) {
        if (node == null) {
            return;
        }
        String nodeReg = MetaUtils.getNodeRegByIdx(idx, nodes);
        if (!nodeReg.contains("*")) {
            if (idx == length) {
                res.add(parent + node.getName());
            } else {
                this.findChildNodePathInNextLevel(node.getChild(nodeReg), nodes, idx + 1, parent + node.getName() + '.', res, length);
            }
        } else if (node.getChildren().size() > 0) {
            for (MNode child : node.getChildren().values()) {
                if (!Pattern.matches(nodeReg.replace("*", ".*"), child.getName())) continue;
                if (idx == length) {
                    res.add(parent + node.getName());
                    continue;
                }
                this.findChildNodePathInNextLevel(child, nodes, idx + 1, parent + node.getName() + '.', res, length);
            }
        } else if (idx == length) {
            String nodeName = node.getName();
            res.add(parent + nodeName);
        }
    }

    Set<PartialPath> getDevices(PartialPath prefixPath) throws MetadataException {
        String[] nodes = prefixPath.getNodes();
        if (nodes.length == 0 || !nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(prefixPath.getFullPath());
        }
        TreeSet<PartialPath> devices = new TreeSet<PartialPath>();
        this.findDevices(this.root, nodes, 1, devices);
        return devices;
    }

    private void findDevices(MNode node, String[] nodes, int idx, Set<PartialPath> res) {
        String nodeReg = MetaUtils.getNodeRegByIdx(idx, nodes);
        if (!nodeReg.contains("*")) {
            MNode next = node.getChild(nodeReg);
            if (next != null) {
                if (next instanceof MeasurementMNode && idx >= nodes.length) {
                    res.add(node.getPartialPath());
                } else {
                    this.findDevices(next, nodes, idx + 1, res);
                }
            }
        } else {
            boolean deviceAdded = false;
            for (MNode child : node.getChildren().values()) {
                if (!Pattern.matches(nodeReg.replace("*", ".*"), child.getName())) continue;
                if (child instanceof MeasurementMNode && !deviceAdded && idx >= nodes.length) {
                    res.add(node.getPartialPath());
                    deviceAdded = true;
                }
                this.findDevices(child, nodes, idx + 1, res);
            }
        }
    }

    List<PartialPath> getNodesList(PartialPath path, int nodeLevel) throws MetadataException {
        return this.getNodesList(path, nodeLevel, null);
    }

    List<PartialPath> getNodesList(PartialPath path, int nodeLevel, MManager.StorageGroupFilter filter) throws MetadataException {
        String[] nodes = path.getNodes();
        if (!nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(path.getFullPath());
        }
        ArrayList<PartialPath> res = new ArrayList<PartialPath>();
        MNode node = this.root;
        for (int i = 1; i < nodes.length; ++i) {
            if (node.getChild(nodes[i]) != null) {
                if (!((node = node.getChild(nodes[i])) instanceof StorageGroupMNode) || filter == null || filter.satisfy(node.getFullPath())) continue;
                return res;
            }
            throw new MetadataException(nodes[i - 1] + NO_CHILDNODE_MSG + nodes[i]);
        }
        this.findNodes(node, path, res, nodeLevel - (nodes.length - 1), filter);
        return res;
    }

    private void findNodes(MNode node, PartialPath path, List<PartialPath> res, int targetLevel, MManager.StorageGroupFilter filter) {
        if (node == null || node instanceof StorageGroupMNode && filter != null && !filter.satisfy(node.getFullPath())) {
            return;
        }
        if (targetLevel == 0) {
            res.add(path);
            return;
        }
        for (MNode child : node.getChildren().values()) {
            this.findNodes(child, path.concatNode(child.toString()), res, targetLevel - 1, filter);
        }
    }

    public void serializeTo(String snapshotPath) throws IOException {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(SystemFileFactory.INSTANCE.getFile(snapshotPath)));){
            this.root.serializeTo(bw);
        }
    }

    public String toString() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add(this.root.getName(), (JsonElement)this.mNodeToJSON(this.root, null));
        return MTree.jsonToString(jsonObject);
    }

    private JsonObject mNodeToJSON(MNode node, String storageGroupName) {
        JsonObject jsonObject = new JsonObject();
        if (node.getChildren().size() > 0) {
            if (node instanceof StorageGroupMNode) {
                storageGroupName = node.getFullPath();
            }
            for (MNode child : node.getChildren().values()) {
                jsonObject.add(child.getName(), (JsonElement)this.mNodeToJSON(child, storageGroupName));
            }
        } else if (node instanceof MeasurementMNode) {
            MeasurementMNode leafMNode = (MeasurementMNode)node;
            jsonObject.add("DataType", GSON.toJsonTree((Object)leafMNode.getSchema().getType()));
            jsonObject.add("Encoding", GSON.toJsonTree((Object)leafMNode.getSchema().getEncodingType()));
            jsonObject.add("Compressor", GSON.toJsonTree((Object)leafMNode.getSchema().getCompressor()));
            if (leafMNode.getSchema().getProps() != null) {
                jsonObject.addProperty("args", leafMNode.getSchema().getProps().toString());
            }
            jsonObject.addProperty("StorageGroup", storageGroupName);
        }
        return jsonObject;
    }

    Map<String, String> determineStorageGroup(PartialPath path) throws IllegalPathException {
        HashMap<String, String> paths = new HashMap<String, String>();
        String[] nodes = path.getNodes();
        if (nodes.length == 0 || !nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(path.getFullPath());
        }
        ArrayDeque<MNode> nodeStack = new ArrayDeque<MNode>();
        ArrayDeque<Integer> depthStack = new ArrayDeque<Integer>();
        if (!this.root.getChildren().isEmpty()) {
            nodeStack.push(this.root);
            depthStack.push(0);
        }
        while (!nodeStack.isEmpty()) {
            MNode mNode = (MNode)nodeStack.removeFirst();
            int depth = (Integer)depthStack.removeFirst();
            this.determineStorageGroup(depth + 1, nodes, mNode, paths, nodeStack, depthStack);
        }
        return paths;
    }

    private void determineStorageGroup(int depth, String[] nodes, MNode mNode, Map<String, String> paths, Deque<MNode> nodeStack, Deque<Integer> depthStack) {
        String currNode = depth >= nodes.length ? "*" : nodes[depth];
        for (Map.Entry<String, MNode> entry : mNode.getChildren().entrySet()) {
            if (!currNode.equals("*") && !currNode.equals(entry.getKey())) continue;
            MNode child = entry.getValue();
            if (child instanceof StorageGroupMNode) {
                String sgName = child.getFullPath();
                StringBuilder pathWithKnownSG = new StringBuilder(sgName);
                for (int i = depth + 1; i < nodes.length; ++i) {
                    pathWithKnownSG.append('.').append(nodes[i]);
                }
                if (depth >= nodes.length - 1 && currNode.equals("*")) {
                    pathWithKnownSG.append('.').append("*");
                }
                paths.put(sgName, pathWithKnownSG.toString());
                continue;
            }
            if (child.getChildren().isEmpty()) continue;
            nodeStack.push(child);
            depthStack.push(depth);
        }
    }
}

