/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.flush;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.flush.pool.FlushSubTaskPoolManager;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.memtable.IWritableMemChunk;
import org.apache.iotdb.db.exception.runtime.FlushRunTimeException;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.IChunkWriter;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemTableFlushTask {
    private static final Logger logger = LoggerFactory.getLogger(MemTableFlushTask.class);
    private static final FlushSubTaskPoolManager subTaskPoolManager = FlushSubTaskPoolManager.getInstance();
    private static IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final Future<?> encodingTaskFuture;
    private final Future<?> ioTaskFuture;
    private final LinkedBlockingQueue<Object> ioTaskQueue = new LinkedBlockingQueue(config.getIoTaskQueueSizeForFlushing());
    private final LinkedBlockingQueue<Object> encodingTaskQueue = new LinkedBlockingQueue(config.getEncodingTaskQueueSizeForFlushing());
    private RestorableTsFileIOWriter writer;
    private String storageGroup;
    private IMemTable memTable;
    private Runnable encodingTask = new Runnable(){

        private void writeOneSeries(TVList tvPairs, IChunkWriter seriesWriterImpl, TSDataType dataType) {
            block8: for (int i = 0; i < tvPairs.size(); ++i) {
                long time = tvPairs.getTime(i);
                if (i + 1 < tvPairs.size() && time == tvPairs.getTime(i + 1)) continue;
                switch (dataType) {
                    case BOOLEAN: {
                        seriesWriterImpl.write(time, tvPairs.getBoolean(i));
                        continue block8;
                    }
                    case INT32: {
                        seriesWriterImpl.write(time, tvPairs.getInt(i));
                        continue block8;
                    }
                    case INT64: {
                        seriesWriterImpl.write(time, tvPairs.getLong(i));
                        continue block8;
                    }
                    case FLOAT: {
                        seriesWriterImpl.write(time, tvPairs.getFloat(i));
                        continue block8;
                    }
                    case DOUBLE: {
                        seriesWriterImpl.write(time, tvPairs.getDouble(i));
                        continue block8;
                    }
                    case TEXT: {
                        seriesWriterImpl.write(time, tvPairs.getBinary(i));
                        continue block8;
                    }
                    default: {
                        logger.error("Storage group {} does not support data type: {}", (Object)MemTableFlushTask.this.storageGroup, (Object)dataType);
                    }
                }
            }
        }

        @Override
        public void run() {
            long memSerializeTime = 0L;
            logger.debug("Storage group {} memtable {}, starts to encoding data.", (Object)MemTableFlushTask.this.storageGroup, (Object)MemTableFlushTask.this.memTable.getVersion());
            while (true) {
                Object task = null;
                try {
                    task = MemTableFlushTask.this.encodingTaskQueue.take();
                }
                catch (InterruptedException e1) {
                    logger.error("Take task into ioTaskQueue Interrupted");
                    Thread.currentThread().interrupt();
                    break;
                }
                if (task instanceof StartFlushGroupIOTask || task instanceof EndChunkGroupIoTask) {
                    try {
                        MemTableFlushTask.this.ioTaskQueue.put(task);
                        continue;
                    }
                    catch (InterruptedException e) {
                        logger.error("Put task into ioTaskQueue Interrupted");
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                if (task instanceof TaskEnd) break;
                long starTime = System.currentTimeMillis();
                Pair encodingMessage = (Pair)task;
                ChunkWriterImpl seriesWriter = new ChunkWriterImpl((MeasurementSchema)encodingMessage.right);
                this.writeOneSeries((TVList)encodingMessage.left, (IChunkWriter)seriesWriter, ((MeasurementSchema)encodingMessage.right).getType());
                seriesWriter.sealCurrentPage();
                seriesWriter.clearPageWriter();
                try {
                    MemTableFlushTask.this.ioTaskQueue.put(seriesWriter);
                }
                catch (InterruptedException e) {
                    logger.error("Put task into ioTaskQueue Interrupted");
                    Thread.currentThread().interrupt();
                }
                memSerializeTime += System.currentTimeMillis() - starTime;
            }
            try {
                MemTableFlushTask.this.ioTaskQueue.put(new TaskEnd());
            }
            catch (InterruptedException e) {
                logger.error("Put task into ioTaskQueue Interrupted");
                Thread.currentThread().interrupt();
            }
            logger.debug("Storage group {}, flushing memtable {} into disk: Encoding data cost {} ms.", new Object[]{MemTableFlushTask.this.storageGroup, MemTableFlushTask.this.memTable.getVersion(), memSerializeTime});
        }
    };
    private Runnable ioTask = () -> {
        long ioTime = 0L;
        logger.debug("Storage group {} memtable {}, start io.", (Object)this.storageGroup, (Object)this.memTable.getVersion());
        while (true) {
            Object ioMessage = null;
            try {
                ioMessage = this.ioTaskQueue.take();
            }
            catch (InterruptedException e1) {
                logger.error("take task from ioTaskQueue Interrupted");
                Thread.currentThread().interrupt();
                break;
            }
            long starTime = System.currentTimeMillis();
            try {
                if (ioMessage instanceof StartFlushGroupIOTask) {
                    this.writer.startChunkGroup(((StartFlushGroupIOTask)ioMessage).deviceId);
                } else {
                    if (ioMessage instanceof TaskEnd) break;
                    if (ioMessage instanceof IChunkWriter) {
                        ChunkWriterImpl chunkWriter = (ChunkWriterImpl)ioMessage;
                        chunkWriter.writeToFileWriter((TsFileIOWriter)this.writer);
                    } else {
                        this.writer.endChunkGroup();
                    }
                }
            }
            catch (IOException e) {
                logger.error("Storage group {} memtable {}, io task meets error.", new Object[]{this.storageGroup, this.memTable.getVersion(), e});
                throw new FlushRunTimeException(e);
            }
            ioTime += System.currentTimeMillis() - starTime;
        }
        logger.debug("flushing a memtable {} in storage group {}, io cost {}ms", new Object[]{this.memTable.getVersion(), this.storageGroup, ioTime});
    };

    public MemTableFlushTask(IMemTable memTable, RestorableTsFileIOWriter writer, String storageGroup) {
        this.memTable = memTable;
        this.writer = writer;
        this.storageGroup = storageGroup;
        this.encodingTaskFuture = subTaskPoolManager.submit(this.encodingTask);
        this.ioTaskFuture = subTaskPoolManager.submit(this.ioTask);
        logger.debug("flush task of Storage group {} memtable {} is created ", (Object)storageGroup, (Object)memTable.getVersion());
    }

    public void syncFlushMemTable() throws ExecutionException, InterruptedException, IOException {
        logger.info("The memTable size of SG {} is {}, the avg series points num in chunk is {}, total timeseries number is {}", new Object[]{this.storageGroup, this.memTable.memSize(), this.memTable.getTotalPointsNum() / (long)this.memTable.getSeriesNumber(), this.memTable.getSeriesNumber()});
        long start = System.currentTimeMillis();
        long sortTime = 0L;
        for (String deviceId : this.memTable.getMemTableMap().keySet()) {
            this.encodingTaskQueue.put(new StartFlushGroupIOTask(deviceId));
            for (String measurementId : this.memTable.getMemTableMap().get(deviceId).keySet()) {
                long startTime = System.currentTimeMillis();
                IWritableMemChunk series = this.memTable.getMemTableMap().get(deviceId).get(measurementId);
                MeasurementSchema desc = series.getSchema();
                TVList tvList = series.getSortedTVList();
                sortTime += System.currentTimeMillis() - startTime;
                this.encodingTaskQueue.put(new Pair((Object)tvList, (Object)desc));
            }
            this.encodingTaskQueue.put(new EndChunkGroupIoTask());
        }
        this.encodingTaskQueue.put(new TaskEnd());
        logger.debug("Storage group {} memtable {}, flushing into disk: data sort time cost {} ms.", new Object[]{this.storageGroup, this.memTable.getVersion(), sortTime});
        try {
            this.encodingTaskFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.ioTaskFuture.cancel(true);
            throw e;
        }
        this.ioTaskFuture.get();
        try {
            this.writer.writeVersion(this.memTable.getVersion());
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
        logger.info("Storage group {} memtable {} flushing a memtable has finished! Time consumption: {}ms", new Object[]{this.storageGroup, this.memTable, System.currentTimeMillis() - start});
    }

    static class StartFlushGroupIOTask {
        private final String deviceId;

        StartFlushGroupIOTask(String deviceId) {
            this.deviceId = deviceId;
        }
    }

    static class EndChunkGroupIoTask {
        EndChunkGroupIoTask() {
        }
    }

    static class TaskEnd {
        TaskEnd() {
        }
    }
}

